/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.rest;

import com.ibm.websphere.jsonsupport.JSON;
import com.ibm.websphere.jsonsupport.JSONFactory;
import com.ibm.websphere.jsonsupport.JSONMarshallException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ui.internal.Filter;
import com.ibm.ws.ui.internal.RequestNLS;
import com.ibm.ws.ui.internal.rest.APIConstants;
import com.ibm.ws.ui.internal.rest.AdminCenterRestHandler;
import com.ibm.ws.ui.internal.rest.HTTPConstants;
import com.ibm.ws.ui.internal.rest.exceptions.BadRequestException;
import com.ibm.ws.ui.internal.rest.exceptions.MediaTypeNotSupportedException;
import com.ibm.ws.ui.internal.rest.exceptions.MethodNotSupportedException;
import com.ibm.ws.ui.internal.rest.exceptions.NoSuchResourceException;
import com.ibm.ws.ui.internal.rest.exceptions.RESTException;
import com.ibm.ws.ui.internal.v1.pojo.Message;
import com.ibm.ws.ui.internal.v1.utils.Utils;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CommonRESTHandler
implements AdminCenterRestHandler,
APIConstants,
HTTPConstants {
    private static final TraceComponent tc = Tr.register(CommonRESTHandler.class);
    protected final Filter filter;
    protected final String handlerURL;
    protected final boolean handlesChildResource;
    protected final boolean handlesGrandchildResource;
    protected static final String KEY_JSON_SERVICE = "jsonService";
    protected static final String ADMINISTRATOR_ROLE_NAME = "Administrator";
    protected static final String ADMIN_RESOURCE_NAME = "com.ibm.ws.management.security.resource";
    protected static final String ALL_AUTHENTICATED_USERS_ROLE_NAME = "allAuthenticatedUsers";
    protected static final String READER_ROLE_NAME = "Reader";
    protected static final Set<String> REQUIRED_ROLES_DEFAULT = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Administrator")));
    protected static final Set<String> REQUIRED_ROLES_GET = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Administrator", "Reader")));
    private JSON json;

    protected CommonRESTHandler(String handlerURL, boolean handlesChildResource, boolean handlesGrandchildResource) {
        this(handlerURL, handlesChildResource, handlesGrandchildResource, new Filter(), null);
    }

    protected CommonRESTHandler(String handlerURL, boolean handlesChildResource, boolean handlesGrandchildResource, Filter filter, JSON json) {
        this.handlerURL = handlerURL;
        this.handlesChildResource = handlesChildResource;
        this.handlesGrandchildResource = handlesGrandchildResource;
        this.filter = filter;
        this.json = json;
    }

    protected JSON getJSONService() throws JSONMarshallException {
        if (this.json != null) {
            return this.json;
        }
        this.json = JSONFactory.newInstance();
        return this.json;
    }

    @Override
    public String baseURL() {
        return this.handlerURL;
    }

    @Override
    public boolean hasChildren() {
        return this.handlesChildResource;
    }

    @Override
    public boolean hasGrandchildren() {
        return this.handlesGrandchildResource;
    }

    final String getChildResourceName(String requestedResource) {
        if (requestedResource == null) {
            return null;
        }
        if (requestedResource.endsWith("/")) {
            requestedResource = requestedResource.substring(0, requestedResource.length() - 1);
        }
        if (!requestedResource.startsWith(this.handlerURL)) {
            return null;
        }
        String childResource = requestedResource.substring(this.handlerURL.length());
        if (childResource.length() < 1) {
            return null;
        }
        if ((childResource = childResource.substring(1)).contains("/")) {
            int nextSlash = childResource.indexOf(47);
            return childResource.substring(0, nextSlash);
        }
        return childResource;
    }

    final String getGrandchildResourceName(String requestedResource) {
        if (requestedResource == null) {
            return null;
        }
        if (requestedResource.endsWith("/")) {
            requestedResource = requestedResource.substring(0, requestedResource.length() - 1);
        }
        if (!requestedResource.startsWith(this.handlerURL)) {
            return null;
        }
        String childResource = requestedResource.substring(this.handlerURL.length());
        if (childResource.length() < 1) {
            return null;
        }
        if ((childResource = childResource.substring(1)).contains("/")) {
            int nextSlash = childResource.indexOf(47);
            String grandchild = childResource.substring(nextSlash + 1);
            if (grandchild.contains("/")) {
                nextSlash = grandchild.indexOf(47);
                return grandchild.substring(0, nextSlash);
            }
            return grandchild;
        }
        return null;
    }

    final boolean isBaseResource(String requestedResource) {
        if (requestedResource == null) {
            return false;
        }
        if (requestedResource.endsWith("/")) {
            requestedResource = requestedResource.substring(0, requestedResource.length() - 1);
        }
        return this.handlerURL.equals(requestedResource);
    }

    final boolean isChildResource(String requestedResource) {
        return this.getChildResourceName(requestedResource) != null && this.getGrandchildResourceName(requestedResource) == null;
    }

    final boolean isGrandchildResource(String requestedResource) {
        if (requestedResource == null) {
            return false;
        }
        if (requestedResource.endsWith("/")) {
            requestedResource = requestedResource.substring(0, requestedResource.length() - 1);
        }
        if (!requestedResource.startsWith(this.handlerURL)) {
            return false;
        }
        String childResource = requestedResource.substring(this.handlerURL.length());
        if (childResource.length() < 1) {
            return false;
        }
        if ((childResource = childResource.substring(1)).contains("/")) {
            int nextSlash = childResource.indexOf(47);
            String grandchild = childResource.substring(nextSlash + 1);
            return !grandchild.contains("/");
        }
        return false;
    }

    @Override
    public boolean isKnownChildResource(String child, RESTRequest request) {
        if (this.hasChildren()) {
            throw new IllegalStateException("When you have children, this method needs to be implemented");
        }
        return false;
    }

    @Override
    public boolean isKnownGrandchildResource(String child, String grandchild, RESTRequest request) {
        if (this.hasGrandchildren()) {
            throw new IllegalStateException("When you have grandchildren, this method needs to be implemented");
        }
        return false;
    }

    @Override
    public Object getBase(RESTRequest request, RESTResponse response) throws RESTException {
        throw new MethodNotSupportedException();
    }

    @Override
    public Object getChild(RESTRequest request, RESTResponse response, String child) throws RESTException {
        if (this.isKnownChildResource(child, request)) {
            throw new MethodNotSupportedException();
        }
        throw new NoSuchResourceException();
    }

    @Override
    public Object getGrandchild(RESTRequest request, RESTResponse response, String child, String grandchild) throws RESTException {
        if (this.isKnownGrandchildResource(child, grandchild, request)) {
            throw new MethodNotSupportedException();
        }
        throw new NoSuchResourceException();
    }

    protected final Object doGET(RESTRequest request, RESTResponse response) throws RESTException {
        String requestPath = Utils.getPath(request);
        if (this.isBaseResource(requestPath)) {
            return this.getBase(request, response);
        }
        if (this.isChildResource(requestPath)) {
            return this.getChild(request, response, this.getChildResourceName(requestPath));
        }
        if (this.isGrandchildResource(requestPath)) {
            return this.getGrandchild(request, response, this.getChildResourceName(requestPath), this.getGrandchildResourceName(requestPath));
        }
        throw new NoSuchResourceException();
    }

    @Override
    public AdminCenterRestHandler.POSTResponse postBase(RESTRequest request, RESTResponse response) throws RESTException {
        throw new MethodNotSupportedException();
    }

    @Override
    public AdminCenterRestHandler.POSTResponse postChild(RESTRequest request, RESTResponse response, String child) throws RESTException {
        if (this.isKnownChildResource(child, request)) {
            throw new MethodNotSupportedException();
        }
        throw new NoSuchResourceException();
    }

    @Override
    public AdminCenterRestHandler.POSTResponse postGrandchild(RESTRequest request, RESTResponse response, String child, String grandchild) throws RESTException {
        if (this.isKnownGrandchildResource(child, grandchild, request)) {
            throw new MethodNotSupportedException();
        }
        throw new NoSuchResourceException();
    }

    protected final AdminCenterRestHandler.POSTResponse doPOST(RESTRequest request, RESTResponse response) throws RESTException {
        String requestPath = Utils.getPath(request);
        if (this.isBaseResource(requestPath)) {
            return this.postBase(request, response);
        }
        if (this.isChildResource(requestPath)) {
            return this.postChild(request, response, this.getChildResourceName(requestPath));
        }
        if (this.isGrandchildResource(requestPath)) {
            return this.postGrandchild(request, response, this.getChildResourceName(requestPath), this.getGrandchildResourceName(requestPath));
        }
        throw new NoSuchResourceException();
    }

    @Override
    public Object putBase(RESTRequest request, RESTResponse response) throws RESTException {
        throw new MethodNotSupportedException();
    }

    @Override
    public Object putChild(RESTRequest request, RESTResponse response, String child) throws RESTException {
        if (this.isKnownChildResource(child, request)) {
            throw new MethodNotSupportedException();
        }
        throw new NoSuchResourceException();
    }

    @Override
    public Object putGrandchild(RESTRequest request, RESTResponse response, String child, String grandchild) throws RESTException {
        if (this.isKnownGrandchildResource(child, grandchild, request)) {
            throw new MethodNotSupportedException();
        }
        throw new NoSuchResourceException();
    }

    protected final Object doPUT(RESTRequest request, RESTResponse response) throws RESTException {
        String requestPath = Utils.getPath(request);
        if (this.isBaseResource(requestPath)) {
            return this.putBase(request, response);
        }
        if (this.isChildResource(requestPath)) {
            return this.putChild(request, response, this.getChildResourceName(requestPath));
        }
        if (this.isGrandchildResource(requestPath)) {
            return this.putGrandchild(request, response, this.getChildResourceName(requestPath), this.getGrandchildResourceName(requestPath));
        }
        throw new NoSuchResourceException();
    }

    @Override
    public Object deleteBase(RESTRequest request, RESTResponse response) throws RESTException {
        throw new MethodNotSupportedException();
    }

    @Override
    public Object deleteChild(RESTRequest request, RESTResponse response, String child) throws RESTException {
        if (this.isKnownChildResource(child, request)) {
            throw new MethodNotSupportedException();
        }
        throw new NoSuchResourceException();
    }

    @Override
    public Object deleteGrandchild(RESTRequest request, RESTResponse response, String child, String grandchild) throws RESTException {
        if (this.isKnownGrandchildResource(child, grandchild, request)) {
            throw new MethodNotSupportedException();
        }
        throw new NoSuchResourceException();
    }

    protected final Object doDELETE(RESTRequest request, RESTResponse response) throws RESTException {
        String requestPath = Utils.getPath(request);
        if (this.isBaseResource(requestPath)) {
            return this.deleteBase(request, response);
        }
        if (this.isChildResource(requestPath)) {
            return this.deleteChild(request, response, this.getChildResourceName(requestPath));
        }
        if (this.isGrandchildResource(requestPath)) {
            return this.deleteGrandchild(request, response, this.getChildResourceName(requestPath), this.getGrandchildResourceName(requestPath));
        }
        throw new NoSuchResourceException();
    }

    private void checkMediaTypeIsPlainText(RESTRequest request) throws MediaTypeNotSupportedException {
        String requestContentType = request.getHeader("Content-Type");
        if (requestContentType == null || requestContentType.indexOf("text/plain") < 0) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Inbound Content-Type is not the required text/plain rather it is " + requestContentType), (Object[])new Object[0]);
            }
            throw new MediaTypeNotSupportedException();
        }
    }

    protected void delegateMethod(RESTRequest request, RESTResponse response) throws RESTException {
        String method = request.getMethod();
        if ("GET".equals(method)) {
            this.setPlainTextResponse(response, this.doGET(request, response), 200);
        } else if ("POST".equals(method)) {
            this.checkMediaTypeIsPlainText(request);
            AdminCenterRestHandler.POSTResponse pr = this.doPOST(request, response);
            response.setResponseHeader("Location", pr.createdURL);
            this.setPlainTextResponse(response, pr.jsonPayload, 201);
        } else if ("PUT".equals(method)) {
            this.checkMediaTypeIsPlainText(request);
            Object obj = this.doPUT(request, response);
            if (obj instanceof Message) {
                this.setJSONResponse(response, obj, 200);
            } else {
                this.setPlainTextResponse(response, obj, 200);
            }
        } else if ("DELETE".equals(method)) {
            Object obj = this.doDELETE(request, response);
            if (obj instanceof Message) {
                this.setJSONResponse(response, obj, 200);
            } else {
                this.setPlainTextResponse(response, obj, 200);
            }
        } else {
            throw new MethodNotSupportedException();
        }
    }

    protected final void setPlainTextResponse(RESTResponse response, Object obj, int status) {
        response.setResponseHeader("Content-Type", "text/plain");
        try {
            byte[] b = obj.toString().getBytes("UTF-8");
            response.setStatus(status);
            response.getOutputStream().write(b);
        }
        catch (IOException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unexpected IOException while writing out POJO response", (Object[])new Object[]{e});
            }
            response.setStatus(500);
        }
    }

    protected final void setJSONResponse(RESTResponse response, Object pojo, int status) {
        response.setResponseHeader("Content-Type", "application/json; charset=UTF-8");
        try {
            JSON jsonService = this.getJSONService();
            byte[] b = jsonService.asBytes(pojo);
            response.setStatus(status);
            response.getOutputStream().write(b);
        }
        catch (JSONMarshallException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unexpected JSONMarshallException while writing out POJO response", (Object[])new Object[]{e});
            }
            response.setStatus(500);
        }
        catch (IOException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unexpected IOException while writing out POJO response", (Object[])new Object[]{e});
            }
            response.setStatus(500);
        }
    }

    protected final boolean matchesExpectedResource(String requestedResource) {
        if (requestedResource == null) {
            return false;
        }
        if (requestedResource.endsWith("/")) {
            requestedResource = requestedResource.substring(0, requestedResource.length() - 1);
        }
        if (this.handlerURL.equals(requestedResource)) {
            return true;
        }
        if (this.handlesChildResource) {
            String childResource = requestedResource.substring(this.handlerURL.length());
            if (childResource.substring(1).contains("/")) {
                if (this.handlesGrandchildResource) {
                    int nextSlash = childResource.substring(1).indexOf(47);
                    String grandchild = childResource.substring(nextSlash + 2);
                    return !grandchild.contains("/");
                }
                return false;
            }
            return true;
        }
        return false;
    }

    protected void handleRESTException(RESTResponse response, RESTException e) throws IOException {
        if (e.getPayload() != null) {
            String contentType = e.getContentType();
            if ("text/plain".equals(contentType)) {
                response.setStatus(e.getStatus());
                response.setResponseHeader("Content-Type", e.getContentType());
                response.getOutputStream().write(e.getPayload().toString().getBytes(Charset.forName("UTF-8")));
            } else {
                response.setStatus(500);
                response.setResponseHeader("Content-Type", "text/plain");
                response.getOutputStream().write("An internal error occurred. RESTException had a set payload but did not specify content type".getBytes(Charset.forName("UTF-8")));
            }
        } else {
            response.setStatus(e.getStatus());
        }
    }

    @FFDCIgnore(value={RESTException.class})
    public final void handleRequest(RESTRequest request, RESTResponse response) throws IOException {
        try {
            if (this.matchesExpectedResource(Utils.getPath(request))) {
                try {
                    this.delegateMethod(request, response);
                }
                catch (RESTException e) {
                    this.handleRESTException(response, e);
                }
            } else {
                response.setStatus(404);
            }
        }
        catch (RuntimeException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unexpected RuntimeException caught during handleRequest", (Object[])new Object[]{e});
            }
            response.setStatus(500);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    protected String getReaderContents(InputStream input, int maxSize) throws IOException, BadRequestException {
        if (input == null) {
            throw new IOException("The input Reader was null");
        }
        try {
            byte[] buf = new byte[maxSize + 1];
            int read = input.read(buf);
            if (read > maxSize) {
                Message error = new Message(400, RequestNLS.formatMessage(tc, "POST_MAX_TEXT_SIZE", maxSize));
                throw new BadRequestException("text/plain", error);
            }
            if (read == -1) {
                Message error = new Message(400, RequestNLS.formatMessage(tc, "POST_NO_PAYLOAD", maxSize));
                throw new BadRequestException("text/plain", error);
            }
            String string = new String(buf, 0, read, "UTF-8");
            return string;
        }
        finally {
            input.close();
        }
    }

    @Trivial
    private final <T> String getSupportedTypes(List<Class<? extends T>> types) {
        StringBuilder sb = new StringBuilder();
        for (Class<T> type : types) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(type.getCanonicalName());
        }
        return sb.toString();
    }

    public boolean isAuthorizedDefault(RESTRequest request, RESTResponse response) {
        boolean isAuthorized;
        boolean isGetMethod = "GET".equals(request.getMethod());
        boolean bl = isAuthorized = request.isUserInRole(ADMINISTRATOR_ROLE_NAME) || isGetMethod && request.isUserInRole(READER_ROLE_NAME);
        if (!isAuthorized) {
            response.setStatus(403);
            response.setRequiredRoles(isGetMethod ? REQUIRED_ROLES_GET : REQUIRED_ROLES_DEFAULT);
        }
        return isAuthorized;
    }

    protected boolean isAuthorizedAdminOrReader(RESTRequest request, RESTResponse response) {
        boolean isAuthorized;
        boolean bl = isAuthorized = request.isUserInRole(ADMINISTRATOR_ROLE_NAME) || request.isUserInRole(READER_ROLE_NAME);
        if (!isAuthorized) {
            response.setStatus(403);
            response.setRequiredRoles(REQUIRED_ROLES_DEFAULT);
        }
        return isAuthorized;
    }
}

