/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.v1.pojo;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ui.internal.RequestNLS;
import com.ibm.ws.ui.internal.validation.InvalidDeployValidationException;
import com.ibm.ws.ui.persistence.SelfValidatingPOJO;

@TraceOptions(messageBundle="com.ibm.ws.ui.internal.resources.ValidationStrings")
public class DeployToolConfig
implements SelfValidatingPOJO {
    private static final transient TraceComponent tc = Tr.register(DeployToolConfig.class);
    static final int MAX_LENGTH = 4096;
    private String password;

    @Trivial
    DeployToolConfig() {
    }

    @Trivial
    public DeployToolConfig(String password) {
        this.password = password;
    }

    @Trivial
    private void setPassword(String password) {
        this.password = password;
    }

    @Trivial
    public String getPassword() {
        return this.password;
    }

    @Override
    public void validateSelf() throws InvalidDeployValidationException {
        if (this.password == null || "".equals(this.password.trim())) {
            throw new InvalidDeployValidationException(RequestNLS.formatMessage(tc, "RQD_FIELDS_MISSING", this.password));
        }
    }

    @Trivial
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DeployToolConfig) {
            DeployToolConfig that = (DeployToolConfig)o;
            boolean sameFields = true;
            return sameFields &= this.password == that.password || this.getPassword() != null && this.getPassword().equals(that.password);
        }
        return false;
    }

    @Trivial
    public int hashCode() {
        return this.password == null ? 0 : this.password.hashCode();
    }

    @Trivial
    String getJSONString(String str) {
        if (str == null) {
            return "null";
        }
        return "\"" + str + "\"";
    }
}

