/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.v1.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.wsspi.rest.handler.RESTRequest;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class Utils {
    private static final TraceComponent tc = Tr.register(Utils.class);
    static final MessageDigest messagedigest;

    @Trivial
    public static final String urlEncode(String toEncode) {
        if (toEncode == null) {
            return null;
        }
        try {
            return URLEncoder.encode(toEncode, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unexpected UnsupportedEncodingException", (Object[])new Object[]{e});
            }
            throw new IllegalStateException("Encountered a JVM with no UTF-8 support!");
        }
    }

    public static String getPath(RESTRequest request) {
        String path = request.getURI();
        try {
            String contextPath = request.getContextPath();
            path = path.substring(path.indexOf(contextPath) + contextPath.length());
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caught exception while trying to get urlencoded path from request.", (Object[])new Object[]{e});
            }
            return request.getPath();
        }
        return path;
    }

    @Trivial
    @FFDCIgnore(value={PrivilegedActionException.class})
    public static final URL getURL(final String urlName) throws MalformedURLException {
        try {
            URL url = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                @Override
                @Trivial
                public URL run() throws MalformedURLException {
                    return new URL(urlName);
                }
            });
            return url;
        }
        catch (PrivilegedActionException e) {
            throw (MalformedURLException)e.getCause();
        }
    }

    public static synchronized String getMD5String(String str) {
        byte[] hash;
        try {
            hash = messagedigest.digest(str.getBytes("UTF-8"));
        }
        catch (Exception e) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Unexpected Exception", (Object[])new Object[]{e});
            }
            throw new IllegalStateException("Encountered a JVM with no UTF-8 support!");
        }
        StringBuilder sb = new StringBuilder(2 * hash.length);
        for (byte b : hash) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    static {
        try {
            messagedigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

