/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIApiConstants;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.RuntimeEventListener;
import com.ibm.ws.sib.mfp.JsApiMessage;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.processor.ExceptionDestinationHandler;
import com.ibm.ws.sib.processor.UndeliverableReturnCode;
import com.ibm.ws.sib.processor.exceptions.SIMPLimitExceededException;
import com.ibm.ws.sib.processor.impl.ConnectionImpl;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.ReportHandler;
import com.ibm.ws.sib.processor.impl.SecurityContext;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.InputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.utils.UserTrace;
import com.ibm.ws.sib.security.auth.OperationType;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.exception.SINotAuthorizedException;
import java.util.Properties;

public class ExceptionDestinationHandlerImpl
implements ExceptionDestinationHandler {
    private static final TraceNLS nls_mt = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSJUMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(ExceptionDestinationHandlerImpl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private DestinationHandler _originalDestination;
    private String _exceptionDestinationName;
    private final Object _exceptionDestinationLock = new Object();
    private InputHandler _inputHandler = null;
    private DestinationHandler _exceptionDestination;
    private final MessageProcessor _messageProcessor;
    private String _defaultExceptionDestinationName = null;
    private ReportHandler _reportHandler = null;

    public static String constructDefaultExceptionDestinationName(String messagingEngineName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"constructDefaultExceptionDestinationName", (Object)messagingEngineName);
        }
        String rc = "_SYSTEM.Exception.Destination";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"constructDefaultExceptionDestinationName", (Object)"_SYSTEM.Exception.Destination");
        }
        return "_SYSTEM.Exception.Destination";
    }

    public String getDefaultExceptionDestinationName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDefaultExceptionDestinationName");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDefaultExceptionDestinationName", (Object)this._defaultExceptionDestinationName);
        }
        return this._defaultExceptionDestinationName;
    }

    public ExceptionDestinationHandlerImpl(DestinationHandler originalDestination) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ExceptionDestinationHandlerImpl", (Object)originalDestination);
        }
        this._originalDestination = originalDestination;
        this._messageProcessor = originalDestination.getMessageProcessor();
        String meName = this._messageProcessor.getMessagingEngineName();
        this._exceptionDestinationName = this._defaultExceptionDestinationName = ExceptionDestinationHandlerImpl.constructDefaultExceptionDestinationName(meName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ExceptionDestinationHandlerImpl", (Object)this);
        }
    }

    public ExceptionDestinationHandlerImpl(SIDestinationAddress destinationAddr, MessageProcessor mp) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ExceptionDestinationHandlerImpl", (Object)new Object[]{destinationAddr, mp});
        }
        this._messageProcessor = mp;
        this.setDestination(destinationAddr);
        String meName = this._messageProcessor.getMessagingEngineName();
        this._exceptionDestinationName = this._defaultExceptionDestinationName = ExceptionDestinationHandlerImpl.constructDefaultExceptionDestinationName(meName);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ExceptionDestinationHandlerImpl", (Object)this);
        }
    }

    public void setDestination(DestinationHandler originalDestination) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestination", (Object)originalDestination);
        }
        this._originalDestination = originalDestination;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDestination");
        }
    }

    public void setDestination(SIDestinationAddress destinationAddr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestination", (Object)destinationAddr);
        }
        if (destinationAddr != null) {
            try {
                this._originalDestination = this._messageProcessor.getDestinationManager().getDestination((JsDestinationAddress)destinationAddr, true);
            }
            catch (SIException e) {
                SibTr.warning((TraceComponent)tc, (String)"EXCEPTION_DESTINATION_WARNING_CWSIP0291", (Object)new Object[]{destinationAddr.getDestinationName(), this._messageProcessor.getMessagingEngineName(), e});
                this._originalDestination = null;
            }
        } else {
            this._originalDestination = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDestination", (Object)this._originalDestination);
        }
    }

    public int checkCanExceptionMessage() {
        DestinationHandler exceptionDestHandler;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkCanExceptionMessage");
        }
        int rc = 0;
        String newExceptionDestination = null;
        boolean usingDefault = false;
        if (this._originalDestination != null) {
            newExceptionDestination = this._originalDestination.getExceptionDestination();
            if (newExceptionDestination == null || newExceptionDestination.equals("")) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"checkCanExceptionMessage", (Object)rc);
                }
                return rc;
            }
            if (newExceptionDestination.equals("$DEFAULT_EXCEPTION_DESTINATION")) {
                newExceptionDestination = this._defaultExceptionDestinationName;
                usingDefault = true;
            }
        } else {
            newExceptionDestination = this._defaultExceptionDestinationName;
            usingDefault = true;
        }
        try {
            exceptionDestHandler = this._messageProcessor.getDestinationManager().getDestination(newExceptionDestination, true);
            rc = exceptionDestHandler.checkCanAcceptMessage(null, null);
        }
        catch (SIException e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (rc != 1 && !usingDefault) {
            try {
                exceptionDestHandler = this._messageProcessor.getDestinationManager().getDestination(this._defaultExceptionDestinationName, true);
                rc = exceptionDestHandler.checkCanAcceptMessage(null, null);
            }
            catch (SIException e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkCanExceptionMessage", (Object)rc);
        }
        return rc;
    }

    public UndeliverableReturnCode handleUndeliverableMessage(SIMPMessage message, TransactionCommon tran, int exceptionReason, String[] exceptionStrings) {
        return this.handleUndeliverableMessage(message, tran, exceptionReason, exceptionStrings, null);
    }

    public UndeliverableReturnCode handleUndeliverableMessage(SIMPMessage message, TransactionCommon tran, int exceptionReason, String[] exceptionStrings, String subscriptionID) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)new Object[]{message, tran, exceptionReason, exceptionStrings, subscriptionID});
        }
        UndeliverableReturnCode rc = this.handleUndeliverableMessage(message, null, tran, exceptionReason, exceptionStrings, this._messageProcessor.getMessagingEngineUuid(), subscriptionID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)rc);
        }
        return rc;
    }

    public UndeliverableReturnCode handleUndeliverableMessage(SIBusMessage msg, String alternateUser, TransactionCommon tran, int exceptionReason, String[] exceptionStrings) {
        return this.handleUndeliverableMessage(msg, alternateUser, tran, exceptionReason, exceptionStrings, null);
    }

    public UndeliverableReturnCode handleUndeliverableMessage(SIBusMessage msg, String alternateUser, TransactionCommon tran, int exceptionReason, String[] exceptionStrings, String subscriptionID) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)new Object[]{msg, alternateUser, tran, exceptionReason, exceptionStrings, subscriptionID});
        }
        UndeliverableReturnCode rc = this.handleUndeliverableMessage(new MessageItem((JsMessage)msg), alternateUser, tran, exceptionReason, exceptionStrings, this._messageProcessor.getMessagingEngineUuid(), subscriptionID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)rc);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UndeliverableReturnCode handleUndeliverableMessage(SIMPMessage message, String alternateUser, TransactionCommon tran, int exceptionReason, String[] exceptionStrings, SIBUuid8 sourceMEUuid, String subscriptionID) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)new Object[]{message, alternateUser, tran, exceptionReason, exceptionStrings, sourceMEUuid, subscriptionID});
        }
        boolean sendComplete = false;
        boolean defaultInUse = false;
        UndeliverableReturnCode rc = UndeliverableReturnCode.OK;
        TransactionCommon localTran = null;
        rc = this.checkMessage(message);
        if (rc == UndeliverableReturnCode.BLOCK) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)rc);
            }
            return rc;
        }
        if (rc != UndeliverableReturnCode.DISCARD) {
            JsMessage msg = null;
            try {
                msg = message.getMessage().getReceived();
            }
            catch (MessageCopyFailedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.handleUndeliverableMessage", (String)"1:568:1.137", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)UndeliverableReturnCode.ERROR);
                }
                return UndeliverableReturnCode.ERROR;
            }
            msg = this.setMessageProperties(msg, exceptionReason, exceptionStrings, subscriptionID);
            String newExceptionDestination = null;
            if (this._originalDestination != null) {
                newExceptionDestination = this._originalDestination.getExceptionDestination();
                if (newExceptionDestination == null || newExceptionDestination.equals("")) {
                    if (this._originalDestination.isToBeDeleted()) {
                        newExceptionDestination = this._defaultExceptionDestinationName;
                        defaultInUse = true;
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)UndeliverableReturnCode.ERROR);
                        }
                        return UndeliverableReturnCode.ERROR;
                    }
                }
                if (newExceptionDestination.equals("$DEFAULT_EXCEPTION_DESTINATION")) {
                    newExceptionDestination = this._defaultExceptionDestinationName;
                    defaultInUse = true;
                }
            } else {
                newExceptionDestination = this._defaultExceptionDestinationName;
                defaultInUse = true;
            }
            Object object = this._exceptionDestinationLock;
            synchronized (object) {
                if (this._inputHandler == null || !newExceptionDestination.equals(this._exceptionDestinationName)) {
                    this._exceptionDestinationName = newExceptionDestination;
                    try {
                        AccessResult result;
                        this._exceptionDestination = this._messageProcessor.getDestinationManager().getDestination(this._exceptionDestinationName, true);
                        if (this._messageProcessor.isBusSecure() && !(result = this.checkExceptionDestinationAccess(msg, null, alternateUser, defaultInUse)).isAllowed()) {
                            this.handleAccessDenied(result, msg, alternateUser);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)UndeliverableReturnCode.BLOCK);
                            }
                            return UndeliverableReturnCode.BLOCK;
                        }
                        msg.setPriority(this._exceptionDestination.getDefaultPriority());
                        this._inputHandler = this._exceptionDestination.getInputHandler(this._exceptionDestination.isPubSub() ? ProtocolType.PUBSUBINPUT : ProtocolType.UNICASTINPUT, this._messageProcessor.getMessagingEngineUuid(), null);
                    }
                    catch (SIException e) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        if (defaultInUse) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.handleUndeliverableMessage", (String)"1:710:1.137", (Object)this);
                            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:716:1.137", e, this._exceptionDestinationName});
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)UndeliverableReturnCode.ERROR);
                            }
                            return UndeliverableReturnCode.ERROR;
                        }
                        SibTr.warning((TraceComponent)tc, (String)"EXCEPTION_DESTINATION_WARNING_CWSIP0291", (Object)new Object[]{this._exceptionDestinationName, this._messageProcessor.getMessagingEngineName(), e});
                        this._exceptionDestinationName = this._defaultExceptionDestinationName;
                        try {
                            AccessResult result;
                            this._exceptionDestination = this._messageProcessor.getDestinationManager().getDestination(this._exceptionDestinationName, true);
                            if (this._messageProcessor.isBusSecure() && !(result = this.checkExceptionDestinationAccess(msg, null, alternateUser, true)).isAllowed()) {
                                this.handleAccessDenied(result, msg, alternateUser);
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)UndeliverableReturnCode.BLOCK);
                                }
                                return UndeliverableReturnCode.BLOCK;
                            }
                            msg.setPriority(this._exceptionDestination.getDefaultPriority());
                            this._inputHandler = this._exceptionDestination.getInputHandler(this._exceptionDestination.isPubSub() ? ProtocolType.PUBSUBINPUT : ProtocolType.UNICASTINPUT, this._messageProcessor.getMessagingEngineUuid(), null);
                            defaultInUse = true;
                        }
                        catch (SIException e2) {
                            FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.handleUndeliverableMessage", (String)"1:786:1.137", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:793:1.137", e2, this._exceptionDestinationName});
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)UndeliverableReturnCode.ERROR);
                            }
                            return UndeliverableReturnCode.ERROR;
                        }
                    }
                }
                sendComplete = false;
                while (!sendComplete) {
                    UndeliverableReturnCode rc2;
                    MessageItem newItem = new MessageItem(msg);
                    newItem.setRequiresNewId(message.getRequiresNewId());
                    try {
                        newItem.setStoreAtSendTime(message.isToBeStoredAtSendTime());
                        TransactionCommon transaction = null;
                        transaction = tran == null ? (localTran = this._exceptionDestination.getTxManager().createLocalTransaction(false)) : tran;
                        this._inputHandler.handleMessage(newItem, transaction, sourceMEUuid);
                        JsMessagingEngine me = this._messageProcessor.getMessagingEngine();
                        if (me.isEventNotificationEnabled() || UserTrace.tc_mt.isDebugEnabled()) {
                            String apiMsgId = null;
                            String correlationId = null;
                            if (message.getMessage() instanceof JsApiMessage) {
                                apiMsgId = ((JsApiMessage)message.getMessage()).getApiMessageId();
                                correlationId = ((JsApiMessage)message.getMessage()).getCorrelationId();
                            } else {
                                if (message.getMessage().getApiMessageIdAsBytes() != null) {
                                    apiMsgId = new String(message.getMessage().getApiMessageIdAsBytes());
                                }
                                if (message.getMessage().getCorrelationIdAsBytes() != null) {
                                    correlationId = new String(message.getMessage().getCorrelationIdAsBytes());
                                }
                            }
                            if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled() && message.getMessage().isApiMessage()) {
                                SibTr.debug((TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage("MESSAGE_EXCEPTION_DESTINATIONED_CWSJU0012", new Object[]{apiMsgId, message.getMessage().getSystemMessageId(), correlationId, this._exceptionDestinationName, exceptionReason, message.getMessage().getExceptionMessage()}, null));
                            }
                            if (me.isEventNotificationEnabled()) {
                                this.fireMessageExceptionedEvent(apiMsgId, message, exceptionReason);
                            }
                        }
                        sendComplete = true;
                    }
                    catch (SIException e) {
                        if (!defaultInUse) {
                            SibTr.warning((TraceComponent)tc, (String)"EXCEPTION_DESTINATION_WARNING_CWSIP0291", (Object)new Object[]{this._exceptionDestinationName, this._messageProcessor.getMessagingEngineName(), e});
                            rc2 = this.sendToDefaultExceptionDestination(msg);
                            if (rc2 != UndeliverableReturnCode.OK) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)rc2);
                                }
                                return rc2;
                            }
                            defaultInUse = true;
                            continue;
                        }
                        if (e instanceof SIMPLimitExceededException) {
                            SibTr.warning((TraceComponent)tc, (String)"EXCEPTION_DESTINATION_WARNING_CWSIP0291", (Object)new Object[]{this._exceptionDestinationName, this._messageProcessor.getMessagingEngineName(), e});
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)UndeliverableReturnCode.BLOCK);
                            }
                            return UndeliverableReturnCode.BLOCK;
                        }
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.handleUndeliverableMessage", (String)"1:938:1.137", (Object)this);
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:944:1.137", e, this._exceptionDestinationName});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)UndeliverableReturnCode.ERROR);
                        }
                        return UndeliverableReturnCode.ERROR;
                    }
                    catch (MessageStoreRuntimeException e) {
                        if (!defaultInUse) {
                            rc2 = this.sendToDefaultExceptionDestination(msg);
                            if (rc2 != UndeliverableReturnCode.OK) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)rc2);
                                }
                                return rc2;
                            }
                            defaultInUse = true;
                            continue;
                        }
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.handleUndeliverableMessage", (String)"1:981:1.137", (Object)this);
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:986:1.137", e, this._exceptionDestinationName});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)UndeliverableReturnCode.ERROR);
                        }
                        return UndeliverableReturnCode.ERROR;
                    }
                }
            }
        }
        if (message.getMessage().getReportException() != null) {
            if (this._reportHandler == null) {
                this._reportHandler = new ReportHandler(this._messageProcessor);
            }
            TransactionCommon transaction = null;
            transaction = tran == null ? localTran : tran;
            try {
                this._reportHandler.handleMessage(message, transaction, SIApiConstants.REPORT_EXCEPTION);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.handleUndeliverableMessage", (String)"1:1029:1.137", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"EXCEPTION_DESTINATION_ERROR_CWSIP0295", (Object)new Object[]{this._exceptionDestinationName, this._messageProcessor.getMessagingEngineName()});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)UndeliverableReturnCode.ERROR);
                }
                return UndeliverableReturnCode.ERROR;
            }
        }
        if (localTran != null) {
            try {
                localTran.commit();
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.handleUndeliverableMessage", (String)"1:1056:1.137", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:1061:1.137", e, this._exceptionDestinationName});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)UndeliverableReturnCode.ERROR);
                }
                return UndeliverableReturnCode.ERROR;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleUndeliverableMessage", (Object)rc);
        }
        return rc;
    }

    private boolean isBlockRequired(SIMPMessage message) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isBlockRequired", (Object)message);
        }
        boolean isBlockRequired = false;
        if (this._originalDestination != null) {
            String exceptionDestination = this._originalDestination.getExceptionDestination();
            boolean toBedeleted = this._originalDestination.isToBeDeleted();
            if ((exceptionDestination == null || exceptionDestination.equals("")) && !toBedeleted) {
                isBlockRequired = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isBlockRequired", (Object)isBlockRequired);
        }
        return isBlockRequired;
    }

    private JsMessage setMessageProperties(JsMessage msg, int exceptionReason, String[] exceptionStrings, String subscriptionID) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMessageProperties", (Object)new Object[]{msg, exceptionReason, exceptionStrings, subscriptionID});
        }
        msg.setExceptionReason(exceptionReason);
        msg.setExceptionInserts(exceptionStrings);
        msg.setExceptionTimestamp(System.currentTimeMillis());
        msg.setExceptionProblemSubscription(subscriptionID);
        msg.setReportCOA(null);
        msg.setReportCOD(null);
        msg.setReportException(null);
        msg.setReportExpiry(null);
        msg.setReportNAN(null);
        msg.setReportPAN(null);
        msg.setForwardRoutingPath(null);
        msg.setRoutingDestination(null);
        msg.setDeliveryDelay(0L);
        if (this._originalDestination != null) {
            msg.setExceptionProblemDestination(this._originalDestination.getName());
        } else {
            msg.setExceptionProblemDestination(null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMessageProperties", (Object)msg);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToExceptionDestination(SIBusMessage siMessage, String alternateUser, TransactionCommon tran, int exceptionReason, ConnectionImpl conn, String[] exceptionStrings) throws SINotPossibleInCurrentConfigurationException, SIResourceException {
        MessageItem message;
        UndeliverableReturnCode rc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendToExceptionDestination", (Object)new Object[]{siMessage, alternateUser, tran, exceptionReason, conn, exceptionStrings});
        }
        boolean sendComplete = false;
        boolean defaultInUse = false;
        TransactionCommon localTran = null;
        JsMessage jsMessage = (JsMessage)siMessage;
        if (jsMessage.getReliability().equals(Reliability.NONE)) {
            if (this._originalDestination != null) {
                jsMessage.setReliability(this._originalDestination.getDefaultReliability());
            } else {
                try {
                    this._exceptionDestination = this._messageProcessor.getDestinationManager().getDestination(this._exceptionDestinationName, true);
                    jsMessage.setReliability(this._exceptionDestination.getDefaultReliability());
                }
                catch (SIException e3) {
                    FFDCFilter.processException((Throwable)e3, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.sendToExceptionDestination", (String)"1:1279:1.137", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e3));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:1287:1.137", e3, this._exceptionDestinationName});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"sendToExceptionDestination", (Object)((Object)e3));
                    }
                    throw new SIErrorException((Throwable)e3);
                }
            }
        }
        if ((rc = this.checkMessage(message = new MessageItem(jsMessage))) == UndeliverableReturnCode.BLOCK) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendToExceptionDestination", (Object)rc);
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0005", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:1309:1.137", rc});
            throw new SINotPossibleInCurrentConfigurationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:1316:1.137", rc}, null));
        }
        if (rc != UndeliverableReturnCode.DISCARD) {
            JsMessage msg = null;
            try {
                msg = message.getMessage().getReceived();
            }
            catch (MessageCopyFailedException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.sendToExceptionDestination", (String)"1:1335:1.137", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"sendToExceptionDestination", (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:1344:1.137", e});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:1352:1.137", e}, null), (Throwable)e);
            }
            msg = this.setMessageProperties(msg, exceptionReason, exceptionStrings, null);
            String newExceptionDestination = null;
            if (this._originalDestination != null) {
                newExceptionDestination = this._originalDestination.getExceptionDestination();
                if (newExceptionDestination.equals("$DEFAULT_EXCEPTION_DESTINATION")) {
                    newExceptionDestination = this._defaultExceptionDestinationName;
                    defaultInUse = true;
                }
            } else {
                newExceptionDestination = this._defaultExceptionDestinationName;
                defaultInUse = true;
            }
            Object object = this._exceptionDestinationLock;
            synchronized (object) {
                if (this._inputHandler == null || !newExceptionDestination.equals(this._exceptionDestinationName)) {
                    this._exceptionDestinationName = newExceptionDestination;
                    try {
                        AccessResult result;
                        this._exceptionDestination = this._messageProcessor.getDestinationManager().getDestination(this._exceptionDestinationName, true);
                        if (this._messageProcessor.isBusSecure() && !(result = this.checkExceptionDestinationAccess(msg, conn, alternateUser, defaultInUse)).isAllowed()) {
                            this.handleAccessDenied(result, msg, alternateUser);
                            rc = UndeliverableReturnCode.BLOCK;
                        }
                        msg.setPriority(this._exceptionDestination.getDefaultPriority());
                        this._inputHandler = this._exceptionDestination.getInputHandler(this._exceptionDestination.isPubSub() ? ProtocolType.PUBSUBINPUT : ProtocolType.UNICASTINPUT, this._messageProcessor.getMessagingEngineUuid(), null);
                    }
                    catch (SIException e) {
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        if (defaultInUse) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.sendToExceptionDestination", (String)"1:1483:1.137", (Object)this);
                            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:1489:1.137", e, this._exceptionDestinationName});
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"sendToExceptionDestination", (Object)((Object)e));
                            }
                            throw new SIErrorException((Throwable)e);
                        }
                        SibTr.warning((TraceComponent)tc, (String)"EXCEPTION_DESTINATION_WARNING_CWSIP0291", (Object)new Object[]{this._exceptionDestinationName, this._messageProcessor.getMessagingEngineName(), e});
                        this._exceptionDestinationName = this._defaultExceptionDestinationName;
                        try {
                            AccessResult result;
                            this._exceptionDestination = this._messageProcessor.getDestinationManager().getDestination(this._exceptionDestinationName, true);
                            if (this._messageProcessor.isBusSecure() && !(result = this.checkExceptionDestinationAccess(msg, conn, alternateUser, true)).isAllowed()) {
                                this.handleAccessDenied(result, msg, alternateUser);
                                rc = UndeliverableReturnCode.BLOCK;
                            }
                            msg.setPriority(this._exceptionDestination.getDefaultPriority());
                            this._inputHandler = this._exceptionDestination.getInputHandler(this._exceptionDestination.isPubSub() ? ProtocolType.PUBSUBINPUT : ProtocolType.UNICASTINPUT, this._messageProcessor.getMessagingEngineUuid(), null);
                            defaultInUse = true;
                        }
                        catch (SIException e2) {
                            FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.sendToExceptionDestination", (String)"1:1558:1.137", (Object)this);
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e2));
                            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:1566:1.137", e2, this._exceptionDestinationName});
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"sendToExceptionDestination", (Object)((Object)e2));
                            }
                            throw new SIErrorException((Throwable)e2);
                        }
                    }
                }
                if (rc == UndeliverableReturnCode.BLOCK) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"sendToExceptionDestination", (Object)rc);
                    }
                    throw new SINotAuthorizedException(nls.getFormattedMessage("EXCEPTION_DESTINATION_AUTH_ERROR_SIMP0314", new Object[]{this._exceptionDestinationName, msg.getSecurityUserid()}, null));
                }
                sendComplete = false;
                while (!sendComplete) {
                    MessageItem newItem = new MessageItem(msg);
                    try {
                        newItem.setStoreAtSendTime(message.isToBeStoredAtSendTime());
                        TransactionCommon transaction = null;
                        transaction = tran == null ? (localTran = this._exceptionDestination.getTxManager().createLocalTransaction(false)) : tran;
                        this._inputHandler.handleMessage(newItem, transaction, this._messageProcessor.getMessagingEngineUuid());
                        JsMessagingEngine me = this._messageProcessor.getMessagingEngine();
                        if (me.isEventNotificationEnabled() || UserTrace.tc_mt.isDebugEnabled()) {
                            String apiMsgId = null;
                            if (message.getMessage() instanceof JsApiMessage) {
                                apiMsgId = ((JsApiMessage)message.getMessage()).getApiMessageId();
                            } else if (message.getMessage().getApiMessageIdAsBytes() != null) {
                                apiMsgId = message.getMessage().getApiMessageIdAsBytes().toString();
                            }
                            if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled() && message.getMessage().isApiMessage()) {
                                SibTr.debug((TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage("MESSAGE_EXCEPTION_DESTINATIONED_CWSJU0012", new Object[]{apiMsgId, message.getMessage().getSystemMessageId(), this._exceptionDestinationName, exceptionReason, message.getMessage().getExceptionMessage()}, null));
                            }
                            if (me.isEventNotificationEnabled()) {
                                this.fireMessageExceptionedEvent(apiMsgId, message, exceptionReason);
                            }
                        }
                        sendComplete = true;
                    }
                    catch (SIException e) {
                        if (!defaultInUse) {
                            SibTr.warning((TraceComponent)tc, (String)"EXCEPTION_DESTINATION_WARNING_CWSIP0291", (Object)new Object[]{this._exceptionDestinationName, this._messageProcessor.getMessagingEngineName(), e});
                            this._exceptionDestinationName = this._defaultExceptionDestinationName;
                            try {
                                this._exceptionDestination = this._messageProcessor.getDestinationManager().getDestination(this._exceptionDestinationName, true);
                                msg.setPriority(this._exceptionDestination.getDefaultPriority());
                                this._inputHandler = this._exceptionDestination.getInputHandler(this._exceptionDestination.isPubSub() ? ProtocolType.PUBSUBINPUT : ProtocolType.UNICASTINPUT, this._messageProcessor.getMessagingEngineUuid(), null);
                                defaultInUse = true;
                                continue;
                            }
                            catch (SIException e2) {
                                FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.sendToExceptionDestination", (String)"1:1702:1.137", (Object)this);
                                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:1713:1.137", e2, this._exceptionDestinationName});
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    SibTr.exit((TraceComponent)tc, (String)"sendToExceptionDestination", (Object)((Object)e2));
                                }
                                throw new SIErrorException((Throwable)e2);
                            }
                        }
                        if (e instanceof SIMPLimitExceededException) {
                            SibTr.warning((TraceComponent)tc, (String)"EXCEPTION_DESTINATION_WARNING_CWSIP0291", (Object)new Object[]{this._exceptionDestinationName, this._messageProcessor.getMessagingEngineName(), e});
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"sendToExceptionDestination", (Object)UndeliverableReturnCode.BLOCK);
                            }
                            throw (SIMPLimitExceededException)e;
                        }
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.sendToExceptionDestination", (String)"1:1741:1.137", (Object)this);
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:1747:1.137", e, this._exceptionDestinationName});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"sendToExceptionDestination", (Object)((Object)e));
                        }
                        throw new SIErrorException((Throwable)e);
                    }
                }
            }
        }
        if (message.getMessage().getReportException() != null) {
            if (this._reportHandler == null) {
                this._reportHandler = new ReportHandler(this._messageProcessor);
            }
            TransactionCommon transaction = tran == null ? localTran : tran;
            try {
                this._reportHandler.handleMessage(message, transaction, SIApiConstants.REPORT_EXCEPTION);
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.sendToExceptionDestination", (String)"1:1791:1.137", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"EXCEPTION_DESTINATION_ERROR_CWSIP0295", (Object)new Object[]{this._exceptionDestinationName, this._messageProcessor.getMessagingEngineName()});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"sendToExceptionDestination", (Object)((Object)e));
                }
                throw new SIResourceException((Throwable)e);
            }
        }
        if (localTran != null) {
            try {
                localTran.commit();
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.sendToExceptionDestination", (String)"1:1819:1.137", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.sendToExceptionDestination", "1:1824:1.137", e, this._exceptionDestinationName});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"sendToExceptionDestination", (Object)UndeliverableReturnCode.ERROR);
                }
                throw new SIResourceException((Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendToExceptionDestination");
        }
    }

    private UndeliverableReturnCode checkMessage(SIMPMessage message) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkMessage", (Object)message);
        }
        UndeliverableReturnCode rc = UndeliverableReturnCode.OK;
        Reliability discardReliabilityThreshold = Reliability.BEST_EFFORT_NONPERSISTENT;
        if (this._originalDestination != null) {
            discardReliabilityThreshold = this._originalDestination.getExceptionDiscardReliability();
        }
        if (message.getReliability().compareTo((Object)discardReliabilityThreshold) <= 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Message reliability (" + message.getReliability() + ") <= Exception reliability (" + discardReliabilityThreshold + ")"));
            }
            rc = UndeliverableReturnCode.DISCARD;
        } else if (this._originalDestination != null && this._originalDestination.isTemporary()) {
            rc = UndeliverableReturnCode.DISCARD;
        } else if (Boolean.TRUE.equals(message.getMessage().getReportDiscardMsg())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Message discarded at sender's request");
            }
            rc = UndeliverableReturnCode.DISCARD;
        } else if (this.isBlockRequired(message)) {
            rc = UndeliverableReturnCode.BLOCK;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkMessage", (Object)rc);
        }
        return rc;
    }

    private AccessResult checkExceptionDestinationAccess(JsMessage msg, ConnectionImpl conn, String alternateUser, boolean defaultInUse) {
        SecurityContext connSecContext;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkExceptionDestinationAccess", (Object)new Object[]{msg, conn, alternateUser, defaultInUse});
        }
        SecurityContext secContext = new SecurityContext(msg, alternateUser, null, this._messageProcessor.getAuthorisationUtils());
        boolean allowed = true;
        boolean identityAdoptionAllowed = true;
        if (defaultInUse) {
            if (conn != null) {
                connSecContext = new SecurityContext(conn.getSecuritySubject(), alternateUser, null, this._messageProcessor.getAuthorisationUtils());
                if (alternateUser != null && !this._messageProcessor.getAccessChecker().checkDestinationAccess(connSecContext, null, "_SYSTEM.Exception.Destination", OperationType.IDENTITY_ADOPTER)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"checkExceptionDestinationAccess", (Object)"not authorized to perform alternate user checks on this destination");
                    }
                    allowed = false;
                    identityAdoptionAllowed = false;
                }
                if (allowed && !this._messageProcessor.getAccessChecker().checkDestinationAccess(connSecContext, null, "_SYSTEM.Exception.Destination", OperationType.SEND)) {
                    allowed = false;
                }
            } else if (!this._messageProcessor.getAccessChecker().checkDestinationAccess(secContext, null, "_SYSTEM.Exception.Destination", OperationType.SEND)) {
                allowed = false;
            }
        } else if (conn != null) {
            connSecContext = new SecurityContext(conn.getSecuritySubject(), alternateUser, null, this._messageProcessor.getAuthorisationUtils());
            if (alternateUser != null && !this._exceptionDestination.checkDestinationAccess(connSecContext, OperationType.IDENTITY_ADOPTER)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"checkExceptionDestinationAccess", (Object)"not authorized to perform alternate user checks on this destination");
                }
                allowed = false;
                identityAdoptionAllowed = false;
            }
            if (allowed && !this._exceptionDestination.checkDestinationAccess(connSecContext, OperationType.SEND)) {
                allowed = false;
            }
        } else if (!this._exceptionDestination.checkDestinationAccess(secContext, OperationType.SEND)) {
            allowed = false;
        }
        AccessResult result = new AccessResult(allowed, identityAdoptionAllowed);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkExceptionDestinationAccess", (Object)result);
        }
        return result;
    }

    private void handleAccessDenied(AccessResult result, JsMessage msg, String alternateUser) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleAccessDenied", (Object)new Object[]{result, msg, alternateUser});
        }
        String userName = null;
        OperationType operationType = null;
        if (result.didIdentityAdoptionFail()) {
            userName = msg.getSecurityUserid();
            operationType = OperationType.IDENTITY_ADOPTER;
        } else {
            operationType = OperationType.SEND;
            userName = alternateUser != null ? alternateUser : msg.getSecurityUserid();
        }
        String nlsMessage = nls.getFormattedMessage("USER_NOT_AUTH_EXCEPTION_DEST_ERROR_CWSIP0313", new Object[]{userName, this._exceptionDestinationName}, null);
        this._messageProcessor.getAccessChecker().fireDestinationAccessNotAuthorizedEvent(this._exceptionDestinationName, userName, operationType, nlsMessage);
        SibTr.warning((TraceComponent)tc, (String)"USER_NOT_AUTH_EXCEPTION_DEST_ERROR_CWSIP0313", (Object)new Object[]{userName, this._exceptionDestinationName});
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleAccessDenied");
        }
    }

    private void fireMessageExceptionedEvent(String apiMsgId, SIMPMessage message, int exceptionReason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"fireMessageExceptionedEvent", (Object)new Object[]{apiMsgId, message, exceptionReason});
        }
        JsMessagingEngine me = this._messageProcessor.getMessagingEngine();
        RuntimeEventListener listener = this._messageProcessor.getRuntimeEventListener();
        String systemMessageId = message.getMessage().getSystemMessageId();
        if (listener != null) {
            String nlsMessage = nls_mt.getFormattedMessage("MESSAGE_EXCEPTION_DESTINATIONED_CWSJU0012", new Object[]{apiMsgId, systemMessageId, this._exceptionDestinationName, exceptionReason, message.getMessage().getExceptionMessage()}, null);
            Properties props = new Properties();
            String intendedDestinationName = "";
            String intendedDestinationUuid = SIBUuid12.toZeroString();
            if (this._originalDestination != null) {
                intendedDestinationName = this._originalDestination.getName();
                intendedDestinationUuid = this._originalDestination.getUuid().toString();
            }
            props.put("intended.destination.name", intendedDestinationName);
            props.put("intended.destination.UUID", intendedDestinationUuid);
            props.put("exception.destination.name", this._exceptionDestination.getName());
            props.put("exception.destination.UUID", this._exceptionDestination.getUuid().toString());
            props.put("system.message.identifier", systemMessageId == null ? "" : systemMessageId);
            props.put("message.exception.reason", String.valueOf(exceptionReason));
            listener.runtimeEventOccurred(me, "SIB.message.exceptioned", nlsMessage, props);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Null RuntimeEventListener, cannot fire event");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"fireMessageExceptionedEvent");
        }
    }

    private UndeliverableReturnCode sendToDefaultExceptionDestination(JsMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendToDefaultExceptionDestination", (Object)msg);
        }
        this._exceptionDestinationName = this._defaultExceptionDestinationName;
        try {
            this._exceptionDestination = this._messageProcessor.getDestinationManager().getDestination(this._exceptionDestinationName, true);
            msg.setPriority(this._exceptionDestination.getDefaultPriority());
            this._inputHandler = this._exceptionDestination.getInputHandler(this._exceptionDestination.isPubSub() ? ProtocolType.PUBSUBINPUT : ProtocolType.UNICASTINPUT, this._messageProcessor.getMessagingEngineUuid(), null);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.sendToDefaultExceptionDestination", (String)"1:2283:1.137", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:2294:1.137", e, this._exceptionDestinationName});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendToDefaultExceptionDestination", (Object)UndeliverableReturnCode.ERROR);
            }
            return UndeliverableReturnCode.ERROR;
        }
        catch (MessageStoreRuntimeException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl.sendToDefaultExceptionDestination", (String)"1:2307:1.137", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl", "1:2318:1.137", e, this._exceptionDestinationName});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendToDefaultExceptionDestination", (Object)UndeliverableReturnCode.ERROR);
            }
            return UndeliverableReturnCode.ERROR;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendToDefaultExceptionDestination", (Object)UndeliverableReturnCode.OK);
        }
        return UndeliverableReturnCode.OK;
    }

    private class AccessResult {
        private boolean _allowed = false;
        private boolean _identityAdoptionFailed = false;

        AccessResult(boolean allowed, boolean identityAdoptionFailed) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AccessResult", (Object)new Object[]{allowed, identityAdoptionFailed});
            }
            this._allowed = allowed;
            this._identityAdoptionFailed = identityAdoptionFailed;
        }

        public boolean isAllowed() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"isAllowed");
                SibTr.exit((TraceComponent)tc, (String)"isAllowed", (Object)this._allowed);
            }
            return this._allowed;
        }

        public boolean didIdentityAdoptionFail() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"didIdentityAdoptionFail");
                SibTr.exit((TraceComponent)tc, (String)"didIdentityAdoptionFail", (Object)this._identityAdoptionFailed);
            }
            return this._identityAdoptionFailed;
        }

        public String toString() {
            return "_allowed=" + Boolean.valueOf(this._allowed) + ",_identityAdoptionFailed=" + Boolean.valueOf(this._identityAdoptionFailed);
        }
    }
}

