/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.gd.AIStream;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.runtime.DeliveryStreamType;
import com.ibm.ws.sib.processor.runtime.HealthState;
import com.ibm.ws.sib.processor.runtime.IndoubtAction;
import com.ibm.ws.sib.processor.runtime.SIMPDeliveryReceiverControllable;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteConsumerReceiverControllable;
import com.ibm.ws.sib.processor.runtime.anycast.AIStreamIterator;
import com.ibm.ws.sib.processor.runtime.impl.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.HealthStateTree;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Iterator;
import java.util.List;

public class RemoteConsumerReceiver
extends AbstractControlAdapter
implements SIMPRemoteConsumerReceiverControllable {
    private AIStream aiStream;
    private DestinationHandler destinationHandler;
    private SIBUuid8 dme;
    private SIBUuid12 gatheringTargetDestUuid;
    private AnycastInputHandler anycastIH;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static TraceComponent tc = SibTr.register(RemoteConsumerReceiver.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public RemoteConsumerReceiver(AIStream aiStream) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"RemoteConsumerReceiver", (Object)new Object[]{aiStream});
        }
        this.aiStream = aiStream;
        this.anycastIH = aiStream.getAnycastInputHandler();
        this.destinationHandler = this.anycastIH.getBaseDestinationHandler();
        this.dme = this.anycastIH.getLocalisationUuid();
        this.gatheringTargetDestUuid = this.anycastIH.getGatheringTargetDestUuid();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"RemoteConsumerReceiver");
        }
    }

    public SIMPIterator getRemoteMessageRequestIterator() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteMessageRequestIterator");
        }
        AIStreamIterator aiStreamIterator = new AIStreamIterator(this.aiStream);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteMessageRequestIterator", (Object)aiStreamIterator);
        }
        return aiStreamIterator;
    }

    public void requestFlushAtSource(IndoubtAction indoubtAction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"requestFlushAtSource", (Object)indoubtAction);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"requestFlushAtSource");
        }
    }

    public long getLastTickReceived() throws SIMPRuntimeOperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLastTickReceived");
        }
        try {
            this.assertValidControllable();
        }
        catch (SIMPControllableNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.RemoteConsumerReceiver.getLastTickReceived", (String)"1:161:1.47", (Object)this);
            SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"RemoteConsumerReceiver.getLastTickReceived", "1:169:1.47", e, this.aiStream.getStreamId()}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getLastTickReceived", (Object)((Object)finalE));
            }
            throw finalE;
        }
        long tick = this.aiStream.getStateStream().getCompletedPrefix();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLastTickReceived", (Object)tick);
        }
        return tick;
    }

    public void forceFlushAtTarget() throws SIMPRuntimeOperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceFlushAtTarget");
        }
        try {
            this.assertValidControllable();
        }
        catch (SIMPControllableNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.RemoteConsumerReceiver.forceFlushAtTarget", (String)"1:204:1.47", (Object)this);
            SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"RemoteConsumerReceiver.forceFlushAtTarget", "1:212:1.47", e, this.aiStream.getStreamId()}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"forceFlushAtTarget", (Object)((Object)finalE));
            }
            throw finalE;
        }
        AnycastInputHandler aih = this.destinationHandler.getAnycastInputHandler(this.dme, this.gatheringTargetDestUuid, true);
        if (aih != null) {
            aih.forceFlushAtTarget();
            try {
                String key = SIMPUtils.getRemoteGetKey(this.dme, this.gatheringTargetDestUuid);
                ((BaseDestinationHandler)this.destinationHandler).removeAnycastInputHandlerAndRCD(key);
            }
            catch (SIResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.RemoteConsumerReceiver.forceFlushAtTarget", (String)"1:238:1.47", (Object)this);
                SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"RemoteConsumerReceiver.forceFlushAtTarget", "1:246:1.47", e, this.aiStream.getStreamId()}, null), (Throwable)e);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"forceFlushAtTarget", (Object)((Object)finalE));
                }
                throw finalE;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceFlushAtTarget");
        }
    }

    public DeliveryStreamType getType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getType");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getType", (Object)DeliveryStreamType.ANYCAST_TARGET);
        }
        return DeliveryStreamType.ANYCAST_TARGET;
    }

    public String getId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
        }
        String id = this.aiStream.getStreamId().toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getId");
        }
        return id;
    }

    public String getName() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName", null);
        }
        return null;
    }

    public void cancelAllRequests() {
        try {
            this.forceFlushAtTarget();
        }
        catch (SIMPRuntimeOperationFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.RemoteConsumerReceiver.cancelAllRequests", (String)"1:316:1.47", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.RemoteConsumerReceiver.cancelAllRequests", "1:321:1.47", SIMPUtils.getStackTrace(e)});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
    }

    @Override
    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this.aiStream == null || this.aiStream.getAIProtocolItemStream() == null) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"RemoteConsumerReceiver.assertValidControllable", "1:342:1.47", this.aiStream}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    @Override
    public void dereferenceControllable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    @Override
    public void registerControlAdapterAsMBean() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
    }

    @Override
    public void deregisterControlAdapterMBean() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
        }
    }

    @Override
    public void runtimeEventOccurred(RuntimeEvent event) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"runtimeEventOccurred", (Object)event);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"runtimeEventOccurred");
        }
    }

    public int getNumberOfActiveRequests() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfActiveRequests");
        }
        List<Long> all = this.aiStream.getTicksOnStream();
        Iterator<Long> it = all.iterator();
        int activeCount = 0;
        while (it.hasNext()) {
            TickRange tr = this.aiStream.getTickRange(it.next());
            if (tr.type == 6) continue;
            ++activeCount;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfActiveRequests", (Object)activeCount);
        }
        return activeCount;
    }

    public long getNumberOfCompletedRequests() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfCompletedRequests");
        }
        long returnValue = this.anycastIH.getCompletedRequestCount();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfCompletedRequests", (Object)returnValue);
        }
        return returnValue;
    }

    public long getNumberOfRequestsIssued() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfRequestsIssued");
        }
        long returnValue = this.anycastIH.getTotalSentRequests();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfRequestsIssued", (Object)returnValue);
        }
        return returnValue;
    }

    public SIBUuid12 getStreamID() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamID");
        }
        SIBUuid12 returnValue = this.aiStream.getStreamId();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamID", (Object)returnValue);
        }
        return returnValue;
    }

    public SIMPDeliveryReceiverControllable.StreamState getStreamState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamState");
        }
        AIStream.AIStreamState returnValue = this.aiStream.getStreamState();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamState", (Object)returnValue);
        }
        return returnValue;
    }

    @Override
    public String getRemoteEngineUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteEngineUuid");
        }
        String returnString = this.dme.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteEngineUuid", (Object)returnString);
        }
        return returnString;
    }

    public HealthState getHealthState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getHealthState");
            SibTr.exit((TraceComponent)tc, (String)"getHealthState", (Object)2);
        }
        return new HealthStateTree();
    }

    public String getDestinationUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationUuid");
            SibTr.exit((TraceComponent)tc, (String)"getDestinationUuid", (Object)this.gatheringTargetDestUuid);
        }
        return String.valueOf(this.gatheringTargetDestUuid);
    }

    public boolean isGathering() {
        boolean isGathering;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isGathering");
        }
        boolean bl = isGathering = this.gatheringTargetDestUuid != null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isGathering", (Object)isGathering);
        }
        return isGathering;
    }
}

