/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.springboot.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.jar.Manifest;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SpringBootManifest {
    private static final String JAR_MAIN_CLASS = "Main-Class";
    private static final String SPRING_START_CLASS_HEADER = "Start-Class";
    private static final String SPRING_BOOT_CLASSES_HEADER = "Spring-Boot-Classes";
    private static final String SPRING_BOOT_LIB_HEADER = "Spring-Boot-Lib";
    private final String springStartClass;
    private final String springBootClasses;
    private final String springBootLib;
    private final String springBootLibPrivided;
    static final long serialVersionUID = 2157521733151322300L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public String getSpringStartClass() {
        return this.springStartClass;
    }

    public String getSpringBootClasses() {
        return this.springBootClasses;
    }

    public String getSpringBootLib() {
        return this.springBootLib;
    }

    public String getSpringBootLibProvided() {
        return this.springBootLibPrivided;
    }

    public SpringBootManifest(Manifest mf) {
        String mainClass = mf.getMainAttributes().getValue(JAR_MAIN_CLASS);
        SpringLauncher launcher = SpringLauncher.fromMainClass(mainClass);
        this.springStartClass = mf.getMainAttributes().getValue(SPRING_START_CLASS_HEADER);
        this.springBootClasses = SpringBootManifest.getSpringHeader(mf, SPRING_BOOT_CLASSES_HEADER, launcher);
        this.springBootLib = SpringBootManifest.getSpringHeader(mf, SPRING_BOOT_LIB_HEADER, launcher);
        this.springBootLibPrivided = SpringBootManifest.getLibProvided(launcher, this.springBootLib);
    }

    private static String getSpringHeader(Manifest mf, String springBootHeaderKey, SpringLauncher launcher) {
        String value = mf.getMainAttributes().getValue(springBootHeaderKey);
        if (value == null) {
            value = launcher.getDefault(springBootHeaderKey);
        }
        return SpringBootManifest.removeTrailingSlash(value);
    }

    private static String removeTrailingSlash(String path) {
        if (path != null && path.length() > 1 && path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    private static String getLibProvided(SpringLauncher launcher, String springBootLib) {
        String suffix = launcher.getLibProvidedSuffix();
        if (suffix != null) {
            return springBootLib + suffix;
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SpringBootManifest.class, (String[])new String[]{"springboot", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.springboot.internal.resources.Messages", (String)"com.ibm.ws.app.manager.springboot.util.SpringBootManifest");
    }

    static enum SpringLauncher {
        JarLauncher("JarLauncher", "BOOT-INF/lib/", "BOOT-INF/classes/"),
        WarLauncher("WarLauncher", "WEB-INF/lib/", "WEB-INF/classes/", "-provided");

        private final String name;
        private final String libDefault;
        private final String classesDefault;
        private final String libProvidedSuffix;

        private SpringLauncher(String name, String libDefault, String classesDefault) {
            this(name, libDefault, classesDefault, null);
        }

        private SpringLauncher(String name, String libDefault, String classesDefault, String libProvidedSuffix) {
            this.name = name;
            this.libDefault = libDefault;
            this.classesDefault = classesDefault;
            this.libProvidedSuffix = libProvidedSuffix;
        }

        static SpringLauncher fromMainClass(String mainClass) {
            if (mainClass != null) {
                mainClass = mainClass.trim();
                for (SpringLauncher l : SpringLauncher.values()) {
                    if (!mainClass.endsWith(l.name)) continue;
                    return l;
                }
            }
            return JarLauncher;
        }

        String getDefault(String springBootHeaderKey) {
            switch (springBootHeaderKey) {
                case "Spring-Boot-Classes": {
                    return this.classesDefault;
                }
                case "Spring-Boot-Lib": {
                    return this.libDefault;
                }
            }
            return null;
        }

        String getLibProvidedSuffix() {
            return this.libProvidedSuffix;
        }
    }
}

