/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.lumberjack;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.lumberjack.LumberjackClient;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.ssl.SSLSupport;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MTLumberjackClient
extends LumberjackClient {
    private final String MT_PROTOCOL_VERSION = "2";
    private final String TENANT_FRAME_TYPE = "T";
    static final long serialVersionUID = 2411341315852364496L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public MTLumberjackClient(String sslConfig, SSLSupport sslSupport) throws SSLException {
        super(sslConfig, sslSupport);
    }

    public boolean authorize(String tenantId, @Sensitive String tenantPassword) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] tenantIdBytes = tenantId.getBytes("UTF-8");
        byte[] tenantPasswordBytes = tenantPassword.getBytes("UTF-8");
        byte tenantIdLength = (byte)tenantIdBytes.length;
        byte tenantPasswordLength = (byte)tenantPasswordBytes.length;
        output.write("2".getBytes("UTF-8"));
        output.write("T".getBytes("UTF-8"));
        output.write(ByteBuffer.allocate(1).put(tenantIdLength).array());
        output.write(tenantIdBytes);
        output.write(ByteBuffer.allocate(1).put(tenantPasswordLength).array());
        output.write(tenantPasswordBytes);
        this.writeFrame(output.toByteArray());
        byte[] buffer = new byte[6];
        int bytesReceived = 0;
        while ((bytesReceived += this.in.read(buffer, bytesReceived, buffer.length - bytesReceived)) != -1) {
            if (bytesReceived != 6) continue;
            String response = new String(Arrays.copyOfRange(buffer, 0, 1), "UTF-8");
            String frameType = new String(Arrays.copyOfRange(buffer, 1, 2), "UTF-8");
            if (frameType.equals("A")) {
                return !response.equals("0");
            }
            return false;
        }
        return false;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.lumberjack.MTLumberjackClient", MTLumberjackClient.class, null, null);
    }
}

