/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.token.Saml20TokenImpl;
import com.ibm.ws.security.sso.common.SsoService;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import java.util.HashMap;
import java.util.Map;
import org.opensaml.saml2.core.Assertion;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Saml20SsoServiceImpl
implements SsoService {
    private static TraceComponent tc = Tr.register(Saml20SsoServiceImpl.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    public static final String KEY_SSO_SERVICE = "ssoService";
    private static final ConcurrentServiceReferenceMap<String, SsoService> ssoServiceRefs = new ConcurrentServiceReferenceMap("ssoService");
    static final long serialVersionUID = 4697716545400163207L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSsoService(ServiceReference<SsoService> reference) {
        String type = (String)reference.getProperty("type");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("saml20 setSsoService type=" + type), (Object[])new Object[0]);
        }
        ConcurrentServiceReferenceMap<String, SsoService> concurrentServiceReferenceMap = ssoServiceRefs;
        synchronized (concurrentServiceReferenceMap) {
            ssoServiceRefs.putReference((Object)type, reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetSsoService(ServiceReference<SsoService> reference) {
        String type = (String)reference.getProperty("type");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("saml20 unsetSsoService type=" + type), (Object[])new Object[0]);
        }
        ConcurrentServiceReferenceMap<String, SsoService> concurrentServiceReferenceMap = ssoServiceRefs;
        synchronized (concurrentServiceReferenceMap) {
            ssoServiceRefs.removeReference((Object)type, reference);
        }
    }

    protected void activate(ComponentContext cc) {
        ssoServiceRefs.activate(cc);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SsoService activated", (Object[])new Object[0]);
        }
    }

    protected void deactivate(ComponentContext cc) {
        ssoServiceRefs.deactivate(cc);
    }

    public Map<String, Object> handleRequest(String requestName, Map<String, Object> requestContext) throws Exception {
        Map<String, Object> result = new HashMap<String, Object>();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("saml20 handleRequest requestName:" + requestName + "requestContext:" + requestContext), (Object[])new Object[0]);
        }
        if ("wssecurity-samlassertion".equals(requestName)) {
            Assertion assertion = null;
            assertion = (Assertion)requestContext.get("wssecurity-samlassertion");
            if (assertion != null) {
                result = this.handleSamlAssertion(assertion);
            }
        }
        return result;
    }

    private Map<String, Object> handleSamlAssertion(Assertion assertion) throws SamlException {
        Saml20TokenImpl token = new Saml20TokenImpl(assertion);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("samlssotoken", token);
        return result;
    }
}

