/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.acs;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContext;
import com.ibm.ws.security.saml.sso20.internal.utils.SignatureMethods;
import java.util.List;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.common.binding.security.BaseSAMLXMLSignatureSecurityPolicyRule;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Response;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.trust.TrustEngine;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SAMLMessageXMLSignatureSecurityPolicyRule
extends BaseSAMLXMLSignatureSecurityPolicyRule {
    private static TraceComponent tc = Tr.register(SAMLMessageXMLSignatureSecurityPolicyRule.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    private final Validator<Signature> sigValidator;
    String processType = "";
    static final long serialVersionUID = -2650453441637014397L;

    public SAMLMessageXMLSignatureSecurityPolicyRule(TrustEngine<Signature> engine) {
        super(engine);
        this.sigValidator = new SAMLSignatureProfileValidator();
    }

    public SAMLMessageXMLSignatureSecurityPolicyRule(TrustEngine<Signature> engine, Validator<Signature> signatureValidator) {
        super(engine);
        this.sigValidator = signatureValidator;
    }

    public void evaluate(MessageContext messageContext) throws SecurityPolicyException {
        if (!(messageContext instanceof SAMLMessageContext)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Invalid message context type, this policy rule only supports SAMLMessageContext", (Object[])new Object[0]);
            }
            return;
        }
        this.evaluateProfile((SAMLMessageContext)messageContext);
        this.evaluateProtocol((SAMLMessageContext)messageContext);
    }

    public void evaluateProfile(SAMLMessageContext<?, ?, ?> samlMsgCtx) throws SecurityPolicyException {
        this.processType = "Profile";
        SAMLObject samlMsg = samlMsgCtx.getInboundSAMLMessage();
        if (!(samlMsg instanceof SignableSAMLObject)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Extracted SAML message was not a SignableSAMLObject, can not process signature", (Object[])new Object[0]);
            }
            return;
        }
        if (samlMsg instanceof Response) {
            Response samlResponse = (Response)samlMsg;
            List assertions = samlResponse.getAssertions();
            for (Assertion assertion : assertions) {
                if (!(assertion instanceof SignableSAMLObject)) continue;
                if (!assertion.isSigned() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"A SAML assertion is not signed. We do not allow this kind of situation", (Object[])new Object[0]);
                }
                this.evaluate(samlMsgCtx, (SignableSAMLObject)assertion);
            }
        }
    }

    public void evaluateAssertion(SAMLMessageContext<?, ?, ?> samlMsgCtx, Assertion assertion) throws SecurityPolicyException {
        this.processType = "Profile";
        if (!assertion.isSigned()) {
            return;
        }
        this.evaluate(samlMsgCtx, (SignableSAMLObject)assertion);
    }

    public void evaluateProtocol(SAMLMessageContext<?, ?, ?> samlMsgCtx) throws SecurityPolicyException {
        this.processType = "Protocol";
        SAMLObject samlMsg = samlMsgCtx.getInboundSAMLMessage();
        if (!(samlMsg instanceof SignableSAMLObject)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Extracted SAML message was not a SignableSAMLObject, can not process signature", (Object[])new Object[0]);
            }
            return;
        }
        SignableSAMLObject signableObject = (SignableSAMLObject)samlMsg;
        if (!signableObject.isSigned()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SAML protocol message was not signed, skipping XML signature processing", (Object[])new Object[0]);
            }
            return;
        }
        this.evaluate(samlMsgCtx, signableObject);
    }

    public void evaluateResponse(SAMLMessageContext<?, ?, ?> samlMsgCtx) throws SecurityPolicyException {
        this.processType = "Protocol";
        SAMLObject samlMsg = samlMsgCtx.getInboundSAMLMessage();
        if (!(samlMsg instanceof SignableSAMLObject)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Extracted SAML message was not a SignableSAMLObject, can not process signature", (Object[])new Object[0]);
            }
            return;
        }
        SignableSAMLObject signableObject = (SignableSAMLObject)samlMsg;
        if (!signableObject.isSigned()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SAML protocol message was not signed, skipping XML signature processing", (Object[])new Object[0]);
            }
            return;
        }
        this.evaluate(samlMsgCtx, signableObject);
    }

    public void evaluate(SAMLMessageContext<?, ?, ?> samlMsgCtx, SignableSAMLObject assertion) throws SecurityPolicyException {
        Signature signature = assertion.getSignature();
        this.evaluateSignatureMethod(samlMsgCtx, signature);
        this.performPreValidation(signature);
        this.doEvaluate(signature, assertion, samlMsgCtx);
    }

    protected void evaluateSignatureMethod(SAMLMessageContext<?, ?, ?> samlMsgCtx, Signature signature) throws SecurityPolicyException {
        String configMethod = ((BasicMessageContext)samlMsgCtx).getSsoConfig().getSignatureMethodAlgorithm();
        String messageMethod = signature.getSignatureAlgorithm();
        if (SignatureMethods.toInteger(messageMethod) < SignatureMethods.toInteger(configMethod)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Required signature method is " + configMethod), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Received signature method is " + messageMethod), (Object[])new Object[0]);
            }
            throw new SecurityPolicyException("The server is configured with the signature method " + configMethod + " but the received SAML assertion is signed with the signature method " + messageMethod + ", the signature method provided is weaker than the required.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void doEvaluate(Signature signature, SignableSAMLObject signableObject, SAMLMessageContext<?, ?, ?> samlMsgCtx) throws SecurityPolicyException {
        String contextIssuer = samlMsgCtx.getInboundMessageIssuer();
        if (contextIssuer == null) {
            if (!tc.isDebugEnabled()) throw new SecurityPolicyException("Context issuer unavailable, can not validate signature");
            Tr.debug((TraceComponent)tc, (String)("Context issuer unavailable, can not attempt SAML " + this.processType + " message signature validation"), (Object[])new Object[0]);
            throw new SecurityPolicyException("Context issuer unavailable, can not validate signature");
        }
        String msgType = signableObject.getElementQName().toString();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Attempting to verify signature on signed SAML " + this.processType + " message using context issuer message type: " + msgType), (Object[])new Object[0]);
        }
        if (!this.evaluate(signature, contextIssuer, (MessageContext)samlMsgCtx)) {
            if (!tc.isDebugEnabled()) throw new SecurityPolicyException("Validation of " + this.processType + " message signature failed");
            Tr.debug((TraceComponent)tc, (String)("Validation of " + this.processType + " message signature failed for context issuer '" + contextIssuer + "', message type: " + msgType), (Object[])new Object[0]);
            throw new SecurityPolicyException("Validation of " + this.processType + " message signature failed");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Validation of " + this.processType + " message signature succeeded, message type: " + msgType), (Object[])new Object[0]);
        }
        if (samlMsgCtx.isInboundSAMLMessageAuthenticated()) return;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Authentication via " + this.processType + " message signature succeeded for context issuer entity ID " + contextIssuer), (Object[])new Object[0]);
        }
        samlMsgCtx.setInboundSAMLMessageAuthenticated(true);
    }

    protected Validator<Signature> getSignaturePrevalidator() {
        return this.sigValidator;
    }

    /*
     * WARNING - void declaration
     */
    protected void performPreValidation(Signature signature) throws SecurityPolicyException {
        if (this.getSignaturePrevalidator() != null) {
            try {
                this.getSignaturePrevalidator().validate((XMLObject)signature);
            }
            catch (ValidationException validationException) {
                void e;
                FFDCFilter.processException((Throwable)validationException, (String)"com.ibm.ws.security.saml.sso20.acs.SAMLMessageXMLSignatureSecurityPolicyRule", (String)"271", (Object)((Object)this), (Object[])new Object[]{signature});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)(this.processType + " message signature failed signature pre-validation"), (Object[])new Object[]{e});
                }
                throw new SecurityPolicyException(this.processType + " message signature failed signature pre-validation", (Exception)e);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(this.processType + " message signature failed without pre-validation"), (Object[])new Object[0]);
            }
            throw new SecurityPolicyException(this.processType + " message signature failed signature pre-validation");
        }
    }
}

