/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.common.structures.Cache;
import com.ibm.ws.security.filemonitor.FileBasedActionable;
import com.ibm.ws.security.filemonitor.SecurityFileMonitor;
import com.ibm.ws.security.saml.Constants;
import com.ibm.ws.security.saml.SsoConfig;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.internal.PkixTrustEngineConfig;
import com.ibm.ws.security.saml.sso20.internal.SAMLRequestTAI;
import com.ibm.ws.security.saml.sso20.internal.SsoConfigImpl;
import com.ibm.ws.security.saml.sso20.internal.utils.UnsolicitedResponseCache;
import com.ibm.ws.security.saml.sso20.rs.RsSamlConfigImpl;
import com.ibm.ws.ssl.KeyStoreService;
import com.ibm.ws.webcontainer.security.WebProviderAuthenticatorHelper;
import com.ibm.wsspi.kernel.filemonitor.FileMonitor;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.ssl.SSLSupport;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SsoServiceImpl
implements SsoSamlService {
    public static final TraceComponent tc = Tr.register(SsoServiceImpl.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    public static final String TYPE = "SAMLSso20";
    public static final String VERSION = "v1.0";
    static final String CONFIGURATION_ADMIN = "configurationAdmin";
    static final String KEY_SECURITY_SERVICE = "securityService";
    static final String KEY_SERVICE_PID = "service.pid";
    static final String KEY_PROVIDER_ID = "id";
    static final String KEY_ID = "id";
    static final String KEY_inboundPropagation = "inboundPropagation";
    boolean isSamlInbound = false;
    private String providerId = null;
    private volatile ConfigurationAdmin configAdmin = null;
    protected AtomicServiceReference<SecurityService> securityServiceRef = new AtomicServiceReference("securityService");
    public static final String KEY_KEYSTORE_SERVICE = "keyStoreService";
    protected AtomicServiceReference<KeyStoreService> keyStoreServiceRef = new AtomicServiceReference("keyStoreService");
    public static final String KEY_SSL_SUPPORT = "sslSupport";
    protected AtomicServiceReference<SSLSupport> sslSupportRef = new AtomicServiceReference("sslSupport");
    static final HashMap<String, Cache> acsCookieCacheMap = new HashMap();
    static final HashMap<String, UnsolicitedResponseCache> replayCacheMap = new HashMap();
    protected SsoConfig samlConfig = new SsoConfigImpl();
    static HashMap<String, SsoSamlService> samlServiceMap = new HashMap();
    private WebProviderAuthenticatorHelper authHelper;
    private SecurityFileMonitor idpMetadataFileMonitor;
    private ServiceRegistration<FileMonitor> idpMetadataFileMonitorRegistration;
    static final long serialVersionUID = -7516611989692527778L;

    protected void setConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
        this.getSamlConfig().setConfigAdmin(configAdmin);
    }

    protected void updateConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
        this.getSamlConfig().setConfigAdmin(configAdmin);
    }

    protected void unsetConfigurationAdmin(ServiceReference<ConfigurationAdmin> ref) {
        this.configAdmin = null;
        this.getSamlConfig().setConfigAdmin(null);
    }

    protected void setSecurityService(ServiceReference<SecurityService> ref) {
        this.securityServiceRef.setReference(ref);
    }

    protected void unsetSecurityService(ServiceReference<SecurityService> ref) {
        this.securityServiceRef.unsetReference(ref);
    }

    protected void setKeyStoreService(ServiceReference<KeyStoreService> ref) {
        this.keyStoreServiceRef.setReference(ref);
    }

    protected void unsetKeyStoreService(ServiceReference<KeyStoreService> ref) {
        this.keyStoreServiceRef.unsetReference(ref);
    }

    protected void setSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.setReference(ref);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setSslSupport service.pid:" + ref.getProperty(KEY_SERVICE_PID)), (Object[])new Object[0]);
        }
    }

    protected void updatedSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.setReference(ref);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updatedtSslSupport service.pid:" + ref.getProperty(KEY_SERVICE_PID)), (Object[])new Object[0]);
        }
    }

    protected void unsetSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.unsetReference(ref);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unsetSslSupport service.pid:" + ref.getProperty(KEY_SERVICE_PID)), (Object[])new Object[0]);
        }
    }

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> props) {
        this.providerId = (String)props.get("id");
        this.securityServiceRef.activate(cc);
        this.keyStoreServiceRef.activate(cc);
        this.sslSupportRef.activate(cc);
        this.initProps(cc, props);
        Tr.info((TraceComponent)tc, (String)"SAML20_CONFIG_PROCESSED", (Object[])new Object[]{this.providerId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initProps(ComponentContext cc, Map<String, Object> props) {
        HashMap<String, Cache> hashMap;
        Object cache;
        String inboundPropagation = ((String)props.get(KEY_inboundPropagation)).trim();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.providerId + " inboundPropagation:'" + inboundPropagation + "'"), (Object[])new Object[0]);
        }
        this.isSamlInbound = "required".equals(inboundPropagation) || "true".equals(inboundPropagation);
        PkixTrustEngineConfig ssoConfig = null;
        ssoConfig = this.isSamlInbound ? new RsSamlConfigImpl(cc, props, this.configAdmin, SAMLRequestTAI.getFilterIdMap(), this) : new SsoConfigImpl(cc, props, this.configAdmin, SAMLRequestTAI.getFilterIdMap(), this);
        this.setSamlConfig((SsoConfig)((Object)ssoConfig));
        this.createFileMonitor(this.getSamlConfig());
        this.authHelper = new WebProviderAuthenticatorHelper(this.securityServiceRef);
        if (acsCookieCacheMap.get(this.providerId) == null) {
            cache = new Cache(0, 0L);
            hashMap = acsCookieCacheMap;
            synchronized (hashMap) {
                acsCookieCacheMap.put(this.providerId, (Cache)cache);
            }
        }
        if (replayCacheMap.get(this.providerId) == null) {
            cache = new UnsolicitedResponseCache(0, 0L, this.getSamlConfig().getClockSkew());
            hashMap = acsCookieCacheMap;
            synchronized (hashMap) {
                replayCacheMap.put(this.providerId, (UnsolicitedResponseCache)cache);
            }
        }
    }

    @Modified
    protected void modified(ComponentContext cc, Map<String, Object> props) {
        this.providerId = (String)props.get("id");
        this.unsetFileMonitorRegistration();
        this.initProps(cc, props);
        Tr.info((TraceComponent)tc, (String)"SAML20_CONFIG_MODIFIED", (Object[])new Object[]{this.providerId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.unsetFileMonitorRegistration();
        this.securityServiceRef.deactivate(cc);
        this.keyStoreServiceRef.deactivate(cc);
        this.setSamlConfig(new SsoConfigImpl());
        this.sslSupportRef.deactivate(cc);
        HashMap<String, Cache> hashMap = acsCookieCacheMap;
        synchronized (hashMap) {
            acsCookieCacheMap.remove(this.providerId);
            replayCacheMap.remove(this.providerId);
        }
        Tr.info((TraceComponent)tc, (String)"SAML20_CONFIG_DEACTIVATED", (Object[])new Object[]{this.providerId});
    }

    public void setSamlConfig(SsoConfig samlConfig) {
        this.samlConfig = samlConfig;
    }

    @Override
    public SsoConfig getConfig() {
        return this.samlConfig;
    }

    public SsoConfig getSamlConfig() {
        return this.samlConfig;
    }

    @Override
    public String getProviderId() {
        return this.providerId;
    }

    @Override
    public Constants.SamlSsoVersion getSamlVersion() {
        return Constants.SamlSsoVersion.SAMLSSO20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cache getAcsCookieCache(String providerId) {
        Cache cache = acsCookieCacheMap.get(providerId);
        if (cache == null) {
            cache = new Cache(0, 0L);
            HashMap<String, Cache> hashMap = acsCookieCacheMap;
            synchronized (hashMap) {
                acsCookieCacheMap.put(providerId, cache);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("acsCockieCache providerId:" + providerId + " cache:" + cache), (Object[])new Object[0]);
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnsolicitedResponseCache getUnsolicitedResponseCache(String providerId) {
        UnsolicitedResponseCache cache = replayCacheMap.get(providerId);
        if (cache == null) {
            cache = new UnsolicitedResponseCache(0, 0L, this.getSamlConfig().getClockSkew());
            HashMap<String, UnsolicitedResponseCache> hashMap = replayCacheMap;
            synchronized (hashMap) {
                replayCacheMap.put(providerId, cache);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("replayCacheMap providerId:" + providerId + " cache:" + cache), (Object[])new Object[0]);
        }
        return cache;
    }

    @Override
    public WebProviderAuthenticatorHelper getAuthHelper() {
        return this.authHelper;
    }

    @Override
    public String getAuthFilterId() {
        return this.getSamlConfig().getAuthFilterId();
    }

    @Sensitive
    public String getDefaultKeyStoreProperty(String propKey) {
        String keyStorePropValue = null;
        SSLSupport sslSupport = (SSLSupport)this.getSslSupportRef().getService();
        JSSEHelper jsseHelper = null;
        if (sslSupport != null) {
            jsseHelper = sslSupport.getJSSEHelper();
        }
        Properties props = null;
        if (jsseHelper != null) {
            block6: {
                try {
                    HashMap<String, String> connectionInfo = new HashMap<String, String>();
                    connectionInfo.put("com.ibm.ssl.direction", "inbound");
                    props = jsseHelper.getProperties("", connectionInfo, null, true);
                }
                catch (SSLException connectionInfo) {
                    FFDCFilter.processException((Throwable)connectionInfo, (String)"com.ibm.ws.security.saml.sso20.internal.SsoServiceImpl", (String)"321", (Object)this, (Object[])new Object[]{propKey});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                    Tr.debug((TraceComponent)tc, (String)"Exception getting jssehelper!!!", (Object[])new Object[0]);
                }
            }
            if (props != null) {
                keyStorePropValue = props.getProperty(propKey);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("KeyStore property ( " + propKey + " ) from default ssl config  "), (Object[])new Object[0]);
                }
            }
        }
        return keyStorePropValue;
    }

    @Override
    @Sensitive
    @FFDCIgnore(value={CertificateException.class, KeyStoreException.class})
    public PrivateKey getPrivateKey() throws KeyStoreException, CertificateException {
        String keyStoreName = this.getSamlConfig().getKeyStoreRef();
        String keyAlias = this.getSamlConfig().getKeyAlias();
        if (keyStoreName == null) {
            keyStoreName = this.getDefaultKeyStoreProperty("com.ibm.ssl.keyStoreName");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"KeyStore name from default ssl config  = ", (Object[])new Object[]{keyStoreName});
            }
        }
        KeyStoreService keyStoreService = (KeyStoreService)this.getKeyStoreServiceRef().getService();
        PrivateKey privateKey = null;
        if (keyStoreService != null) {
            if (keyAlias == null) {
                keyAlias = "samlsp";
                try {
                    privateKey = keyStoreService.getPrivateKeyFromKeyStore(keyStoreName, keyAlias, this.getSamlConfig().getKeyPassword());
                }
                catch (KeyStoreException kse) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception getting key using default alias.", (Object[])new Object[]{kse.toString()});
                        Tr.debug((TraceComponent)tc, (String)"Try getting key one more time to see if there is only one key!!", (Object[])new Object[0]);
                    }
                    privateKey = keyStoreService.getPrivateKeyFromKeyStore(keyStoreName);
                }
                catch (CertificateException ce) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception getting key using default alias.", (Object[])new Object[]{ce.toString()});
                        Tr.debug((TraceComponent)tc, (String)"Try getting key one more time to see if there is only one key!!", (Object[])new Object[0]);
                    }
                    privateKey = keyStoreService.getPrivateKeyFromKeyStore(keyStoreName);
                }
            } else {
                privateKey = keyStoreService.getPrivateKeyFromKeyStore(keyStoreName, keyAlias, this.getSamlConfig().getKeyPassword());
            }
        }
        return privateKey;
    }

    @Override
    @Sensitive
    @FFDCIgnore(value={CertificateException.class, KeyStoreException.class})
    public Certificate getSignatureCertificate() throws KeyStoreException, CertificateException {
        String keyStoreName = this.getSamlConfig().getKeyStoreRef();
        String keyAlias = this.getSamlConfig().getKeyAlias();
        if (keyStoreName == null) {
            keyStoreName = this.getDefaultKeyStoreProperty("com.ibm.ssl.keyStoreName");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"KeyStore name from default ssl config  = ", (Object[])new Object[]{keyStoreName});
            }
        }
        KeyStoreService keyStoreService = (KeyStoreService)this.getKeyStoreServiceRef().getService();
        Certificate cert = null;
        if (keyAlias == null) {
            keyAlias = "samlsp";
            try {
                cert = keyStoreService.getCertificateFromKeyStore(keyStoreName, keyAlias);
            }
            catch (KeyStoreException kse) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception getting key using default alias.", (Object[])new Object[]{kse.toString()});
                    Tr.debug((TraceComponent)tc, (String)"Try getting key one more time to see if there is only one key!!", (Object[])new Object[0]);
                }
                cert = keyStoreService.getX509CertificateFromKeyStore(keyStoreName);
            }
            catch (CertificateException ce) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception getting key using default alias.", (Object[])new Object[]{ce.toString()});
                    Tr.debug((TraceComponent)tc, (String)"Try getting key one more time to see if there is only one key!!", (Object[])new Object[0]);
                }
                cert = keyStoreService.getX509CertificateFromKeyStore(keyStoreName);
            }
        } else {
            cert = keyStoreService.getCertificateFromKeyStore(keyStoreName, keyAlias);
        }
        return cert;
    }

    /*
     * WARNING - void declaration
     */
    void createFileMonitor(SsoConfig samlConfig) {
        block9: {
            try {
                if (samlConfig instanceof FileBasedActionable) {
                    this.idpMetadataFileMonitor = new SecurityFileMonitor((FileBasedActionable)samlConfig);
                    String idpFileName = samlConfig.getIdpMetadata();
                    if (idpFileName != null && !idpFileName.isEmpty()) {
                        this.setFileMonitorRegistration((ServiceRegistration<FileMonitor>)this.idpMetadataFileMonitor.monitorFiles(Arrays.asList(samlConfig.getIdpMetadata()), 2000L));
                    }
                } else if (samlConfig instanceof RsSamlConfigImpl) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The rsSamlConfig does not need to monitor idp metadata xml file.", (Object[])new Object[0]);
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ERROR: The samlConfig is not an FileBasedActionable instance.", (Object[])new Object[0]);
                }
            }
            catch (Exception idpFileName) {
                void e;
                FFDCFilter.processException((Throwable)idpFileName, (String)"com.ibm.ws.security.saml.sso20.internal.SsoServiceImpl", (String)"457", (Object)this, (Object[])new Object[]{samlConfig});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                Tr.debug((TraceComponent)tc, (String)"Exception creating the idpMetadata file monitor.", (Object[])new Object[]{e});
            }
        }
    }

    protected void setFileMonitorRegistration(ServiceRegistration<FileMonitor> idpMetadataFileMonitorRegistration) {
        this.idpMetadataFileMonitorRegistration = idpMetadataFileMonitorRegistration;
    }

    protected void unsetFileMonitorRegistration() {
        if (this.idpMetadataFileMonitorRegistration != null) {
            this.idpMetadataFileMonitorRegistration.unregister();
            this.idpMetadataFileMonitorRegistration = null;
        }
    }

    ConfigurationAdmin getConfigurationAdmin() {
        return this.configAdmin;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean searchTrustAnchors(Collection<X509Certificate> trustAnchors, String trustAnchorName) throws SamlException {
        KeyStoreService keyStoreService;
        if (trustAnchorName == null || trustAnchorName.isEmpty()) {
            trustAnchorName = this.getDefaultKeyStoreProperty("com.ibm.ssl.trustStoreName");
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"TrustStore name from default ssl config  = ", (Object[])new Object[]{trustAnchorName});
            }
        }
        if ((keyStoreService = (KeyStoreService)this.getKeyStoreServiceRef().getService()) == null) {
            return false;
        }
        try {
            Collection certNames = keyStoreService.getTrustedCertEntriesInKeyStore(trustAnchorName);
            for (String certName : certNames) {
                X509Certificate cert = keyStoreService.getX509CertificateFromKeyStore(trustAnchorName, certName);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getCert trustAnchorName:" + trustAnchorName + " certId:" + certName + " cert:" + cert), (Object[])new Object[0]);
                }
                trustAnchors.add(cert);
            }
        }
        catch (KeyStoreException keyStoreException) {
            void e;
            FFDCFilter.processException((Throwable)keyStoreException, (String)"com.ibm.ws.security.saml.sso20.internal.SsoServiceImpl", (String)"508", (Object)this, (Object[])new Object[]{trustAnchors, trustAnchorName});
            throw new SamlException((Exception)e);
        }
        catch (CertificateException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.saml.sso20.internal.SsoServiceImpl", (String)"510", (Object)this, (Object[])new Object[]{trustAnchors, trustAnchorName});
            throw new SamlException(e);
        }
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.getSamlConfig().isEnabled();
    }

    public AtomicServiceReference<KeyStoreService> getKeyStoreServiceRef() {
        return this.keyStoreServiceRef;
    }

    public AtomicServiceReference<SSLSupport> getSslSupportRef() {
        return this.sslSupportRef;
    }

    @Override
    public boolean isInboundPropagation() {
        return this.isSamlInbound;
    }

    @Override
    @Sensitive
    public String getDefaultKeyStorePassword() {
        return this.getDefaultKeyStoreProperty("com.ibm.ssl.keyStorePassword");
    }
}

