/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.api.error.oauth20;

import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.api.error.oauth20.OAuth20ExceptionUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.security.oauth20.web.WebUtils;
import java.text.MessageFormat;
import java.util.Locale;

public class OAuth20BadParameterFormatException
extends OAuth20Exception {
    private static final TraceComponent tc = Tr.register(OAuth20BadParameterFormatException.class, (String)"OAUTH20", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    private static final long serialVersionUID = 1L;
    private String _paramName;
    private String _paramValue;

    public OAuth20BadParameterFormatException(String paramName, String paramValue) {
        super("invalid_request", "The parameter: [" + paramName + "] contained an illegally formatted value: [" + paramValue + "].", null);
        this._paramName = paramName;
        this._paramValue = paramValue;
    }

    public OAuth20BadParameterFormatException(String msgKey, String paramName, String paramValue) {
        super("invalid_request", Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])new Object[]{paramName, paramValue}), null);
        this._msgKey = msgKey;
        this._paramName = paramName;
        this._paramValue = paramValue;
    }

    @Override
    public String formatSelf(Locale locale, String encoding) {
        return MessageFormat.format(OAuth20ExceptionUtil.getResourceBundle(locale).getString(this._msgKey), this._paramName, WebUtils.encode(this._paramValue, locale, encoding));
    }

    public String getParamName() {
        return this._paramName;
    }

    public String getParamValue() {
        return this._paramValue;
    }
}

