/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20;

import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20MissingParameterException;
import com.ibm.oauth.core.internal.OAuthUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OAuth20Util
extends OAuthUtil {
    static final String CLASS = OAuth20Util.class.getName();
    static Logger _log = Logger.getLogger(CLASS);
    static Pattern _integerPattern = Pattern.compile("^[0-9]+$");
    static Pattern _scopePattern = Pattern.compile("^[\\!\\#-\\[\\]-\\~]+$");
    private static final String[] NUMBER_RESPONSE_FIELDS = new String[]{"expires_in"};
    private static final Set NUMBER_RESPONSE_FIELDS_SET = new HashSet<String>(Arrays.asList(NUMBER_RESPONSE_FIELDS));

    public static boolean scopeEquals(String[] requestedScope, String[] approvedScope) {
        HashSet<String> requestedSet;
        HashSet<String> approvedSet;
        boolean result = false;
        if (approvedScope == null) {
            approvedScope = new String[]{};
        }
        if (requestedScope == null) {
            requestedScope = new String[]{};
        }
        if (requestedScope.length == 0) {
            result = true;
        }
        if (!result && (approvedSet = new HashSet<String>(Arrays.asList(approvedScope))).containsAll(requestedSet = new HashSet<String>(Arrays.asList(requestedScope)))) {
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateRedirectUri(String redirectUri) {
        String methodName = "validateRedirectUri";
        _log.entering(CLASS, methodName, new Object[]{redirectUri});
        boolean finestLoggable = _log.isLoggable(Level.FINEST);
        boolean result = false;
        try {
            if (OAuth20Util.validateUri(redirectUri)) {
                if (redirectUri.indexOf("#") == -1) {
                    result = true;
                } else if (finestLoggable) {
                    _log.logp(Level.FINEST, CLASS, methodName, "The redirect URI contains a fragment");
                }
            } else if (finestLoggable) {
                _log.logp(Level.FINEST, CLASS, methodName, "The redirect URI is not a valid absolute URI");
            }
        }
        finally {
            _log.exiting(CLASS, methodName, "" + result);
        }
        return result;
    }

    public static void validateRequiredAttribute(String name, String value) throws OAuthException {
        if (value == null || value.length() == 0) {
            throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", name, null);
        }
    }

    public static String JSONEncode(String s) {
        String[] params;
        StringBuffer result = new StringBuffer();
        result.append("{");
        if (s != null && (params = s.split("&")) != null) {
            for (int i = 0; i < params.length; ++i) {
                String name;
                String[] nameval = params[i].split("=", 2);
                if (nameval == null || nameval.length != 1 && nameval.length != 2 || (name = nameval[0]) == null) continue;
                String value = "";
                if (nameval.length == 2) {
                    value = nameval[1];
                }
                result.append("\"" + name + "\"");
                result.append(":");
                boolean encodeAsNumber = false;
                if (NUMBER_RESPONSE_FIELDS_SET.contains(name)) {
                    Matcher m = _integerPattern.matcher(value);
                    encodeAsNumber = m.matches();
                }
                if (encodeAsNumber) {
                    result.append(value);
                } else {
                    result.append("\"" + value + "\"");
                }
                if (i >= params.length - 1) continue;
                result.append(",");
            }
        }
        result.append("}");
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateScopeString(String scope) {
        String methodName = "validateScopeString";
        _log.entering(CLASS, methodName, new Object[]{scope});
        boolean result = false;
        try {
            Matcher m = _scopePattern.matcher(scope);
            result = m.matches();
        }
        finally {
            _log.exiting(CLASS, methodName, "" + result);
        }
        return result;
    }

    public static void populateJwtAccessTokenData(AttributeList attributeList, Map<String, String[]> accessTokenMap) {
        _log.entering(CLASS, "populateJwtAccessTokenData", new Object[]{attributeList, accessTokenMap});
        String issuerIdentifier = attributeList.getAttributeValueByName("issuerIdentifier");
        accessTokenMap.put("issuerIdentifier", new String[]{issuerIdentifier});
        String sharedKey = attributeList.getAttributeValueByNameAndType("client_secret", "urn:ibm:names:oauth:param");
        accessTokenMap.put("client_secret", new String[]{sharedKey});
        String[] audiences = attributeList.getAttributeValuesByNameAndType("resource", "urn:ibm:names:oauth:param");
        accessTokenMap.put("resource", audiences);
    }
}

