/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.filter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.security.oauth20.filter.CommonHTTPHeaderFilter;
import com.ibm.ws.security.oauth20.filter.HTTPHeaderFilter;
import com.ibm.ws.security.oauth20.filter.RealRequestInfo;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OAuthResourceProtectionFilter
extends CommonHTTPHeaderFilter
implements HTTPHeaderFilter {
    static final TraceComponent tc = Tr.register(OAuthResourceProtectionFilter.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    static final long serialVersionUID = -527939798544838959L;

    public OAuthResourceProtectionFilter(boolean processAll) {
        super.setProcessAll(processAll);
    }

    public OAuthResourceProtectionFilter(String p, boolean processAll) {
        super(p);
        super.setProcessAll(processAll);
    }

    @Override
    public boolean init(String s1) {
        super.init(s1);
        boolean initialized = false;
        if (s1 == null) {
            this.nonFilter = true;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Filter Not Defined", (Object[])new Object[0]);
            }
        } else {
            initialized = true;
        }
        return initialized;
    }

    @Override
    public boolean isAccepted(HttpServletRequest req) {
        if (this.isOAuthServiceApp(req)) {
            return false;
        }
        return this.isAccepted(new RealRequestInfo(req));
    }

    private boolean isOAuthServiceApp(HttpServletRequest req) {
        String appName = OAuthResourceProtectionFilter.getApplication(req);
        if ("com.ibm.ws.security.oauth.2.0".equalsIgnoreCase(appName) || "io.openliberty.security.oauth.internal.2.0".equalsIgnoreCase(appName)) {
            return true;
        }
        return ("com.ibm.ws.security.openidconnect.server".equalsIgnoreCase(appName) || "io.openliberty.security.openidconnect.internal.server".equalsIgnoreCase(appName)) && !this.isProtectedByAccessToken(req);
    }

    private boolean isProtectedByAccessToken(HttpServletRequest req) {
        String uri = req.getRequestURI();
        return !uri.endsWith("token") && !uri.endsWith("authorize");
    }

    private static String getApplication(HttpServletRequest req) {
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        WebModuleMetaData wmmd = (WebModuleMetaData)cmd.getModuleMetaData();
        return wmmd.getConfiguration().getApplicationName();
    }
}

