/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authorization.AuthorizationTableService;
import com.ibm.ws.security.authorization.FeatureAuthorizationTableService;
import com.ibm.ws.security.authorization.builtin.AbstractSecurityAuthorizationTable;
import com.ibm.ws.security.registry.UserRegistryChangeListener;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.security.oauth20.roles"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, property={"service.vendor=IBM", "com.ibm.ws.security.authorization.table.name=oauth20"})
public class OAuth20WebAppAuthorizationTable
extends AbstractSecurityAuthorizationTable
implements AuthorizationTableService,
UserRegistryChangeListener {
    private static final TraceComponent tc = Tr.register(OAuth20WebAppAuthorizationTable.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    public static final String OAUTH_WEB_APP_NAME = "com.ibm.ws.security.oauth20";
    public static final String OAUTH_FEATURE_ROLE_MAP_NAME = "com.ibm.ws.security.oauth20";
    static final String[] roleNames = new String[]{"authenticated", "clientManager", "tokenManager"};
    static final String KEY_FEATURE_SECURITY_AUTHZ_SERVICE = "featureAuthzTableService";
    private final AtomicServiceReference<FeatureAuthorizationTableService> featureAuthzTableServiceRef = new AtomicServiceReference("featureAuthzTableService");
    private Map<String, Object> properties;
    static final long serialVersionUID = -7045572483137015686L;

    @Activate
    protected synchronized void activate(ComponentContext cc, Map<String, Object> properties) {
        super.activate(cc);
        this.featureAuthzTableServiceRef.activate(cc);
        this.properties = properties;
        this.setConfiguration(roleNames, (ConfigurationAdmin)this.configAdminRef.getService(), properties);
        FeatureAuthorizationTableService featureCollabAuthzTable = (FeatureAuthorizationTableService)this.featureAuthzTableServiceRef.getServiceWithException();
        featureCollabAuthzTable.addAuthorizationTable("com.ibm.ws.security.oauth20", (AuthorizationTableService)this);
        Tr.info((TraceComponent)tc, (String)"OAUTH_ROLE_CONFIG_PROCESSED", (Object[])new Object[0]);
    }

    @Modified
    protected synchronized void modify(Map<String, Object> properties) {
        this.properties = properties;
        this.modify();
    }

    private synchronized void modify() {
        this.setConfiguration(roleNames, (ConfigurationAdmin)this.configAdminRef.getService(), this.properties);
        FeatureAuthorizationTableService featureCollabAuthzTable = (FeatureAuthorizationTableService)this.featureAuthzTableServiceRef.getServiceWithException();
        featureCollabAuthzTable.addAuthorizationTable("com.ibm.ws.security.oauth20", (AuthorizationTableService)this);
        Tr.info((TraceComponent)tc, (String)"OAUTH_ROLE_CONFIG_PROCESSED", (Object[])new Object[0]);
    }

    @Deactivate
    protected synchronized void deactivate(ComponentContext cc) {
        super.deactivate(cc);
        this.featureAuthzTableServiceRef.deactivate(cc);
    }

    @Reference(name="featureAuthzTableService", service=FeatureAuthorizationTableService.class, policy=ReferencePolicy.DYNAMIC)
    protected void setFeatureAuthzTableService(ServiceReference<FeatureAuthorizationTableService> ref) {
        this.featureAuthzTableServiceRef.setReference(ref);
    }

    protected void unsetFeatureAuthzTableService(ServiceReference<FeatureAuthorizationTableService> ref) {
        this.featureAuthzTableServiceRef.unsetReference(ref);
    }

    protected String getApplicationName() {
        return "com.ibm.ws.security.oauth20";
    }

    public synchronized void configurationEvent(ConfigurationEvent event) {
        if (event.getType() != 2 && this.pids.contains(event.getPid())) {
            this.modify();
        }
    }

    public boolean isAuthzInfoAvailableForApp(String appName) {
        return "com.ibm.ws.security.oauth20".equals(appName);
    }
}

