/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins.db;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.util.JSONUtil;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OAuth20EnhancedTokenCache;
import com.ibm.ws.security.oauth20.exception.OAuthDataException;
import com.ibm.ws.security.oauth20.plugins.CacheEntry;
import com.ibm.ws.security.oauth20.plugins.OAuth20TokenImpl;
import com.ibm.ws.security.oauth20.plugins.db.DetectDatabaseType;
import com.ibm.ws.security.oauth20.plugins.db.DynamicDBMigrator;
import com.ibm.ws.security.oauth20.plugins.db.OAuthJDBCImpl;
import com.ibm.ws.security.oauth20.util.CacheUtil;
import com.ibm.ws.security.oauth20.util.DynaCacheUtils;
import com.ibm.ws.security.oauth20.util.MessageDigestUtil;
import com.ibm.ws.security.oauth20.web.EndpointUtils;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.sql.DataSource;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CachedDBOidcTokenStore
extends OAuthJDBCImpl
implements OAuth20EnhancedTokenCache {
    private static final TraceComponent tc = Tr.register(CachedDBOidcTokenStore.class, (String)"OAuth20Provider", null);
    private static final String INSERT_STMT = "INSERT INTO %s (LOOKUPKEY,UNIQUEID,COMPONENTID,TYPE,SUBTYPE,CREATEDAT,LIFETIME,EXPIRES,TOKENSTRING,CLIENTID,USERNAME,SCOPE,REDIRECTURI,STATEID,EXTENDEDFIELDS) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    static final String CONFIG_CLEANUP_INTERVAL = "oauthjdbc.CleanupInterval";
    static final String CONFIG_LIMIT_REFRESH = "oauthjdbc.LimitRefreshToken";
    static final String CONFIG_CLEANUP_BATCH_SIZE = "oauthjdbc.CleanupBatchSize";
    static final String TYPE_AZN_GRANT = "authorization_grant";
    static final String SUBTYPE_REFRESH = "refresh_token";
    int cleanupInterval = 0;
    int cleanupBatchSize = 250;
    boolean limitRefreshTokens = true;
    protected String componentId;
    protected String tableName;
    private String tokenCacheJndi;
    private boolean columnAdded = false;
    private ExecutorService executorService;
    Future cleanupThreadFuture;
    boolean cleanupThreadExitSemaphore = false;
    String accessTokenEncoding = "plain";
    int accessTokenLength;
    static Map<String, CacheEntry> cache;
    static final long serialVersionUID = -468918692298311694L;

    public CachedDBOidcTokenStore() {
    }

    public CachedDBOidcTokenStore(String componentId, ExecutorService executorsvc, DataSource dataSource, String tableName, @Sensitive Object[] credentials, String tokenCacheJndi, int cleanupInterval, int cleanupBatchSize, boolean limitRefreshTokens) {
        super(dataSource, credentials);
        this.componentId = componentId;
        this.tableName = tableName;
        this.tokenCacheJndi = tokenCacheJndi == null || "".equals(tokenCacheJndi) ? "services/cache/OAuth20DBTokenCache" : tokenCacheJndi;
        this.executorService = executorsvc;
        this.cleanupInterval = cleanupInterval;
        this.cleanupBatchSize = cleanupBatchSize;
        this.limitRefreshTokens = limitRefreshTokens;
    }

    public CachedDBOidcTokenStore(String componentId, ExecutorService executorsvc, DataSource dataSource, String tableName, @Sensitive Object[] credentials, String tokenCacheJndi, int cleanupInterval, int cleanupBatchSize, boolean limitRefreshTokens, String accessTokenEncoding, int accessTokenLength) {
        super(dataSource, credentials);
        this.componentId = componentId;
        this.tableName = tableName;
        this.tokenCacheJndi = tokenCacheJndi == null || "".equals(tokenCacheJndi) ? "services/cache/OAuth20DBTokenCache" : tokenCacheJndi;
        this.executorService = executorsvc;
        this.cleanupInterval = cleanupInterval;
        this.cleanupBatchSize = cleanupBatchSize;
        this.limitRefreshTokens = limitRefreshTokens;
        this.accessTokenEncoding = accessTokenEncoding;
        this.accessTokenLength = accessTokenLength;
    }

    @Override
    public void initialize() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Using cleanup interval: " + this.cleanupInterval + " limitRefreshTokens: " + this.limitRefreshTokens + " cleanupBatchSize: " + this.cleanupBatchSize), (Object[])new Object[0]);
        }
        this.startCleanupThread();
        CachedDBOidcTokenStore.getCache(this.tokenCacheJndi);
    }

    @Override
    @FFDCIgnore(value={NumberFormatException.class})
    public void init(OAuthComponentConfiguration config) {
        block4: {
            super.init(config);
            this.componentId = config.getUniqueId();
            this.tableName = config.getConfigPropertyValue("oauthjdbc.token.table");
            this.cleanupInterval = config.getConfigPropertyIntValue(CONFIG_CLEANUP_INTERVAL);
            this.limitRefreshTokens = config.getConfigPropertyBooleanValue(CONFIG_LIMIT_REFRESH);
            try {
                this.cleanupBatchSize = config.getConfigPropertyIntValue(CONFIG_CLEANUP_BATCH_SIZE);
            }
            catch (NumberFormatException e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("No setting for oauthjdbc.CleanupBatchSize, using default cleanup batch size of: " + this.cleanupBatchSize), (Object[])new Object[0]);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Using cleanup interval: " + this.cleanupInterval + " limitRefreshTokens: " + this.limitRefreshTokens + " cleanupBatchSize: " + this.cleanupBatchSize), (Object[])new Object[0]);
        }
        this.startCleanupThread();
        String tokenCacheJndi = config.getConfigPropertyValue("oauth20.db.token.cache.jndi.tokens");
        if (tokenCacheJndi == null || "".equals(tokenCacheJndi)) {
            tokenCacheJndi = "services/cache/OAuth20DBTokenCache";
        }
        CachedDBOidcTokenStore.getCache(tokenCacheJndi);
    }

    private static synchronized void getCache(String tokenCacheJndi) {
        if (cache == null) {
            cache = DynaCacheUtils.getDynamicCache(tokenCacheJndi, new String[0], new CacheEntry[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public OAuth20Token getByHash(String hash) {
        OAuth20Token result = null;
        Connection conn = null;
        ResultSet queryResults = null;
        boolean error = true;
        boolean isSqlException = false;
        String cacheKey = this.getCacheKey(hash);
        CacheEntry ce = cache.get(cacheKey);
        if (ce != null) {
            if (!ce.isExpired()) {
                result = ce._token;
                if (result != null) {
                    result.setLastAccess();
                }
            } else {
                Tr.info((TraceComponent)tc, (String)("Token with the cacheKey: " + cacheKey + " has expired."), (Object[])new Object[0]);
                cache.remove(cacheKey);
            }
        }
        if (result == null) {
            try {
                conn = this.getInitializedConnection();
                result = this.getByHash(conn, hash, queryResults);
                error = false;
            }
            catch (SQLException sQLException) {
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"234", (Object)this, (Object[])new Object[]{hash});
                isSqlException = true;
                if (!this.columnAdded) {
                    try {
                        new DynamicDBMigrator().addColumnToTable(conn, this.tableName, "EXTENDEDFIELDS", "CLOB");
                        result = this.getByHash(conn, hash, queryResults);
                        error = false;
                    }
                    catch (Exception exception) {
                        void e;
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"246", (Object)this, (Object[])new Object[]{hash});
                        Tr.error((TraceComponent)tc, (String)("Internal error getting token by hash key: " + e.getMessage()), (Object[])new Object[]{e});
                    }
                } else {
                    void sqle;
                    Tr.error((TraceComponent)tc, (String)("Internal error getting token by hash key: " + sqle.getMessage()), (Object[])new Object[]{sqle});
                }
            }
            catch (Exception sqle) {
                void e;
                FFDCFilter.processException((Throwable)sqle, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"252", (Object)this, (Object[])new Object[]{hash});
                Tr.error((TraceComponent)tc, (String)("Internal error getting token by hash key: " + e.getMessage()), (Object[])new Object[]{e});
                error = true;
            }
            finally {
                if (isSqlException && !this.columnAdded) {
                    this.columnAdded = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"getByHash , columnAdded is true", (Object[])new Object[0]);
                    }
                }
                this.closeResultSet(queryResults);
                this.closeConnection(conn, error);
            }
            if (result != null) {
                cache.put(cacheKey, new CacheEntry(result, result.getLifetimeSeconds()));
            } else {
                block27: {
                    try {
                        Thread.yield();
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"273", (Object)this, (Object[])new Object[]{hash});
                        if (!tc.isDebugEnabled()) break block27;
                        Tr.debug((TraceComponent)tc, (String)"Internal error while yielding", (Object[])new Object[]{e});
                    }
                }
                ce = cache.get(cacheKey);
                if (ce != null) {
                    if (!ce.isExpired()) {
                        result = ce._token;
                    } else {
                        cache.remove(cacheKey);
                    }
                }
            }
        }
        if (tc.isDebugEnabled() && result == null) {
            Tr.debug((TraceComponent)tc, (String)"Token not found, lookup details follow:", (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("  table name: " + this.tableName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("  lookup key: " + hash), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("  component ID: " + this.componentId), (Object[])new Object[0]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OAuth20Token getByHash(Connection conn, String hash, ResultSet queryResults) throws SQLException {
        PreparedStatement st = null;
        OAuth20Token result = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE " + "LOOKUPKEY" + " = ? AND " + "COMPONENTID" + " = ?";
            st = conn.prepareStatement(query);
            st.setString(1, hash);
            st.setString(2, this.componentId);
            queryResults = st.executeQuery();
            while (queryResults != null && result == null && queryResults.next()) {
                result = this.createToken(queryResults);
            }
        }
        catch (Throwable throwable) {
            this.closeResultSet(queryResults);
            this.closeStatement(st);
            throw throwable;
        }
        this.closeResultSet(queryResults);
        this.closeStatement(st);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void removeByHash(String hash) {
        Connection conn = null;
        boolean error = true;
        boolean isSqlException = false;
        String cacheKey = this.getCacheKey(hash);
        CacheEntry ce = cache.get(cacheKey);
        if (ce != null) {
            cache.remove(cacheKey);
        }
        try {
            conn = this.getInitializedConnection();
            this.removeByHash(conn, hash);
            error = false;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"350", (Object)this, (Object[])new Object[]{hash});
            isSqlException = true;
            if (!this.columnAdded) {
                try {
                    new DynamicDBMigrator().addColumnToTable(conn, this.tableName, "EXTENDEDFIELDS", "CLOB");
                    this.removeByHash(conn, hash);
                    error = false;
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"362", (Object)this, (Object[])new Object[]{hash});
                    Tr.error((TraceComponent)tc, (String)("Internal error removing token by hash key: " + e.getMessage()), (Object[])new Object[]{e});
                }
            } else {
                void sqle;
                Tr.error((TraceComponent)tc, (String)("Internal error removing token by hash key: " + sqle.getMessage()), (Object[])new Object[]{sqle});
            }
        }
        catch (Exception sqle) {
            void e;
            FFDCFilter.processException((Throwable)sqle, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"368", (Object)this, (Object[])new Object[]{hash});
            Tr.error((TraceComponent)tc, (String)("Internal error removing token by hash key: " + e.getMessage()), (Object[])new Object[]{e});
        }
        finally {
            if (isSqlException && !this.columnAdded) {
                this.columnAdded = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"removeByHash , columnAdded is true", (Object[])new Object[0]);
                }
            }
            this.closeConnection(conn, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeByHash(Connection conn, String hash) throws SQLException {
        PreparedStatement st = null;
        try {
            String delete = "DELETE FROM " + this.tableName + " WHERE " + "LOOKUPKEY" + " = ? AND " + "COMPONENTID" + " = ?";
            st = conn.prepareStatement(delete);
            st.setString(1, hash);
            st.setString(2, this.componentId);
            st.execute();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Token removed, details follow:", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  table name: " + this.tableName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  lookup key: " + hash), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  component ID: " + this.componentId), (Object[])new Object[0]);
            }
            this.closeStatement(st);
        }
        catch (Throwable throwable) {
            this.closeStatement(st);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @FFDCIgnore(value={SQLSyntaxErrorException.class})
    public void add(String lookupKeyParm, OAuth20Token entry, int lifetime) {
        String lookupKey = lookupKeyParm;
        boolean shouldHash = false;
        CacheUtil cacheUtil = new CacheUtil();
        if (cacheUtil.shouldHash(entry, this.accessTokenEncoding)) {
            shouldHash = true;
            lookupKey = cacheUtil.computeHash(lookupKeyParm, this.accessTokenEncoding);
        } else {
            lookupKey = MessageDigestUtil.getDigest(lookupKeyParm);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("lookupKey: " + lookupKey), (Object[])new Object[0]);
        }
        boolean error = true;
        boolean isSqlException = false;
        Connection conn = null;
        String cacheKey = this.getCacheKey(lookupKey);
        if (!shouldHash) {
            cache.put(cacheKey, new CacheEntry(entry, lifetime));
        }
        long expires = 0L;
        if (entry.getLifetimeSeconds() > 0) {
            expires = entry.getCreatedAt() + 1000L * (long)entry.getLifetimeSeconds();
        }
        StringBuffer scopes = new StringBuffer();
        String[] ascopes = entry.getScope();
        if (ascopes != null && ascopes.length > 0) {
            for (int i = 0; i < ascopes.length; ++i) {
                scopes.append(ascopes[i].trim());
                if (i >= ascopes.length - 1) continue;
                scopes.append(" ");
            }
        }
        try {
            conn = this.getInitializedConnection();
            this.add(conn, entry, lookupKey, expires, scopes, false, shouldHash);
            error = false;
        }
        catch (SQLSyntaxErrorException sqle) {
            isSqlException = true;
            if (!this.columnAdded) {
                try {
                    new DynamicDBMigrator().addColumnToTable(conn, this.tableName, "EXTENDEDFIELDS", "CLOB");
                    this.add(conn, entry, lookupKey, expires, scopes, false, shouldHash);
                    error = false;
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"468", (Object)this, (Object[])new Object[]{lookupKeyParm, entry, lifetime});
                    Tr.error((TraceComponent)tc, (String)("Internal error adding token: " + e.getMessage()), (Object[])new Object[]{e});
                }
            } else {
                Tr.error((TraceComponent)tc, (String)("Internal error adding token: " + sqle.getMessage()), (Object[])new Object[]{sqle});
            }
        }
        catch (Exception sqle) {
            void e;
            FFDCFilter.processException((Throwable)sqle, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"474", (Object)this, (Object[])new Object[]{lookupKeyParm, entry, lifetime});
            Tr.error((TraceComponent)tc, (String)("Internal error adding token: " + e.getMessage()), (Object[])new Object[]{e});
        }
        finally {
            if (isSqlException && !this.columnAdded) {
                this.columnAdded = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"add , columnAdded is true", (Object[])new Object[0]);
                }
            }
            this.closeConnection(conn, error);
            if (tc.isDebugEnabled() && !error) {
                Tr.debug((TraceComponent)tc, (String)"Token added, details follow:", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  table: " + this.tableName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  key: " + lookupKey), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  id: " + entry.getId()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  component: " + this.componentId), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  type: " + entry.getType()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  subtype: " + entry.getSubType()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  creation: " + entry.getCreatedAt()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  lifetime: " + entry.getLifetimeSeconds()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  expires: " + expires), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)"  (password skipped)", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  client id: " + entry.getClientId()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  username: " + entry.getUsername()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  scopes: " + scopes.toString()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  redirect: " + entry.getRedirectUri()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  state: " + entry.getStateId()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  grantType: " + entry.getGrantType()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  extensionProperties: " + entry.getExtensionProperties()), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Connection conn, OAuth20Token entry, String lookupKey, long expires, StringBuffer scopes, boolean alreadyHashed, boolean shouldHash) throws Exception, SQLSyntaxErrorException {
        String tokenId = entry.getId();
        String tokenString = entry.getTokenString();
        CacheUtil cacheUtil = new CacheUtil(this);
        if (!alreadyHashed) {
            if (shouldHash) {
                tokenId = cacheUtil.computeHash(tokenId, this.accessTokenEncoding);
                tokenString = cacheUtil.computeHash(tokenString, this.accessTokenEncoding);
            } else {
                tokenString = PasswordUtil.passwordEncode((String)tokenString);
            }
        }
        PreparedStatement st = null;
        try {
            st = conn.prepareStatement(String.format(INSERT_STMT, this.tableName));
            st.setString(1, lookupKey);
            st.setString(2, tokenId);
            st.setString(3, this.componentId);
            st.setString(4, entry.getType());
            st.setString(5, entry.getSubType());
            st.setLong(6, entry.getCreatedAt());
            st.setInt(7, entry.getLifetimeSeconds());
            st.setLong(8, expires);
            st.setString(9, tokenString);
            st.setString(10, entry.getClientId());
            st.setString(11, entry.getUsername());
            st.setString(12, scopes.toString());
            st.setString(13, entry.getRedirectUri());
            st.setString(14, entry.getStateId());
            JsonObject extendedFields = JSONUtil.getJsonObject(entry.getExtensionProperties());
            if (extendedFields == null) {
                extendedFields = new JsonObject();
            }
            extendedFields.addProperty("grant_type", entry.getGrantType());
            String refreshId = null;
            String accessId = null;
            if ("access_token".equals(entry.getType())) {
                refreshId = cacheUtil.getRefreshTokenId(entry);
                if (refreshId != null) {
                    extendedFields.addProperty("refresh_token_id", refreshId);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Access Token is added to cache , refresh token id " + refreshId), (Object[])new Object[0]);
                    }
                }
            } else if ("id_token".equals(entry.getType()) && (accessId = cacheUtil.getAccessTokenId(entry)) != null) {
                extendedFields.addProperty("access_token_id", accessId);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("ID Token is added to cache , access token id " + accessId), (Object[])new Object[0]);
                }
            }
            if (!alreadyHashed && shouldHash) {
                OAuth20TokenImpl localToken = new OAuth20TokenImpl(tokenId, this.componentId, entry.getType(), entry.getSubType(), entry.getCreatedAt(), entry.getLifetimeSeconds(), tokenString, entry.getClientId(), entry.getUsername(), entry.getScope(), entry.getRedirectUri(), entry.getStateId(), entry.getExtensionProperties(), entry.getGrantType());
                if (localToken != null) {
                    if (refreshId != null) {
                        localToken.setRefreshTokenKey(refreshId);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Saving the token to in-memory, refresh token id in local token = " + refreshId), (Object[])new Object[0]);
                        }
                    } else if (accessId != null) {
                        localToken.setAccessTokenKey(accessId);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Saving the token to in-memory, , access token id in local token = " + accessId), (Object[])new Object[0]);
                        }
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Saving the token to in-memory, local token id = " + tokenId), (Object[])new Object[0]);
                }
                String cacheKey = this.getCacheKey(lookupKey);
                cache.put(cacheKey, new CacheEntry(localToken, localToken.getLifetimeSeconds()));
            }
            String jsonString = extendedFields.toString();
            st.setString(15, jsonString);
            st.execute();
            this.closeStatement(st);
        }
        catch (Throwable throwable) {
            this.closeStatement(st);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @FFDCIgnore(value={SQLSyntaxErrorException.class})
    public void addByHash(String lookupKey, OAuth20Token entry, int lifetime) {
        boolean error = true;
        boolean isSqlException = false;
        Connection conn = null;
        String cacheKey = this.getCacheKey(lookupKey);
        cache.put(cacheKey, new CacheEntry(entry, lifetime));
        long expires = 0L;
        if (entry.getLifetimeSeconds() > 0) {
            expires = entry.getCreatedAt() + 1000L * (long)entry.getLifetimeSeconds();
        }
        StringBuffer scopes = new StringBuffer();
        String[] ascopes = entry.getScope();
        if (ascopes != null && ascopes.length > 0) {
            for (int i = 0; i < ascopes.length; ++i) {
                scopes.append(ascopes[i].trim());
                if (i >= ascopes.length - 1) continue;
                scopes.append(" ");
            }
        }
        try {
            conn = this.getInitializedConnection();
            this.add(conn, entry, lookupKey, expires, scopes, true, false);
            error = false;
        }
        catch (SQLSyntaxErrorException sqle) {
            isSqlException = true;
            if (!this.columnAdded) {
                try {
                    new DynamicDBMigrator().addColumnToTable(conn, this.tableName, "EXTENDEDFIELDS", "CLOB");
                    this.add(conn, entry, lookupKey, expires, scopes, true, false);
                    error = false;
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"660", (Object)this, (Object[])new Object[]{lookupKey, entry, lifetime});
                    Tr.error((TraceComponent)tc, (String)("Internal error adding token: " + e.getMessage()), (Object[])new Object[]{e});
                }
            } else {
                Tr.error((TraceComponent)tc, (String)("Internal error adding token: " + sqle.getMessage()), (Object[])new Object[]{sqle});
            }
        }
        catch (Exception sqle) {
            void e;
            FFDCFilter.processException((Throwable)sqle, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"666", (Object)this, (Object[])new Object[]{lookupKey, entry, lifetime});
            Tr.error((TraceComponent)tc, (String)("Internal error adding token: " + e.getMessage()), (Object[])new Object[]{e});
        }
        finally {
            if (isSqlException && !this.columnAdded) {
                this.columnAdded = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"add , columnAdded is true", (Object[])new Object[0]);
                }
            }
            this.closeConnection(conn, error);
            if (tc.isDebugEnabled() && !error) {
                Tr.debug((TraceComponent)tc, (String)"Token added, details follow:", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  table: " + this.tableName), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  key: " + lookupKey), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  id: " + entry.getId()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  component: " + this.componentId), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  type: " + entry.getType()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  subtype: " + entry.getSubType()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  creation: " + entry.getCreatedAt()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  lifetime: " + entry.getLifetimeSeconds()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  expires: " + expires), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)"  (password skipped)", (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  client id: " + entry.getClientId()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  username: " + entry.getUsername()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  scopes: " + scopes.toString()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  redirect: " + entry.getRedirectUri()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  state: " + entry.getStateId()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  grantType: " + entry.getGrantType()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("  extensionProperties: " + entry.getExtensionProperties()), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public Collection<OAuth20Token> getAll() {
        ArrayList<OAuth20Token> results = new ArrayList<OAuth20Token>();
        Connection conn = null;
        boolean error = true;
        boolean isSqlException = false;
        ResultSet queryResults = null;
        try {
            conn = this.getInitializedConnection();
            this.getAll(conn, results, queryResults);
            error = false;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"719", (Object)this, (Object[])new Object[0]);
            isSqlException = true;
            if (!this.columnAdded) {
                try {
                    new DynamicDBMigrator().addColumnToTable(conn, this.tableName, "EXTENDEDFIELDS", "CLOB");
                    this.getAll(conn, results, queryResults);
                    error = false;
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"731", (Object)this, (Object[])new Object[0]);
                    Tr.error((TraceComponent)tc, (String)("Internal error getting all tokens: " + e.getMessage()), (Object[])new Object[]{e});
                }
            } else {
                void sqle;
                Tr.error((TraceComponent)tc, (String)("Internal error getting all token : " + sqle.getMessage()), (Object[])new Object[]{sqle});
            }
        }
        catch (Exception sqle) {
            void e;
            FFDCFilter.processException((Throwable)sqle, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"737", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)("Internal error getting all tokens: " + e.getMessage()), (Object[])new Object[]{e});
        }
        finally {
            if (isSqlException && !this.columnAdded) {
                this.columnAdded = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getAll , columnAdded is true", (Object[])new Object[0]);
                }
            }
            this.closeResultSet(queryResults);
            this.closeConnection(conn, error);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAll(Connection conn, Collection<OAuth20Token> results, ResultSet queryResults) throws SQLException {
        PreparedStatement st = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE " + "COMPONENTID" + " =? ";
            st = conn.prepareStatement(query);
            st.setString(1, this.componentId);
            queryResults = st.executeQuery();
            while (queryResults != null && queryResults.next()) {
                OAuth20Token result = this.createToken(queryResults);
                results.add(result);
            }
            this.closeStatement(st);
        }
        catch (Throwable throwable) {
            this.closeStatement(st);
            this.closeResultSet(queryResults);
            throw throwable;
        }
        this.closeResultSet(queryResults);
    }

    protected OAuth20Token createToken(ResultSet queryResults) throws SQLException {
        Date now;
        boolean isAuthorizationGrantTypeAndCodeSubType;
        OAuth20Token result = null;
        String uniqueId = queryResults.getString("UNIQUEID");
        String componentId = queryResults.getString("COMPONENTID");
        String type = queryResults.getString("TYPE");
        String subType = queryResults.getString("SUBTYPE");
        long createdAt = queryResults.getLong("CREATEDAT");
        int lifetime = queryResults.getInt("LIFETIME");
        long expires = queryResults.getLong("EXPIRES");
        String tokenString = queryResults.getString("TOKENSTRING");
        String clientId = queryResults.getString("CLIENTID");
        String username = queryResults.getString("USERNAME");
        String scopeStr = queryResults.getString("SCOPE");
        String redirectUri = queryResults.getString("REDIRECTURI");
        String stateId = queryResults.getString("STATEID");
        JsonObject extendedFields = null;
        if (this.getDBType().isClobSupported()) {
            Clob clob = queryResults.getClob("EXTENDEDFIELDS");
            extendedFields = new JsonParser().parse(clob.getCharacterStream()).getAsJsonObject();
        } else {
            String strClob = queryResults.getString("EXTENDEDFIELDS");
            extendedFields = new JsonParser().parse(strClob).getAsJsonObject();
        }
        String grantType = null;
        String refreshId = null;
        String accessId = null;
        if (extendedFields != null) {
            grantType = extendedFields.get("grant_type").getAsString();
            if ("access_token".equals(type)) {
                if (extendedFields.get("refresh_token_id") != null) {
                    refreshId = extendedFields.get("refresh_token_id").getAsString();
                }
            } else if ("id_token".equals(type)) {
                accessId = extendedFields.get("access_token_id").getAsString();
            }
            extendedFields.remove("grant_type");
            extendedFields.remove("refresh_token_id");
            extendedFields.remove("access_token_id");
        }
        boolean isAppPasswordOrAppTokenGT = "app_password".equals(grantType) || "app_token".equals(grantType);
        boolean bl = isAuthorizationGrantTypeAndCodeSubType = TYPE_AZN_GRANT.equals(type) && "authorization_code".equals(subType);
        if (isAuthorizationGrantTypeAndCodeSubType || !isAppPasswordOrAppTokenGT && "plain".equals(this.accessTokenEncoding)) {
            tokenString = PasswordUtil.passwordDecode((String)tokenString);
        }
        Map<String, String[]> extensionProperties = JSONUtil.jsonObjectToStringsMap(extendedFields);
        String[] scopes = null;
        if (scopeStr != null) {
            scopes = scopeStr.split(" ");
        }
        if ((now = new Date()).getTime() < expires) {
            result = new OAuth20TokenImpl(uniqueId, componentId, type, subType, createdAt, lifetime, tokenString, clientId, username, scopes, redirectUri, stateId, extensionProperties, grantType);
            if (refreshId != null) {
                ((OAuth20TokenImpl)result).setRefreshTokenKey(refreshId);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Got the Access Token from cache, refresh token id = " + refreshId), (Object[])new Object[0]);
                }
            } else if (accessId != null) {
                ((OAuth20TokenImpl)result).setAccessTokenKey(accessId);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Got the ID Token from cache, access token id = " + accessId), (Object[])new Object[0]);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Internal error ceating token :The OAuth20Token is expired already", (Object[])new Object[0]);
        }
        if (result != null) {
            result.setLastAccess();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void dumpTokens(Connection conn) {
        ResultSet queryResults = null;
        PreparedStatement st = null;
        try {
            String query = "SELECT * FROM " + this.tableName;
            st = conn.prepareStatement(query);
            queryResults = st.executeQuery();
            while (queryResults != null && queryResults.next()) {
                boolean expired;
                String type = queryResults.getString("TYPE");
                String subType = queryResults.getString("SUBTYPE");
                long expires = queryResults.getLong("EXPIRES");
                String tokenString = queryResults.getString("TOKENSTRING");
                Date now = new Date();
                boolean bl = expired = now.getTime() >= expires;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("token: " + tokenString + " type: " + type + " subtype: " + subType + " expires: " + expires + " expired: " + expired), (Object[])new Object[0]);
            }
        }
        catch (Exception query) {
            try {
                void e;
                FFDCFilter.processException((Throwable)query, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"897", (Object)this, (Object[])new Object[]{conn});
                Tr.error((TraceComponent)tc, (String)("internal error dumping tokens: " + e.getMessage()), (Object[])new Object[]{e});
            }
            catch (Throwable throwable) {
                this.closeResultSet(queryResults);
                this.closeStatement(st);
                throw throwable;
            }
            this.closeResultSet(queryResults);
            this.closeStatement(st);
        }
        this.closeResultSet(queryResults);
        this.closeStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCleanupThread() {
        Class<CachedDBOidcTokenStore> clazz = CachedDBOidcTokenStore.class;
        synchronized (CachedDBOidcTokenStore.class) {
            if (this.cleanupInterval > 0 && this.cleanupThreadFuture == null) {
                this.cleanupThreadFuture = this.executorService.submit(new CleanupThread(this));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void stopCleanupThread() {
        if (this.cleanupThreadFuture != null) {
            this.cleanupThreadExitSemaphore = true;
            this.cleanupThreadFuture.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    protected int getExpiredCount(long nowTime) {
        int result = -1;
        ResultSet queryResults = null;
        Statement st = null;
        Connection conn = null;
        try {
            conn = this.getDBConnection();
            conn.setAutoCommit(false);
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Checking for expired with time: " + nowTime), (Object[])new Object[0]);
            }
            String query = "SELECT COUNT(*) AS \"TOTAL\" FROM " + this.tableName + " WHERE " + "EXPIRES" + " > 0 AND " + "EXPIRES" + " <= ? ";
            st = conn.prepareStatement(query);
            st.setLong(1, nowTime);
            queryResults = st.executeQuery();
            while (queryResults != null && queryResults.next()) {
                result = queryResults.getInt("TOTAL");
                if (!tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)("Updated result to: " + result), (Object[])new Object[0]);
            }
        }
        catch (SQLException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"1081", (Object)this, (Object[])new Object[]{nowTime});
            Tr.error((TraceComponent)tc, (String)("Internal SQL error wile getting expired count: " + e.getMessage()), (Object[])new Object[]{e});
            this.closeResultSet(queryResults);
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e2222222222) {
                    FFDCFilter.processException((Throwable)e2222222222, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"1092", (Object)this, (Object[])new Object[]{nowTime});
                    Tr.error((TraceComponent)tc, (String)("Internal error wile closing SQL statement: " + e2222222222.getMessage()), (Object[])new Object[]{e2222222222});
                }
            }
            this.closeConnection(conn, false);
        }
        catch (OAuthDataException e2) {
            FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"1084", (Object)this, (Object[])new Object[]{nowTime});
            Tr.error((TraceComponent)tc, (String)("Internal OAuth error wile getting expired count: " + e2.getMessage()), (Object[])new Object[]{e2});
            {
                catch (Throwable throwable) {
                    this.closeResultSet(queryResults);
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException sQLException) {
                            void e3;
                            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"1092", (Object)this, (Object[])new Object[]{nowTime});
                            Tr.error((TraceComponent)tc, (String)("Internal error wile closing SQL statement: " + e3.getMessage()), (Object[])new Object[]{e3});
                        }
                    }
                    this.closeConnection(conn, false);
                    throw throwable;
                }
            }
            this.closeResultSet(queryResults);
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e4222222222) {
                    FFDCFilter.processException((Throwable)e4222222222, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"1092", (Object)this, (Object[])new Object[]{nowTime});
                    Tr.error((TraceComponent)tc, (String)("Internal error wile closing SQL statement: " + e4222222222.getMessage()), (Object[])new Object[]{e4222222222});
                }
            }
            this.closeConnection(conn, false);
        }
        this.closeResultSet(queryResults);
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException query) {
                void e;
                FFDCFilter.processException((Throwable)query, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"1092", (Object)this, (Object[])new Object[]{nowTime});
                Tr.error((TraceComponent)tc, (String)("Internal error wile closing SQL statement: " + e.getMessage()), (Object[])new Object[]{e});
            }
        }
        this.closeConnection(conn, false);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     */
    @Override
    public int getNumTokens(String username, String client) {
        Connection conn;
        Statement st;
        ResultSet queryResults;
        int result;
        block27: {
            result = -1;
            queryResults = null;
            st = null;
            conn = null;
            boolean isSqlException = false;
            try {
                conn = this.getInitializedConnection();
                result = this.getNumTokens(conn, username, client, (PreparedStatement)st, queryResults);
                if (!isSqlException || this.columnAdded) break block27;
                this.columnAdded = true;
            }
            catch (SQLException e) {
                block28: {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"1115", (Object)this, (Object[])new Object[]{username, client});
                    isSqlException = true;
                    if (!this.columnAdded) {
                        try {
                            new DynamicDBMigrator().addColumnToTable(conn, this.tableName, "EXTENDEDFIELDS", "CLOB");
                            result = this.getNumTokens(conn, username, client, (PreparedStatement)st, queryResults);
                        }
                        catch (Exception exception) {
                            void e2;
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"1126", (Object)this, (Object[])new Object[]{username, client});
                            Tr.error((TraceComponent)tc, (String)("Internal SQL error while getting number of tokens: " + e2.getMessage()), (Object[])new Object[]{e2});
                        }
                    } else {
                        void sqle;
                        Tr.error((TraceComponent)tc, (String)("Internal SQL error while getting number of tokens: " + sqle.getMessage()), (Object[])new Object[]{sqle});
                    }
                    if (!isSqlException || this.columnAdded) break block28;
                    this.columnAdded = true;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"getNumTokens , columnAdded is true", (Object[])new Object[0]);
                    }
                }
                this.closeResultSet(queryResults);
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException sqle) {
                        FFDCFilter.processException((Throwable)sqle, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"1146", (Object)this, (Object[])new Object[]{username, client});
                        Tr.error((TraceComponent)tc, (String)("Internal error wile closing SQL statement: " + e2.getMessage()), (Object[])new Object[]{e2});
                    }
                }
                this.closeConnection(conn, false);
            }
            catch (OAuthDataException e2) {
                block29: {
                    FFDCFilter.processException((Throwable)e2, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"1132", (Object)this, (Object[])new Object[]{username, client});
                    Tr.error((TraceComponent)tc, (String)("Internal OAuth error while getting number of tokens: " + e2.getMessage()), (Object[])new Object[]{e2});
                    if (!isSqlException || this.columnAdded) break block29;
                    this.columnAdded = true;
                    {
                        catch (Throwable throwable) {
                            if (isSqlException && !this.columnAdded) {
                                this.columnAdded = true;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"getNumTokens , columnAdded is true", (Object[])new Object[0]);
                                }
                            }
                            this.closeResultSet(queryResults);
                            if (st != null) {
                                try {
                                    st.close();
                                }
                                catch (SQLException sQLException) {
                                    void e3;
                                    FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"1146", (Object)this, (Object[])new Object[]{username, client});
                                    Tr.error((TraceComponent)tc, (String)("Internal error wile closing SQL statement: " + e3.getMessage()), (Object[])new Object[]{e3});
                                }
                            }
                            this.closeConnection(conn, false);
                            throw throwable;
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"getNumTokens , columnAdded is true", (Object[])new Object[0]);
                    }
                }
                this.closeResultSet(queryResults);
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (SQLException e4) {
                        FFDCFilter.processException((Throwable)e4, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"1146", (Object)this, (Object[])new Object[]{username, client});
                        Tr.error((TraceComponent)tc, (String)("Internal error wile closing SQL statement: " + e4.getMessage()), (Object[])new Object[]{e4});
                    }
                }
                this.closeConnection(conn, false);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getNumTokens , columnAdded is true", (Object[])new Object[0]);
            }
        }
        this.closeResultSet(queryResults);
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException sQLException) {
                void e;
                FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"1146", (Object)this, (Object[])new Object[]{username, client});
                Tr.error((TraceComponent)tc, (String)("Internal error wile closing SQL statement: " + e.getMessage()), (Object[])new Object[]{e});
            }
        }
        this.closeConnection(conn, false);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNumTokens(Connection conn, String username, String client, PreparedStatement st, ResultSet queryResults) throws SQLException {
        int result = -1;
        try {
            String query = "SELECT COUNT(*) AS \"TOTAL\" FROM " + this.tableName + " WHERE " + "COMPONENTID" + " =? AND " + "CLIENTID" + " =? AND " + "USERNAME" + " =?";
            st = conn.prepareStatement(query);
            st.setString(1, this.componentId);
            st.setString(2, client);
            st.setString(3, username);
            queryResults = st.executeQuery();
            while (queryResults != null && queryResults.next()) {
                result = queryResults.getInt("TOTAL");
                if (!tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)("Updated result to: " + result), (Object[])new Object[0]);
            }
        }
        finally {
            this.closeResultSet(queryResults);
            this.closeStatement(st);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public Collection<OAuth20Token> getAllUserTokens(String username) {
        ArrayList<OAuth20Token> results = new ArrayList<OAuth20Token>();
        Connection conn = null;
        boolean error = true;
        boolean isSqlException = false;
        ResultSet queryResults = null;
        try {
            conn = this.getInitializedConnection();
            this.getAllUserTokens(conn, username, queryResults, results);
            error = false;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"1212", (Object)this, (Object[])new Object[]{username});
            isSqlException = true;
            if (!this.columnAdded) {
                try {
                    new DynamicDBMigrator().addColumnToTable(conn, this.tableName, "EXTENDEDFIELDS", "CLOB");
                    this.getAllUserTokens(conn, username, queryResults, results);
                    error = false;
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"1224", (Object)this, (Object[])new Object[]{username});
                    Tr.error((TraceComponent)tc, (String)("Internal error while getting all user tokens: " + e.getMessage()), (Object[])new Object[]{e});
                }
            } else {
                void sqle;
                Tr.error((TraceComponent)tc, (String)("Internal SQL error while getting all user tokens: " + sqle.getMessage()), (Object[])new Object[]{sqle});
            }
        }
        catch (Exception sqle) {
            void e;
            FFDCFilter.processException((Throwable)sqle, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"1230", (Object)this, (Object[])new Object[]{username});
            Tr.error((TraceComponent)tc, (String)("Internal error getting all user tokens: " + e.getMessage()), (Object[])new Object[]{e});
            error = true;
        }
        finally {
            if (isSqlException && !this.columnAdded) {
                this.columnAdded = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getAllUserTokens , columnAdded is true", (Object[])new Object[0]);
                }
            }
            this.closeResultSet(queryResults);
            this.closeConnection(conn, error);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAllUserTokens(Connection conn, String username, ResultSet queryResults, Collection<OAuth20Token> results) throws SQLException {
        PreparedStatement st = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE " + "COMPONENTID" + " =? AND " + "USERNAME" + " =?";
            st = conn.prepareStatement(query);
            st.setString(1, this.componentId);
            st.setString(2, username);
            queryResults = st.executeQuery();
            while (queryResults != null && queryResults.next()) {
                OAuth20Token result = this.createToken(queryResults);
                if (result == null) continue;
                results.add(result);
            }
        }
        catch (Throwable throwable) {
            this.closeResultSet(queryResults);
            this.closeStatement(st);
            throw throwable;
        }
        this.closeResultSet(queryResults);
        this.closeStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMatchingTokens(Connection conn, String username, String clientId, String stateId, ResultSet queryResults, Collection<OAuth20Token> results) throws SQLException {
        PreparedStatement st = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE " + "COMPONENTID" + " =? AND " + "CLIENTID" + " =? AND " + "USERNAME" + " =? AND " + "STATEID" + " =? ";
            st = conn.prepareStatement(query);
            st.setString(1, this.componentId);
            st.setString(2, clientId);
            st.setString(3, username);
            st.setString(4, stateId);
            queryResults = st.executeQuery();
            while (queryResults != null && queryResults.next()) {
                OAuth20Token result = this.createToken(queryResults);
                if (result == null) continue;
                results.add(result);
            }
        }
        catch (Throwable throwable) {
            this.closeResultSet(queryResults);
            this.closeStatement(st);
            throw throwable;
        }
        this.closeResultSet(queryResults);
        this.closeStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMatchingTokens(Connection conn, String username, String clientId, ResultSet queryResults, Collection<OAuth20Token> results) throws SQLException {
        PreparedStatement st = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE " + "COMPONENTID" + " =? AND " + "CLIENTID" + " =? AND " + "USERNAME" + " =? ";
            st = conn.prepareStatement(query);
            st.setString(1, this.componentId);
            st.setString(2, clientId);
            st.setString(3, username);
            queryResults = st.executeQuery();
            while (queryResults != null && queryResults.next()) {
                OAuth20Token result = this.createToken(queryResults);
                if (result == null) continue;
                results.add(result);
            }
        }
        catch (Throwable throwable) {
            this.closeResultSet(queryResults);
            this.closeStatement(st);
            throw throwable;
        }
        this.closeResultSet(queryResults);
        this.closeStatement(st);
    }

    protected String getCacheKey(String lookupKey) {
        return lookupKey + "_" + this.componentId;
    }

    @Override
    public OAuth20Token get(String lookupKey) {
        String hash = lookupKey;
        if (!PasswordUtil.isHashed((String)hash)) {
            hash = !"plain".equals(this.accessTokenEncoding) || lookupKey.length() == this.accessTokenLength + 2 ? ("plain".equals(this.accessTokenEncoding) ? EndpointUtils.computeTokenHash(lookupKey) : EndpointUtils.computeTokenHash(lookupKey, this.accessTokenEncoding)) : MessageDigestUtil.getDigest(lookupKey);
        }
        return this.getByHash(hash);
    }

    @Override
    public void remove(String lookupKey) {
        String hash = lookupKey;
        if (!PasswordUtil.isHashed((String)hash)) {
            hash = !"plain".equals(this.accessTokenEncoding) || lookupKey.length() == this.accessTokenLength + 2 ? ("plain".equals(this.accessTokenEncoding) ? EndpointUtils.computeTokenHash(lookupKey) : EndpointUtils.computeTokenHash(lookupKey, this.accessTokenEncoding)) : MessageDigestUtil.getDigest(lookupKey);
        }
        this.removeByHash(hash);
    }

    private Connection getInitializedConnection() throws OAuthDataException, SQLException {
        Connection conn = this.getDBConnection();
        conn.setAutoCommit(false);
        return conn;
    }

    /*
     * WARNING - void declaration
     */
    protected void closeStatement(Statement statement) {
        block3: {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    void e;
                    FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"1413", (Object)this, (Object[])new Object[]{statement});
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)"Internal error closing SQL statement", (Object[])new Object[]{e});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public Collection<OAuth20Token> getMatchingTokens(String username, String client, String tokenType) {
        ArrayList<OAuth20Token> results = new ArrayList<OAuth20Token>();
        Connection conn = null;
        boolean error = true;
        boolean isSqlException = false;
        ResultSet queryResults = null;
        try {
            conn = this.getInitializedConnection();
            if (tokenType != null) {
                this.getMatchingTokens(conn, username, client, tokenType, queryResults, results);
            } else {
                this.getMatchingTokens(conn, username, client, queryResults, results);
            }
            error = false;
        }
        catch (SQLException sQLException) {
            FFDCFilter.processException((Throwable)sQLException, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"1437", (Object)this, (Object[])new Object[]{username, client, tokenType});
            isSqlException = true;
            if (!this.columnAdded) {
                try {
                    new DynamicDBMigrator().addColumnToTable(conn, this.tableName, "EXTENDEDFIELDS", "CLOB");
                    if (tokenType != null) {
                        this.getMatchingTokens(conn, username, client, tokenType, queryResults, results);
                    } else {
                        this.getMatchingTokens(conn, username, client, queryResults, results);
                    }
                    error = false;
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"1453", (Object)this, (Object[])new Object[]{username, client, tokenType});
                    Tr.error((TraceComponent)tc, (String)("Internal error while getting all matching tokens: " + e.getMessage()), (Object[])new Object[]{e});
                }
            } else {
                void sqle;
                Tr.error((TraceComponent)tc, (String)("Internal SQL error while getting all matching tokens: " + sqle.getMessage()), (Object[])new Object[]{sqle});
            }
        }
        catch (Exception sqle) {
            void e;
            FFDCFilter.processException((Throwable)sqle, (String)"com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore", (String)"1459", (Object)this, (Object[])new Object[]{username, client, tokenType});
            Tr.error((TraceComponent)tc, (String)("Internal error getting all matching tokens: " + e.getMessage()), (Object[])new Object[]{e});
            error = true;
        }
        finally {
            if (isSqlException && !this.columnAdded) {
                this.columnAdded = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getMatchingTokens , columnAdded is true", (Object[])new Object[0]);
                }
            }
            this.closeResultSet(queryResults);
            this.closeConnection(conn, error);
        }
        return results;
    }

    @Override
    public Collection<OAuth20Token> getUserAndClientTokens(String username, String client) {
        return this.getMatchingTokens(username, client, null);
    }

    @Trivial
    class CleanupThread
    extends Thread {
        protected CachedDBOidcTokenStore _me;
        protected DetectDatabaseType.DBType databaseType = null;
        private boolean stopped = false;

        public CleanupThread(CachedDBOidcTokenStore me) {
            this._me = me;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @FFDCIgnore(value={OAuthDataException.class, InterruptedException.class})
        public void run() {
            Connection connCheck = null;
            try {
                connCheck = this._me.getDBConnection();
                this.databaseType = DetectDatabaseType.DetectionUtils.detectDbType(connCheck);
            }
            catch (OAuthDataException e) {
                Tr.error((TraceComponent)tc, (String)("Internal error getting DB connection: " + e.getMessage()), (Object[])new Object[]{e});
                return;
            }
            finally {
                block17: {
                    try {
                        if (connCheck != null && !connCheck.isClosed()) {
                            connCheck.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!tc.isDebugEnabled()) break block17;
                        Tr.debug((TraceComponent)tc, (String)"Unable to close connection.", (Object[])new Object[0]);
                    }
                }
            }
            while (!this.stopped) {
                block18: {
                    try {
                        CleanupThread.sleep(this._me.cleanupInterval * 1000);
                    }
                    catch (InterruptedException e) {
                        if (!tc.isDebugEnabled()) break block18;
                        Tr.debug((TraceComponent)tc, (String)"Cleanup thread was interrupted", (Object[])new Object[0]);
                    }
                }
                if (this._me.cleanupThreadExitSemaphore) {
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)"token store cleanup thread exiting because exit semaphore is true", (Object[])new Object[0]);
                    break;
                }
                this.runCleanup();
            }
        }

        public void stopCleanup() {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"stopping cleanup thread", (Object[])new Object[0]);
            }
            this.stopped = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        protected void runCleanup() {
            Date now = new Date();
            long nowTime = now.getTime();
            int expiredCount = CachedDBOidcTokenStore.this.getExpiredCount(nowTime);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("About to delete all tokens with expiry <= " + nowTime), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("Number of expired tokens in the DB: " + expiredCount), (Object[])new Object[0]);
            }
            if (expiredCount > 10000) {
                Tr.warning((TraceComponent)tc, (String)"OAUTH_PROVIDER_DB_TOOMANY_EXPTOKEN", (Object[])new Object[]{expiredCount, this._me.cleanupInterval, "cleanupExpiredTokenInterval"});
            }
            boolean error = false;
            Connection conn = null;
            int numDeleted = 0;
            while (expiredCount > 0 && numDeleted < expiredCount) {
                PreparedStatement st = null;
                try {
                    String delete;
                    conn = this._me.getDBConnection();
                    conn.setAutoCommit(false);
                    if (DetectDatabaseType.DBType.DB2 == this.databaseType) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Running cleanup with LIMIT in DB2", (Object[])new Object[0]);
                        }
                        delete = "DELETE FROM (SELECT EXPIRES FROM " + CachedDBOidcTokenStore.this.tableName + " WHERE " + "EXPIRES" + " > 0 AND " + "EXPIRES" + " <= ?  ORDER BY " + "EXPIRES" + " FETCH FIRST " + CachedDBOidcTokenStore.this.cleanupBatchSize + " ROWS ONLY)";
                        numDeleted += CachedDBOidcTokenStore.this.cleanupBatchSize;
                    } else if (this.databaseType.isSqlLimitSupported()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Running cleanup with LIMIT", (Object[])new Object[0]);
                        }
                        delete = "DELETE FROM " + CachedDBOidcTokenStore.this.tableName + " WHERE " + "EXPIRES" + " > 0 AND " + "EXPIRES" + " <= ? LIMIT " + CachedDBOidcTokenStore.this.cleanupBatchSize;
                        numDeleted += CachedDBOidcTokenStore.this.cleanupBatchSize;
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Running cleanup without LIMIT", (Object[])new Object[0]);
                        }
                        delete = "DELETE FROM " + CachedDBOidcTokenStore.this.tableName + " WHERE " + "EXPIRES" + " > 0 AND " + "EXPIRES" + " <= ?";
                        numDeleted += expiredCount;
                    }
                    st = conn.prepareStatement(delete);
                    st.setLong(1, nowTime);
                    st.execute();
                    CachedDBOidcTokenStore.this.closeStatement(st);
                }
                catch (SQLException syne) {
                    this.databaseType = DetectDatabaseType.DBType.UNKNOWN;
                    if (tc.isWarningEnabled()) {
                        Tr.warning((TraceComponent)tc, (String)("Internal error running cleanup: " + syne.getMessage()), (Object[])new Object[]{syne});
                    }
                    if (!tc.isErrorEnabled()) continue;
                    Tr.error((TraceComponent)tc, (String)"SQL error, switching off LIMIT", (Object[])new Object[0]);
                    continue;
                }
                catch (Exception e) {
                    Tr.error((TraceComponent)tc, (String)("Internal error running cleanup: " + e.getMessage()), (Object[])new Object[]{e});
                    error = true;
                    continue;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    CachedDBOidcTokenStore.this.closeStatement(st);
                    CachedDBOidcTokenStore.this.closeConnection(conn, error);
                    continue;
                }
                CachedDBOidcTokenStore.this.closeConnection(conn, error);
            }
        }
    }
}

