/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.util;

import com.ibm.oauth.core.internal.oauth20.granttype.OAuth20GrantTypeHandlerFactory;
import com.ibm.oauth.core.internal.oauth20.responsetype.OAuth20ResponseTypeHandlerFactory;
import com.ibm.oauth.core.internal.oauth20.tokentype.OAuth20TokenTypeHandler;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.common.claims.UserClaimsRetrieverService;
import com.ibm.ws.security.oauth20.internal.LibertyOAuth20Provider;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.oauth20.util.OAuth20Parameter;
import com.ibm.ws.security.wim.VMMService;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.oauth20.JwtAccessTokenMediator;
import com.ibm.wsspi.security.openidconnect.IDTokenMediator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ConfigUtils.class}, name="com.ibm.ws.security.oauth20.util.ConfigUtils", immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class ConfigUtils {
    private static TraceComponent tc = Tr.register(ConfigUtils.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    protected static final List<OidcBaseClient> clientsList = Collections.synchronizedList(new ArrayList());
    protected static final Map<String, List<OAuth20Parameter>> providerConfigMap = Collections.synchronizedMap(new HashMap());
    protected static final Map<String, ClassLoader> providerPluginClassLoaderMap = Collections.synchronizedMap(new HashMap());
    private static Map<String, Object[]> jdbcCredentialsMap = Collections.synchronizedMap(new HashMap());
    private static UserClaimsRetrieverService userClaimsRetrieverService;
    public static final String KEY_JWT_MEDIATOR = "jwtAccessTokenMediator";
    private static ConcurrentServiceReferenceMap<String, JwtAccessTokenMediator> jwtMediatorRef;
    public static final String KEY_IDTOKEN_MEDIATOR = "idTokenMediator";
    private static ConcurrentServiceReferenceMap<String, IDTokenMediator> idTokenMediatorRef;
    public static final String BUILTIN_DB_PROVIDER_CLASS = "com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcClientProvider";
    public static final String BUILTIN_DB_TOKEN_STORE_CLASS = "com.ibm.ws.security.oauth20.plugins.db.CachedDBOidcTokenStore";
    public static final String BUILTIN_BASE_PROVIDER_CLASS = "com.ibm.ws.security.oauth20.plugins.OidcBaseClientProvider";
    public static final String BUILTIN_BASE_TOKEN_STORE_CLASS = "com.ibm.ws.security.oauth20.plugins.BaseCache";
    public static final String BUILTIN_BASE_TOKEN_HANDLER_CLASS = "com.ibm.ws.security.oauth20.plugins.BaseTokenHandler";
    public static final String BUILTIN_BASE_ID_TOKEN_HANDLER_CLASS = "com.ibm.ws.security.openidconnect.server.plugins.IDTokenHandler";
    public static final String BUILTIN_GRANT_TYPE_HANDLER_FACTORY_CLASS = "com.ibm.ws.security.openidconnect.server.plugins.OIDCGrantTypeHandlerFactoryImpl";
    public static final String BUILTIN_RESPONSE_TYPE_HANDLER_FACTORY_CLASS = "com.ibm.ws.security.openidconnect.server.plugins.OIDCResponseTypeHandlerFactoryImpl";
    public static final String BUILTIN_MEDIATOR_CLASS = "com.ibm.oauth.core.internal.oauth20.mediator.impl.OAuth20MediatorDefaultImpl";
    public static final String BUILTIN_SAMPLE_MEDIATOR_CLASS = "com.ibm.ws.security.oauth20.mediator.ResourceOwnerValidationMediator";
    private static Map<String, SecurityService> mapSecurityService;
    public static final String KEY_ID = "id";
    public static final String KEY_OIDC_SERVER_CONFIG = "oidcServerConfig";
    private static final String KEY_VMM_SERVICE = "vmmService";
    static AtomicServiceReference<VMMService> vmmServiceRef;
    private static final ConcurrentServiceReferenceMap<String, OidcServerConfig> oidcServerConfigRef;
    private static boolean bOidcUpdated;
    private static HashMap<String, OidcServerConfig> oidcMap;
    private static final String KEY_OIDC_IDTOKEN_HANDLER = "IDTokenHandler";
    private volatile OAuth20TokenTypeHandler oidcIDTokenHandler = null;
    private static final String KEY_OIDC_GRANT_TYPE_HANDLER_FACTORY = "OAuth20GrantTypeHandlerFactory";
    private volatile OAuth20GrantTypeHandlerFactory oidcGrantTypeHandlerFactory = null;
    private static final String KEY_OIDC_RESPONSE_TYPE_HANDLER_FACTORY = "OAuth20ResponseTypeHandlerFactory";
    private volatile OAuth20ResponseTypeHandlerFactory oidcResponseTypeHandlerFactory = null;
    static final long serialVersionUID = 3236504291377478764L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    public void activate(ComponentContext cc) {
        ConcurrentServiceReferenceMap<String, OidcServerConfig> concurrentServiceReferenceMap = oidcServerConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            oidcServerConfigRef.activate(cc);
            bOidcUpdated = true;
        }
        vmmServiceRef.activate(cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    public void deactivate(ComponentContext cc) {
        ConcurrentServiceReferenceMap<String, OidcServerConfig> concurrentServiceReferenceMap = oidcServerConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            oidcServerConfigRef.deactivate(cc);
            bOidcUpdated = true;
        }
        vmmServiceRef.deactivate(cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=OidcServerConfig.class, name="oidcServerConfig", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    public void setOidcServerConfig(ServiceReference<OidcServerConfig> ref) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setOidcServerConfig", (Object[])new Object[]{ref});
        }
        ConcurrentServiceReferenceMap<String, OidcServerConfig> concurrentServiceReferenceMap = oidcServerConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            oidcServerConfigRef.putReference((Object)((String)ref.getProperty(KEY_ID)), ref);
            bOidcUpdated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetOidcServerConfig(ServiceReference<OidcServerConfig> ref) {
        ConcurrentServiceReferenceMap<String, OidcServerConfig> concurrentServiceReferenceMap = oidcServerConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            oidcServerConfigRef.removeReference((Object)((String)ref.getProperty(KEY_ID)), ref);
            bOidcUpdated = true;
        }
    }

    @Reference(service=VMMService.class, name="vmmService", policy=ReferencePolicy.DYNAMIC)
    public void setVmmService(ServiceReference<VMMService> ref) {
        vmmServiceRef.setReference(ref);
    }

    protected void unsetVmmService(ServiceReference<VMMService> ref) {
        vmmServiceRef.unsetReference(ref);
    }

    @Reference(name="IDTokenHandler", service=OAuth20TokenTypeHandler.class)
    protected void setOidcIDTokenTypeHandler(OAuth20TokenTypeHandler handler) {
        this.oidcIDTokenHandler = handler;
        LibertyOAuth20Provider.setOidcIDTokenTypeHandler(handler);
    }

    protected void unsetOidcIDTokenTypeHandler(OAuth20TokenTypeHandler handler) {
        this.oidcIDTokenHandler = null;
        LibertyOAuth20Provider.setOidcIDTokenTypeHandler(null);
    }

    @Reference(name="OAuth20GrantTypeHandlerFactory", service=OAuth20GrantTypeHandlerFactory.class)
    protected void setOidcGrantTypeHandlerFactory(OAuth20GrantTypeHandlerFactory handler) {
        this.oidcGrantTypeHandlerFactory = handler;
        LibertyOAuth20Provider.setOidcGrantTypeHandlerFactory(handler);
    }

    protected void unsetOidcGrantTypeHandlerFactory(OAuth20GrantTypeHandlerFactory handler) {
        this.oidcGrantTypeHandlerFactory = null;
        LibertyOAuth20Provider.setOidcGrantTypeHandlerFactory(null);
    }

    @Reference(name="OAuth20ResponseTypeHandlerFactory", service=OAuth20ResponseTypeHandlerFactory.class)
    protected void setOidcResponseTypeHandlerFactory(OAuth20ResponseTypeHandlerFactory handler) {
        this.oidcResponseTypeHandlerFactory = handler;
        LibertyOAuth20Provider.setOidcResponseTypeHandlerFactory(handler);
    }

    protected void unsetOidcResponseTypeHandlerFactory(OAuth20ResponseTypeHandlerFactory handler) {
        this.oidcResponseTypeHandlerFactory = null;
        LibertyOAuth20Provider.setOidcResponseTypeHandlerFactory(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OidcServerConfig getOidcServerConfigForOAuth20Provider(String oauth20providerName) {
        OidcServerConfig oidcServerConfig = null;
        ConcurrentServiceReferenceMap<String, OidcServerConfig> concurrentServiceReferenceMap = oidcServerConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            if (bOidcUpdated) {
                ConfigUtils configUtils = new ConfigUtils();
                oidcMap = configUtils.checkDuplicateOAuthProvider(oidcServerConfigRef);
                bOidcUpdated = false;
            }
        }
        Set<String> oidcServerConfigIds = oidcMap.keySet();
        for (String oidcServerConfigId : oidcServerConfigIds) {
            OidcServerConfig entry = oidcMap.get(oidcServerConfigId);
            String providerName = entry.getOauthProviderName();
            if (!oauth20providerName.equals(providerName)) continue;
            oidcServerConfig = entry;
            break;
        }
        return oidcServerConfig;
    }

    @ManualTrace
    public static String nameAndValueProperty(String name, String value) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"nameAndValueProperty", (Object[])new Object[]{name, value});
        }
        String result = null;
        StringBuffer sb = new StringBuffer();
        if (name != null && value != null) {
            sb.append("\"");
            sb.append(name);
            sb.append("=");
            sb.append(value);
            sb.append("\"");
            result = sb.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"nameAndValueProperty", result);
        }
        return result;
    }

    @ManualTrace
    public static String getPropertyValue(String prefix, String key, Map<String, String> spProps) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPropertyValue", (Object[])new Object[]{prefix, key, spProps});
        }
        String value = null;
        if (prefix != null && prefix.length() > 0 && key != null && key.length() > 0 && spProps != null && !spProps.isEmpty()) {
            String propName = prefix + key;
            for (Map.Entry<String, String> entry : spProps.entrySet()) {
                String name = entry.getKey();
                if (name == null || !name.equalsIgnoreCase(propName)) continue;
                value = entry.getValue();
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPropertyValue", (Object)new Object[]{value});
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public static boolean isCustomPropStringGood(String propString) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isCustomPropStringGood", (Object[])new Object[]{propString});
        }
        try {
            if (propString != null && propString.length() > 0) {
                if (!propString.startsWith("\"") && !propString.endsWith("\"")) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"isCustomPropStringGood", (Object)false);
                    }
                    return false;
                }
                StringTokenizer tokenizer = new StringTokenizer(propString, "\"");
                while (tokenizer.hasMoreTokens()) {
                    String getComma;
                    String token = tokenizer.nextToken();
                    if (token.indexOf("=") < 0) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"isCustomPropStringGood", (Object)false);
                        }
                        return false;
                    }
                    if (!tokenizer.hasMoreTokens() || (getComma = tokenizer.nextToken()) != null && getComma.trim().equals(",") && tokenizer.hasMoreTokens()) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"isCustomPropStringGood", (Object)false);
                    }
                    return false;
                }
            }
        }
        catch (Exception tokenizer) {
            void e;
            FFDCFilter.processException((Throwable)tokenizer, (String)"com.ibm.ws.security.oauth20.util.ConfigUtils", (String)"298", null, (Object[])new Object[]{propString});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception while tokenizing custom property string " + e), (Object[])new Object[0]);
            }
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isCustomPropStringGood", (Object)true);
        }
        return true;
    }

    public static void clearClientAndProviderConfigs() {
        clientsList.clear();
        providerConfigMap.clear();
        providerPluginClassLoaderMap.clear();
    }

    public static void setClients(List<OidcBaseClient> clients) {
        clientsList.addAll(clients);
    }

    public static List<OidcBaseClient> getClients() {
        return clientsList;
    }

    public static void setProviderConfigMap(Map<String, List<OAuth20Parameter>> configMap) {
        providerConfigMap.putAll(configMap);
    }

    public static Map<String, List<OAuth20Parameter>> getProviderConfigMap() {
        return providerConfigMap;
    }

    public static Map<String, ClassLoader> getProviderPluginClassLoaderMap() {
        return providerPluginClassLoaderMap;
    }

    public static Map<String, Object[]> getProviderJdbcCredentialsMap() {
        return jdbcCredentialsMap;
    }

    public static boolean isBuiltinClass(String className) {
        boolean isBuiltin = className.equals(BUILTIN_DB_PROVIDER_CLASS) || className.equals(BUILTIN_DB_TOKEN_STORE_CLASS) || className.equals(BUILTIN_BASE_PROVIDER_CLASS) || className.equals(BUILTIN_BASE_TOKEN_HANDLER_CLASS) || className.equals(BUILTIN_BASE_ID_TOKEN_HANDLER_CLASS) || className.equals(BUILTIN_GRANT_TYPE_HANDLER_FACTORY_CLASS) || className.equals(BUILTIN_RESPONSE_TYPE_HANDLER_FACTORY_CLASS) || className.equals(BUILTIN_MEDIATOR_CLASS) || className.equals(BUILTIN_SAMPLE_MEDIATOR_CLASS) || className.equals(BUILTIN_BASE_TOKEN_STORE_CLASS);
        return isBuiltin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    public static boolean deleteClients(String providerId) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("deleteClients " + providerId), (Object[])new Object[0]);
        }
        List<OidcBaseClient> list = clientsList;
        synchronized (list) {
            Iterator<OidcBaseClient> it = clientsList.iterator();
            while (it.hasNext()) {
                OidcBaseClient client = it.next();
                if (!client.getComponentId().equals(providerId)) continue;
                it.remove();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"deleteClients");
        }
        return true;
    }

    public static synchronized void setUserClaimsRetrieverService(UserClaimsRetrieverService claimsRetrieverService) {
        userClaimsRetrieverService = claimsRetrieverService;
    }

    public static synchronized UserClaimsRetrieverService getUserClaimsRetrieverService() {
        return userClaimsRetrieverService;
    }

    public static synchronized VMMService getVMMService() {
        return (VMMService)vmmServiceRef.getService();
    }

    public static synchronized void setJwtAccessTokenMediatorService(ConcurrentServiceReferenceMap<String, JwtAccessTokenMediator> jwtAccessTokenMediatorServiceRef) {
        jwtMediatorRef = jwtAccessTokenMediatorServiceRef;
    }

    public static synchronized ConcurrentServiceReferenceMap<String, JwtAccessTokenMediator> getJwtAccessTokenMediatorService() {
        return jwtMediatorRef;
    }

    public static synchronized void setIdTokenMediatorService(ConcurrentServiceReferenceMap<String, IDTokenMediator> idTokenMediatorServiceRef) {
        idTokenMediatorRef = idTokenMediatorServiceRef;
    }

    public static synchronized ConcurrentServiceReferenceMap<String, IDTokenMediator> getIdTokenMediatorService() {
        return idTokenMediatorRef;
    }

    public static void addSecurityService(String providerId, SecurityService securityService) {
        mapSecurityService.put(providerId, securityService);
    }

    public static void removeSecurityService(String providerId) {
        mapSecurityService.remove(providerId);
    }

    public static SecurityService getSecurityService(String providerId) {
        return mapSecurityService.get(providerId);
    }

    public HashMap<String, OidcServerConfig> checkDuplicateOAuthProvider(ConcurrentServiceReferenceMap<String, OidcServerConfig> oidcServerConfigRef) {
        HashMap<String, OidcServerConfig> result = new HashMap<String, OidcServerConfig>();
        HashMap<String, String> mapProviderId = new HashMap<String, String>();
        HashMap<String, String> mapConfigId = new HashMap<String, String>();
        Set configIDs = oidcServerConfigRef.keySet();
        for (String configId : configIDs) {
            String oldOidcProviderId;
            OidcServerConfig oidcServerConfig = (OidcServerConfig)oidcServerConfigRef.getService((Object)configId);
            String oidcProviderId = oidcServerConfig.getProviderId();
            String oauthProviderName = oidcServerConfig.getOauthProviderName();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("oidcConfigId: " + oidcProviderId + " oauthProviderName: " + oauthProviderName), (Object[])new Object[0]);
            }
            if ((oldOidcProviderId = (String)mapProviderId.get(oauthProviderName)) != null) {
                Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_MULTI_OIDC_TO_ONE_OAUTH", (Object[])new Object[]{oldOidcProviderId, oidcProviderId, oauthProviderName});
                String oldConfigId = (String)mapConfigId.get(oauthProviderName);
                result.remove(oldConfigId);
                continue;
            }
            mapProviderId.put(oauthProviderName, oidcProviderId);
            mapConfigId.put(oauthProviderName, configId);
            result.put(configId, oidcServerConfig);
        }
        return result;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        jwtMediatorRef = new ConcurrentServiceReferenceMap(KEY_JWT_MEDIATOR);
        idTokenMediatorRef = new ConcurrentServiceReferenceMap(KEY_IDTOKEN_MEDIATOR);
        mapSecurityService = Collections.synchronizedMap(new HashMap());
        vmmServiceRef = new AtomicServiceReference(KEY_VMM_SERVICE);
        oidcServerConfigRef = new ConcurrentServiceReferenceMap(KEY_OIDC_SERVER_CONFIG);
        bOidcUpdated = false;
        oidcMap = new HashMap();
    }
}

