/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oauth20.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.ProvidersService;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.web.OAuth20Request;
import io.openliberty.security.common.http.SupportedHttpMethodHandler;
import io.openliberty.security.oauth20.internal.config.OAuthEndpointSettings;
import io.openliberty.security.oauth20.internal.config.SpecificOAuthEndpointSettings;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OAuthSupportedHttpMethodHandler
extends SupportedHttpMethodHandler {
    private static TraceComponent tc = Tr.register(OAuthSupportedHttpMethodHandler.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    protected OAuth20Request oauth20Request = this.getOAuth20RequestAttribute();
    protected String oauth20ProviderName = null;
    protected OAuth20Provider oauthProvider = null;
    static final long serialVersionUID = 607599999667979948L;

    public OAuthSupportedHttpMethodHandler(HttpServletRequest request, HttpServletResponse response) {
        super(request, response);
        if (this.oauth20Request != null) {
            this.oauth20ProviderName = this.oauth20Request.getProviderName();
            this.oauthProvider = this.getOAuth20Provider();
        }
    }

    public boolean isValidHttpMethodForRequest(SupportedHttpMethodHandler.HttpMethod requestMethod) {
        OAuth20Request.EndpointType endpointType = this.getEndpointType();
        if (endpointType == null) {
            return false;
        }
        Set<SupportedHttpMethodHandler.HttpMethod> supportedMethods = this.getSupportedMethodsForEndpoint(endpointType);
        return supportedMethods != null && supportedMethods.contains(requestMethod);
    }

    public void sendHttpOptionsResponse() throws IOException {
        OAuth20Request.EndpointType endpointType = this.getEndpointType();
        if (endpointType == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Failed to find a known endpoint type from the inbound request", (Object[])new Object[0]);
            }
            this.response.sendError(404);
            return;
        }
        Set<SupportedHttpMethodHandler.HttpMethod> supportedMethods = this.getSupportedMethodsForEndpoint(endpointType);
        this.setAllowHeaderAndSendResponse(supportedMethods);
    }

    protected OAuth20Request.EndpointType getEndpointType() {
        if (this.oauth20Request == null) {
            return null;
        }
        return this.oauth20Request.getType();
    }

    Set<SupportedHttpMethodHandler.HttpMethod> getSupportedMethodsForEndpoint(OAuth20Request.EndpointType endpointType) {
        Set<SupportedHttpMethodHandler.HttpMethod> supportedMethods = this.getDefaultSupportedMethodsForEndpoint(endpointType);
        if (supportedMethods == null || supportedMethods.isEmpty()) {
            return supportedMethods;
        }
        Set<SupportedHttpMethodHandler.HttpMethod> configuredSupportedMethods = this.getConfiguredSupportedMethodsForEndpoint(endpointType);
        return this.getAdjustedSupportedMethodsForEndpoint(supportedMethods, configuredSupportedMethods);
    }

    protected Set<SupportedHttpMethodHandler.HttpMethod> getDefaultSupportedMethodsForEndpoint(OAuth20Request.EndpointType endpointType) {
        HashSet<SupportedHttpMethodHandler.HttpMethod> supportedMethods = new HashSet<SupportedHttpMethodHandler.HttpMethod>();
        supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.OPTIONS);
        if (endpointType == OAuth20Request.EndpointType.authorize) {
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.GET);
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.HEAD);
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.POST);
        } else if (endpointType == OAuth20Request.EndpointType.introspect) {
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.GET);
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.HEAD);
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.POST);
        } else if (endpointType == OAuth20Request.EndpointType.revoke) {
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.POST);
        } else if (endpointType == OAuth20Request.EndpointType.token) {
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.POST);
        } else if (endpointType == OAuth20Request.EndpointType.coverage_map) {
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.GET);
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.HEAD);
        } else if (endpointType == OAuth20Request.EndpointType.registration) {
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.GET);
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.HEAD);
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.POST);
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.DELETE);
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.PUT);
        } else if (endpointType == OAuth20Request.EndpointType.logout) {
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.GET);
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.HEAD);
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.POST);
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.DELETE);
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.PUT);
        } else if (endpointType == OAuth20Request.EndpointType.app_password) {
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.GET);
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.HEAD);
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.POST);
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.DELETE);
        } else if (endpointType == OAuth20Request.EndpointType.app_token) {
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.GET);
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.HEAD);
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.POST);
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.DELETE);
        } else if (endpointType == OAuth20Request.EndpointType.clientManagement) {
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.GET);
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.HEAD);
        } else if (endpointType == OAuth20Request.EndpointType.personalTokenManagement) {
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.GET);
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.HEAD);
        } else if (endpointType == OAuth20Request.EndpointType.usersTokenManagement) {
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.GET);
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.HEAD);
        } else if (endpointType == OAuth20Request.EndpointType.clientMetatype) {
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.GET);
            supportedMethods.add(SupportedHttpMethodHandler.HttpMethod.HEAD);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Received a request for an unknown OAuth endpoint: [" + (Object)((Object)endpointType) + "]"), (Object[])new Object[0]);
            }
            return null;
        }
        return supportedMethods;
    }

    protected Set<SupportedHttpMethodHandler.HttpMethod> getConfiguredSupportedMethodsForEndpoint(OAuth20Request.EndpointType endpoint) {
        OAuthEndpointSettings endpointConfigSettings = this.getConfiguredOAuthEndpointSettings();
        if (endpointConfigSettings == null) {
            return null;
        }
        SpecificOAuthEndpointSettings specificEndpointSettings = endpointConfigSettings.getSpecificOAuthEndpointSettings(endpoint);
        if (specificEndpointSettings == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Did not find any specific OAuth endpoint settings for endpoint [" + (Object)((Object)endpoint) + "]"), (Object[])new Object[0]);
            }
            return null;
        }
        return specificEndpointSettings.getSupportedHttpMethods();
    }

    OAuthEndpointSettings getConfiguredOAuthEndpointSettings() {
        if (this.oauthProvider == null) {
            return null;
        }
        return this.oauthProvider.getOAuthEndpointSettings();
    }

    protected OAuth20Provider getOAuth20Provider() {
        if (this.oauth20ProviderName == null) {
            return null;
        }
        OAuth20Provider provider = ProvidersService.getOAuth20Provider(this.oauth20ProviderName);
        if (provider == null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Did not find an OAuth provider matching the name [{0}]", (Object[])new Object[]{this.oauth20ProviderName});
        }
        return provider;
    }

    Set<SupportedHttpMethodHandler.HttpMethod> getAdjustedSupportedMethodsForEndpoint(Set<SupportedHttpMethodHandler.HttpMethod> defaultSupportedMethods, Set<SupportedHttpMethodHandler.HttpMethod> configuredSupportedMethods) {
        if (defaultSupportedMethods == null || defaultSupportedMethods.isEmpty()) {
            return defaultSupportedMethods;
        }
        HashSet<SupportedHttpMethodHandler.HttpMethod> adjustedSupportedMethods = new HashSet<SupportedHttpMethodHandler.HttpMethod>(defaultSupportedMethods);
        if (configuredSupportedMethods != null) {
            adjustedSupportedMethods.retainAll(configuredSupportedMethods);
        }
        if (!adjustedSupportedMethods.contains(SupportedHttpMethodHandler.HttpMethod.OPTIONS)) {
            adjustedSupportedMethods.add(SupportedHttpMethodHandler.HttpMethod.OPTIONS);
        }
        return adjustedSupportedMethods;
    }

    OAuth20Request getOAuth20RequestAttribute() {
        OAuth20Request oauth20Request = (OAuth20Request)this.request.getAttribute("OAuth20Request");
        if (oauth20Request == null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Failed to find OAuth20Request information from the inbound request", (Object[])new Object[0]);
        }
        return oauth20Request;
    }
}

