/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.objectManager;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.SimplifiedSerialization;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.sib.msgstore.persistence.TupleTypeEnum;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class PersistableMetaData
extends ManagedObject
implements SimplifiedSerialization {
    private static final long serialVersionUIDV0 = 7600601884916750783L;
    private static final long serialVersionUIDV1 = 7600601884916130911L;
    private static final long serialVersionUID = 2L;
    private static TraceComponent tc = SibTr.register(PersistableMetaData.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private long _uniqueID;
    private long _streamID;
    private long _lockID = -2L;
    private long _referredID = -1L;
    private long _sequence;
    private long _expiryTime;
    private int _redeliveredCount;
    private int _storageStrategy = 1;
    private int _priority;
    private int _persistentSize;
    private int _maxDepth;
    private boolean _canExpireSilently;
    private String _type;
    private String _className;
    private byte[] _transactionId;
    private long _deliveryDelayTime;
    private transient boolean _deliveryDelayTimeIsSuspect = false;
    private transient boolean _logicallyDeleted;
    private Token _streamListToken;
    private Token _itemListToken;
    private Token _rawDataToken;
    private boolean _containsExpirables;
    private Token _streamListEntryToken;
    private Token _itemListEntryToken;
    private transient long _estimatedLength = -1L;
    private static long _estimatedLengthHeader;

    public PersistableMetaData() {
    }

    public PersistableMetaData(long uniqueID, long streamID, String type) {
        this._uniqueID = uniqueID;
        this._streamID = streamID;
        this._type = type;
    }

    public PersistableMetaData(PersistableMetaData donor) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)("Donor=" + donor));
        }
        this._uniqueID = donor._uniqueID;
        this._streamID = donor._streamID;
        this._type = donor._type;
        this._lockID = donor._lockID;
        this._referredID = donor._referredID;
        this._sequence = donor._sequence;
        this._expiryTime = donor._expiryTime;
        this._storageStrategy = donor._storageStrategy;
        this._priority = donor._priority;
        this._persistentSize = donor._persistentSize;
        this._maxDepth = donor._maxDepth;
        this._canExpireSilently = donor._canExpireSilently;
        this._type = donor._type;
        this._className = donor._className;
        this._transactionId = donor._transactionId;
        this._containsExpirables = donor._containsExpirables;
        this._redeliveredCount = donor._redeliveredCount;
        this._deliveryDelayTime = donor._deliveryDelayTime;
        this._logicallyDeleted = donor._logicallyDeleted;
        this._estimatedLength = donor._estimatedLength;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public Token getStreamListEntryToken() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getStreamListEntryToken");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getStreamListEntryToken", (Object)("return=" + this._streamListEntryToken));
        }
        return this._streamListEntryToken;
    }

    public void setStreamListEntryToken(Token token) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setStreamListEntryToken", (Object)("Token=" + token));
        }
        this._streamListEntryToken = token;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setStreamListEntryToken");
        }
    }

    public Token getItemListEntryToken() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getItemListEntryToken");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getItemListEntryToken", (Object)("return=" + this._itemListEntryToken));
        }
        return this._itemListEntryToken;
    }

    public void setItemListEntryToken(Token token) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setItemListEntryToken", (Object)("Token=" + token));
        }
        this._itemListEntryToken = token;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setItemListEntryToken");
        }
    }

    public Token getStreamListToken() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getStreamListToken");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getStreamListToken", (Object)("return=" + this._streamListToken));
        }
        return this._streamListToken;
    }

    public void setStreamListToken(Token token) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setStreamListToken", (Object)("Token=" + token));
        }
        this._streamListToken = token;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setStreamListToken", (Object)"");
        }
    }

    public Token getItemListToken() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getItemListToken");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getItemListToken", (Object)("return=" + this._itemListToken));
        }
        return this._itemListToken;
    }

    public void setItemListToken(Token token) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setItemListToken", (Object)("Token=" + token));
        }
        this._itemListToken = token;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setItemListToken");
        }
    }

    public Token getRawDataToken() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getRawDataToken");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getRawDataToken", (Object)("return=" + this._rawDataToken));
        }
        return this._rawDataToken;
    }

    public void setRawDataToken(Token token) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setRawDataToken", (Object)("Token=" + token));
        }
        this._rawDataToken = token;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setRawDataToken");
        }
    }

    public void setCanExpireSilently(boolean canExpireSilently) {
        this._canExpireSilently = canExpireSilently;
    }

    public boolean canExpireSilently() {
        return this._canExpireSilently;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public String getClassName() {
        return this._className;
    }

    public void setContainsExpirables(boolean containsExpirables) {
        this._containsExpirables = containsExpirables;
    }

    public boolean containsExpirables() {
        return this._containsExpirables;
    }

    public void setExpiryTime(long expiryTime) {
        this._expiryTime = expiryTime;
    }

    public long getExpiryTime() {
        return this._expiryTime;
    }

    public void setRedeliveredCount(int redeliveredCount) {
        this._redeliveredCount = redeliveredCount;
    }

    public int getRedeliveredCount() {
        return this._redeliveredCount;
    }

    public void setLockID(long lockID) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setLockID", (Object)("LockID=" + lockID));
        }
        this._lockID = lockID;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setLockID");
        }
    }

    public long getLockID() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLockID");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getLockID", (Object)("return=" + this._lockID));
        }
        return this._lockID;
    }

    public void setLogicallyDeleted(boolean logicallyDeleted) {
        this._logicallyDeleted = logicallyDeleted;
    }

    public boolean isLogicallyDeleted() {
        return this._logicallyDeleted;
    }

    public void setMaxDepth(int maxDepth) {
        this._maxDepth = maxDepth;
    }

    public int getMaxDepth() {
        return this._maxDepth;
    }

    public void setPersistentSize(int persistentSize) {
        this._persistentSize = persistentSize;
    }

    public int getPersistentSize() {
        return this._persistentSize;
    }

    public void setPriority(int priority) {
        this._priority = priority;
    }

    public int getPriority() {
        return this._priority;
    }

    public void setReferredID(long referredID) {
        this._referredID = referredID;
    }

    public long getReferredID() {
        return this._referredID;
    }

    public void setSequence(long sequence) {
        this._sequence = sequence;
    }

    public long getSequence() {
        return this._sequence;
    }

    public void setStorageStrategy(int storageStrategy) {
        this._storageStrategy = storageStrategy;
    }

    public int getStorageStrategy() {
        return this._storageStrategy;
    }

    public long getStreamId() {
        return this._streamID;
    }

    public void setTransactionId(byte[] transactionId) {
        this._transactionId = transactionId;
    }

    public byte[] getTransactionId() {
        return this._transactionId;
    }

    public TupleTypeEnum getTupleType() {
        return TupleTypeEnum.getInstance(this._type);
    }

    public long getUniqueId() {
        return this._uniqueID;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(super.toString());
        buffer.append("(PersistableMetaData[ uniqueId: ");
        buffer.append(this._uniqueID);
        buffer.append(", containingStreamId: ");
        buffer.append(this._streamID);
        buffer.append(", className: ");
        buffer.append(this._className);
        buffer.append(", dataSize: ");
        buffer.append(this._persistentSize);
        buffer.append(", storageStrategy: ");
        buffer.append(this._storageStrategy);
        buffer.append(", tupleType: ");
        buffer.append(this._type);
        buffer.append(", maximumDepth: ");
        buffer.append(this._maxDepth);
        buffer.append(", priority: ");
        buffer.append(this._priority);
        buffer.append(", sequence: ");
        buffer.append(this._sequence);
        buffer.append(", canExpireSilently: ");
        buffer.append(this._canExpireSilently);
        buffer.append(", lockId: ");
        buffer.append(this._lockID);
        buffer.append(", referredId: ");
        buffer.append(this._referredID);
        buffer.append(", expiryTime: ");
        buffer.append(this._expiryTime);
        buffer.append(", logicallyDeleted: ");
        buffer.append(this._logicallyDeleted);
        buffer.append(", transactionId: ");
        buffer.append(Arrays.toString(this._transactionId));
        buffer.append(", rawDataToken: ");
        buffer.append(this._rawDataToken);
        buffer.append(", itemListToken: ");
        buffer.append(this._itemListToken);
        buffer.append(", streamListToken: ");
        buffer.append(this._streamListToken);
        buffer.append(", redeliveredCount: ");
        buffer.append(this._redeliveredCount);
        buffer.append(", deliveryDelayTime: ");
        buffer.append(this._deliveryDelayTime);
        buffer.append(" ])");
        return buffer.toString();
    }

    @Override
    public void becomeCloneOf(ManagedObject clone) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"becomeCloneOf", (Object)("Clone=" + clone));
        }
        PersistableMetaData theOther = (PersistableMetaData)clone;
        this._uniqueID = theOther._uniqueID;
        this._streamID = theOther._streamID;
        this._lockID = theOther._lockID;
        this._referredID = theOther._referredID;
        this._sequence = theOther._sequence;
        this._expiryTime = theOther._expiryTime;
        this._storageStrategy = theOther._storageStrategy;
        this._priority = theOther._priority;
        this._persistentSize = theOther._persistentSize;
        this._maxDepth = theOther._maxDepth;
        this._canExpireSilently = theOther._canExpireSilently;
        this._logicallyDeleted = theOther._logicallyDeleted;
        this._type = theOther._type;
        this._className = theOther._className;
        this._transactionId = theOther._transactionId;
        this._streamListToken = theOther._streamListToken;
        this._itemListToken = theOther._itemListToken;
        this._rawDataToken = theOther._rawDataToken;
        this._containsExpirables = theOther._containsExpirables;
        this._redeliveredCount = theOther._redeliveredCount;
        this._deliveryDelayTime = theOther._deliveryDelayTime;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"becomeCloneOf");
        }
    }

    @Override
    public long estimatedLength() {
        if (this._estimatedLength == -1L) {
            this._estimatedLength = _estimatedLengthHeader + 8L;
            this._estimatedLength += 56L;
            this._estimatedLength += 20L;
            this._estimatedLength += 2L;
            if (this._type != null) {
                this._estimatedLength += (long)(this._type.length() * 3);
            }
            if (this._className != null) {
                this._estimatedLength += (long)(this._className.length() * 3);
            }
            this._estimatedLength += 4L;
            if (this._transactionId != null) {
                this._estimatedLength += (long)this._transactionId.length;
            }
            this._estimatedLength += 5L;
            if (this._streamListToken != null) {
                this._estimatedLength += Token.maximumSerializedSize();
            }
            if (this._itemListToken != null) {
                this._estimatedLength += Token.maximumSerializedSize();
            }
            if (this._rawDataToken != null) {
                this._estimatedLength += Token.maximumSerializedSize();
            }
            if (this._streamListEntryToken != null) {
                this._estimatedLength += Token.maximumSerializedSize();
            }
            if (this._itemListEntryToken != null) {
                this._estimatedLength += Token.maximumSerializedSize();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("_estimatedLength=" + this._estimatedLength));
        }
        return this._estimatedLength;
    }

    @Override
    public void writeObject(DataOutputStream dataOutputStream) throws ObjectManagerException, IOException {
        super.writeObject(dataOutputStream);
        dataOutputStream.writeLong(2L);
        dataOutputStream.writeLong(this._uniqueID);
        dataOutputStream.writeLong(this._streamID);
        dataOutputStream.writeLong(this._lockID);
        dataOutputStream.writeLong(this._referredID);
        dataOutputStream.writeLong(this._sequence);
        dataOutputStream.writeLong(this._expiryTime);
        dataOutputStream.writeInt(this._redeliveredCount);
        dataOutputStream.writeInt(this._storageStrategy);
        dataOutputStream.writeInt(this._priority);
        dataOutputStream.writeInt(this._persistentSize);
        dataOutputStream.writeInt(this._maxDepth);
        dataOutputStream.writeBoolean(this._canExpireSilently);
        dataOutputStream.writeBoolean(this._containsExpirables);
        if (this._type != null) {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeUTF(this._type);
        } else {
            dataOutputStream.writeBoolean(false);
        }
        if (this._className != null) {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeUTF(this._className);
        } else {
            dataOutputStream.writeBoolean(false);
        }
        if (this._transactionId != null) {
            dataOutputStream.writeInt(this._transactionId.length);
            dataOutputStream.write(this._transactionId, 0, this._transactionId.length);
        } else {
            dataOutputStream.writeInt(-1);
        }
        if (this._streamListToken != null) {
            dataOutputStream.writeBoolean(true);
            this._streamListToken.writeObject(dataOutputStream);
        } else {
            dataOutputStream.writeBoolean(false);
        }
        if (this._itemListToken != null) {
            dataOutputStream.writeBoolean(true);
            this._itemListToken.writeObject(dataOutputStream);
        } else {
            dataOutputStream.writeBoolean(false);
        }
        if (this._rawDataToken != null) {
            dataOutputStream.writeBoolean(true);
            this._rawDataToken.writeObject(dataOutputStream);
        } else {
            dataOutputStream.writeBoolean(false);
        }
        if (this._streamListEntryToken != null) {
            dataOutputStream.writeBoolean(true);
            this._streamListEntryToken.writeObject(dataOutputStream);
        } else {
            dataOutputStream.writeBoolean(false);
        }
        if (this._itemListEntryToken != null) {
            dataOutputStream.writeBoolean(true);
            this._itemListEntryToken.writeObject(dataOutputStream);
        } else {
            dataOutputStream.writeBoolean(false);
        }
        dataOutputStream.writeLong(this._deliveryDelayTime);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("bytes written==" + dataOutputStream.size()));
        }
    }

    @Override
    public void readObject(DataInputStream dataInputStream, ObjectManagerState objectManagerState) throws ObjectManagerException, IOException {
        int length;
        String methodName = "readObject";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readObject", (Object)("bytes available==" + dataInputStream.available()));
        }
        super.readObject(dataInputStream, objectManagerState);
        long serialVersionUIDRead = dataInputStream.readLong();
        this._uniqueID = dataInputStream.readLong();
        this._streamID = dataInputStream.readLong();
        this._lockID = dataInputStream.readLong();
        this._referredID = dataInputStream.readLong();
        this._sequence = dataInputStream.readLong();
        this._expiryTime = dataInputStream.readLong();
        this._redeliveredCount = serialVersionUIDRead == 7600601884916750783L ? 0 : dataInputStream.readInt();
        this._storageStrategy = dataInputStream.readInt();
        this._priority = dataInputStream.readInt();
        this._persistentSize = dataInputStream.readInt();
        this._maxDepth = dataInputStream.readInt();
        this._canExpireSilently = dataInputStream.readBoolean();
        this._containsExpirables = dataInputStream.readBoolean();
        boolean read = dataInputStream.readBoolean();
        if (read) {
            this._type = dataInputStream.readUTF();
        }
        if (read = dataInputStream.readBoolean()) {
            this._className = dataInputStream.readUTF();
        }
        if ((length = dataInputStream.readInt()) != -1) {
            this._transactionId = new byte[length];
            dataInputStream.readFully(this._transactionId, 0, length);
        }
        if (read = dataInputStream.readBoolean()) {
            this._streamListToken = Token.restore(dataInputStream, objectManagerState);
        }
        if (read = dataInputStream.readBoolean()) {
            this._itemListToken = Token.restore(dataInputStream, objectManagerState);
        }
        if (read = dataInputStream.readBoolean()) {
            this._rawDataToken = Token.restore(dataInputStream, objectManagerState);
        }
        if (read = dataInputStream.readBoolean()) {
            this._streamListEntryToken = Token.restore(dataInputStream, objectManagerState);
        }
        if (read = dataInputStream.readBoolean()) {
            this._itemListEntryToken = Token.restore(dataInputStream, objectManagerState);
        }
        if (serialVersionUIDRead == 7600601884916750783L) {
            this._deliveryDelayTime = 0L;
        } else if (serialVersionUIDRead == 7600601884916130911L) {
            if (dataInputStream.available() >= 8 && this._className.equals("com.ibm.ws.sib.processor.impl.store.items.MessageItem")) {
                this._deliveryDelayTime = dataInputStream.readLong();
                this._deliveryDelayTimeIsSuspect = true;
            } else {
                this._deliveryDelayTime = 0L;
            }
        } else {
            this._deliveryDelayTime = dataInputStream.readLong();
        }
        this._estimatedLength = -1L;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readObject", (Object)("serialVersionUIDRead=" + serialVersionUIDRead + " bytes available==" + dataInputStream.available()));
        }
    }

    public void setDeliveryDelayTime(long deliveryDelayTime) {
        this._deliveryDelayTime = deliveryDelayTime;
    }

    public long getDeliveryDelayTime() {
        return this._deliveryDelayTime;
    }

    public boolean getDeliveryDelayTimeIsSuspect() {
        return this._deliveryDelayTimeIsSuspect;
    }

    static {
        try {
            class DummyOutputStream
            extends OutputStream {
                DummyOutputStream() {
                }

                @Override
                public void write(int b) throws IOException {
                }
            }
            DataOutputStream dataOutputStream = new DataOutputStream(new DummyOutputStream());
            dataOutputStream.writeUTF(new PersistableMetaData().getClass().getName());
            _estimatedLengthHeader = dataOutputStream.size();
            dataOutputStream.close();
            dataOutputStream = null;
            _estimatedLengthHeader += 64L;
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)"Exception caught initialising _estimatedLengthHeader!", (Object)e);
            }
            _estimatedLengthHeader = 150L;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("_estimatedLengthHeader=" + _estimatedLengthHeader));
        }
    }
}

