/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal.client;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.openliberty.grpc.internal.client.LibertyHeaderPropagationSupport;

public class LibertyClientInterceptor
implements ClientInterceptor {
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, final Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                int colonIndex;
                String remoteHost = next.authority();
                if (remoteHost != null && (colonIndex = remoteHost.indexOf(":")) > 1) {
                    remoteHost = remoteHost.substring(0, colonIndex);
                }
                LibertyHeaderPropagationSupport.handleHeaderPropagation(remoteHost, method, headers);
                super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){}, headers);
            }
        };
    }
}

