/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.managedobject.ManagedObjectException;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannelProvider;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import io.openliberty.grpc.internal.GrpcManagedObjectProvider;
import io.openliberty.grpc.internal.client.GrpcClientComponent;
import io.openliberty.grpc.internal.client.GrpcSSLService;
import io.openliberty.grpc.internal.client.LibertyClientInterceptor;
import io.openliberty.grpc.internal.client.config.GrpcClientConfigHolder;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class LibertyManagedChannelProvider
extends ManagedChannelProvider {
    private static final TraceComponent tc = Tr.register(LibertyManagedChannelProvider.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.client.resources.grpcclientmessages");

    public boolean isAvailable() {
        return true;
    }

    public int priority() {
        return 10;
    }

    public NettyChannelBuilder builderForAddress(String name, int port) {
        NettyChannelBuilder builder = NettyChannelBuilder.forAddress((String)name, (int)port);
        this.configureLibertyBuilder(builder, name, String.valueOf(port));
        return builder;
    }

    public NettyChannelBuilder builderForTarget(String target) {
        NettyChannelBuilder builder = NettyChannelBuilder.forTarget((String)target);
        this.configureLibertyBuilder(builder, target, "");
        return builder;
    }

    private void configureLibertyBuilder(NettyChannelBuilder builder, String target, String port) {
        this.addLibertyInterceptors(builder);
        Map<String, String> config = GrpcClientConfigHolder.getHostProps(target);
        if (config != null && !config.isEmpty()) {
            this.addUserInterceptors(builder, config);
            this.addKeepAliveConfiguration(builder, config);
            this.addMaxInboundMessageSize(builder, config);
            this.addMaxInboundMetadataSize(builder, config);
            this.addUserAgent(builder, config);
            this.addOverrideAuthority(builder, config);
        }
        if (!this.isUsePlaintextEnabled(config)) {
            this.addLibertySSLConfig(builder, target, port, config);
        }
    }

    private void addLibertyInterceptors(NettyChannelBuilder builder) {
        builder.intercept(new ClientInterceptor[]{new LibertyClientInterceptor()});
        ClientInterceptor monitoringInterceptor = this.createMonitoringClientInterceptor();
        if (monitoringInterceptor != null) {
            builder.intercept(new ClientInterceptor[]{monitoringInterceptor});
        }
    }

    private void addLibertySSLConfig(NettyChannelBuilder builder, String target, String port, Map<String, String> config) {
        String sslRef = null;
        if (config != null && !config.isEmpty()) {
            sslRef = config.get("sslRef");
        }
        SslContext context = null;
        GrpcSSLService sslService = GrpcClientComponent.getGrpcSSLService();
        if (sslService != null && (context = sslService.getOutboundClientSSLContext(sslRef, target, port)) != null) {
            builder.sslContext(context);
        }
    }

    private void addKeepAliveConfiguration(NettyChannelBuilder builder, Map<String, String> config) {
        String keepAliveTime = config.get("keepAliveTime");
        String keepAliveWithoutCalls = config.get("keepAliveWithoutCalls");
        String keepAliveTimeout = config.get("keepAliveTimeout");
        if (keepAliveTime != null && !keepAliveTime.isEmpty()) {
            int time = Integer.parseInt(keepAliveTime);
            builder.keepAliveTime((long)time, TimeUnit.SECONDS);
        }
        if (keepAliveWithoutCalls != null && !keepAliveWithoutCalls.isEmpty()) {
            Boolean enabled = Boolean.parseBoolean(keepAliveWithoutCalls);
            builder.keepAliveWithoutCalls(enabled.booleanValue());
        }
        if (keepAliveTimeout != null && !keepAliveTimeout.isEmpty()) {
            int timeout = Integer.parseInt(keepAliveTimeout);
            builder.keepAliveTimeout((long)timeout, TimeUnit.SECONDS);
        }
    }

    private void addMaxInboundMessageSize(NettyChannelBuilder builder, Map<String, String> config) {
        String maxMsgSizeString = config.get("maxInboundMessageSize");
        if (maxMsgSizeString != null && !maxMsgSizeString.isEmpty()) {
            int maxSize = Integer.parseInt(maxMsgSizeString);
            if (maxSize == -1) {
                builder.maxInboundMessageSize(Integer.MAX_VALUE);
            } else if (maxSize > 0) {
                builder.maxInboundMessageSize(maxSize);
            }
        }
    }

    private void addMaxInboundMetadataSize(NettyChannelBuilder builder, Map<String, String> config) {
        String maxMetaString = config.get("maxInboundMetadataSize");
        if (maxMetaString != null && !maxMetaString.isEmpty()) {
            int maxSize = Integer.parseInt(maxMetaString);
            if (maxSize == -1) {
                builder.maxInboundMetadataSize(Integer.MAX_VALUE);
            } else if (maxSize > 0) {
                builder.maxInboundMetadataSize(maxSize);
            }
        }
    }

    private void addUserAgent(NettyChannelBuilder builder, Map<String, String> config) {
        String userAgent = config.get("userAgent");
        if (userAgent != null && !userAgent.isEmpty()) {
            builder.userAgent(userAgent);
        }
    }

    private void addOverrideAuthority(NettyChannelBuilder builder, Map<String, String> config) {
        String authority = config.get("overrideAuthority");
        if (authority != null && !authority.isEmpty()) {
            builder.overrideAuthority(authority);
        }
    }

    private boolean isUsePlaintextEnabled(Map<String, String> config) {
        String usePlaintext;
        if (config != null && (usePlaintext = config.get("usePlaintext")) != null && !usePlaintext.isEmpty()) {
            return Boolean.parseBoolean(usePlaintext);
        }
        return false;
    }

    private void addUserInterceptors(NettyChannelBuilder builder, Map<String, String> config) {
        List<String> items;
        String interceptorListString = config.get("clientInterceptors");
        if (interceptorListString != null && !(items = Arrays.asList(interceptorListString.split("\\s*,\\s*"))).isEmpty()) {
            for (String className : items) {
                try {
                    ClientInterceptor interceptor = (ClientInterceptor)GrpcManagedObjectProvider.createObjectFromClassName((String)className);
                    if (interceptor == null) continue;
                    builder.intercept(new ClientInterceptor[]{interceptor});
                }
                catch (ManagedObjectException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    Tr.warning((TraceComponent)tc, (String)"invalid.clientinterceptor", (Object[])new Object[]{e.getMessage()});
                }
            }
        }
    }

    private ClientInterceptor createMonitoringClientInterceptor() {
        return GrpcClientComponent.getMonitoringClientInterceptor();
    }
}

