/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal.client.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class GrpcClientConfigHolder {
    private static final TraceComponent tc = Tr.register(GrpcClientConfigHolder.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.client.resources.grpcclientmessages");
    private static volatile Map<String, Map<String, String>> configInfo = new TreeMap<String, Map<String, String>>();
    private static volatile Map<String, String> hostMap = new HashMap<String, String>();
    private static volatile Map<String, Map<String, String>> resolvedConfigInfoCacheByHost = new HashMap<String, Map<String, String>>();
    private static volatile Map<String, Map<String, String>> resolvedConfigInfoCacheByPath = new HashMap<String, Map<String, String>>();

    public static synchronized void addConfig(String id, String host, Map<String, String> params) {
        hostMap.put(id, host);
        configInfo.put(host, params);
        resolvedConfigInfoCacheByHost.clear();
        resolvedConfigInfoCacheByPath.clear();
    }

    public static synchronized void removeConfig(String objectId) {
        String host = hostMap.get(objectId);
        if (host != null) {
            configInfo.remove(host);
        }
        hostMap.remove(objectId);
        resolvedConfigInfoCacheByHost.clear();
        resolvedConfigInfoCacheByPath.clear();
    }

    public static String getHeaderPropagationSupport(String host, String method) {
        Map<String, String> props = GrpcClientConfigHolder.getHostProps(host, method);
        if (props != null) {
            return props.get("headersToPropagate");
        }
        return null;
    }

    public static String getSSLConfig(String host) {
        Map<String, String> props = GrpcClientConfigHolder.getHostProps(host);
        if (props != null) {
            return props.get("sslRef");
        }
        return null;
    }

    public static String getKeepAliveWithoutCalls(String host) {
        Map<String, String> props = GrpcClientConfigHolder.getHostProps(host);
        if (props != null) {
            return props.get("keepAliveWithoutCalls");
        }
        return null;
    }

    public static String getKeepAliveTime(String host) {
        Map<String, String> props = GrpcClientConfigHolder.getHostProps(host);
        if (props != null) {
            return props.get("keepAliveTime");
        }
        return null;
    }

    public static String getKeepAliveTimeout(String host) {
        Map<String, String> props = GrpcClientConfigHolder.getHostProps(host);
        if (props != null) {
            return props.get("keepAliveTimeout");
        }
        return null;
    }

    public static String getClientInterceptors(String host) {
        Map<String, String> props = GrpcClientConfigHolder.getHostProps(host);
        if (props != null) {
            return props.get("clientInterceptors");
        }
        return null;
    }

    public static String getMaxInboundMessageSize(String host) {
        Map<String, String> props = GrpcClientConfigHolder.getHostProps(host);
        if (props != null) {
            return props.get("maxInboundMessageSize");
        }
        return null;
    }

    public static String getMaxInboundMetadataSize(String host) {
        Map<String, String> props = GrpcClientConfigHolder.getHostProps(host);
        if (props != null) {
            return props.get("maxInboundMetadataSize");
        }
        return null;
    }

    public static String getOverrideAuthority(String host) {
        Map<String, String> props = GrpcClientConfigHolder.getHostProps(host);
        if (props != null) {
            return props.get("overrideAuthority");
        }
        return null;
    }

    public static String getUserAgent(String host) {
        Map<String, String> props = GrpcClientConfigHolder.getHostProps(host);
        if (props != null) {
            return props.get("userAgent");
        }
        return null;
    }

    public static Map<String, String> getHostProps(String host) {
        return GrpcClientConfigHolder.getHostProps(host, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getHostProps(String host, String path) {
        Map<String, String> props;
        Map<String, Map<String, String>> map;
        boolean debug = tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled();
        String fullPath = GrpcClientConfigHolder.getPathID(host, path);
        if (configInfo.isEmpty()) {
            if (debug) {
                Tr.debug((TraceComponent)tc, (String)"getHostProps is empty, return null", (Object[])new Object[0]);
            }
            return null;
        }
        if (path == null) {
            map = resolvedConfigInfoCacheByHost;
            synchronized (map) {
                props = resolvedConfigInfoCacheByHost.get(host);
                if (props != null) {
                    if (debug) {
                        Tr.debug((TraceComponent)tc, (String)("resolvedConfigInfoCacheByHost cache hit, host: " + host + " path " + path + " props: " + props), (Object[])new Object[0]);
                    }
                    return props.isEmpty() ? null : props;
                }
            }
        }
        map = resolvedConfigInfoCacheByPath;
        synchronized (map) {
            props = resolvedConfigInfoCacheByPath.get(fullPath);
            if (props != null) {
                if (debug) {
                    Tr.debug((TraceComponent)tc, (String)("resolvedConfigInfoCacheByPath cache hit, host: " + host + " path " + path + " props: " + props), (Object[])new Object[0]);
                }
                return props.isEmpty() ? null : props;
            }
        }
        HashMap<String, String> mergedProps = new HashMap<String, String>();
        if (debug) {
            Tr.debug((TraceComponent)tc, (String)"begin wildcard search", (Object[])new Object[0]);
        }
        Class<GrpcClientConfigHolder> clazz = GrpcClientConfigHolder.class;
        synchronized (GrpcClientConfigHolder.class) {
            Iterator<String> it = configInfo.keySet().iterator();
            String trimmedKey = null;
            while (it.hasNext()) {
                String key = it.next();
                String hostFromKey = key.substring(0, key.indexOf("$"));
                trimmedKey = hostFromKey.startsWith("*") ? hostFromKey.substring(1, hostFromKey.length()) : hostFromKey;
                Map<String, String> props2 = configInfo.get(key);
                if (!host.endsWith(trimmedKey) || !GrpcClientConfigHolder.pathMatches(path, props2.get("path"))) continue;
                if (debug) {
                    Tr.debug((TraceComponent)tc, (String)("getHostProps match = " + hostFromKey + ", will merge these props: " + props2), (Object[])new Object[0]);
                }
                mergedProps.putAll(props2);
            }
            if (path == null) {
                resolvedConfigInfoCacheByHost.put(host, mergedProps);
            } else {
                resolvedConfigInfoCacheByPath.put(fullPath, mergedProps);
            }
            if (debug) {
                Tr.debug((TraceComponent)tc, (String)("getHostProps final result for host: " + host + " path " + path + " values: " + mergedProps), (Object[])new Object[0]);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return mergedProps.isEmpty() ? null : mergedProps;
        }
    }

    private static boolean pathMatches(String path, String configPath) {
        if (tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("pathMatches checking path " + path + " against config path " + configPath), (Object[])new Object[0]);
        }
        if (path == null || configPath == null) {
            return true;
        }
        int wildcardPosition = configPath.indexOf("*");
        if (wildcardPosition == 0) {
            return true;
        }
        if (wildcardPosition == -1) {
            return path.equals(configPath);
        }
        String trimmedConfigPath = configPath.substring(0, wildcardPosition);
        return path.startsWith(trimmedConfigPath);
    }

    protected static String getPathID(String host, String path) {
        if (path == null) {
            return host + "$";
        }
        return host + "$" + path;
    }
}

