/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl;

import io.smallrye.graphql.client.typesafe.api.GraphQlClientException;
import io.smallrye.graphql.client.typesafe.impl.HeaderBuilder;
import io.smallrye.graphql.client.typesafe.impl.RequestBuilder;
import io.smallrye.graphql.client.typesafe.impl.json.JsonReader;
import io.smallrye.graphql.client.typesafe.impl.reflection.FieldInfo;
import io.smallrye.graphql.client.typesafe.impl.reflection.MethodInfo;
import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReaderFactory;
import javax.json.JsonValue;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GraphQlClientProxy {
    private static final Logger log = LoggerFactory.getLogger(GraphQlClientProxy.class);
    private static final JsonBuilderFactory jsonObjectFactory = Json.createBuilderFactory(null);
    private static final JsonReaderFactory jsonReaderFactory = Json.createReaderFactory(null);
    private final WebTarget target;
    private final Stack<String> typeStack = new Stack();

    GraphQlClientProxy(WebTarget target) {
        this.target = target;
    }

    Object invoke(Class<?> api, MethodInfo method) {
        MultivaluedMap<String, Object> headers = new HeaderBuilder(api, method).build();
        String request = this.request(method);
        log.info("request graphql: {}", (Object)request);
        String response = this.post(request, headers);
        log.info("response graphql: {}", (Object)response);
        return this.fromJson(method, request, response);
    }

    private String request(MethodInfo method) {
        JsonObjectBuilder request = jsonObjectFactory.createObjectBuilder();
        request.add("query", this.operation(method) + " { " + new RequestBuilder(method).build() + this.fields(method.getReturnType()) + " }");
        return request.build().toString();
    }

    private String operation(MethodInfo method) {
        return method.isQuery() ? "query" : "mutation";
    }

    private String fields(TypeInfo type) {
        if (this.typeStack.contains(type.getTypeName())) {
            throw new GraphQlClientException("field recursion found");
        }
        try {
            this.typeStack.push(type.getTypeName());
            String string = this.recursionCheckedFields(type);
            return string;
        }
        finally {
            this.typeStack.pop();
        }
    }

    private String recursionCheckedFields(TypeInfo type) {
        while (type.isOptional()) {
            type = type.getItemType();
        }
        if (type.isScalar()) {
            return "";
        }
        if (type.isCollection()) {
            return this.fields(type.getItemType());
        }
        return type.fields().map(this::field).collect(Collectors.joining(" ", " {", "}"));
    }

    private String field(FieldInfo field) {
        TypeInfo type = field.getType();
        if (type.isScalar() || type.isCollection() && type.getItemType().isScalar()) {
            return field.getName();
        }
        return field.getName() + this.fields(type);
    }

    private String post(String request, MultivaluedMap<String, Object> headers) {
        Response response = this.target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).headers(headers).post(Entity.json((Object)request));
        Response.StatusType status = response.getStatusInfo();
        if (status.getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw new GraphQlClientException("expected successful status code but got " + status.getStatusCode() + " " + status.getReasonPhrase() + ":\n" + (String)response.readEntity(String.class));
        }
        return (String)response.readEntity(String.class);
    }

    private Object fromJson(MethodInfo method, String request, String response) {
        JsonObject responseJson = this.readResponse(request, response);
        JsonValue value = this.getData(method, responseJson);
        return JsonReader.readFrom(method, value);
    }

    private JsonObject readResponse(String request, String response) {
        JsonObject responseJson = jsonReaderFactory.createReader((Reader)new StringReader(response)).readObject();
        if (responseJson.containsKey((Object)"errors") && !responseJson.isNull("errors")) {
            throw new GraphQlClientException("errors from service: " + responseJson.getJsonArray("errors") + ":\n  " + request);
        }
        return responseJson;
    }

    private JsonValue getData(MethodInfo method, JsonObject responseJson) {
        JsonObject data = responseJson.getJsonObject("data");
        if (!data.containsKey((Object)method.getName())) {
            throw new GraphQlClientException("no data for '" + method.getName() + "':\n  " + data);
        }
        return (JsonValue)data.get((Object)method.getName());
    }
}

