/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl.json;

import io.smallrye.graphql.client.typesafe.api.GraphQlClientException;
import io.smallrye.graphql.client.typesafe.impl.json.JsonArrayReader;
import io.smallrye.graphql.client.typesafe.impl.json.JsonBooleanReader;
import io.smallrye.graphql.client.typesafe.impl.json.JsonNullReader;
import io.smallrye.graphql.client.typesafe.impl.json.JsonNumberReader;
import io.smallrye.graphql.client.typesafe.impl.json.JsonObjectReader;
import io.smallrye.graphql.client.typesafe.impl.json.JsonStringReader;
import io.smallrye.graphql.client.typesafe.impl.json.Location;
import io.smallrye.graphql.client.typesafe.impl.json.Reader;
import io.smallrye.graphql.client.typesafe.impl.reflection.MethodInfo;
import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import java.util.Optional;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

public class JsonReader
extends Reader<JsonValue> {
    public static Object readFrom(MethodInfo method, JsonValue value) {
        TypeInfo type = method.getReturnType();
        return JsonReader.readJson(new Location(type, method.toString()), type, value);
    }

    static Object readJson(Location location, TypeInfo type, JsonValue value) {
        return new JsonReader(type, location, value).read();
    }

    JsonReader(TypeInfo type, Location location, JsonValue value) {
        super(type, location, value);
    }

    @Override
    Object read() {
        if (this.type.isOptional()) {
            return Optional.ofNullable(JsonReader.readJson(this.location, this.type.getItemType(), this.value));
        }
        return this.reader(this.location).read();
    }

    private Reader<?> reader(Location location) {
        switch (this.value.getValueType()) {
            case ARRAY: {
                return new JsonArrayReader(this.type, location, (JsonArray)this.value);
            }
            case OBJECT: {
                return new JsonObjectReader(this.type, location, (JsonObject)this.value);
            }
            case STRING: {
                return new JsonStringReader(this.type, location, (JsonString)this.value);
            }
            case NUMBER: {
                return new JsonNumberReader(this.type, location, (JsonNumber)this.value);
            }
            case TRUE: 
            case FALSE: {
                return new JsonBooleanReader(this.type, location, this.value);
            }
            case NULL: {
                return new JsonNullReader(this.type, location, this.value);
            }
        }
        throw new GraphQlClientException("unreachable code");
    }
}

