/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl.reflection;

import io.smallrye.graphql.client.typesafe.api.GraphQlClientException;
import io.smallrye.graphql.client.typesafe.impl.CollectionUtils;
import io.smallrye.graphql.client.typesafe.impl.reflection.ParameterInfo;
import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.enterprise.inject.Stereotype;
import org.eclipse.microprofile.graphql.Mutation;
import org.eclipse.microprofile.graphql.Query;

public class MethodInfo {
    private final TypeInfo type;
    private final Method method;
    private final Object[] parameterValues;

    public static MethodInfo of(Method method, Object ... args) {
        return new MethodInfo(new TypeInfo(null, method.getDeclaringClass()), method, args);
    }

    private MethodInfo(TypeInfo type, Method method, Object[] parameterValues) {
        this.type = type;
        this.method = method;
        this.parameterValues = parameterValues;
    }

    public String toString() {
        return this.type + "#" + this.method.getName();
    }

    public boolean isQuery() {
        return !this.ifAnnotated(Mutation.class).isPresent();
    }

    public String getName() {
        return this.queryName().orElseGet(() -> this.mutationName().orElseGet(this::methodName));
    }

    private Optional<String> queryName() {
        return this.ifAnnotated(Query.class).map(Query::value).filter(CollectionUtils::nonEmpty);
    }

    private Optional<String> mutationName() {
        return this.ifAnnotated(Mutation.class).map(Mutation::value).filter(CollectionUtils::nonEmpty);
    }

    private String methodName() {
        String name = this.method.getName();
        if (name.startsWith("get") && name.length() > 3 && Character.isUpperCase(name.charAt(3))) {
            return Character.toLowerCase(name.charAt(3)) + name.substring(4);
        }
        return name;
    }

    private <T extends Annotation> Optional<T> ifAnnotated(Class<T> type) {
        return Optional.ofNullable(this.method.getAnnotation(type));
    }

    public TypeInfo getReturnType() {
        return new TypeInfo(this.type, this.method.getGenericReturnType(), this.returnTypeAnnotations());
    }

    private AnnotatedType[] returnTypeAnnotations() {
        if (this.method.getAnnotatedReturnType() instanceof AnnotatedParameterizedType) {
            return ((AnnotatedParameterizedType)this.method.getAnnotatedReturnType()).getAnnotatedActualTypeArguments();
        }
        return new AnnotatedType[0];
    }

    public Stream<ParameterInfo> parameters() {
        Parameter[] parameters = this.method.getParameters();
        assert (parameters.length == (this.parameterValues == null ? 0 : this.parameterValues.length));
        ArrayList<ParameterInfo> list = new ArrayList<ParameterInfo>();
        for (int i = 0; i < parameters.length; ++i) {
            list.add(new ParameterInfo(this, parameters[i], new TypeInfo(null, this.method.getGenericParameterTypes()[i]), this.parameterValues[i]));
        }
        return list.stream();
    }

    public TypeInfo getDeclaringType() {
        return this.type;
    }

    public <A extends Annotation> Stream<A> getResolvedAnnotations(Class<?> declaring, Class<A> type) {
        return Stream.concat(MethodInfo.resolveAnnotations(this.method, type), this.resolveInheritedAnnotations(declaring, type)).filter(Objects::nonNull);
    }

    private <A extends Annotation> Stream<A> resolveInheritedAnnotations(Class<?> declaring, Class<A> type) {
        Stream<A> stream = MethodInfo.resolveAnnotations(declaring, type);
        for (Class<?> i : declaring.getInterfaces()) {
            stream = Stream.concat(stream, this.resolveInheritedAnnotations(i, type));
        }
        return stream;
    }

    private static <A extends Annotation> Stream<A> resolveAnnotations(AnnotatedElement annotatedElement, Class<A> type) {
        return Stream.concat(Stream.of(annotatedElement.getAnnotationsByType(type)), MethodInfo.resolveStereotypes(annotatedElement.getAnnotations(), type));
    }

    private static <A extends Annotation> Stream<A> resolveStereotypes(Annotation[] annotations, Class<A> type) {
        return Stream.of(annotations).map(Annotation::annotationType).filter(annotation -> annotation.isAnnotationPresent(Stereotype.class)).flatMap(a -> MethodInfo.resolveAnnotations(a, type));
    }

    public Object invoke(Object instance, Object ... args) {
        try {
            if (System.getSecurityManager() == null) {
                this.method.setAccessible(true);
            } else {
                AccessController.doPrivileged(() -> {
                    this.method.setAccessible(true);
                    return null;
                });
            }
            return this.method.invoke(instance, args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw new GraphQlClientException("can't invoke " + this, e);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("expected to be unreachable", e);
        }
    }

    public boolean isStatic() {
        return this.is(Modifier::isStatic);
    }

    public boolean isPublic() {
        return this.is(Modifier::isPublic);
    }

    public boolean isPackagePrivate() {
        return !this.isPrivate() && !this.isProtected() && !this.isPublic();
    }

    public boolean isProtected() {
        return this.is(Modifier::isProtected);
    }

    public boolean isPrivate() {
        return this.is(Modifier::isPrivate);
    }

    private boolean is(Function<Integer, Boolean> f) {
        return f.apply(this.method.getModifiers());
    }

    public boolean isAccessibleFrom(TypeInfo caller) {
        return this.isPublic() || this.isPackagePrivate() && this.type.getPackage().equals(caller.getPackage()) || (this.isPrivate() || this.isProtected()) && caller.isNestedIn(this.getDeclaringType());
    }
}

