/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl.reflection;

import io.smallrye.graphql.client.typesafe.api.GraphQlClientException;
import io.smallrye.graphql.client.typesafe.impl.reflection.MethodInfo;
import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import org.eclipse.microprofile.graphql.Name;

public class ParameterInfo {
    private final MethodInfo method;
    private final Parameter parameter;
    private final TypeInfo type;
    private final Object value;

    public ParameterInfo(MethodInfo method, Parameter parameter, TypeInfo type, Object value) {
        this.method = method;
        this.parameter = parameter;
        this.type = type;
        this.value = value;
    }

    public String toString() {
        return "parameter '" + this.parameter.getName() + "' in " + this.method;
    }

    public TypeInfo getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public String getName() {
        if (this.parameter.isAnnotationPresent(Name.class)) {
            return this.parameter.getAnnotation(Name.class).value();
        }
        if (!this.parameter.isNamePresent()) {
            throw new GraphQlClientException("compile with -parameters to add the parameter names to the class file");
        }
        return this.parameter.getName();
    }

    public <A extends Annotation> A[] getAnnotations(Class<A> type) {
        return this.parameter.getAnnotationsByType(type);
    }

    public boolean isAnnotated(Class<? extends Annotation> annotationClass) {
        return this.parameter.getAnnotationsByType(annotationClass).length > 0;
    }
}

