/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.GraphQLContext;
import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherResult;
import graphql.execution.ExecutionPath;
import graphql.language.SourceLocation;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.bootstrap.Config;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.datafetcher.helper.ArgumentHelper;
import io.smallrye.graphql.execution.datafetcher.helper.FieldHelper;
import io.smallrye.graphql.execution.datafetcher.helper.ReflectionHelper;
import io.smallrye.graphql.execution.error.GraphQLExceptionWhileDataFetching;
import io.smallrye.graphql.execution.event.EventEmitter;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.graphql.GraphQLException;

public class ReflectionDataFetcher<T>
implements DataFetcher<T> {
    private final Operation operation;
    private final FieldHelper fieldHelper;
    private final ReflectionHelper reflectionHelper;
    private final ArgumentHelper argumentHelper;
    private final EventEmitter eventEmitter;

    public ReflectionDataFetcher(Operation operation, Config config) {
        this.operation = operation;
        this.eventEmitter = new EventEmitter(config);
        this.fieldHelper = new FieldHelper(operation);
        this.reflectionHelper = new ReflectionHelper(operation, this.eventEmitter);
        this.argumentHelper = new ArgumentHelper(operation.getArguments());
    }

    public T get(DataFetchingEnvironment dfe) throws Exception {
        SmallRyeContext.setDataFromFetcher(dfe, this.operation);
        GraphQLContext context = (GraphQLContext)dfe.getContext();
        DataFetcherResult.Builder resultBuilder = DataFetcherResult.newResult().localContext((Object)context);
        this.eventEmitter.fireBeforeDataFetch();
        if (this.operation.isAsync()) {
            return (T)this.getAsync(dfe, (DataFetcherResult.Builder<Object>)resultBuilder);
        }
        return (T)this.getSync(dfe, (DataFetcherResult.Builder<Object>)resultBuilder);
    }

    private DataFetcherResult<Object> getSync(DataFetchingEnvironment dfe, DataFetcherResult.Builder<Object> resultBuilder) throws Exception {
        try {
            Object[] transformedArguments = this.argumentHelper.getArguments(dfe);
            Object resultFromMethodCall = this.reflectionHelper.invoke(transformedArguments);
            Object resultFromTransform = this.fieldHelper.transformResponse(resultFromMethodCall);
            resultBuilder.data(resultFromTransform);
        }
        catch (AbstractDataFetcherException abstractDataFetcherException) {
            abstractDataFetcherException.appendDataFetcherResult(resultBuilder, dfe);
            this.eventEmitter.fireOnDataFetchError(dfe.getExecutionId().toString(), abstractDataFetcherException);
        }
        catch (GraphQLException graphQLException) {
            this.appendPartialResult(resultBuilder, dfe, graphQLException);
            this.eventEmitter.fireOnDataFetchError(dfe.getExecutionId().toString(), graphQLException);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
            this.eventEmitter.fireOnDataFetchError(dfe.getExecutionId().toString(), ex);
            throw ex;
        }
        finally {
            this.eventEmitter.fireAfterDataFetch();
        }
        return resultBuilder.build();
    }

    private CompletionStage<DataFetcherResult<Object>> getAsync(DataFetchingEnvironment dfe, DataFetcherResult.Builder<Object> resultBuilder) throws Exception {
        try {
            Object[] transformedArguments = this.argumentHelper.getArguments(dfe);
            CompletionStage futureResultFromMethodCall = (CompletionStage)this.reflectionHelper.invoke(transformedArguments);
            CompletionStage<DataFetcherResult<Object>> completionStage = futureResultFromMethodCall.handle((result, throwable) -> {
                if (throwable instanceof CompletionException) {
                    throwable = throwable.getCause();
                }
                if (throwable != null) {
                    this.eventEmitter.fireOnDataFetchError(dfe.getExecutionId().toString(), (Throwable)throwable);
                    if (throwable instanceof GraphQLException) {
                        GraphQLException graphQLException = (GraphQLException)((Object)throwable);
                        this.appendPartialResult(resultBuilder, dfe, graphQLException);
                    } else {
                        if (throwable instanceof Exception) {
                            throw SmallRyeGraphQLServerMessages.msg.dataFetcherException(this.operation, (Throwable)throwable);
                        }
                        if (throwable instanceof Error) {
                            throw (Error)throwable;
                        }
                    }
                } else {
                    try {
                        resultBuilder.data(this.fieldHelper.transformResponse(result));
                    }
                    catch (AbstractDataFetcherException te) {
                        te.appendDataFetcherResult(resultBuilder, dfe);
                    }
                }
                return resultBuilder.build();
            });
            return completionStage;
        }
        catch (AbstractDataFetcherException abstractDataFetcherException) {
            abstractDataFetcherException.appendDataFetcherResult(resultBuilder, dfe);
            this.eventEmitter.fireOnDataFetchError(dfe.getExecutionId().toString(), abstractDataFetcherException);
        }
        catch (GraphQLException graphQLException) {
            this.appendPartialResult(resultBuilder, dfe, graphQLException);
            this.eventEmitter.fireOnDataFetchError(dfe.getExecutionId().toString(), graphQLException);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
            this.eventEmitter.fireOnDataFetchError(dfe.getExecutionId().toString(), ex);
            throw ex;
        }
        finally {
            this.eventEmitter.fireAfterDataFetch();
        }
        return CompletableFuture.completedFuture(resultBuilder.build());
    }

    private DataFetcherResult.Builder<Object> appendPartialResult(DataFetcherResult.Builder<Object> resultBuilder, DataFetchingEnvironment dfe, GraphQLException graphQLException) {
        DataFetcherExceptionHandlerParameters handlerParameters = DataFetcherExceptionHandlerParameters.newExceptionParameters().dataFetchingEnvironment(dfe).exception((Throwable)graphQLException).build();
        SourceLocation sourceLocation = handlerParameters.getSourceLocation();
        ExecutionPath path = handlerParameters.getPath();
        GraphQLExceptionWhileDataFetching error = new GraphQLExceptionWhileDataFetching(path, graphQLException, sourceLocation);
        return resultBuilder.data(graphQLException.getPartialResults()).error((GraphQLError)error);
    }
}

