/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.validation.OASValidationResult;
import io.openliberty.microprofile.openapi20.validation.TypeValidator;
import io.openliberty.microprofile.openapi20.validation.ValidationHelper;
import io.openliberty.microprofile.openapi20.validation.ValidatorUtils;
import org.eclipse.microprofile.openapi.models.info.Info;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class InfoValidator
extends TypeValidator<Info> {
    private static final TraceComponent tc = Tr.register(InfoValidator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static final InfoValidator INSTANCE = new InfoValidator();
    static final long serialVersionUID = 1886991906404472099L;

    public static InfoValidator getInstance() {
        return INSTANCE;
    }

    private InfoValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Info t) {
        if (t != null) {
            ValidatorUtils.validateRequiredField(t.getVersion(), context, "version").ifPresent(helper::addValidationEvent);
            ValidatorUtils.validateRequiredField(t.getTitle(), context, "title").ifPresent(helper::addValidationEvent);
            if (t.getTermsOfService() != null && !ValidatorUtils.isValidURI(t.getTermsOfService())) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"infoTermsOfServiceInvalidURL", (Object[])new Object[]{t.getTermsOfService()});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("termsOfService"), message));
            }
        }
    }
}

