/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.address;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Host {
    private static final LogMgr c_logger = Log.get(Host.class);
    public static final int HOST_NAME = 1;
    public static final int IPV4ADDRESS = 2;
    String m_hostname;
    int m_addressType;
    InetAddress m_inetAddress;

    public Host() {
        this.m_addressType = 1;
    }

    public Host(String hostName) throws IllegalArgumentException {
        if (hostName == null) {
            throw new IllegalArgumentException("null host name");
        }
        this.m_hostname = hostName.trim().toLowerCase();
        this.m_addressType = 2;
    }

    public Host(String name, int addrType) {
        this.m_addressType = addrType;
        this.m_hostname = name.trim().toLowerCase();
    }

    public String encode() {
        return this.m_hostname;
    }

    public int hashCode() {
        int result = 1;
        result = 37 * result + this.m_hostname.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Host)) {
            return false;
        }
        Host other = (Host)obj;
        return other.m_hostname.equals(this.m_hostname);
    }

    public String getHostname() {
        return this.m_hostname;
    }

    public String getAddress() {
        return this.m_hostname;
    }

    public String getIpAddress() {
        String rawIpAddress = null;
        if (this.m_hostname == null) {
            return null;
        }
        if (this.m_addressType == 1) {
            try {
                if (this.m_inetAddress == null) {
                    this.m_inetAddress = InetAddress.getByName(this.m_hostname);
                }
                rawIpAddress = this.m_inetAddress.getHostAddress();
            }
            catch (UnknownHostException ex) {
                if (c_logger.isErrorEnabled()) {
                    c_logger.error("error.unknown.host.exception", "Connect", null, (Throwable)ex);
                }
            }
        } else {
            rawIpAddress = this.m_hostname;
        }
        return rawIpAddress;
    }

    public void setHostName(String name) {
        this.m_inetAddress = null;
        this.m_addressType = 1;
        if (name != null) {
            this.m_hostname = name.trim().toLowerCase();
        }
    }

    public void setAddress(String address) {
        this.m_inetAddress = null;
        this.m_addressType = 2;
        if (address != null) {
            this.m_hostname = address.trim();
        }
    }

    public boolean isHostname() {
        return this.m_addressType == 1;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        if (this.m_hostname == null) {
            return null;
        }
        if (this.m_inetAddress != null) {
            return this.m_inetAddress;
        }
        this.m_inetAddress = InetAddress.getByName(this.m_hostname);
        return this.m_inetAddress;
    }

    public String toString() {
        return this.encode();
    }
}

