/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.address;

import com.ibm.ws.jain.protocol.ip.sip.address.URIImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ParametersImpl;
import com.ibm.ws.sip.parser.Coder;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import com.ibm.ws.sip.parser.util.CharsBuffersPool;
import jain.protocol.ip.sip.SipException;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.SipURL;
import java.net.InetAddress;
import java.util.Iterator;

public class SipURLImpl
extends URIImpl
implements SipURL {
    private static final long serialVersionUID = 4194354724484789196L;
    public static final String USER = "user";
    public static final String SIP = "sip";
    public static final String TRANSPORT = "transport";
    public static final String METHOD = "method";
    public static final String TTL = "ttl";
    public static final String MADDR = "maddr";
    String m_host;
    int m_port = -1;
    String m_userName;
    String m_userPassword;
    String m_userType;
    String m_isdnSubAddress;
    String m_postDial;
    boolean m_isGlobal;
    private ParametersImpl m_headers;
    private ParametersImpl m_params;

    public SipURLImpl() {
        super(SIP);
    }

    @Override
    public void setIsdnSubAddress(String isdnSubAddress) throws IllegalArgumentException, SipException, SipParseException {
        if (isdnSubAddress == null) {
            throw new IllegalArgumentException("SipUrl: null isdnSubAddress");
        }
        if (!this.m_userType.equals("ip") && !this.m_userType.equals("phone")) {
            throw new SipException("SipUrl : user type is not USER_TYPE_PHONE");
        }
        this.m_isdnSubAddress = isdnSubAddress;
    }

    @Override
    public String getIsdnSubAddress() {
        return this.m_isdnSubAddress;
    }

    @Override
    public boolean hasIsdnSubAddress() {
        return this.m_isdnSubAddress != null;
    }

    @Override
    public void removeIsdnSubAddress() {
        this.m_isdnSubAddress = null;
    }

    @Override
    public String getPostDial() {
        return this.m_postDial;
    }

    @Override
    public boolean hasPostDial() {
        return this.m_postDial != null;
    }

    @Override
    public void setPostDial(String postDial) throws IllegalArgumentException, SipException, SipParseException {
        if (postDial == null) {
            throw new IllegalArgumentException("SipUrl: null postDial");
        }
        if (!this.m_userType.equals("phone")) {
            throw new SipException("SipUrl: user type is not USER_TYPE_PHONE");
        }
        this.m_postDial = postDial;
    }

    @Override
    public void removePostDial() {
        this.m_postDial = null;
    }

    @Override
    public String getUserName() {
        return this.m_userName;
    }

    @Override
    public boolean hasUserName() {
        return this.m_userName != null;
    }

    @Override
    public void removeUserName() {
        this.m_userName = null;
    }

    @Override
    public void setUserName(String userName) throws IllegalArgumentException, SipParseException {
        if (userName == null) {
            throw new IllegalArgumentException("SipUrl: Null user name");
        }
        if (userName.length() == 0) {
            userName = null;
        }
        this.m_userName = userName;
    }

    @Override
    public String getUserPassword() {
        return this.m_userPassword;
    }

    @Override
    public boolean hasUserPassword() {
        return this.m_userPassword != null && !this.m_userPassword.equals("");
    }

    @Override
    public void removeUserPassword() {
        this.m_userPassword = null;
    }

    @Override
    public void setUserPassword(String userPassword) throws IllegalArgumentException, SipException, SipParseException {
        if (userPassword == null) {
            throw new IllegalArgumentException("SipUrl: Null password");
        }
        this.m_userPassword = userPassword;
    }

    @Override
    public String getUserType() {
        return this.m_userType;
    }

    @Override
    public boolean hasUserType() {
        return this.m_userType != null;
    }

    @Override
    public void removeUserType() {
        this.m_userType = null;
    }

    @Override
    public void setUserType(String userType) throws IllegalArgumentException, SipParseException {
        if (userType == null) {
            throw new IllegalArgumentException("SipUrl: null userType");
        }
        if (!userType.equals("ip") && !userType.equals("phone")) {
            throw new SipParseException("SipUrl: unknown user type", "");
        }
        this.m_userType = userType;
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    @Override
    public void setHost(String host) throws IllegalArgumentException, SipParseException {
        if (host == null) {
            throw new IllegalArgumentException("SipUrl: Null host");
        }
        this.m_host = host;
    }

    @Override
    public void setHost(InetAddress host) throws IllegalArgumentException, SipParseException {
        if (host == null) {
            throw new IllegalArgumentException("SipUrl: Null host");
        }
        this.m_host = host.getHostName();
    }

    @Override
    public int getPort() {
        return this.m_port;
    }

    @Override
    public boolean hasPort() {
        return this.m_port != -1;
    }

    @Override
    public void removePort() {
        this.m_port = -1;
    }

    @Override
    public void setPort(int port) throws SipParseException {
        if (port < 0) {
            throw new SipParseException("SipUrl: Negative port");
        }
        this.m_port = port;
    }

    @Override
    public int getTTL() {
        if (this.hasTTL()) {
            return Integer.parseInt(this.getParameter(TTL));
        }
        return -1;
    }

    @Override
    public boolean hasTTL() {
        return this.getParameter(TTL) != null;
    }

    @Override
    public void removeTTL() {
        this.removeParameter(TTL);
    }

    @Override
    public void setTTL(int ttl) throws SipParseException {
        this.setParameter(TTL, String.valueOf(ttl));
    }

    @Override
    public String getTransport() {
        return this.getParameter(TRANSPORT);
    }

    @Override
    public boolean hasTransport() {
        return this.getParameter(TRANSPORT) != null;
    }

    @Override
    public void removeTransport() {
        this.removeParameter(TRANSPORT);
    }

    @Override
    public void setTransport(String transport) throws IllegalArgumentException, SipParseException {
        if (transport == null || transport.length() == 0) {
            throw new IllegalArgumentException("SipUrl: null or empty transport");
        }
        this.setParameter(TRANSPORT, transport);
    }

    @Override
    public String getMethod() {
        return this.getParameter(METHOD);
    }

    @Override
    public boolean hasMethod() {
        return this.getParameter(METHOD) != null;
    }

    @Override
    public void removeMethod() {
        this.removeParameter(METHOD);
    }

    @Override
    public void setMethod(String method) throws IllegalArgumentException, SipParseException {
        if (method == null) {
            throw new IllegalArgumentException("SipUrl: null method");
        }
        this.setParameter(METHOD, method);
    }

    @Override
    public String getMAddr() {
        return this.getParameter(MADDR);
    }

    @Override
    public boolean hasMAddr() {
        return this.getParameter(MADDR) != null;
    }

    @Override
    public void removeMAddr() {
        this.removeParameter(MADDR);
    }

    @Override
    public void setMAddr(String mAddr) throws IllegalArgumentException, SipParseException {
        if (mAddr == null) {
            throw new IllegalArgumentException("SipUrl: null mAddr");
        }
        this.setParameter(MADDR, mAddr);
    }

    @Override
    public void setMAddr(InetAddress mAddr) throws IllegalArgumentException, SipParseException {
        if (mAddr == null) {
            throw new IllegalArgumentException("SipUrl: null mAddr");
        }
        this.setParameter(MADDR, mAddr.getHostName());
    }

    @Override
    public boolean isGlobal() throws SipException {
        if (!this.m_userType.equals("phone")) {
            throw new SipException("SipUrl: user type not Phone");
        }
        return this.m_isGlobal;
    }

    @Override
    public void setGlobal(boolean global) throws SipException, SipParseException {
        if (!this.m_userType.equals("phone")) {
            throw new SipException("SipUrl: user type not phone");
        }
        this.m_isGlobal = global;
    }

    @Override
    public String toString() {
        CharsBuffer buffer = CharsBuffersPool.getBuffer();
        this.writeToCharBuffer(buffer);
        String value = buffer.toString();
        CharsBuffersPool.putBufferBack(buffer);
        return value;
    }

    @Override
    public void writeToCharBuffer(CharsBuffer ret) {
        boolean ipv6;
        ret.append(this.m_scheme);
        ret.append(':');
        if (this.m_isGlobal) {
            ret.append('+');
        }
        if (this.hasUserName()) {
            Coder.encodeUser(this.m_userName, ret);
            if (this.hasUserPassword()) {
                ret.append(':');
                Coder.encodePassword(this.m_userPassword, ret);
            }
            ret.append('@');
        }
        boolean bl = ipv6 = this.m_host.indexOf(58) != -1;
        if (ipv6) {
            ret.append('[');
        }
        ret.append(this.m_host);
        if (ipv6) {
            ret.append(']');
        }
        if (this.hasPort()) {
            ret.append(':');
            ret.append(this.m_port);
        }
        if (this.hasParameters()) {
            ret.append(';');
            this.m_params.encode(ret, ';', true);
        }
        if (this.hasHeaders()) {
            ret.append('?');
            this.m_headers.encode(ret, '&', true);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof SipURLImpl)) {
            return false;
        }
        SipURLImpl other = (SipURLImpl)obj;
        if (!super.equals(obj)) {
            return false;
        }
        if (!this.m_host.equalsIgnoreCase(other.m_host)) {
            return false;
        }
        if (this.m_port != other.m_port) {
            return false;
        }
        if (this.hasUserName() ? !this.m_userName.equals(other.m_userName) : other.hasUserName()) {
            return false;
        }
        if (this.hasIsdnSubAddress() ? !this.m_isdnSubAddress.equals(other.m_isdnSubAddress) : other.hasIsdnSubAddress()) {
            return false;
        }
        if (this.hasPostDial() ? !this.m_postDial.equals(other.m_postDial) : other.hasPostDial()) {
            return false;
        }
        if (this.hasUserPassword() ? !this.m_userPassword.equals(other.m_userPassword) : other.hasUserPassword()) {
            return false;
        }
        if (!SipURLImpl.areHeadersEqual(this.m_headers, other.m_headers)) {
            return false;
        }
        return SipURLImpl.areParamsEqual(this.m_params, other.m_params) && SipURLImpl.areParamsEqual(other.m_params, this.m_params);
    }

    private static boolean areHeadersEqual(ParametersImpl p1, ParametersImpl p2) {
        if (p1 == null || !p1.hasParameters()) {
            return p2 == null || !p2.hasParameters();
        }
        if (p2 == null || !p2.hasParameters() || p1.size() != p2.size()) {
            return false;
        }
        for (int i = 0; i < p1.size(); ++i) {
            ParametersImpl.Parameter param1 = p1.get(i);
            String key1 = param1.getKey();
            String val1 = param1.getValue();
            String val2 = p2.getParameter(key1);
            if (val2 == null) {
                return false;
            }
            if (val1.equalsIgnoreCase(val2)) continue;
            return false;
        }
        return true;
    }

    private static boolean areParamsEqual(ParametersImpl p1, ParametersImpl p2) {
        if (p1 == null || !p1.hasParameters()) {
            return true;
        }
        for (int i = 0; i < p1.size(); ++i) {
            String val2;
            ParametersImpl.Parameter param1 = p1.get(i);
            String key1 = param1.getKey();
            String val1 = param1.getValue();
            String string = val2 = p2 == null ? null : p2.getParameter(key1);
            if (!(val2 == null ? key1.equals(TTL) || key1.equals(MADDR) || key1.equals(METHOD) || key1.equals(TRANSPORT) || key1.equals(USER) : !val1.equalsIgnoreCase(val2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return SipURLImpl.computeHashCode(this.m_scheme, this.m_userName, this.m_userPassword, this.m_host, this.m_port, this.m_params, this.m_headers);
    }

    private static int computeHashCode(String schema, String username, String passwd, String hostname, int hostport, ParametersImpl optionalParams, ParametersImpl optionalHeaders) {
        int result = 0;
        if (schema != null) {
            result ^= schema.hashCode();
        }
        if (username != null) {
            result ^= username.hashCode();
        }
        if (passwd != null) {
            result ^= passwd.hashCode();
        }
        if (hostname != null) {
            result ^= hostname.hashCode();
        }
        result ^= hostport;
        if (optionalParams != null) {
            result ^= optionalParams.hashCode();
        }
        if (optionalHeaders != null) {
            result ^= optionalHeaders.hashCode();
        }
        return result;
    }

    @Override
    public Object clone() {
        SipURLImpl clone = (SipURLImpl)super.clone();
        if (this.m_params != null) {
            clone.m_params = (ParametersImpl)this.m_params.clone();
        }
        if (this.m_headers != null) {
            clone.m_headers = (ParametersImpl)this.m_headers.clone();
        }
        return clone;
    }

    @Override
    public Iterator getHeaders() {
        if (this.m_headers == null) {
            return null;
        }
        return this.m_headers.getParameters();
    }

    @Override
    public String getHeader(String name) throws IllegalArgumentException {
        if (this.m_headers == null) {
            return null;
        }
        return this.m_headers.getParameter(name);
    }

    @Override
    public void setHeader(String name, String value) throws IllegalArgumentException, SipParseException {
        if (this.m_headers == null) {
            this.m_headers = new ParametersImpl();
        }
        this.m_headers.setParameter(name, value);
    }

    @Override
    public boolean hasHeaders() {
        return this.m_headers != null && this.m_headers.hasParameters();
    }

    @Override
    public boolean hasHeader(String name) throws IllegalArgumentException {
        return this.m_headers != null && this.m_headers.hasParameter(name);
    }

    @Override
    public void removeHeader(String name) throws IllegalArgumentException {
        if (this.m_headers != null) {
            this.m_headers.removeParameter(name);
        }
    }

    @Override
    public void removeHeaders() {
        if (this.m_headers != null) {
            this.m_headers.removeParameters();
        }
    }

    @Override
    public String getParameter(String name) throws IllegalArgumentException {
        if (this.m_params == null) {
            return null;
        }
        return this.m_params.getParameter(name);
    }

    @Override
    public void setParameter(String name, String value) throws IllegalArgumentException, SipParseException {
        if (this.m_params == null) {
            this.m_params = new ParametersImpl();
        }
        this.m_params.setParameter(name, value);
    }

    @Override
    public boolean hasParameters() {
        return this.m_params != null && this.m_params.hasParameters();
    }

    @Override
    public boolean hasParameter(String name) throws IllegalArgumentException {
        return this.m_params != null && this.m_params.hasParameter(name);
    }

    @Override
    public void removeParameter(String name) throws IllegalArgumentException {
        if (this.m_params != null) {
            this.m_params.removeParameter(name);
        }
    }

    @Override
    public void removeParameters() {
        if (this.m_params != null) {
            this.m_params.removeParameters();
        }
    }

    @Override
    public Iterator getParameters() {
        if (this.m_params == null) {
            return null;
        }
        return this.m_params.getParameters();
    }

    public void setParameters(ParametersImpl params) {
        this.m_params = params;
    }

    public void setHeaders(ParametersImpl headers) {
        this.m_headers = headers;
    }
}

