/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.extensions;

import com.ibm.ws.jain.protocol.ip.sip.extensions.RAckHeader;
import com.ibm.ws.jain.protocol.ip.sip.extensions.RSeqHeader;
import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.header.CSeqHeader;

public class RAckHeaderImpl
extends HeaderImpl
implements RAckHeader {
    private long m_responseNumber;
    private long m_sequenceNumber;
    private String m_method;

    @Override
    public long getResponseNumber() {
        return this.m_responseNumber;
    }

    @Override
    public void setResponseNumber(long responseNumber) throws SipParseException {
        if (responseNumber < 1L || responseNumber > 0xFFFFFFFFL) {
            throw new SipParseException("Invalid response number set in RAck header");
        }
        this.m_responseNumber = responseNumber;
    }

    @Override
    public long getSequenceNumber() {
        return this.m_sequenceNumber;
    }

    @Override
    public void setSequenceNumber(long sequenceNumber) throws SipParseException {
        if (sequenceNumber < 0L || sequenceNumber > 0xFFFFFFFFL) {
            throw new SipParseException("Invalid sequence number set in RAck header");
        }
        this.m_sequenceNumber = sequenceNumber;
    }

    @Override
    public String getMethod() {
        return this.m_method;
    }

    @Override
    public void setMethod(String method) throws IllegalArgumentException, SipParseException {
        if (method == null) {
            throw new IllegalArgumentException("Null method set in RAck header");
        }
        if (method.length() == 0) {
            throw new SipParseException("Empty method set in RAck header");
        }
        this.m_method = method;
    }

    @Override
    protected void parseValue(SipParser parser) throws SipParseException {
        long responseNumber = parser.longNumber();
        if (!Character.isSpaceChar(parser.LA())) {
            throw new SipParseException("whitespace expected after response-num in RAck header");
        }
        parser.lws();
        long sequenceNumber = parser.longNumber();
        if (!Character.isSpaceChar(parser.LA())) {
            throw new SipParseException("whitespace expected after CSeq-num in RAck header");
        }
        String method = parser.nextToken('\u0000');
        this.setResponseNumber(responseNumber);
        this.setSequenceNumber(sequenceNumber);
        this.setMethod(method);
    }

    @Override
    protected void encodeValue(CharsBuffer ret) {
        ret.append(this.m_responseNumber).append(' ').append(this.m_sequenceNumber).append(' ').append(this.m_method);
    }

    @Override
    protected boolean valueEquals(HeaderImpl other) {
        if (!(other instanceof RAckHeaderImpl)) {
            return false;
        }
        RAckHeaderImpl o = (RAckHeaderImpl)other;
        return this.m_responseNumber == o.m_responseNumber && this.m_sequenceNumber == o.m_sequenceNumber && this.m_method == null ? o.m_method == null : this.m_method.equals(o.m_method);
    }

    @Override
    public String getName() {
        return "RAck";
    }

    @Override
    public boolean isNested() {
        return false;
    }

    @Override
    public boolean match(RSeqHeader rseq, CSeqHeader cseq) {
        return this.m_responseNumber == rseq.getResponseNumber() && this.m_sequenceNumber == cseq.getSequenceNumber() && this.m_method.equals(cseq.getMethod());
    }
}

