/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.ar;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.dar.DefaultApplicationRouter;
import com.ibm.ws.sip.properties.SipPropertiesMap;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.ar.SipApplicationRouter;
import javax.servlet.sip.ar.SipApplicationRouterInfo;
import javax.servlet.sip.ar.SipApplicationRoutingDirective;
import javax.servlet.sip.ar.SipApplicationRoutingRegion;
import javax.servlet.sip.ar.SipTargetedRequestInfo;
import javax.servlet.sip.ar.spi.SipApplicationRouterProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={SipApplicationRouter.class}, configurationPolicy=ConfigurationPolicy.OPTIONAL, configurationPid={"com.ibm.ws.sip.ar"}, name="com.ibm.ws.sip.ar", property={"service.vendor=IBM"})
public class SipApplicationRouterImpl
implements SipApplicationRouter {
    private static final LogMgr c_logger = Log.get(SipApplicationRouterImpl.class);
    private static SipApplicationRouter s_sipApplicationRouter = null;
    private static SipApplicationRouterProvider s_sipApplicationRouterProvider;

    protected void activate(Map<String, Object> properties) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipApplicationRouterImpl activated", properties);
        }
        SipPropertiesMap props = PropertiesStore.getInstance().getProperties();
        props.updateProperties(properties);
        this.initSipApplicationRouter();
    }

    public void deactivate(int reason) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipApplicationRouterImpl deactivated, reason=" + reason);
        }
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        if (c_logger.isWarnEnabled()) {
            c_logger.warn("warn.dar.file.modification");
        }
    }

    private void initSipApplicationRouter() {
        boolean enableCAR = PropertiesStore.getInstance().getProperties().getBoolean("enable.car");
        s_sipApplicationRouter = enableCAR && s_sipApplicationRouterProvider != null ? s_sipApplicationRouterProvider.getSipApplicationRouter() : new DefaultApplicationRouter();
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setSipApplicationRouterProvider(SipApplicationRouterProvider sarp) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("setSipApplicationRouterProvider ", sarp);
        }
        s_sipApplicationRouterProvider = sarp;
    }

    protected void unsetSipApplicationRouterProvider(SipApplicationRouterProvider sarp) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("unsetSipApplicationRouterProvider ", sarp);
        }
    }

    @Override
    public void applicationDeployed(List<String> newlyDeployedApplicationNames) {
        s_sipApplicationRouter.applicationDeployed(newlyDeployedApplicationNames);
    }

    @Override
    public void applicationUndeployed(List<String> undeployedApplicationNames) {
        s_sipApplicationRouter.applicationUndeployed(undeployedApplicationNames);
    }

    @Override
    public void destroy() {
        s_sipApplicationRouter.destroy();
    }

    @Override
    public SipApplicationRouterInfo getNextApplication(SipServletRequest initialRequest, SipApplicationRoutingRegion region, SipApplicationRoutingDirective directive, SipTargetedRequestInfo targetedRequestInfo, Serializable stateInfo) throws NullPointerException, IllegalStateException {
        return s_sipApplicationRouter.getNextApplication(initialRequest, region, directive, targetedRequestInfo, stateInfo);
    }

    @Override
    public void init() {
        s_sipApplicationRouter.init();
    }

    @Override
    public void init(Properties properties) throws IllegalStateException {
        s_sipApplicationRouter.init(properties);
    }
}

