/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.channel.resolver.impl;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.channel.resolver.dns.impl.AAAARecord;
import com.ibm.ws.sip.channel.resolver.dns.impl.ARecord;
import com.ibm.ws.sip.channel.resolver.dns.impl.Dns;
import com.ibm.ws.sip.channel.resolver.dns.impl.DnsMessage;
import com.ibm.ws.sip.channel.resolver.dns.impl.NAPTRRecord;
import com.ibm.ws.sip.channel.resolver.dns.impl.Name;
import com.ibm.ws.sip.channel.resolver.dns.impl.ResourceRecord;
import com.ibm.ws.sip.channel.resolver.dns.impl.SRVRecord;
import com.ibm.ws.sip.channel.resolver.impl.SipResolverEvent;
import com.ibm.ws.sip.channel.resolver.impl.SipResolverListener;
import com.ibm.ws.sip.channel.resolver.impl.SipResolverService;
import com.ibm.wsspi.sip.channel.resolver.SIPUri;
import com.ibm.wsspi.sip.channel.resolver.SipURILookup;
import com.ibm.wsspi.sip.channel.resolver.SipURILookupCallback;
import com.ibm.wsspi.sip.channel.resolver.SipURILookupException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class SipURILookupImpl
implements SipURILookup,
SipResolverListener {
    private static final LogMgr c_logger = Log.get(SipURILookupImpl.class);
    protected ArrayList<SIPUri> _answerList;
    protected final SIPUri _suri;
    protected String _target;
    protected int _port;
    protected String _transport;
    protected String _scheme;
    protected final SipURILookupCallback _sll;
    private Timer _timer;
    protected StateMachine _fsm;
    private static final short TARGET_NUMERIC = 0;
    private static final short TARGET_HOSTNAME = 1;
    private static final short TARGET_INVALID = 255;
    private static final short PORT_NOT_SET = 0;
    private static final short PORT_SET = 1;
    private static final short SIP_SCHEME = 0;
    private static final short SIPS_SCHEME = 1;
    private static final short TRANSPORT_NOT_SET = 0;
    private static final short TRANSPORT_SET = 1;
    private static final int DEFAULT_PORT = 5060;
    private static final int DEFAULT_SEC_PORT = 5061;
    public static final String TCP = "tcp";
    public static final String UDP = "udp";
    public static final String SCTP = "sctp";
    public static final String SIP = "sip";
    public static final String SIPS = "sips";
    private static final String IBM_TTL_PARAM = "ibmttl";
    protected RequestTimeoutTimerTask _timeoutTask = null;
    protected final Hashtable<SIPUri, SipURILookupImpl> _lookupCache;
    protected final long _cacheTimeout;
    boolean doTCP = false;
    boolean didTCPLast = false;
    private static final int MAX_CACHE_ENTRIES = 5000;
    private static long messageTimeoutValue = 31000L;
    private static boolean usePreciseSystemTimer = false;

    public static void setMessageTimeoutValue(long localMessageTimeoutValue) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("Setting Message timeout to " + localMessageTimeoutValue);
        }
        messageTimeoutValue = localMessageTimeoutValue;
    }

    public static void setUsePreciseSystemTimer(boolean tempUsePreciseSystemTimer) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("Setting usePreciseSystemTimer " + tempUsePreciseSystemTimer);
        }
        usePreciseSystemTimer = tempUsePreciseSystemTimer;
    }

    protected SipURILookupImpl(SipURILookupCallback sll, SIPUri suri, Timer timer, Hashtable<SIPUri, SipURILookupImpl> lookupCache, long cacheTimeout) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipURILookupImpl: constructor: entry: id=" + this.hashCode());
        }
        this._answerList = new ArrayList();
        this._suri = suri;
        this._sll = sll;
        this._lookupCache = lookupCache;
        this._cacheTimeout = cacheTimeout;
        this._timer = timer;
        try {
            this._fsm = new StateMachine(this);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipURILookupImpl: constructor: exit: id=" + this.hashCode());
        }
    }

    @Override
    public SIPUri getSipURI() {
        return this._suri;
    }

    @Override
    public synchronized boolean lookup() throws SipURILookupException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipURILookupImpl: lookup: entry: id=" + this.hashCode());
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("A Sip URI Lookup is being performed for " + this._suri.getBaseSIPUri());
        }
        boolean bool = false;
        if (this._fsm.currentState == 0) {
            this.validateSipURI();
            short action = this.rulesMatrix();
            if (action != 0 && action != 6) {
                this._timeoutTask = new RequestTimeoutTimerTask();
                Date currentDate = new Date();
                this._timer.schedule((TimerTask)this._timeoutTask, new Date(currentDate.getTime() + messageTimeoutValue));
            }
            this._fsm.runMachine(action, null);
            if (this._fsm.currentState == 5) {
                bool = true;
                if (this._lookupCache.size() < 5000) {
                    UriExpirationTimerTask _expirationTask = new UriExpirationTimerTask();
                    Date currentDate = new Date();
                    this._timer.schedule((TimerTask)_expirationTask, new Date(currentDate.getTime() + this._cacheTimeout));
                    this._lookupCache.put(this.getSipURI(), this);
                }
                if (this._timeoutTask != null) {
                    this._timeoutTask.cancel();
                }
            } else if (this._fsm.currentState == 6) {
                if (this._timeoutTask != null) {
                    this._timeoutTask.cancel();
                }
                bool = false;
                throw new SipURILookupException(SipURILookupException.DEFAULTMSG);
            }
        } else if (this._fsm.currentState == 5) {
            bool = true;
        } else {
            this._timeoutTask.cancel();
            throw new SipURILookupException(SipURILookupException.LOOKUP_IN_PROGRESS);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipURILookupImpl: lookup: exit: id=" + this.hashCode());
        }
        return bool;
    }

    private void validateSipURI() throws SipURILookupException {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipURILookupImpl: validateSipUri: entry: id=" + this.hashCode());
        }
        if (this._suri == null) {
            throw new SipURILookupException(SipURILookupException.SIPURI_NULL);
        }
        this._target = this._suri.getMaddr();
        if (this._target == null) {
            this._target = this._suri.getHost();
            if (this._target == null) {
                throw new SipURILookupException(SipURILookupException.TARGET_UNDEFINED);
            }
        }
        this._port = this._suri.getPortInt();
        if (this._port > 65535) {
            throw new SipURILookupException(SipURILookupException.PORT_INVALID + this._port);
        }
        this._transport = this._suri.getTransport();
        if (!(this._transport == null || this._transport.equalsIgnoreCase(TCP) || this._transport.equalsIgnoreCase(UDP) || this._transport.equalsIgnoreCase(SCTP))) {
            throw new SipURILookupException(SipURILookupException.TRANSPORT_INVALID + this._transport);
        }
        this._scheme = this._suri.getScheme();
        if (this._scheme == null) {
            throw new SipURILookupException(SipURILookupException.SCHEME_UNDEFINED);
        }
        if (!this._scheme.equalsIgnoreCase(SIP) && !this._scheme.equalsIgnoreCase(SIPS)) {
            throw new SipURILookupException(SipURILookupException.SCHEME_INVALID + this._scheme);
        }
        if (this._transport != null && this._scheme != null && (this._scheme.equals(SIP) && this._transport.equalsIgnoreCase(SCTP) || this._scheme.equals(SIPS) && this._transport.equalsIgnoreCase(UDP))) {
            throw new SipURILookupException(SipURILookupException.TRANSPORT_SCHEME_INVALID);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipURILookupImpl: validateSipUri: exit: id=" + this.hashCode());
        }
    }

    private short rulesMatrix() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipURILookupImpl: rulesMatrix: entry: id=" + this.hashCode());
        }
        short truthTableAction = 0;
        short fsmAction = 0;
        SIPUri answer = null;
        int bit3 = this.checkTarget();
        int bit2 = this.checkTransport();
        int bit1 = this.checkPort();
        int bit0 = this.checkScheme();
        if (bit3 == 255) {
            fsmAction = 6;
            this._fsm.initAction = fsmAction;
            return fsmAction;
        }
        if (bit3 == 1 && !new Character('.').equals(Character.valueOf(this._target.charAt(this._target.length() - 1)))) {
            this._target = this._target + ".";
        }
        truthTableAction = (short)(bit3 << 3 | bit2 << 2 | bit1 << 1 | bit0);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("SipURILookupImpl: rulesMatrix: truthTableAction = " + truthTableAction);
        }
        switch (truthTableAction) {
            case 0: {
                answer = SIPUri.createSIPUri(this._suri.getURI());
                answer.setScheme(this._scheme);
                answer.setHost(this._target);
                answer.setPortInt(5060);
                answer.setTransport(UDP);
                this._answerList.add(answer);
                fsmAction = 0;
                break;
            }
            case 1: {
                answer = SIPUri.createSIPUri(this._suri.getURI());
                answer.setScheme(this._scheme);
                answer.setHost(this._target);
                answer.setTransport(TCP);
                answer.setPortInt(5061);
                this._answerList.add(answer);
                fsmAction = 0;
                break;
            }
            case 2: {
                answer = SIPUri.createSIPUri(this._suri.getURI());
                answer.setScheme(this._scheme);
                answer.setHost(this._target);
                answer.setPortInt(this._port);
                answer.setTransport(UDP);
                this._answerList.add(answer);
                fsmAction = 0;
                break;
            }
            case 3: {
                answer = SIPUri.createSIPUri(this._suri.getURI());
                answer.setScheme(this._scheme);
                answer.setHost(this._target);
                answer.setPortInt(this._port);
                answer.setTransport(TCP);
                this._answerList.add(answer);
                fsmAction = 0;
                break;
            }
            case 4: {
                answer = SIPUri.createSIPUri(this._suri.getURI());
                answer.setScheme(this._scheme);
                answer.setHost(this._target);
                answer.setTransport(this._transport);
                answer.setPortInt(5060);
                this._answerList.add(answer);
                fsmAction = 0;
                break;
            }
            case 5: {
                answer = SIPUri.createSIPUri(this._suri.getURI());
                answer.setScheme(this._scheme);
                answer.setHost(this._target);
                answer.setTransport(this._transport);
                answer.setPortInt(5061);
                this._answerList.add(answer);
                fsmAction = 0;
                break;
            }
            case 6: 
            case 7: {
                answer = SIPUri.createSIPUri(this._suri.getURI());
                answer.setScheme(this._scheme);
                answer.setHost(this._target);
                answer.setPortInt(this._port);
                answer.setTransport(this._transport);
                this._answerList.add(answer);
                fsmAction = 0;
                break;
            }
            case 8: 
            case 9: {
                fsmAction = 1;
                break;
            }
            case 10: {
                this._transport = UDP;
                fsmAction = 3;
                break;
            }
            case 11: {
                this._transport = TCP;
                fsmAction = 3;
                break;
            }
            case 12: 
            case 13: {
                fsmAction = 2;
                break;
            }
            case 14: 
            case 15: {
                fsmAction = 3;
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipURILookupImpl: rulesMatrix: exit: id=" + this.hashCode());
        }
        this._fsm.initAction = fsmAction;
        return fsmAction;
    }

    private int checkTarget() {
        int result = 0;
        String[] v6split = this._target.split("\\:");
        if (v6split.length == 1) {
            String[] v4split = this._target.split("\\.");
            if (v4split.length == 4) {
                result = 0;
                for (int i = 0; i < v4split.length; ++i) {
                    try {
                        Integer.parseInt(v4split[i]);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        result = 1;
                        break;
                    }
                }
                try {
                    if (result == 0) {
                        InetAddress.getByName(this._target);
                    }
                }
                catch (Exception e2) {
                    result = 255;
                }
            } else {
                result = 1;
            }
        } else if (v6split[0].equals("") || Character.digit(v6split[0].charAt(0), 16) <= 15 || new Character('[').equals(Character.valueOf(v6split[0].charAt(0)))) {
            try {
                InetAddress.getByName(this._target);
            }
            catch (Exception e3) {
                result = 255;
            }
            result = 0;
        } else {
            result = 255;
        }
        return result;
    }

    private int checkPort() {
        int result = 0;
        result = this._port < 0 || this._port == 0 ? 0 : 1;
        return result;
    }

    private int checkScheme() {
        int result = 0;
        if (this._scheme.equalsIgnoreCase(SIP)) {
            result = 0;
        } else if (this._scheme.equalsIgnoreCase(SIPS)) {
            result = 1;
        }
        return result;
    }

    private int checkTransport() {
        int result = 0;
        result = this._transport != null && (this._transport.equalsIgnoreCase(TCP) || this._transport.equalsIgnoreCase(UDP) || this._transport.equalsIgnoreCase(SCTP)) ? 1 : 0;
        return result;
    }

    @Override
    public ArrayList<SIPUri> getAnswer() {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipURILookupImpl: getAnswer: entry: id=" + this.hashCode());
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipURILookupImpl: getAnswer: exit: id=" + this.hashCode());
        }
        return this._answerList;
    }

    @Override
    public void handleSipResolverEvent(SipResolverEvent event) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "SipURILookupImpl: handleSipResolverEvent: entry: id=" + this.hashCode());
        }
        if (event.getType() != 5) {
            this.didTCPLast = false;
        }
        switch (event.getType()) {
            case 1: 
            case 2: {
                this._fsm.handleEvent(event);
                if (this._fsm.currentState == 5) {
                    this._timeoutTask.cancel();
                    if (this._answerList.isEmpty()) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("SipURILookupImpl: handleSipResolverEvent: sll.error()");
                        }
                        this._sll.error(this, new SipURILookupException(SipURILookupException.NAMING_ERROR));
                        break;
                    }
                    int ttl = this._fsm.getTTL();
                    if (ttl > 0) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("SipURILookupImpl: handleSipResolverEvent: ttl(seconds) = " + ttl + " caching results");
                        }
                        if (this._lookupCache.size() < 5000) {
                            UriExpirationTimerTask _expirationTask = new UriExpirationTimerTask();
                            Date currentDate = new Date();
                            this._timer.schedule((TimerTask)_expirationTask, new Date(currentDate.getTime() + Math.min(this._cacheTimeout, (long)(ttl * 1000))));
                            this._lookupCache.put(this.getSipURI(), this);
                        }
                    } else if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("SipURILookupImpl: handleSipResolverEvent: ttl = 0, not caching lookup");
                    }
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("SipURILookupImpl: handleSipResolverEvent: sll.complete()");
                    }
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("SipURILookupImpl: handleSipResolverEvent: sll.complete()");
                    }
                    this._sll.complete(this);
                    break;
                }
                if (this._fsm.currentState != 6) break;
                this._timeoutTask.cancel();
                this._sll.error(this, new SipURILookupException(SipURILookupException.NAMING_ERROR));
                break;
            }
            case 4: 
            case 6: {
                this._timeoutTask.cancel();
                this._sll.error(this, new SipURILookupException(SipURILookupException.DEFAULTMSG));
                break;
            }
            case 3: {
                this._timeoutTask.cancel();
                this._fsm.reset();
                try {
                    this.lookup();
                }
                catch (SipURILookupException e2) {
                    this._sll.error(this, e2);
                }
                break;
            }
            case 5: {
                this._timeoutTask.cancel();
                this._fsm.reset();
                if (this.didTCPLast) break;
                this.didTCPLast = true;
                this.doTCP = true;
                try {
                    this.lookup();
                }
                catch (SipURILookupException e3) {
                    this._sll.error(this, e3);
                }
                break;
            }
            default: {
                this._timeoutTask.cancel();
                this._sll.error(this, new SipURILookupException(SipURILookupException.NAMING_ERROR));
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "SipURILookupImpl: handleSipResolverEvent: exit: id=" + this.hashCode());
        }
    }

    static class StateMachine {
        private int previousState = 0;
        protected int currentState = 0;
        protected int initAction = 13;
        private static final int INITIAL = 0;
        private static final int NAPTR_PEND = 1;
        private static final int SRV_PEND = 2;
        private static final int A_PEND = 3;
        private static final int AAAA_PEND = 4;
        private static final int COMPLETE = 5;
        private static final int ERROR = 6;
        private static final short FINISHED = 0;
        private static final short SEND_NAPTR_REQUEST = 1;
        private static final short SEND_SRV_REQUEST = 2;
        private static final short SEND_A_REQUEST = 3;
        private static final short SEND_AAAA_REQUEST = 4;
        private static final short NAPTR_RESP = 5;
        private static final short NAPTR_ERROR = 6;
        private static final short NOOP = 13;
        private static final String SIP_D2T = "SIP+D2T";
        private static final String SIPS_D2T = "SIPS+D2T";
        private static final String SIP_D2U = "SIP+D2U";
        private static final String SIP_D2S = "SIPS+D2S";
        private static final String[] mapper;
        private final SipURILookupImpl _simpl;
        private static final Class<StateMachine> c;
        private static final Method CHKANS;
        private static final Method CHKERR;
        private static final Method SNAPTR;
        private static final Method SSRV;
        private static final Method SA;
        private static final Method SAAAA;
        private static final Method ANSWER;
        private static final Method NONE;
        private final Vector<DnsMessage> _dnsRequests;
        private final Vector<NAPTRRecord> _NAPTRResponses;
        private Vector<SRVRecord>[] _SRVResponses;
        private final Hashtable<String, Vector> _AResponses;
        private final Hashtable<String, Vector> _AAAAResponses;
        private static final e[][] lookup_stateMachine;

        StateMachine(SipURILookupImpl simpl) throws Exception {
            this._simpl = simpl;
            this._dnsRequests = new Vector();
            this._NAPTRResponses = new Vector();
            this._SRVResponses = null;
            this._AResponses = new Hashtable();
            this._AAAAResponses = new Hashtable();
        }

        protected synchronized void runMachine(int input, DnsMessage msg) {
            block9: {
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceEntry(this, "StateMachine: runMachine: entry: id=" + this.hashCode());
                }
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("StateMachine: runMachine: before the state machine current state = " + this.currentState + " input = " + input);
                }
                e element = lookup_stateMachine[this.currentState][input];
                this.previousState = this.currentState;
                this.currentState = element.nextState;
                try {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("StateMachine: runMachine: after the state machine current action method = " + element.action.getName());
                    }
                    if (msg != null && !msg.isNameError()) {
                        Object[] arg = new Object[]{msg};
                        element.action.invoke((Object)this, arg);
                    } else {
                        element.action.invoke((Object)this, (Object[])null);
                    }
                }
                catch (Exception e2) {
                    if (!c_logger.isTraceDebugEnabled()) break block9;
                    c_logger.traceDebug("StateMachine: runMachine: state machine error " + e2);
                }
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("StateMachine: runMachine: after state machine current state = " + this.currentState);
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "StateMachine: runMachine: exit: id=" + this.hashCode());
            }
        }

        protected boolean checkSRVAdditional(DnsMessage msg) {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: checkSRVAdditional: entry: id=" + this.hashCode());
            }
            boolean bool = false;
            this.checkSRV(msg.getAdditional());
            this.checkA(msg.getAdditional());
            this.checkAAAA(msg.getAdditional());
            if (this.haveSRVResponses() && (!this._AResponses.isEmpty() || !this._AAAAResponses.isEmpty()) && this._dnsRequests.isEmpty()) {
                bool = true;
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "StateMachine: checkSRVAdditional: exit: id=" + this.hashCode());
            }
            return bool;
        }

        protected void checkAError(DnsMessage msg) {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: checkAError: entry: id=" + this.hashCode());
            }
            if (this._dnsRequests.isEmpty()) {
                this.sendAAAA();
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "StateMachine: checkAError: exit: id=" + this.hashCode());
            }
        }

        protected boolean checkA(Vector rec) {
            boolean bool = false;
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: checkA: entry: id=" + this.hashCode());
            }
            Vector<ARecord> vector1 = null;
            Vector vector2 = rec;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("StateMachine: checkAAnswer: answer size " + vector2.size());
            }
            Enumeration e2 = vector2.elements();
            while (e2.hasMoreElements()) {
                ResourceRecord rr = (ResourceRecord)e2.nextElement();
                if (rr.getType() != 1) continue;
                vector1 = this._AResponses.get(rr.getName().getString());
                if (vector1 == null) {
                    vector1 = new Vector<ARecord>();
                }
                boolean dontAdd = false;
                Enumeration e1 = vector1.elements();
                while (e1.hasMoreElements()) {
                    ARecord aRec = (ARecord)e1.nextElement();
                    if (!aRec.getAddress().equals(((ARecord)rr).getAddress())) continue;
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("duplicate record found for " + rr.getName().toString());
                    }
                    c_logger.traceDebug("duplicate record found for " + aRec.getAddress().getHostName());
                    dontAdd = true;
                    break;
                }
                if (!dontAdd) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("adding record for " + rr.getName().toString());
                    }
                    vector1.add((ARecord)rr);
                    bool = true;
                }
                if (this._AResponses.contains(rr.getName().getString())) continue;
                this._AResponses.put(rr.getName().getString(), vector1);
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "StateMachine: checkA: exit: id=" + this.hashCode());
            }
            return bool;
        }

        protected boolean checkAAAA(Vector rec) {
            boolean bool = false;
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: checkAAAA: entry: id=" + this.hashCode());
            }
            Vector<AAAARecord> vector1 = null;
            Vector vector2 = rec;
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: checkAAAA: answer size " + vector2.size());
            }
            Enumeration e2 = vector2.elements();
            while (e2.hasMoreElements()) {
                ResourceRecord rr = (ResourceRecord)e2.nextElement();
                if (rr.getType() != 28) continue;
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceEntry(this, "StateMachine: checkAAAA: found AAAA record");
                }
                if ((vector1 = this._AAAAResponses.get(rr.getName().getString())) == null) {
                    if (c_logger.isTraceEntryExitEnabled()) {
                        c_logger.traceEntry(this, "StateMachine: checkAAAA: create new Vector");
                    }
                    vector1 = new Vector<AAAARecord>();
                }
                boolean dontAdd = false;
                Enumeration e1 = vector1.elements();
                while (e1.hasMoreElements()) {
                    AAAARecord aaaa = (AAAARecord)e1.nextElement();
                    if (!aaaa.getAddress().equals(((AAAARecord)rr).getAddress())) continue;
                    dontAdd = true;
                    break;
                }
                if (!dontAdd) {
                    if (c_logger.isTraceEntryExitEnabled()) {
                        c_logger.traceEntry(this, "StateMachine: checkAAAA: add record " + rr.getName().getString());
                    }
                    vector1.add((AAAARecord)rr);
                    bool = true;
                }
                if (this._AAAAResponses.contains(rr.getName().getString())) continue;
                this._AAAAResponses.put(rr.getName().getString(), vector1);
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "StateMachine: checkAAAA: exit: id=" + this.hashCode());
            }
            return bool;
        }

        protected boolean checkAAAAAdditional(DnsMessage msg) {
            boolean bool = false;
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: checkAAAAAdditional: entry: id=" + this.hashCode());
            }
            bool = this.checkAAAA(msg.getAdditional());
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "StateMachine: checkAAAAAdditional: exit: id=" + this.hashCode());
            }
            return bool;
        }

        public void sendReq(DnsMessage msg) {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: sendReq: entry: id=" + this.hashCode());
            }
            this._dnsRequests.add(msg);
            SipResolverEvent event = SipResolverService.getResolver().resolve(msg, this._simpl, this._simpl.doTCP);
            if (event != null && !event.successfulResolution()) {
                this._simpl._timeoutTask.cancel();
                this._simpl._sll.error(this._simpl, new SipURILookupException(SipURILookupException.DEFAULTMSG));
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "StateMachine: sendReq: exit: id=" + this.hashCode());
            }
        }

        public void sendNAPTR() {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: sendNAPTR: entry: id=" + this.hashCode());
            }
            DnsMessage request = new DnsMessage(35, this._simpl._target);
            this.sendReq(request);
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "StateMachine: sendNAPTR: exit: id=" + this.hashCode());
            }
        }

        public void sendSRV() {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: sendSRV: entry: id=" + this.hashCode());
            }
            if (this._NAPTRResponses.size() > 0) {
                Enumeration<NAPTRRecord> e2 = this._NAPTRResponses.elements();
                while (e2.hasMoreElements()) {
                    NAPTRRecord r = e2.nextElement();
                    DnsMessage request = new DnsMessage(33, r.getReplacement().getString());
                    this.sendReq(request);
                }
            } else if (this.previousState == 1) {
                String target1 = null;
                String target2 = null;
                if (this._simpl._scheme.equalsIgnoreCase(SipURILookupImpl.SIP)) {
                    target1 = "_sip._udp." + this._simpl._target;
                    target2 = "_sip._tcp." + this._simpl._target;
                } else if (this._simpl._scheme.equalsIgnoreCase(SipURILookupImpl.SIPS)) {
                    target1 = "_sips._tcp." + this._simpl._target;
                }
                DnsMessage request = new DnsMessage(33, target1);
                this.sendReq(request);
                if (target2 != null) {
                    DnsMessage request2 = new DnsMessage(33, target2);
                    this.sendReq(request2);
                }
            } else {
                String target = null;
                String transport = this._simpl._suri.getTransport();
                if (transport.equalsIgnoreCase(SipURILookupImpl.UDP)) {
                    target = "_sip._udp." + this._simpl._target;
                } else if (transport.equalsIgnoreCase(SipURILookupImpl.TCP)) {
                    String scheme = this._simpl._suri.getScheme();
                    if (scheme.equalsIgnoreCase(SipURILookupImpl.SIP)) {
                        target = "_sip._tcp." + this._simpl._target;
                    } else if (scheme.equalsIgnoreCase(SipURILookupImpl.SIPS)) {
                        target = "_sips._tcp." + this._simpl._target;
                    }
                } else if (transport.equalsIgnoreCase(SipURILookupImpl.SCTP)) {
                    target = "_sips._sctp." + this._simpl._target;
                }
                DnsMessage request = new DnsMessage(33, target);
                this.sendReq(request);
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "StateMachine: sendSRV: exit: id=" + this.hashCode());
            }
        }

        public void sendA() {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: sendA: entry: id=" + this.hashCode());
            }
            if (this.previousState == 2 && this.currentState == 3 && this.haveSRVResponses()) {
                for (int i = 0; i < this._SRVResponses.length; ++i) {
                    Vector<SRVRecord> vector2 = this._SRVResponses[i];
                    Enumeration<SRVRecord> e2 = vector2.elements();
                    while (e2.hasMoreElements()) {
                        SRVRecord srv = e2.nextElement();
                        DnsMessage req = new DnsMessage(1, srv.getTarget().toString());
                        this.sendReq(req);
                    }
                }
            } else {
                DnsMessage request = new DnsMessage(1, this._simpl._target);
                this.sendReq(request);
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "StateMachine: sendA: exit: id=" + this.hashCode());
            }
        }

        public void sendAAAA() {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: sendAAAA: entry: id=" + this.hashCode());
            }
            if (this.haveSRVResponses()) {
                for (int i = 0; i < this._SRVResponses.length; ++i) {
                    Vector<SRVRecord> vector2 = this._SRVResponses[i];
                    Enumeration<SRVRecord> e2 = vector2.elements();
                    while (e2.hasMoreElements()) {
                        SRVRecord srv = e2.nextElement();
                        DnsMessage req = new DnsMessage(28, srv.getTarget().toString());
                        this.sendReq(req);
                    }
                }
            } else {
                DnsMessage request = new DnsMessage(28, this._simpl._target);
                this.sendReq(request);
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "StateMachine: sendAAAA: exit: id=" + this.hashCode());
            }
        }

        public void none() {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: none: entry: id=" + this.hashCode());
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: none: exit: id=" + this.hashCode());
            }
        }

        protected void reset() {
            this.previousState = 0;
            this.currentState = 0;
            Enumeration<DnsMessage> e2 = this._dnsRequests.elements();
            while (e2.hasMoreElements()) {
                DnsMessage msg = e2.nextElement();
                SipResolverService.getResolver().cancelRequest(msg, false);
            }
            this._dnsRequests.clear();
            this._NAPTRResponses.clear();
            this._SRVResponses = null;
            this._AResponses.clear();
            this._AAAAResponses.clear();
        }

        protected void fillSRVAnswer() {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: fillSRVAnswer: entry: id=" + this.hashCode());
            }
            if (this.haveSRVResponses()) {
                Vector<SRVRecord>[] tmp = this._SRVResponses;
                for (int i = 0; i < tmp.length; ++i) {
                    float j = this.calcTotalWeight(tmp[i]);
                    Enumeration<SRVRecord> e2 = tmp[i].elements();
                    while (e2.hasMoreElements()) {
                        SRVRecord r = e2.nextElement();
                        Vector vector2 = this.fillSipUri(r);
                        if (vector2.isEmpty()) continue;
                        float k = r.getWeight().shortValue();
                        if (k > 0.0f && j - k != 0.0f) {
                            for (float l = 0.0f; l < k / (j - k); l += 1.0f) {
                                Enumeration e1 = vector2.elements();
                                while (e1.hasMoreElements()) {
                                    SIPUri suri = (SIPUri)e1.nextElement();
                                    this._simpl._answerList.add(suri);
                                }
                            }
                            continue;
                        }
                        Enumeration e1 = vector2.elements();
                        while (e1.hasMoreElements()) {
                            SIPUri suri = (SIPUri)e1.nextElement();
                            this._simpl._answerList.add(suri);
                        }
                    }
                }
            } else {
                this.fillAError();
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("StateMachine: fillSRVAnswer: _answerList.size()" + this._simpl._answerList.size());
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "StateMachine: fillSRVAnswer: exit: id=" + this.hashCode());
            }
        }

        protected void fillAAnswer() {
            SIPUri answer;
            Enumeration e1;
            Vector vector2;
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: fillAAnswer: entry: id=" + this.hashCode());
            }
            Enumeration<Vector> e2 = this._AResponses.elements();
            while (e2.hasMoreElements()) {
                vector2 = e2.nextElement();
                e1 = vector2.elements();
                while (e1.hasMoreElements()) {
                    ARecord a = (ARecord)e1.nextElement();
                    answer = SIPUri.createSIPUri(this._simpl._suri.getURI());
                    answer.setScheme(this._simpl._scheme);
                    answer.setHost(a.getAddress().getHostAddress());
                    answer.setTransport(this._simpl._transport);
                    answer.setPortInt(this._simpl._port);
                    this.addUriToList(answer, this._simpl._answerList, a);
                }
            }
            e2 = this._AAAAResponses.elements();
            while (e2.hasMoreElements()) {
                vector2 = e2.nextElement();
                e1 = vector2.elements();
                while (e1.hasMoreElements()) {
                    AAAARecord aaaa = (AAAARecord)e1.nextElement();
                    answer = SIPUri.createSIPUri(this._simpl._suri.getURI());
                    answer.setScheme(this._simpl._scheme);
                    answer.setHost(aaaa.getAddress().getHostAddress());
                    answer.setTransport(this._simpl._transport);
                    answer.setPortInt(this._simpl._port);
                    this.addUriToList(answer, this._simpl._answerList, aaaa);
                }
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "StateMachine: fillAAnswer: exit: id=" + this.hashCode());
            }
        }

        protected void fillAError() {
            SIPUri answer;
            Enumeration e1;
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: fillAError: entry: id=" + this.hashCode());
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("StateMachine: fillAError: _target = " + this._simpl._target);
            }
            Vector vector1 = null;
            vector1 = this._AResponses.get(this._simpl._target);
            if (vector1 != null) {
                e1 = vector1.elements();
                while (e1.hasMoreElements()) {
                    ARecord aRec = (ARecord)e1.nextElement();
                    answer = SIPUri.createSIPUri(this._simpl._suri.getURI());
                    answer.setScheme(this._simpl._scheme);
                    answer.setHost(aRec.getAddress().getHostAddress());
                    if (this._simpl._scheme.equals(SipURILookupImpl.SIP)) {
                        if (this._simpl._transport == null) {
                            answer.setTransport(SipURILookupImpl.UDP);
                        }
                        answer.setPortInt(5060);
                    } else {
                        if (this._simpl._transport == null) {
                            answer.setTransport(SipURILookupImpl.TCP);
                        }
                        answer.setPortInt(5061);
                    }
                    this.addUriToList(answer, this._simpl._answerList, aRec);
                }
            }
            if ((vector1 = this._AAAAResponses.get(this._simpl._target)) != null) {
                e1 = vector1.elements();
                while (e1.hasMoreElements()) {
                    AAAARecord aaaa = (AAAARecord)e1.nextElement();
                    answer = SIPUri.createSIPUri(this._simpl._suri.getURI());
                    answer.setScheme(this._simpl._scheme);
                    answer.setHost(aaaa.getAddress().getHostAddress());
                    if (this._simpl._scheme.equals(SipURILookupImpl.SIP)) {
                        if (this._simpl._transport == null) {
                            answer.setTransport(SipURILookupImpl.UDP);
                        }
                        answer.setPortInt(5060);
                    } else {
                        if (this._simpl._transport == null) {
                            answer.setTransport(SipURILookupImpl.TCP);
                        }
                        answer.setPortInt(5061);
                    }
                    this.addUriToList(answer, this._simpl._answerList, aaaa);
                }
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "StateMachine: fillAError: exit: id=" + this.hashCode());
            }
        }

        protected float calcTotalWeight(Vector vec) {
            float f = 0.0f;
            Enumeration e2 = vec.elements();
            while (e2.hasMoreElements()) {
                SRVRecord r = (SRVRecord)e2.nextElement();
                f += (float)r.getWeight().shortValue();
            }
            return f;
        }

        protected Vector fillSipUri(SRVRecord r) {
            SIPUri suri;
            Enumeration e2;
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: fillSipUri: entry: id=" + this.hashCode());
            }
            Vector vector2 = new Vector();
            Vector vector1 = null;
            vector1 = this._AResponses.get(r.getTarget().toString());
            if (vector1 != null) {
                e2 = vector1.elements();
                while (e2.hasMoreElements()) {
                    ARecord aRec = (ARecord)e2.nextElement();
                    suri = SIPUri.createSIPUri(this._simpl._suri.getBaseSIPUri());
                    suri.setHost(aRec.getAddress().getHostAddress());
                    suri.setPort(new Integer(r.getPort()).toString());
                    suri.setTransport(r.getProtocol().substring(1));
                    suri.setScheme(r.getService().substring(1));
                    this.addUriToList(suri, vector2, aRec);
                }
            }
            if ((vector1 = this._AAAAResponses.get(r.getTarget().toString())) != null) {
                e2 = vector1.elements();
                while (e2.hasMoreElements()) {
                    AAAARecord aaaa = (AAAARecord)e2.nextElement();
                    suri = SIPUri.createSIPUri(this._simpl._suri.getBaseSIPUri());
                    suri.setHost(aaaa.getAddress().getHostAddress());
                    suri.setPort(new Integer(r.getPort()).toString());
                    suri.setTransport(r.getProtocol().substring(1));
                    suri.setScheme(r.getService().substring(1));
                    this.addUriToList(suri, vector2, aaaa);
                }
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "StateMachine: fillSipUri: exit: id=" + this.hashCode());
            }
            return vector2;
        }

        protected int getTTL() {
            ResourceRecord rec;
            Enumeration e1;
            Vector vector2;
            ResourceRecord rec2;
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: getTTL: entry: id=" + this.hashCode());
            }
            int i = Integer.MAX_VALUE;
            Enumeration<Object> e2 = this._NAPTRResponses.elements();
            while (e2.hasMoreElements()) {
                rec2 = e2.nextElement();
                if (rec2.getTTL() >= i) continue;
                i = rec2.getTTL();
            }
            if (this.haveSRVResponses()) {
                for (int j = 0; j < this._SRVResponses.length; ++j) {
                    if (this._SRVResponses[j].isEmpty() || (rec2 = this._SRVResponses[j].firstElement()).getTTL() >= i) continue;
                    i = rec2.getTTL();
                }
            }
            e2 = this._AResponses.elements();
            while (e2.hasMoreElements()) {
                vector2 = (Vector)e2.nextElement();
                e1 = vector2.elements();
                while (e1.hasMoreElements()) {
                    rec = (ARecord)e1.nextElement();
                    if (rec.getTTL() >= i) continue;
                    i = rec.getTTL();
                }
            }
            e2 = this._AAAAResponses.elements();
            while (e2.hasMoreElements()) {
                vector2 = (Vector)e2.nextElement();
                e1 = vector2.elements();
                while (e1.hasMoreElements()) {
                    rec = (AAAARecord)e1.nextElement();
                    if (rec.getTTL() >= i) continue;
                    i = rec.getTTL();
                }
            }
            if (i == Integer.MAX_VALUE) {
                i = 0;
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "StateMachine: getTTL: exit: id=" + this.hashCode());
            }
            return i;
        }

        public void checkAnswer(DnsMessage msg) {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: checkAnswer: entry: id=" + this.hashCode());
            }
            int input = 13;
            switch (this.currentState) {
                case 1: {
                    this.checkNAPTRAnswer(msg);
                    this.checkAdditional(msg);
                    if (this.currentState == 5) break;
                    input = 2;
                    break;
                }
                case 2: {
                    this.checkSRV(msg.getAnswers());
                    this.checkAdditional(msg);
                    if (!this._dnsRequests.isEmpty() || this.currentState == 5 && !this._simpl._answerList.isEmpty()) break;
                    input = 3;
                    break;
                }
                case 3: {
                    this.checkA(msg.getAnswers());
                    this.checkAdditional(msg);
                    if (!this._dnsRequests.isEmpty() || this.currentState == 5 && !this._simpl._answerList.isEmpty()) break;
                    input = 4;
                    break;
                }
                case 4: {
                    this.checkAAAA(msg.getAnswers());
                    if (!this._dnsRequests.isEmpty() || this.currentState == 5) break;
                    input = 0;
                    break;
                }
            }
            this.runMachine(input, null);
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "StateMachine: checkAnswer: exit: id=" + this.hashCode());
            }
        }

        public void checkAdditional(DnsMessage msg) {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: checkAdditional: entry: id=" + this.hashCode());
            }
            int input = 13;
            switch (this.currentState) {
                case 1: {
                    if (!this.checkSRVAdditional(msg)) break;
                    input = 0;
                    break;
                }
                case 2: {
                    if (!this.checkSRVAdditional(msg)) break;
                    input = 0;
                    break;
                }
                case 3: {
                    if (!this.checkAAAAAdditional(msg)) break;
                    input = 0;
                    break;
                }
                case 4: {
                    break;
                }
            }
            this.runMachine(input, null);
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "StateMachine: checkAdditional: exit: id=" + this.hashCode());
            }
        }

        public void checkError() {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: checkError: entry: id=" + this.hashCode());
            }
            int input = 13;
            switch (this.currentState) {
                case 1: {
                    input = 2;
                    break;
                }
                case 2: {
                    if (!this._dnsRequests.isEmpty()) break;
                    input = 3;
                    break;
                }
                case 3: {
                    if (!this._dnsRequests.isEmpty()) break;
                    input = 4;
                    break;
                }
                case 4: {
                    if (!this._dnsRequests.isEmpty()) break;
                    input = 0;
                    break;
                }
            }
            this.runMachine(input, null);
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "StateMachine: checkError: exit: id=" + this.hashCode());
            }
        }

        protected boolean checkNAPTRAnswer(DnsMessage msg) {
            Vector<ResourceRecord> vAnswer;
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: checkNAPTRAnswer: entry: id=" + this.hashCode());
            }
            if ((vAnswer = msg.getAnswers()) != null) {
                Enumeration<ResourceRecord> e2 = vAnswer.elements();
                while (e2.hasMoreElements()) {
                    NAPTRRecord r;
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("StateMachine: checkNAPTRAnswer: v size " + vAnswer.size());
                    }
                    if (this.validateNAPTRService(r = (NAPTRRecord)e2.nextElement())) continue;
                    if (this._NAPTRResponses.isEmpty()) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("StateMachine: checkNAPTRAnswer: insert into empty list");
                        }
                        this._NAPTRResponses.insertElementAt(r, 0);
                        continue;
                    }
                    int i = 0;
                    Enumeration<NAPTRRecord> e1 = this._NAPTRResponses.elements();
                    while (e1.hasMoreElements()) {
                        NAPTRRecord existing = e1.nextElement();
                        i = this._NAPTRResponses.indexOf(existing);
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("StateMachine: checkNAPTRAnswer: after existing ");
                        }
                        if (r.getOrder() == existing.getOrder()) {
                            if (r.getPreference() >= existing.getPreference()) {
                                if (c_logger.isTraceDebugEnabled()) {
                                    c_logger.traceDebug("StateMachine: checkNAPTRAnswer: answers same Order higer pref ");
                                }
                                this._NAPTRResponses.insertElementAt(r, i);
                                break;
                            }
                            if (c_logger.isTraceDebugEnabled()) {
                                c_logger.traceDebug("StateMachine: checkNAPTRAnswer: same Order lower pref ");
                            }
                            this._NAPTRResponses.insertElementAt(r, i + 1);
                            break;
                        }
                        if (r.getOrder() >= existing.getOrder()) continue;
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("StateMachine: checkNAPTRAnswer: lower order");
                        }
                        this._NAPTRResponses.insertElementAt(r, i);
                        break;
                    }
                    if (this._NAPTRResponses.contains(r)) continue;
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("StateMachine: checkNAPTRAnswer: insert at the end of list");
                    }
                    this._NAPTRResponses.insertElementAt(r, i + 1);
                }
            }
            boolean bool = false;
            if (this._NAPTRResponses.isEmpty()) {
                bool = false;
            } else {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("StateMachine: checkNAPTRAnswer: setting up SRVResponses");
                }
                this._SRVResponses = new Vector[this._NAPTRResponses.size()];
                for (int i = 0; i < this._NAPTRResponses.size(); ++i) {
                    this._SRVResponses[i] = new Vector();
                }
                bool = true;
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "StateMachine: checkNAPTRAnswer: exit: id=" + this.hashCode());
            }
            return bool;
        }

        protected boolean validateNAPTRService(NAPTRRecord nr) {
            boolean bool = false;
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: validateNAPTRService: entry: id=" + this.hashCode());
            }
            String service = nr.getService();
            if (this._simpl._scheme.startsWith(SipURILookupImpl.SIPS) && !service.startsWith("SIPS")) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("StateMachine: validateNAPTRService: Non-Secure service");
                }
                bool = true;
            } else if (!(service.equals(SIP_D2T) || service.equals(SIPS_D2T) || service.equals(SIP_D2U))) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("StateMachine: validateNAPTRService: Unsupported service " + service);
                }
                bool = true;
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "StateMachine: validateNAPTRService: exit: id=" + this.hashCode());
            }
            return bool;
        }

        private void mapNAPTRtransportToSRVprotocol(NAPTRRecord naptr, SRVRecord srv) {
            String service = naptr.getService();
            if (service.equals(SIP_D2U)) {
                srv.setProtocol("_udp");
            } else if (service.equals(SIPS_D2T)) {
                srv.setProtocol("_tcp");
            } else if (service.equals(SIP_D2T)) {
                srv.setProtocol("_tcp");
            } else if (service.equals(SIP_D2S)) {
                srv.setProtocol("_sctp");
            }
        }

        protected boolean checkSRV(Vector vec) {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: checkSRV: entry: id=" + this.hashCode());
            }
            Vector vAnswer = vec;
            if (this._SRVResponses == null) {
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceEntry(this, "StateMachine: checkSRV: setting up SRVResponses");
                }
                this._SRVResponses = new Vector[1];
                this._SRVResponses[0] = new Vector();
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("StateMachine: checkSRV: vAnswer size " + vAnswer.size());
            }
            Enumeration e2 = vAnswer.elements();
            block0: while (e2.hasMoreElements()) {
                ResourceRecord rr = (ResourceRecord)e2.nextElement();
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("StateMachine: checkSRV: type " + rr.getType());
                }
                if (rr.getType() != 33) continue;
                SRVRecord srv = (SRVRecord)rr;
                if (!this._NAPTRResponses.isEmpty()) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("StateMachine: checkSRV: have Naptr ");
                    }
                    Enumeration<NAPTRRecord> e1 = this._NAPTRResponses.elements();
                    while (e1.hasMoreElements()) {
                        NAPTRRecord naptr = e1.nextElement();
                        Name n = naptr.getReplacement();
                        String s = srv.getService() + "." + srv.getProtocol() + "." + srv.getSrvName();
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("StateMachine: checkSRV: replacement " + n.getString());
                        }
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("StateMachine: checkSRV: srv " + s);
                        }
                        if (!s.equals(n.getString())) continue;
                        this.mapNAPTRtransportToSRVprotocol(naptr, srv);
                        if (this._SRVResponses[this._NAPTRResponses.indexOf(naptr)].isEmpty()) {
                            if (c_logger.isTraceDebugEnabled()) {
                                c_logger.traceDebug("StateMachine: checkSRV: insert into empty list");
                            }
                            this._SRVResponses[this._NAPTRResponses.indexOf(naptr)].insertElementAt(srv, 0);
                            continue block0;
                        }
                        int i = 0;
                        Enumeration<SRVRecord> e22 = this._SRVResponses[this._NAPTRResponses.indexOf(naptr)].elements();
                        while (e22.hasMoreElements()) {
                            SRVRecord existing = e22.nextElement();
                            i = this._SRVResponses[this._NAPTRResponses.indexOf(naptr)].indexOf(existing);
                            if (srv.getPriority() == existing.getPriority()) {
                                if (srv.getWeight() >= existing.getWeight()) {
                                    if (c_logger.isTraceDebugEnabled()) {
                                        c_logger.traceDebug("StateMachine: checkSRV: insert same pri higher weight");
                                    }
                                    this._SRVResponses[this._NAPTRResponses.indexOf(naptr)].insertElementAt(srv, i);
                                    break;
                                }
                                this._SRVResponses[this._NAPTRResponses.indexOf(naptr)].insertElementAt(srv, i + 1);
                                if (!c_logger.isTraceDebugEnabled()) break;
                                c_logger.traceDebug("StateMachine: checkSRV: insert same pri lower weight");
                                break;
                            }
                            if (srv.getPriority() >= existing.getPriority()) continue;
                            this._SRVResponses[this._NAPTRResponses.indexOf(naptr)].insertElementAt(srv, i);
                            break;
                        }
                        if (this._SRVResponses[this._NAPTRResponses.indexOf(naptr)].contains(srv)) continue;
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("StateMachine: checkSRV: insert at the end of list");
                        }
                        this._SRVResponses[this._NAPTRResponses.indexOf(naptr)].insertElementAt(srv, i + 1);
                    }
                    continue;
                }
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("StateMachine: checkSRV: checking SRV with NO NAPTR");
                }
                if (this.validateSRVServiceAndProtocol(srv)) continue;
                if (this._SRVResponses[0].isEmpty()) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("StateMachine: checkSRV: no NAPTR insert into empty list");
                    }
                    this._SRVResponses[0].insertElementAt(srv, 0);
                    continue;
                }
                int i = 0;
                Enumeration<SRVRecord> e23 = this._SRVResponses[0].elements();
                while (e23.hasMoreElements()) {
                    SRVRecord existing = e23.nextElement();
                    i = this._SRVResponses[0].indexOf(existing);
                    if (srv.getPriority() == existing.getPriority()) {
                        if (srv.getWeight() >= existing.getWeight()) {
                            if (c_logger.isTraceDebugEnabled()) {
                                c_logger.traceDebug("StateMachine: checkSRV: same pri higher weight");
                            }
                            this._SRVResponses[0].insertElementAt(srv, i);
                            break;
                        }
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug("StateMachine: checkSRV: same pri lower weight");
                        }
                        this._SRVResponses[0].insertElementAt(srv, i + 1);
                        break;
                    }
                    if (srv.getPriority() >= existing.getPriority()) continue;
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("StateMachine: checkSRV: lower priority");
                    }
                    this._SRVResponses[0].insertElementAt(srv, i);
                    break;
                }
                if (this._SRVResponses[0].contains(srv)) continue;
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("StateMachine: checkSRV: insert at the end of list");
                }
                this._SRVResponses[0].insertElementAt(srv, i + 1);
            }
            boolean bool = false;
            bool = this._dnsRequests.isEmpty();
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "StateMachine: checkSRV: exit: id=" + this.hashCode());
            }
            return bool;
        }

        private boolean validateSRVServiceAndProtocol(SRVRecord sr) {
            String protocol;
            String service;
            boolean bool = false;
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: validateSRVServiceAndProtocol: entry: id=" + this.hashCode());
            }
            if (!(service = sr.getService()).startsWith("_sip") && !service.startsWith("_sips")) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("StateMachine: validateSRVServiceAndProtocol: Invalid service " + service);
                }
                bool = true;
            }
            if (this._simpl._scheme.startsWith(SipURILookupImpl.SIPS) && !service.startsWith("_sips")) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("StateMachine: validateSRVServiceAndProtocol: Non-Secure service");
                }
                bool = true;
            }
            if (!((protocol = sr.getProtocol()).equals("_udp") || protocol.equals("_tcp") || protocol.equals("_sctp"))) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("StateMachine: validateSRVServiceAndProtocol: Invalid protocol " + protocol);
                }
                bool = true;
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "StateMachine: validateSRVServiceAndProtocol: exit: id=" + this.hashCode());
            }
            return bool;
        }

        protected void handleEvent(SipResolverEvent event) {
            DnsMessage dnsResponse = event.getResponse();
            DnsMessage dnsRequest = this.getDnsRequest(dnsResponse);
            if (dnsRequest == null) {
                if (c_logger.isTraceEntryExitEnabled()) {
                    c_logger.traceEntry(this, "StateMachine: handleSipResolverEvent: exit: No matching request id=" + this.hashCode());
                }
                return;
            }
            this._dnsRequests.remove(dnsRequest);
            int input = 0;
            for (int i = 0; i < mapper.length; ++i) {
                if (!Dns.TYPESTRING[dnsResponse.getQtype()].equals(mapper[i])) continue;
                input = i;
                break;
            }
            if (dnsResponse.isNameError()) {
                ++input;
            }
            this.runMachine(input, dnsResponse);
        }

        protected DnsMessage getDnsRequest(DnsMessage dnsResponse) {
            DnsMessage dnsRequest = null;
            Enumeration<DnsMessage> e2 = this._dnsRequests.elements();
            while (e2.hasMoreElements() && (dnsRequest = e2.nextElement()).getId() != dnsResponse.getId()) {
            }
            return dnsRequest;
        }

        protected void cancelRequests() {
            Enumeration<DnsMessage> e2 = this._dnsRequests.elements();
            while (e2.hasMoreElements()) {
                DnsMessage msg = e2.nextElement();
                SipResolverService.getResolver().cancelRequest(msg, true);
            }
        }

        public void constructAnswer() {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "StateMachine: constructAnswer: entry: id=" + this.hashCode());
            }
            switch (this._simpl._fsm.initAction) {
                case 0: {
                    break;
                }
                case 1: {
                    this._simpl._fsm.fillSRVAnswer();
                    break;
                }
                case 2: {
                    this._simpl._fsm.fillSRVAnswer();
                    break;
                }
                case 3: {
                    this._simpl._fsm.fillAAnswer();
                    break;
                }
            }
            if (c_logger.isTraceDebugEnabled()) {
                ListIterator<SIPUri> li = this._simpl._answerList.listIterator();
                while (li.hasNext()) {
                    SIPUri look = li.next();
                    c_logger.traceDebug("StateMachine: completeAnswer: SIPUri number  " + (li.nextIndex() - 1));
                    c_logger.traceDebug("StateMachine: completeAnswer: SIPUri " + look.getScheme() + ":" + look.getUserInfo() + "@" + look.getHost() + ":" + look.getPort() + ";" + look.getTransport());
                }
            }
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "StateMachine: completeAnswer: exit: id=" + this.hashCode());
            }
        }

        private boolean haveSRVResponses() {
            boolean bool = false;
            if (this._SRVResponses != null && !this._SRVResponses[0].isEmpty()) {
                bool = true;
            }
            return bool;
        }

        private void addUriToList(SIPUri uri, List uriList, ResourceRecord record) {
            if (SipResolverService.isAddTTL()) {
                StringBuilder builder = new StringBuilder(uri.getAdditionalParms());
                builder.append(";");
                builder.append(SipURILookupImpl.IBM_TTL_PARAM);
                builder.append("=");
                builder.append(record.getTTL());
                builder.append("_");
                if (usePreciseSystemTimer) {
                    builder.append(System.nanoTime() / 1000000L);
                } else {
                    builder.append(System.currentTimeMillis());
                }
                uri.setAdditionalParms(builder.toString());
            }
            uriList.add(uri);
        }

        static {
            Method mCHKANS;
            Method mCHKERR;
            Method mSNAPTR;
            Method mSSRV;
            Method mSA;
            Method mSAAAA;
            Method mANSWER;
            Method mNONE;
            block3: {
                mapper = new String[]{"PH0", "PH1", "PH2", "PH3", "PH4", "NAPTR", "PH5", "SRV", "PH6", "A", "PH7", "AAAA"};
                c = StateMachine.class;
                if (c_logger.isInfoEnabled()) {
                    c_logger.info("State machine, allocating static data");
                }
                mNONE = null;
                mANSWER = null;
                mSAAAA = null;
                mSA = null;
                mSSRV = null;
                mSNAPTR = null;
                mCHKERR = null;
                mCHKANS = null;
                try {
                    mCHKANS = c.getMethod("checkAnswer", DnsMessage.class);
                    mCHKERR = c.getMethod("checkError", new Class[0]);
                    mSNAPTR = c.getMethod("sendNAPTR", new Class[0]);
                    mSSRV = c.getMethod("sendSRV", new Class[0]);
                    mSA = c.getMethod("sendA", new Class[0]);
                    mSAAAA = c.getMethod("sendAAAA", new Class[0]);
                    mANSWER = c.getMethod("constructAnswer", new Class[0]);
                    mNONE = c.getMethod("none", new Class[0]);
                }
                catch (Exception e2) {
                    if (!c_logger.isTraceDebugEnabled()) break block3;
                    c_logger.traceDebug("StateMachine: StateMachine exception " + e2);
                }
            }
            CHKANS = mCHKANS;
            CHKERR = mCHKERR;
            SNAPTR = mSNAPTR;
            SSRV = mSSRV;
            SA = mSA;
            SAAAA = mSAAAA;
            ANSWER = mANSWER;
            NONE = mNONE;
            lookup_stateMachine = new e[][]{{new e(ANSWER, 5), new e(SNAPTR, 1), new e(SSRV, 2), new e(SA, 3), new e(SAAAA, 4), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 0)}, {new e(ANSWER, 5), new e(NONE, 6), new e(SSRV, 2), new e(SA, 2), new e(SAAAA, 4), new e(CHKANS, 1), new e(SSRV, 2), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 1)}, {new e(ANSWER, 5), new e(NONE, 6), new e(NONE, 6), new e(SA, 3), new e(SAAAA, 4), new e(NONE, 6), new e(NONE, 6), new e(CHKANS, 2), new e(CHKERR, 2), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 2)}, {new e(ANSWER, 5), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(SAAAA, 4), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(CHKANS, 3), new e(CHKERR, 3), new e(NONE, 6), new e(NONE, 6), new e(NONE, 3)}, {new e(ANSWER, 5), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(CHKANS, 4), new e(CHKERR, 4), new e(NONE, 4)}, {new e(NONE, 5), new e(NONE, 6), new e(SSRV, 2), new e(SA, 3), new e(SAAAA, 4), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 5)}, {new e(ANSWER, 5), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6), new e(NONE, 6)}};
        }

        static class e {
            final Method action;
            final int nextState;

            e(Method m, int s) {
                this.action = m;
                this.nextState = s;
            }
        }
    }

    private class UriExpirationTimerTask
    extends TimerTask {
        private UriExpirationTimerTask() {
        }

        @Override
        public void run() {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "UriExpirationTimerTask: run: entry: id=" + this.hashCode());
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("UriExpirationTimerTask: run: Removing request " + SipURILookupImpl.this._suri.getBaseSIPUri() + " from the SipUResolverLookupCache");
            }
            SipURILookupImpl.this._lookupCache.remove(SipURILookupImpl.this.getSipURI());
            this.cancel();
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "UriExpirationTimerTask: run: exit: id=" + this.hashCode());
            }
        }
    }

    private class RequestTimeoutTimerTask
    extends TimerTask {
        private RequestTimeoutTimerTask() {
        }

        @Override
        public void run() {
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceEntry(this, "RequestTimeoutTimerTask: run: entry: id=" + this.hashCode());
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("RequestTimeoutTimerTask: run: Message timeout occurred. Cancelling request for " + SipURILookupImpl.this._suri.getBaseSIPUri());
            }
            SipURILookupImpl.this._fsm.cancelRequests();
            SIPUri suri = SipURILookupImpl.this.getSipURI();
            SipURILookupImpl.this._sll.error(SipURILookupImpl.this, new SipURILookupException(SipURILookupException.LOOKUP_TIMEOUT + suri.getBaseSIPUri()));
            this.cancel();
            if (c_logger.isTraceEntryExitEnabled()) {
                c_logger.traceExit(this, "RequestTimeoutTimerTask: run: exit: id=" + this.hashCode());
            }
        }
    }
}

