/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.timer;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.events.ContextEstablisher;
import com.ibm.ws.sip.container.failover.Replicatable;
import com.ibm.ws.sip.container.failover.repository.SessionRepository;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.pmi.TaskDurationMeasurer;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.timer.BaseTimer;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.container.util.Queueable;
import java.io.Serializable;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.TimerListener;

public class ServletTimerImpl
extends BaseTimer
implements ServletTimer,
Runnable,
Replicatable,
Queueable {
    private static final long serialVersionUID = 1L;
    private static final LogMgr c_logger = Log.get(ServletTimerImpl.class);
    private transient SipApplicationSessionImpl m_appSession;
    private Serializable m_info;
    private transient boolean _isRunning = false;
    private TaskDurationMeasurer _sipContainerQueueDuration = null;
    private TaskDurationMeasurer _sipContainerApplicationCodeDuration = null;

    @Override
    public String getId() {
        return Integer.toString(this.getTimerId());
    }

    public ServletTimerImpl(SipApplicationSessionImpl appSession, Serializable info) {
        this.m_appSession = appSession;
        this.m_info = info;
        this.setTimerId(this.m_appSession.getNextTimerId());
        this.setSharedId(this.m_appSession.getSharedId());
        this.setQueueIndex(this.extractQueueIndex());
    }

    @Override
    public SipApplicationSession getApplicationSession() {
        return this.m_appSession;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(96);
        buffer.append("Timer, App Session:").append(this.m_appSession).append(" ,Delay:").append(this.getDelay()).append(" ,Period:").append(this.getPeriod()).append(" ,Fixed Delay:").append(this.isFixedDelay()).append(" ,Cancelled:").append(this.isCancelled()).append(" ,info:").append(this.getInfo());
        return buffer.toString();
    }

    @Override
    public Serializable getInfo() {
        return this.m_info;
    }

    @Override
    public void cancel() {
        if (this.isCancelled()) {
            return;
        }
        if (!this._isRunning) {
            super.cancel();
            this.m_appSession.removeTimer(this);
        } else {
            this.cancelWithoutRemove();
        }
    }

    public void cancelWithoutRemove() {
        super.cancel();
        this.setDirty();
        this.store();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        SipAppDesc desc = this.m_appSession.getAppDescriptor();
        TimerListener timerL = desc.getTimerListener();
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("ServletTimerImpl.run(): timerListener=" + timerL);
        }
        if (null != timerL) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            ContextEstablisher contextEstablisher = null;
            try {
                contextEstablisher = desc.getContextEstablisher();
                if (contextEstablisher != null) {
                    contextEstablisher.establishContext(timerL.getClass().getClassLoader());
                }
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("ServletTimerImpl.run(): calling timeout timerListener=" + timerL + "ServletTimer=" + this);
                }
                this._isRunning = true;
                timerL.timeout(this);
                return;
            }
            catch (Throwable t) {
                if (!c_logger.isErrorEnabled()) return;
                c_logger.error("Fail to run timeout method", null, null, t);
                return;
            }
            finally {
                this._isRunning = false;
                if (this.getPeriod() <= 0L && !this.isCancelled()) {
                    this.m_appSession.removeTimer(this);
                }
                if (this.isCancelled() && this.m_appSession.isValid()) {
                    this.m_appSession.removeTimer(this);
                } else if (this.isCancelled()) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("appsession already invalidated, removing timer directly from the session repository, timerId: " + this.getId() + ", appSession: " + this.m_appSession.getId());
                    }
                    this.removeFromStorage();
                }
                if (contextEstablisher != null) {
                    contextEstablisher.removeContext(cl);
                }
            }
        } else {
            if (!c_logger.isWarnEnabled()) return;
            Object[] args = new Object[]{desc.getApplicationName()};
            c_logger.warn("warning.timer.listener.unavailable", "Create", args);
        }
    }

    public void setAppSession(SipApplicationSessionImpl appSession) {
        this.m_appSession = appSession;
    }

    @Override
    public void store() {
        SessionRepository.getInstance().put(this.m_appSession, this);
    }

    public void notifyOnActivation() {
    }

    @Override
    protected int extractQueueIndex() {
        if (this.m_appSession != null) {
            return this.m_appSession.extractAppSessionCounter();
        }
        return 0;
    }

    @Override
    public int priority() {
        return 50;
    }

    @Override
    public long getTimeRemaining() {
        long scheduled = this.m_nextExecution;
        long now = System.currentTimeMillis();
        long remaining = scheduled - now;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getTimeRemaining", "scheduled [" + scheduled + "] now [" + now + "] remaining [" + remaining + ']');
        }
        return remaining;
    }

    @Override
    public Object getServiceSynchronizer() {
        return this.m_appSession.getServiceSynchronizer();
    }

    @Override
    public TaskDurationMeasurer getSipContainerQueueDuration() {
        return this._sipContainerQueueDuration;
    }

    @Override
    public TaskDurationMeasurer getApplicationCodeDuration() {
        return this._sipContainerApplicationCodeDuration;
    }

    @Override
    public String getAppName() {
        if (this.m_appSession != null && this.m_appSession.getAppDescriptor() != null) {
            return this.m_appSession.getAppDescriptor().getApplicationName();
        }
        return null;
    }

    @Override
    public Integer getAppIndexForPMI() {
        if (this.m_appSession != null && this.m_appSession.getAppDescriptor() != null) {
            return this.m_appSession.getAppDescriptor().getAppIndexForPmi();
        }
        return null;
    }

    @Override
    public void setSipContainerQueueDuration(TaskDurationMeasurer tm) {
        this._sipContainerQueueDuration = tm;
    }

    @Override
    public void setApplicationCodeDuration(TaskDurationMeasurer tm) {
        this._sipContainerApplicationCodeDuration = tm;
    }

    @Override
    public TransactionUserWrapper getTuWrapper() {
        return null;
    }

    @Override
    public void removeFromStorage() {
        SessionRepository.getInstance().removeTimer(this.m_appSession.getId(), this);
    }
}

