/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.tu;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.servlets.SipServletMessageImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import jain.protocol.ip.sip.message.Request;
import jain.protocol.ip.sip.message.Response;

public class TUKey
implements Cloneable {
    private static final transient LogMgr c_logger = Log.get(TUKey.class);
    private static final String EMPTY_STRING = "";
    String _tag_1 = null;
    String _tag_2 = null;
    String _key = null;
    boolean _isExchangable = false;

    public void setup(String tag_1, String tag_2, String key, boolean isExchangable) {
        this._tag_1 = tag_1;
        this._tag_2 = tag_2;
        this._key = key;
        this._isExchangable = isExchangable;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug((Object)null, "setup", "New key tag_1=" + this._tag_1 + " tag_2=" + this._tag_2 + " key=" + key + " isExchangable =" + isExchangable);
        }
    }

    protected void cleanKey() {
        this._tag_1 = null;
        this._tag_2 = null;
        this._key = null;
        this._isExchangable = false;
    }

    public void setParams(SipServletRequestImpl request, String sessionId, SipServletMessageImpl.MessageType type) {
        Request req = request.getRequest();
        if (type == SipServletMessageImpl.MessageType.INCOMING_REQUEST) {
            this.setup(req.getToHeader().getTag(), req.getFromHeader().getTag(), sessionId, true);
        } else {
            this.setup(req.getFromHeader().getTag(), req.getToHeader().getTag(), sessionId, true);
        }
    }

    public void setParams(Response resp, String key, boolean isProxy) {
        if (isProxy) {
            this.setup(resp.getFromHeader().getTag(), resp.getToHeader().getTag(), key, true);
        } else {
            this.setup(resp.getFromHeader().getTag(), resp.getToHeader().getTag(), key, false);
        }
    }

    public void setParams(SipServletRequestImpl request, SipServletMessageImpl.MessageType type) {
        Request req = request.getRequest();
        if (type == SipServletMessageImpl.MessageType.INCOMING_REQUEST) {
            this.setup(req.getToHeader().getTag(), req.getFromHeader().getTag(), request.getCallId(), false);
        } else if (type == SipServletMessageImpl.MessageType.OUTGOING_REQUEST) {
            this.setup(req.getToHeader().getTag(), req.getFromHeader().getTag(), request.getCallId(), false);
        }
    }

    public void setParams(Response response, SipServletMessageImpl.MessageType type) {
        if (type == SipServletMessageImpl.MessageType.OUTGOING_RESPONSE) {
            this.setup(response.getToHeader().getTag(), response.getFromHeader().getTag(), response.getCallIdHeader().getCallId(), false);
        } else if (type == SipServletMessageImpl.MessageType.INCOMING_RESPONSE) {
            this.setup(response.getFromHeader().getTag(), response.getToHeader().getTag(), response.getCallIdHeader().getCallId(), false);
        }
    }

    public int hashCode() {
        int result = 0;
        if (this._tag_1 != null) {
            result ^= this._tag_1.hashCode();
        }
        if (this._tag_2 != null) {
            result ^= this._tag_2.hashCode();
        }
        if (this._key != null) {
            result ^= this._key.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        TUKey other = (TUKey)obj;
        if (!this._key.equals(other._key)) {
            return false;
        }
        if (this._isExchangable != other._isExchangable) {
            return false;
        }
        if (this._isExchangable) {
            String otherTag1;
            String tag2 = this._tag_2 == null ? EMPTY_STRING : this._tag_2;
            String otherTag2 = other._tag_2 == null ? EMPTY_STRING : other._tag_2;
            String tag1 = this._tag_1 == null ? EMPTY_STRING : this._tag_1;
            String string = otherTag1 = other._tag_1 == null ? EMPTY_STRING : other._tag_1;
            if (tag1.equals(otherTag1) && tag2.equals(otherTag2) || tag1.equals(otherTag2) && tag2.equals(otherTag1)) {
                return true;
            }
        } else {
            if (this._tag_1 != null && !this._tag_1.equals(other._tag_1)) {
                return false;
            }
            if (this._tag_1 == null && other._tag_1 != null) {
                return false;
            }
            if (this._tag_2 == null && other._tag_2 != null || other._tag_2 == null && this._tag_2 != null) {
                return false;
            }
            if (this._tag_2 == null && other._tag_2 == null) {
                return true;
            }
            if (!this._tag_2.equals(other._tag_2)) {
                return false;
            }
        }
        return true;
    }

    public void setTag_2(String tag_2) {
        this._tag_2 = tag_2;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append('[');
        buff.append(this._tag_1);
        buff.append(',');
        buff.append(this._tag_2);
        buff.append(',');
        buff.append(this._key);
        buff.append(',');
        buff.append(this._isExchangable);
        buff.append(']');
        return buff.toString();
    }

    public String get_tag_2() {
        return this._tag_2;
    }

    public TUKey clone() throws CloneNotSupportedException {
        TUKey newkey = new TUKey();
        newkey._isExchangable = this._isExchangable;
        newkey._key = this._key;
        newkey._tag_1 = this._tag_1;
        newkey._tag_2 = this._tag_2;
        return newkey;
    }
}

