/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.was;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.container.service.annotations.FragmentAnnotations;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.parser.SipServletDesc;
import com.ibm.ws.sip.container.router.SipAppDescManager;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.info.AnnotationInfo;
import com.ibm.wsspi.anno.info.AnnotationValue;
import com.ibm.wsspi.anno.info.ClassInfo;
import com.ibm.wsspi.anno.info.MethodInfo;
import com.ibm.wsspi.anno.info.PackageInfo;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.sip.annotation.SipApplication;
import javax.servlet.sip.annotation.SipApplicationKey;
import javax.servlet.sip.annotation.SipListener;
import javax.servlet.sip.annotation.SipServlet;

public class SipAppAnnotationsInfo {
    private static final TraceComponent tc = Tr.register(SipAppAnnotationsInfo.class);
    private String _appName;
    private String _appDescription;
    private String _mainServlet;
    private String _webAppName = null;
    private static String NAME = "name";
    private static String DISPLAY_NAME = "displayName";
    private static String DESCRIPTION = "description";
    private static String SESSION_TIMEOUT = "sessionTimeout";
    private static String DISTRIBUTABLE = "distributable";
    private static String PROXY_TIMEOUT = "proxyTimeout";
    private static String MAIN_SERVLET = "mainServlet";
    private static String LARGE_ICON = "largeIcon";
    private static String SMALL_ICON = "smallIcon";
    private static String LOAD_ON_STARTUP = "loadOnStartup";
    private static String APP_NAME = "applicationName";
    private WebAnnotations _webAnnotations = null;
    private FragmentAnnotations _fragmentAnnotations = null;
    private String error = null;

    public SipAppAnnotationsInfo(String moduleName, WebAnnotations webAnnotations, FragmentAnnotations fragmentAnnotations) throws UnableToAdaptException {
        this._webAnnotations = webAnnotations;
        this._fragmentAnnotations = fragmentAnnotations;
        this._webAppName = moduleName;
    }

    public SipAppDesc createSipAppDesc() {
        SipAppDesc newApp;
        block6: {
            if (this._fragmentAnnotations == null || this._webAnnotations == null) {
                return null;
            }
            newApp = SipAppDescManager.getInstance().getSipAppDesc(this._webAppName);
            try {
                newApp = this.readSipApplicationAnnotations(newApp);
                if (newApp != null) {
                    this.readSipServlets(newApp);
                    this.readSipListeners(newApp);
                    this.createSipAppKeys(newApp);
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"createSipAppDesc", (Object[])new Object[]{"Application has no appropriate DD , neigther @SipApplication annotation"});
                }
            }
            catch (UnableToAdaptException e2) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)"createSipAppDesc", (Object[])new Object[]{"UnableToAdaptException = " + e2.getStackTrace()});
            }
        }
        return newApp;
    }

    private void readSipListeners(SipAppDesc application) throws UnableToAdaptException {
        Set sipListenerClassesName = this._fragmentAnnotations.selectAnnotatedClasses(SipListener.class);
        if (sipListenerClassesName.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processSipServletAnnotations", (Object[])new Object[]{"No Listeners found "});
            }
            return;
        }
        LinkedList<String> _sipListeners = new LinkedList<String>();
        Iterator iterator = sipListenerClassesName.iterator();
        while (iterator.hasNext()) {
            String cName;
            String fullyQualifiedClassName = cName = (String)iterator.next();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"@SipListener found on class {0}", (Object[])new Object[]{fullyQualifiedClassName});
            }
            _sipListeners.add(fullyQualifiedClassName);
        }
        application.setSipListeners(_sipListeners);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"processSipServletAnnotations", (Object[])new Object[]{"Listeners = " + sipListenerClassesName});
        }
    }

    private void createSipAppKeys(SipAppDesc app) throws UnableToAdaptException {
        AnnotationTargets_Targets targets = this._webAnnotations.getAnnotationTargets();
        Set annotatedClasses = targets.getClassesWithMethodAnnotation(SipApplicationKey.class.getName());
        for (String cName : annotatedClasses) {
            ClassInfo classInfo = this._webAnnotations.getClassInfo(cName);
            List annotatedMethods = classInfo.getDeclaredMethods();
            for (MethodInfo mName : annotatedMethods) {
                AnnotationInfo annotation;
                if (!mName.isDeclaredAnnotationPresent() || (annotation = mName.getDeclaredAnnotation(SipApplicationKey.class)) == null) continue;
                app.setAppKeyInfo(cName, mName.getName());
                return;
            }
        }
    }

    private SipAppDesc readSipApplicationAnnotations(SipAppDesc sipApp) throws UnableToAdaptException {
        if (this._webAnnotations == null) {
            return null;
        }
        SipAppDesc appDesc = sipApp;
        AnnotationTargets_Targets targets = this._webAnnotations.getAnnotationTargets();
        Set appSessions = targets.getAnnotatedPackages(SipApplication.class.getName());
        for (String targetClassName : appSessions) {
            AnnotationInfo runAsAnnotation;
            PackageInfo info = this._webAnnotations.getInfoStore().getPackageInfo(targetClassName);
            String fullyQualifiedClassName = targetClassName;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"@SipApplication found on class {0}", (Object[])new Object[]{fullyQualifiedClassName});
            }
            if ((runAsAnnotation = info.getAnnotation(SipApplication.class.getName())) == null) continue;
            AnnotationValue value = runAsAnnotation.getValue(NAME);
            if (value != null) {
                this._appName = value.getStringValue();
                value = runAsAnnotation.getValue(DISPLAY_NAME);
                String displayName = null;
                displayName = value != null ? value.getStringValue() : this._appName;
                if (appDesc == null) {
                    appDesc = new SipAppDesc(displayName, this._appName);
                    appDesc.setWebAppName(this._webAppName);
                    SipAppDescManager.getInstance().addNewApp(appDesc);
                } else {
                    if (appDesc.getAppNameMember() == null) {
                        appDesc.setAppName(this._appName);
                    }
                    if (!appDesc.getAppName().equalsIgnoreCase(this._appName)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Application name in sip.xml should match the @SipApplication", (Object[])new Object[0]);
                        }
                        this.error = "Application name in sip.xml should match the @SipApplication";
                        return null;
                    }
                }
            } else if (appDesc == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"sip.xml or @SipApplication not found.", (Object[])new Object[0]);
                }
                this.error = "sip.xml or @SipApplication not found.";
                return null;
            }
            if ((value = runAsAnnotation.getValue(DESCRIPTION)) != null) {
                this._appDescription = value.getStringValue();
                if (appDesc.getDescription() == null || !appDesc.getDescription().equalsIgnoreCase(this._appDescription)) {
                    appDesc.setDescription(this._appDescription);
                }
            }
            if ((value = runAsAnnotation.getValue(SESSION_TIMEOUT)) != null) {
                int sessionTimeout = value.getIntValue();
                if (appDesc.getAppSessionTTL() != sessionTimeout) {
                    appDesc.setAppSessionTTL(sessionTimeout);
                }
            }
            if ((value = runAsAnnotation.getValue(PROXY_TIMEOUT)) != null) {
                int proxyTimeout = value.getIntValue();
                if (appDesc.getProxyTimeout() != proxyTimeout) {
                    appDesc.setProxyTimeout(proxyTimeout);
                }
            }
            if ((value = runAsAnnotation.getValue(DISTRIBUTABLE)) != null) {
                boolean distributable = value.getBoolean();
                if (appDesc.isDistributed() != distributable) {
                    appDesc.setIsDistributed(distributable);
                }
            }
            if ((value = runAsAnnotation.getValue(MAIN_SERVLET)) != null) {
                this._mainServlet = value.getStringValue();
                if (!(this._mainServlet == null || this._mainServlet.isEmpty() || appDesc.getMainSipletName() != null && appDesc.getMainSipletName().equalsIgnoreCase(this._mainServlet))) {
                    appDesc.setMainSipletName(this._mainServlet);
                }
            }
            if ((value = runAsAnnotation.getValue(SMALL_ICON)) != null) {
                // empty if block
            }
            if ((value = runAsAnnotation.getValue(LARGE_ICON)) == null) continue;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("After loading annotations, SipApplications: " + appSessions), (Object[])new Object[0]);
        }
        return appDesc;
    }

    private void readSipServlets(SipAppDesc application) throws UnableToAdaptException {
        String servletname = null;
        String applicationName = null;
        String description = null;
        int loadOnStartup = -1;
        boolean hasLoadOnStartupTag = false;
        AnnotationValue value = null;
        Set sipServletClassesName = this._fragmentAnnotations.selectAnnotatedClasses(SipServlet.class);
        for (String targetClassName : sipServletClassesName) {
            AnnotationInfo annotatedServlet;
            ClassInfo classInfo = this._webAnnotations.getClassInfo(targetClassName);
            String fullyQualifiedClassName = targetClassName;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"@SipServlet found on class {0}", (Object[])new Object[]{fullyQualifiedClassName});
            }
            if ((value = (annotatedServlet = classInfo.getAnnotation(SipServlet.class)).getValue(APP_NAME)) != null) {
                applicationName = value.getStringValue();
            }
            if ((value = annotatedServlet.getValue(NAME)) != null) {
                servletname = value.getStringValue();
            }
            if (servletname.equals("")) {
                String packageName = classInfo.getPackageName();
                servletname = classInfo.getName().split(packageName)[1].substring(1);
            }
            if ((value = annotatedServlet.getValue(DESCRIPTION)) != null && (description = value.getStringValue()) != null) {
                this._appDescription = description;
            }
            if ((value = annotatedServlet.getValue(LOAD_ON_STARTUP)) != null) {
                loadOnStartup = value.getInteger();
                if (!annotatedServlet.isValueDefaulted(LOAD_ON_STARTUP)) {
                    hasLoadOnStartupTag = true;
                }
            }
            SipServletDesc siplet = null;
            if (servletname.equalsIgnoreCase(this._mainServlet)) {
                siplet = new SipServletDesc(application, servletname, fullyQualifiedClassName, true, loadOnStartup, hasLoadOnStartupTag);
                application.setMainSipletName(this._mainServlet);
            } else {
                siplet = new SipServletDesc(application, servletname, fullyQualifiedClassName, false, loadOnStartup, hasLoadOnStartupTag);
            }
            application.addSipServlet(siplet);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)"processSipServletAnnotations", (Object[])new Object[]{"New Siplet = " + siplet});
        }
    }

    public String getError() {
        return this.error;
    }
}

