/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transport.connections.tls;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.ListeningPointImpl;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnectionFactory;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPListenningConnection;
import com.ibm.ws.sip.stack.transaction.transport.connections.tls.SIPListenningConnectionImpl;
import com.ibm.ws.sip.stack.transaction.transport.connections.tls.SSLRepertoire;
import com.ibm.ws.sip.stack.transaction.util.ApplicationProperties;
import jain.protocol.ip.sip.ListeningPoint;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class SIPConnectionFactoryImpl
implements SIPConnectionFactory {
    private static final LogMgr c_logger = Log.get(SIPConnectionFactoryImpl.class);
    private SSLSocketFactory m_socketFactory;
    private SSLServerSocketFactory m_serverSocketFactory;
    private boolean c_firstTime = true;
    private boolean c_instanciationPassed = false;

    @Override
    public SIPListenningConnection createListeningConnection(ListeningPoint lp) {
        SIPListenningConnectionImpl retval;
        block8: {
            retval = null;
            if (this.c_firstTime) {
                try {
                    SSLContext sslContext = null;
                    boolean isUseDeafultSSL = ApplicationProperties.getProperties().getBoolean("com.ibm.ssl.useSSLDefaults");
                    if (!isUseDeafultSSL) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "createListeningConnection", "initiating ssl");
                        }
                        SSLRepertoire repertoire = SIPConnectionFactoryImpl.createSSLRepertoire();
                        c_logger.traceDebug(this, "createListeningConnection", "created ssl repertoire:\n" + repertoire);
                        sslContext = this.initSSL(repertoire);
                    }
                    this.createSSLSockets(sslContext);
                }
                catch (IllegalStateException exp) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "createListeningConnection", exp.getMessage(), exp);
                    }
                }
                catch (Throwable t) {
                    if (!c_logger.isTraceDebugEnabled()) break block8;
                    c_logger.traceDebug(this, "createListeningConnection", t.getMessage(), t);
                }
            }
        }
        if (this.c_instanciationPassed) {
            retval = new SIPListenningConnectionImpl(this.m_serverSocketFactory, this.m_socketFactory, (ListeningPointImpl)lp);
        }
        return retval;
    }

    public static SSLRepertoire createSSLRepertoire() {
        String protocol = ApplicationProperties.getProperties().getString("sslProtocol");
        String contextProvider = ApplicationProperties.getProperties().getString("sslContextProvider");
        boolean isClientAuthenticationEnabled = ApplicationProperties.getProperties().getBoolean("sslClientAuthentication");
        String keyStoreFile = ApplicationProperties.getProperties().getString("sslKeyStore");
        String keyStorePassword = ApplicationProperties.getProperties().getString("sslKeyStorePassword");
        String keyManagerName = ApplicationProperties.getProperties().getString("sslKeyManager");
        String keyStoreProvider = ApplicationProperties.getProperties().getString("sslKeyStoreProvider");
        String keyStoreType = ApplicationProperties.getProperties().getString("sslKeyStoreType");
        String trustStoreFile = ApplicationProperties.getProperties().getString("sslTrustStore");
        String trustStorePassword = ApplicationProperties.getProperties().getString("sslTrustStorePassword");
        String trustManagerName = ApplicationProperties.getProperties().getString("sslTrustManager");
        String trustStoreProvider = ApplicationProperties.getProperties().getString("sslTrustStoreProvider");
        String trustStoreType = ApplicationProperties.getProperties().getString("sslTrustStoreType");
        String jsseProviderClassName = ApplicationProperties.getProperties().getString("sslProviderClassName");
        return new SSLRepertoire(protocol, contextProvider, isClientAuthenticationEnabled, keyStoreFile, keyStorePassword, keyManagerName, keyStoreProvider, keyStoreType, trustStoreFile, trustStorePassword, trustManagerName, trustStoreProvider, trustStoreType, jsseProviderClassName);
    }

    private SSLContext initSSL(SSLRepertoire repertoire) {
        try {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "initSSL", "getting SSLContext");
            }
            if (Security.getProvider(repertoire.getJsseProviderClassName()) == null) {
                Security.addProvider((Provider)Class.forName(repertoire.getJsseProviderClassName()).newInstance());
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "initSSL", "did not found IBM security Provider ,installing new one");
                }
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "initSSL", "found IBM secuirity Provider , not installing new one");
            }
            SSLContext sslContext = SSLContext.getInstance(repertoire.getProtocol(), repertoire.getContextProvider());
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "initSSL", "initing KeyStore...");
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(repertoire.getKeyManagerName(), repertoire.getContextProvider());
            KeyStore ks = KeyStore.getInstance(repertoire.getKeyStoreType(), repertoire.getKeyStoreProvider());
            ks.load(new FileInputStream(repertoire.getKeyStoreFile()), repertoire.getKeyStorePassword() == null ? null : repertoire.getKeyStorePassword().toCharArray());
            kmf.init(ks, repertoire.getKeyStorePassword().toCharArray());
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "initSSL", "initiated KeyStore");
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "initSSL", "initing TrustStore...");
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(repertoire.getTrustManagerName(), repertoire.getContextProvider());
            KeyStore ts = KeyStore.getInstance(repertoire.getTrustStoreType(), repertoire.getTrustStoreProvider());
            ts.load(new FileInputStream(repertoire.getTrustStoreFile()), repertoire.getTrustStorePassword() == null ? null : repertoire.getTrustStorePassword().toCharArray());
            tmf.init(ts);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "initSSL", "initiated TrustStore");
            }
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "initSSL", "initiated sslContext");
            }
            return sslContext;
        }
        catch (NoSuchProviderException e2) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "initSSL", e2.getMessage(), e2);
            }
            throw new IllegalStateException(e2.getMessage());
        }
        catch (NoSuchAlgorithmException e3) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "initSSL", e3.getMessage(), e3);
            }
            throw new IllegalStateException(e3.getMessage());
        }
        catch (KeyStoreException e4) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "initSSL", e4.getMessage(), e4);
            }
            throw new IllegalStateException(e4.getMessage());
        }
        catch (CertificateException e5) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "initSSL", e5.getMessage(), e5);
            }
            throw new IllegalStateException(e5.getMessage());
        }
        catch (FileNotFoundException e6) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "initSSL", e6.getMessage(), e6);
            }
            throw new IllegalStateException(e6.getMessage());
        }
        catch (IOException e7) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "initSSL", e7.getMessage(), e7);
            }
            throw new IllegalStateException(e7.getMessage());
        }
        catch (UnrecoverableKeyException e8) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "initSSL", e8.getMessage(), e8);
            }
            throw new IllegalStateException(e8.getMessage());
        }
        catch (KeyManagementException e9) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "initSSL", e9.getMessage(), e9);
            }
            throw new IllegalStateException(e9.getMessage());
        }
        catch (InstantiationException e10) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "initSSL", e10.getMessage(), e10);
            }
            throw new IllegalStateException(e10.getMessage());
        }
        catch (IllegalAccessException e11) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "initSSL", e11.getMessage(), e11);
            }
            throw new IllegalStateException(e11.getMessage());
        }
        catch (ClassNotFoundException e12) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "initSSL", e12.getMessage(), e12);
            }
            throw new IllegalStateException(e12.getMessage());
        }
    }

    private void createSSLSockets(SSLContext sslContext) {
        if (sslContext != null) {
            this.m_socketFactory = sslContext.getSocketFactory();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createSSLSockets", "got socketFactory");
            }
            this.m_serverSocketFactory = sslContext.getServerSocketFactory();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createSSLSockets", "got serverSocketFactory");
            }
        } else {
            this.m_socketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createSSLSockets", "got default socketFactory");
            }
            this.m_serverSocketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "createSSLSockets", "got default serverSocketFactory");
            }
        }
        this.c_firstTime = false;
        this.c_instanciationPassed = true;
    }
}

