/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.AccessException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.UtilDelegate;
import javax.rmi.CORBA.ValueHandler;
import javax.rmi.PortableRemoteObject;
import org.apache.yoko.logging.VerboseLogging;
import org.apache.yoko.osgi.ProviderLocator;
import org.apache.yoko.rmi.impl.CopyRecursionException;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.PortableRemoteObjectImpl;
import org.apache.yoko.rmi.impl.RMIState;
import org.apache.yoko.rmi.impl.RMIStub;
import org.apache.yoko.rmi.impl.RemoteDescriptor;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.apache.yoko.rmi.impl.ValueHandlerImpl;
import org.apache.yoko.util.PrivilegedActions;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_REQUIRED;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.UnknownException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class UtilImpl
implements UtilDelegate {
    private static final Logger logger = Logger.getLogger(UtilImpl.class.getName());
    private static final SecMan _secman = (SecMan)AccessController.doPrivileged(PrivilegedActions.action(SecMan::new));
    private static final ClassLoader BEST_GUESS_AT_EXTENSION_CLASS_LOADER;
    static final java.lang.Object READ_SERIALIZABLE_KEY;

    private static ClassLoader findFirstNonNullLoader(String ... classNames) {
        for (String className : classNames) {
            try {
                Class<?> c = Class.forName(className);
                ClassLoader cl = (ClassLoader)AccessController.doPrivileged(PrivilegedActions.action(c::getClassLoader));
                if (cl == null) continue;
                return cl;
            }
            catch (Exception | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public RemoteException mapSystemException(SystemException ex) {
        if (ex instanceof UnknownException) {
            Throwable orig = ((UnknownException)((java.lang.Object)ex)).originalEx;
            if (orig instanceof Error) {
                return new ServerError("Error occurred in server thread", (Error)orig);
            }
            if (orig instanceof RemoteException) {
                return new ServerException("RemoteException occurred in server thread", (Exception)orig);
            }
            if (orig instanceof RuntimeException) {
                throw (RuntimeException)orig;
            }
        }
        Class<?> exclass = ((java.lang.Object)((java.lang.Object)ex)).getClass();
        String name = exclass.getName();
        StringBuffer buf = new StringBuffer("CORBA ");
        String prefix = "org.omg.CORBA";
        if (name.startsWith("org.omg.CORBA")) {
            buf.append(name.substring("org.omg.CORBA".length() + 1));
        } else {
            buf.append(name);
        }
        buf.append(" ");
        buf.append(ex.minor);
        switch (ex.completed.value()) {
            case 0: {
                buf.append(" Yes");
                break;
            }
            case 1: {
                buf.append(" No");
                break;
            }
            case 2: {
                buf.append(" Maybe");
            }
        }
        String exceptionMessage = buf.toString();
        return this.createRemoteException(ex, exceptionMessage);
    }

    private RemoteException createRemoteException(SystemException sysEx, String s) {
        RemoteException result;
        try {
            throw sysEx;
        }
        catch (BAD_PARAM | COMM_FAILURE | MARSHAL e) {
            result = new MarshalException(s);
        }
        catch (INV_OBJREF | NO_IMPLEMENT | OBJECT_NOT_EXIST e) {
            result = new NoSuchObjectException(s);
        }
        catch (NO_PERMISSION e) {
            result = new AccessException(s);
        }
        catch (TRANSACTION_REQUIRED e) {
            result = TransactionExceptions.REQUIRED.create(s);
        }
        catch (TRANSACTION_ROLLEDBACK e) {
            result = TransactionExceptions.ROLLED_BACK.create(s);
        }
        catch (INVALID_TRANSACTION e) {
            result = TransactionExceptions.INVALID.create(s);
        }
        catch (SystemException e) {
            result = new RemoteException(s);
        }
        result.detail = sysEx;
        return result;
    }

    static SystemException mapRemoteException(RemoteException rex) {
        if (rex.detail instanceof SystemException) {
            return (SystemException)rex.detail;
        }
        if (rex.detail instanceof RemoteException) {
            rex = (RemoteException)rex.detail;
        }
        Throwable sysEx = rex instanceof NoSuchObjectException ? new INV_OBJREF(rex.getMessage()) : (rex instanceof AccessException ? new NO_PERMISSION(rex.getMessage()) : (rex instanceof MarshalException ? new MARSHAL(rex.getMessage()) : UtilImpl.createSystemException(rex)));
        sysEx.initCause((Throwable)rex);
        throw sysEx;
    }

    private static SystemException createSystemException(RemoteException rex) {
        return UtilImpl.createSystemException(rex, rex.getClass());
    }

    private static SystemException createSystemException(RemoteException rex, Class<?> fromClass) {
        switch (fromClass.getName()) {
            case "java.lang.Object": 
            case "java.lang.Throwable": 
            case "java.lang.Exception": 
            case "java.lang.RuntimeException": 
            case "java.lang.Error": 
            case "java.io.IOException": 
            case "java.rmi.RemoteException": {
                return new UnknownException((Throwable)rex);
            }
            case "javax.transaction.InvalidTransactionException": 
            case "jakarta.transaction.InvalidTransactionException": {
                return new INVALID_TRANSACTION(rex.getMessage());
            }
            case "javax.transaction.TransactionRolledbackException": 
            case "jakarta.transaction.TransactionRolledbackException": {
                return new TRANSACTION_ROLLEDBACK(rex.getMessage());
            }
            case "javax.transaction.TransactionRequiredException": 
            case "jakarta.transaction.TransactionRequiredException": {
                return new TRANSACTION_REQUIRED(rex.getMessage());
            }
        }
        return UtilImpl.createSystemException(rex, fromClass.getSuperclass());
    }

    public void writeAny(org.omg.CORBA.portable.OutputStream out, java.lang.Object obj) throws SystemException {
        ORB orb = ORB.init();
        Any any = orb.create_any();
        if (obj == null) {
            any.insert_Value(null);
        } else if (obj instanceof String) {
            any.insert_Value((Serializable)((java.lang.Object)((String)obj)));
        } else if (obj instanceof Object) {
            any.insert_Object((Object)obj);
        } else if (obj instanceof Any) {
            any.insert_any((Any)obj);
        } else if (obj instanceof IDLEntity) {
            any.insert_Value((Serializable)obj);
        } else if (obj instanceof Remote) {
            Object corba_obj;
            Remote ro = (Remote)obj;
            try {
                corba_obj = (Object)PortableRemoteObject.toStub((Remote)ro);
            }
            catch (NoSuchObjectException ex) {
                throw (MARSHAL)new MARSHAL("object not exported " + ro).initCause((Throwable)ex);
            }
            any.insert_Object(corba_obj);
        } else if (obj instanceof Serializable || obj instanceof Externalizable) {
            any.insert_Value((Serializable)obj);
        } else {
            throw new MARSHAL("cannot write as " + obj.getClass() + " to an Any");
        }
        out.write_any(any);
    }

    public java.lang.Object readAny(org.omg.CORBA.portable.InputStream in) throws SystemException {
        Any any = in.read_any();
        TypeCode typecode = any.type();
        switch (typecode.kind().value()) {
            case 0: 
            case 1: {
                return null;
            }
            case 29: 
            case 30: {
                return any.extract_Value();
            }
            case 32: {
                InputStream in23 = (InputStream)any.create_input_stream();
                return in23.read_abstract_interface();
            }
            case 18: {
                return any.extract_string();
            }
            case 14: {
                return any.extract_Object();
            }
            case 11: {
                return any.extract_any();
            }
        }
        String id = "<unknown>";
        try {
            id = typecode.id();
        }
        catch (BadKind badKind) {
            // empty catch block
        }
        throw new MARSHAL("cannot extract " + id + " (" + typecode.kind().value() + ") value from Any");
    }

    public void writeRemoteObject(org.omg.CORBA.portable.OutputStream out, java.lang.Object obj) throws SystemException {
        Object objref = null;
        if (obj == null) {
            out.write_Object(null);
            return;
        }
        if (obj instanceof Object) {
            objref = (Object)obj;
        } else if (obj instanceof Remote) {
            try {
                objref = (Stub)PortableRemoteObject.toStub((Remote)((Remote)obj));
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
            if (objref == null) {
                try {
                    PortableRemoteObject.exportObject((Remote)((Remote)obj));
                    objref = (Stub)PortableRemoteObject.toStub((Remote)((Remote)obj));
                }
                catch (RemoteException ex) {
                    throw (MARSHAL)new MARSHAL("cannot convert Remote to Object").initCause((Throwable)ex);
                }
            }
        } else {
            throw new MARSHAL("object is neither Remote nor org.omg.CORBA.Object: " + obj.getClass().getName());
        }
        out.write_Object(objref);
    }

    public void writeAbstractObject(org.omg.CORBA.portable.OutputStream out, java.lang.Object obj) {
        logger.finer("writeAbstractObject.1  out=" + out);
        if (!(obj instanceof Object) && !(obj instanceof Serializable) && obj instanceof Remote) {
            Object objref = null;
            try {
                objref = (Object)PortableRemoteObject.toStub((Remote)((Remote)obj));
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
            if (objref == null) {
                try {
                    PortableRemoteObject.exportObject((Remote)((Remote)obj));
                    objref = (Object)PortableRemoteObject.toStub((Remote)((Remote)obj));
                }
                catch (RemoteException ex) {
                    throw (MARSHAL)new MARSHAL("unable to export object").initCause((Throwable)ex);
                }
            }
            obj = objref;
        }
        OutputStream out_ = (OutputStream)out;
        logger.finer("writeAbstractObject.2  out=" + out);
        out_.write_abstract_interface(obj);
    }

    protected Map<Remote, Tie> tie_map() {
        return RMIState.current().tie_map;
    }

    public void registerTarget(Tie tie, Remote obj) {
        if (obj == null) {
            throw new IllegalArgumentException("remote object is null");
        }
        tie.setTarget(obj);
        this.tie_map().put(obj, tie);
    }

    public Tie getTie(Remote obj) {
        if (obj == null) {
            return null;
        }
        return this.tie_map().get(obj);
    }

    public ValueHandler createValueHandler() {
        return ValueHandlerImpl.get();
    }

    public String getCodebase(Class clz) {
        return null;
    }

    public Class loadClass(String name, String codebase, ClassLoader loader) throws ClassNotFoundException {
        if (VerboseLogging.CLASS_LOG.isLoggable(Level.FINEST)) {
            VerboseLogging.CLASS_LOG.finer(String.format("loadClass(\"%s\", \"%s\", %s)", name, codebase, loader));
        }
        return ((Stream)Arrays.stream(ClassLoadStrategy.values()).sequential()).map(strategy -> strategy.getAction(loader)).filter(Optional::isPresent).map(Optional::get).map(action -> action.tryToLoad(name)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new ClassNotFoundException(name));
    }

    private static ClassLoader getStackLoader() {
        ClassLoader thisLoader = UtilImpl.class.getClassLoader();
        VerboseLogging.CLASS_LOG.finest(() -> "Looking for stack loader other than loader of UtilImpl: " + thisLoader);
        for (Class candidateContextClass : _secman.getClassContext()) {
            ClassLoader candidateLoader = candidateContextClass.getClassLoader();
            if (candidateLoader == null) {
                VerboseLogging.CLASS_LOG.finest(() -> "Ignoring system class " + candidateContextClass.getName());
                continue;
            }
            if (thisLoader == candidateLoader) {
                VerboseLogging.CLASS_LOG.finest(() -> "Ignoring yoko class " + candidateContextClass.getName());
                continue;
            }
            VerboseLogging.CLASS_LOG.finer(() -> "Using " + candidateContextClass.getName() + "'s loader: " + candidateLoader);
            return candidateLoader;
        }
        return null;
    }

    public boolean isLocal(Stub stub) throws RemoteException {
        try {
            if (stub instanceof RMIStub) {
                return true;
            }
            return stub._is_local();
        }
        catch (SystemException ex) {
            throw this.mapSystemException(ex);
        }
    }

    public RemoteException wrapException(Throwable ex) {
        if (ex instanceof Error) {
            return new ServerError(ex.getMessage(), (Error)ex);
        }
        if (ex instanceof RemoteException) {
            return new ServerException(ex.getMessage(), (Exception)ex);
        }
        if (ex instanceof UnknownException) {
            UnknownException uex = (UnknownException)ex;
            return new ServerError(ex.getMessage(), uex.originalEx instanceof Error ? (Error)uex.originalEx : new Error("[OTHER EXCEPTION] " + ex.getMessage()));
        }
        if (ex instanceof SystemException) {
            return this.mapSystemException((SystemException)ex);
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        return new RemoteException(ex.getMessage(), ex);
    }

    static java.lang.Object copyRMIStub(RMIStub stub) throws RemoteException {
        Class targetClass;
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(PrivilegedActions.GET_CONTEXT_CLASS_LOADER);
        if (AccessController.doPrivileged(PrivilegedActions.action(stub._descriptor.type::getClassLoader)) == loader) {
            return stub;
        }
        RemoteDescriptor desc = stub._descriptor;
        try {
            targetClass = Util.loadClass((String)desc.type.getName(), (String)stub._get_codebase(), (ClassLoader)loader);
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.FINER, "copyRMIStub exception (current loader is: " + loader + ") " + ex.getMessage(), ex);
            throw new RemoteException("Class not found", ex);
        }
        return PortableRemoteObjectImpl.narrow1(RMIState.current(), (ObjectImpl)stub, targetClass);
    }

    public java.lang.Object copyObject(java.lang.Object obj, ORB orb) throws RemoteException {
        if (obj == null) {
            return null;
        }
        if (orb == null) {
            throw new NullPointerException();
        }
        if (obj instanceof String || obj instanceof Number) {
            return obj;
        }
        if (obj instanceof RMIStub) {
            return UtilImpl.copyRMIStub((RMIStub)((java.lang.Object)obj));
        }
        try {
            TypeRepository rep = RMIState.current().repo;
            CopyState state = new CopyState(rep);
            return state.copy(obj);
        }
        catch (CopyRecursionException ex) {
            throw new MarshalException("unable to resolve recursion", ex);
        }
        catch (SystemException ex) {
            throw this.mapSystemException(ex);
        }
    }

    public java.lang.Object[] copyObjects(java.lang.Object[] objs, ORB orb) throws RemoteException {
        if (objs == null || orb == null) {
            throw new NullPointerException();
        }
        if (objs.length == 0) {
            return objs;
        }
        try {
            TypeRepository rep = RMIState.current().repo;
            CopyState state = new CopyState(rep);
            try {
                return (java.lang.Object[])state.copy(objs);
            }
            catch (CopyRecursionException ex) {
                throw new MarshalException("unable to resolve recursion", ex);
            }
        }
        catch (SystemException ex) {
            throw this.mapSystemException(ex);
        }
    }

    public void unexportObject(Remote obj) throws NoSuchObjectException {
        if (obj == null) {
            return;
        }
        Map<Remote, Tie> tie_map = this.tie_map();
        if (tie_map == null) {
            return;
        }
        Tie tie = tie_map.remove(obj);
        if (tie == null) {
            logger.fine("unexporting unknown instance of " + obj.getClass().getName() + " from " + RMIState.current().getName());
            return;
        }
        logger.finer("unexporting instance of " + obj.getClass().getName() + " from " + RMIState.current().getName());
        tie.deactivate();
    }

    static {
        ClassLoader candidateLoader = (ClassLoader)AccessController.doPrivileged(PrivilegedActions.action(UtilImpl.class::getClassLoader));
        if (candidateLoader == null) {
            candidateLoader = UtilImpl.findFirstNonNullLoader("sun.net.spi.nameservice.dns.DNSNameService", "javax.transaction.UserTransaction");
        }
        for (ClassLoader l = candidateLoader; l != null; l = l.getParent()) {
            candidateLoader = l;
        }
        BEST_GUESS_AT_EXTENSION_CLASS_LOADER = candidateLoader;
        READ_SERIALIZABLE_KEY = new java.lang.Object();
    }

    static enum ClassLoadStrategy {
        PROVIDER_LOADER(l -> Optional.of(n -> ProviderLocator.loadClass((String)n, null, (ClassLoader)l))),
        STACK_LOADER(l -> Optional.ofNullable(UtilImpl.getStackLoader()).map(sl -> sl::loadClass)),
        THIS_LOADER(l -> Optional.ofNullable(l).map(gl -> gl::loadClass)),
        GIVEN_LOADER(l -> Optional.ofNullable(l).map(gl -> gl::loadClass)),
        CONTEXT_LOADER(l -> Optional.ofNullable(null == l ? (ClassLoader)AccessController.doPrivileged(PrivilegedActions.GET_CONTEXT_CLASS_LOADER) : null).map(ccl -> ccl::loadClass));

        private final Function<ClassLoader, Optional<ClassLoadAction>> fun;

        private ClassLoadStrategy(Function<ClassLoader, Optional<ClassLoadAction>> fun) {
            this.fun = fun;
        }

        final Optional<ClassLoadAction> getAction(ClassLoader givenLoader) {
            Optional<ClassLoadAction> optionalAction = this.fun.apply(givenLoader);
            VerboseLogging.CLASS_LOG.finest(() -> optionalAction.map(a -> "searching " + this.name() + "...").orElse("skipping " + this.name()));
            return optionalAction;
        }
    }

    @FunctionalInterface
    static interface ClassLoadAction {
        public Class<?> loadClass(String var1) throws ClassNotFoundException;

        default public Class<?> tryToLoad(String name) {
            try {
                Class<?> clazz = this.loadClass(name);
                if (clazz != null) {
                    VerboseLogging.CLASS_LOG.fine(() -> "found " + name);
                }
                return clazz;
            }
            catch (ClassNotFoundException ignored) {
                return null;
            }
        }
    }

    static class SecMan
    extends RMISecurityManager {
        SecMan() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }

    private static enum TransactionExceptions {
        REQUIRED("jakarta.transaction.TransactionRequiredException", "javax.transaction.TransactionRequiredException"),
        ROLLED_BACK("jakarta.transaction.TransactionRolledbackException", "javax.transaction.TransactionRolledbackException"),
        INVALID("jakarta.transaction.InvalidTransactionException", "javax.transaction.InvalidTransactionException");

        final List<String> remoteExceptionClassNames;

        private TransactionExceptions(String ... classNames) {
            this.remoteExceptionClassNames = Arrays.asList(classNames);
        }

        RemoteException create(String message) {
            return this.remoteExceptionClassNames.stream().map(this::loadClass).filter(Objects::nonNull).map(this::getSingleStringConstructor).filter(Objects::nonNull).map(cons -> (RemoteException)this.invokeConstructor((Constructor)cons, message)).filter(Objects::nonNull).map(RemoteException.class::cast).findFirst().orElseGet(() -> new RemoteException(message));
        }

        Class<? extends RemoteException> loadClass(String name) {
            try {
                Class clazz = Util.loadClass((String)name, null, null);
                if (RemoteException.class.isAssignableFrom(clazz)) {
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return null;
        }

        <T> Constructor<T> getSingleStringConstructor(Class<T> clazz) {
            try {
                return clazz.getConstructor(String.class);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }

        <T> T invokeConstructor(Constructor<T> ctor, String arg) {
            try {
                return ctor.newInstance(arg);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                return null;
            }
        }
    }
}

