/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.health30.services.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.CDIService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.health.services.HealthCheckBeanCallException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.health30.services.HealthCheck30CDIBeanInvoker;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/ejs/ras/TraceComponent;")
@InjectedFFDC
@Component(service={HealthCheck30CDIBeanInvoker.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class HealthCheck30CDIBeanInvokerImpl
implements HealthCheck30CDIBeanInvoker {
    private static final TraceComponent tc = Tr.register(HealthCheck30CDIBeanInvokerImpl.class);
    private final Map<String, BeanManager> beanManagers;
    private CDIService cdiService;
    static final long serialVersionUID = 5562340781042900425L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public HealthCheck30CDIBeanInvokerImpl() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[0]);
        }
        this.beanManagers = new HashMap<String, BeanManager>();
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    @Reference(service=CDIService.class)
    protected void setCdiService(CDIService cdiService) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setCdiService", (Object)new Object[]{cdiService});
        }
        this.cdiService = cdiService;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setCdiService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected void unsetCdiService(CDIService cdiService) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unsetCdiService", (Object)new Object[]{cdiService});
        }
        if (this.cdiService == cdiService) {
            this.cdiService = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unsetCdiService");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public Set<HealthCheckResponse> checkAllBeans(String appName, String moduleName, String healthCheckProcedure) throws HealthCheckBeanCallException {
        void var8_11;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkAllBeans", (Object)new Object[]{appName, moduleName, healthCheckProcedure});
        }
        BeanManager beanManager = this.getBeanManager(appName, moduleName);
        HashSet<HealthCheckResponse> retVal = new HashSet<HealthCheckResponse>();
        Set<Object> healthCheckBeans = new HashSet();
        String string = healthCheckProcedure;
        int n = -1;
        switch (string.hashCode()) {
            case 2337004: {
                if (!string.equals("LIVE")) break;
                boolean bl = false;
                break;
            }
            case 77848963: {
                if (!string.equals("READY")) break;
                boolean bl = true;
            }
        }
        switch (var8_11) {
            case 0: {
                healthCheckBeans = this.getHealthCheckLivenessBeans(beanManager);
                break;
            }
            case 1: {
                healthCheckBeans = this.getHealthCheckReadinessBeans(beanManager);
                break;
            }
            default: {
                healthCheckBeans = this.getAllHealthCheckBeans(beanManager);
            }
        }
        for (Object e : healthCheckBeans) {
            HealthCheck tempHCBean = (HealthCheck)e;
            try {
                retVal.add(tempHCBean.call());
            }
            catch (Throwable throwable) {
                void e2;
                FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.microprofile.health30.services.impl.HealthCheck30CDIBeanInvokerImpl", (String)"80", (Object)this, (Object[])new Object[]{appName, moduleName, healthCheckProcedure});
                HealthCheckBeanCallException hcbce = new HealthCheckBeanCallException((Throwable)e2);
                hcbce.setBeanName(e.getClass().toString());
                throw hcbce;
            }
            Tr.event((TraceComponent)tc, (String)("HealthCheck beanClass: " + e.getClass() + " called"));
        }
        HashSet<HealthCheckResponse> hashSet = retVal;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            hashSet = hashSet;
            Tr.exit((TraceComponent)tc, (String)"checkAllBeans", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private Set<Object> getHealthCheckLivenessBeans(BeanManager beanManager) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getHealthCheckLivenessBeans", (Object)new Object[]{beanManager});
        }
        HashSet<Object> hcLivenessBeans = new HashSet();
        HashSet<Object> hashSet = hcLivenessBeans = this.getHealthCheckBeans(beanManager, (Annotation)Liveness.Literal.INSTANCE);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            hashSet = hashSet;
            Tr.exit((TraceComponent)tc, (String)"getHealthCheckLivenessBeans", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private Set<Object> getHealthCheckReadinessBeans(BeanManager beanManager) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getHealthCheckReadinessBeans", (Object)new Object[]{beanManager});
        }
        HashSet<Object> hcReadinessBeans = new HashSet();
        HashSet<Object> hashSet = hcReadinessBeans = this.getHealthCheckBeans(beanManager, (Annotation)Readiness.Literal.INSTANCE);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            hashSet = hashSet;
            Tr.exit((TraceComponent)tc, (String)"getHealthCheckReadinessBeans", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private Set<Object> getAllHealthCheckBeans(BeanManager beanManager) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAllHealthCheckBeans", (Object)new Object[]{beanManager});
        }
        HashSet<Object> hcAllBeans = new HashSet<Object>();
        hcAllBeans.addAll(this.getHealthCheckLivenessBeans(beanManager));
        hcAllBeans.addAll(this.getHealthCheckReadinessBeans(beanManager));
        HashSet<Object> hashSet = hcAllBeans;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            hashSet = hashSet;
            Tr.exit((TraceComponent)tc, (String)"getAllHealthCheckBeans", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private Set<Object> getHealthCheckBeans(BeanManager beanManager, Annotation hcQualifier) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getHealthCheckBeans", (Object)new Object[]{beanManager, hcQualifier});
        }
        HashSet<Object> healthCheckBeans = new HashSet<Object>();
        if (beanManager != null) {
            Set beans = beanManager.getBeans(HealthCheck.class, new Annotation[]{hcQualifier});
            for (Bean bean : beans) {
                Tr.event((TraceComponent)tc, (String)("Bean Found: HealthCheck beanClass = " + bean.getBeanClass() + ", class = " + bean.getClass() + ", name = " + bean.getName()));
                healthCheckBeans.add(beanManager.getReference(bean, HealthCheck.class, beanManager.createCreationalContext((Contextual)bean)));
            }
        }
        HashSet<Object> hashSet = healthCheckBeans;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            hashSet = hashSet;
            Tr.exit((TraceComponent)tc, (String)"getHealthCheckBeans", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private BeanManager getBeanManager(String appName, String moduleName) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getBeanManager", (Object)new Object[]{appName, moduleName});
        }
        String key = appName + "#" + moduleName;
        BeanManager manager = this.beanManagers.get(key);
        if (manager == null) {
            if (this.beanManagers.containsKey(key) || this.cdiService == null) {
                BeanManager beanManager = null;
                if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                    beanManager = beanManager;
                    Tr.exit((TraceComponent)tc, (String)"getBeanManager", beanManager);
                }
                return beanManager;
            }
            manager = this.cdiService.getCurrentModuleBeanManager();
            this.beanManagers.put(key, manager);
        }
        BeanManager beanManager = manager;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            beanManager = beanManager;
            Tr.exit((TraceComponent)tc, (String)"getBeanManager", (Object)beanManager);
        }
        return beanManager;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public void removeModuleReferences(String appName, String moduleName) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeModuleReferences", (Object)new Object[]{appName, moduleName});
        }
        String key = appName + "#" + moduleName;
        this.beanManagers.remove(key);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeModuleReferences");
        }
    }
}

