/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.utility.http;

import com.ibm.ws.jbatch.utility.http.EntityReader;
import com.ibm.ws.jbatch.utility.http.HttpUtils;
import com.ibm.ws.jbatch.utility.http.StringEntityReader;
import com.ibm.ws.jbatch.utility.utils.IOUtils;
import com.ibm.ws.jbatch.utility.utils.ObjectUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;

public class Response {
    private HttpURLConnection con;

    public Response(HttpURLConnection con) {
        this.con = con;
    }

    public <T> T readEntity(EntityReader<T> entityReader) throws IOException {
        return entityReader.readEntity(this.getInputStream());
    }

    public InputStream getInputStream() throws IOException {
        try {
            return this.con.getInputStream();
        }
        catch (IOException e) {
            this.handleFailureResponse(e);
            throw e;
        }
    }

    protected void handleFailureResponse(IOException e) throws IOException {
        Object errorResponse = new StringEntityReader().readEntity(this.con.getErrorStream());
        if (errorResponse.isEmpty()) {
            throw e;
        }
        throw new IOException(e.getMessage() + ": " + errorResponse.toString(), e);
    }

    public String getHeader(String name) {
        return this.con.getHeaderField(name);
    }

    public void copyToStream(OutputStream outputStream) throws IOException {
        InputStream responseStream = this.getInputStream();
        String contentType = this.getHeader("Content-Type");
        if (contentType != null && contentType.contains("text/plain")) {
            String charsetName = ObjectUtils.firstNonNull(HttpUtils.parseHeaderParameter(contentType, "charset"), "UTF-8");
            IOUtils.copyReader(new InputStreamReader(responseStream, charsetName), new OutputStreamWriter(outputStream));
        } else {
            IOUtils.copyStream(responseStream, outputStream);
        }
    }
}

