/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.utility.utils;

import com.ibm.ws.security.utility.utils.CommandUtils;
import java.io.InputStream;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class SAFEncryptionKey {
    private String keyring;
    private String type;
    private String label;
    private static final String racfPass = "password";
    private KeyStore keystore = null;
    Pattern safKeyringPattern = Pattern.compile("(safkeyring|(safkeyringhw|safkeyringhybrid)):/{2,3}\\w.*");
    private final Map<String, String> handlers = new HashMap<String, String>();

    public SAFEncryptionKey(String saf_keyring, String saf_type, String saf_label) throws Exception {
        if (saf_keyring != null) {
            this.keyring = saf_keyring;
        }
        if (saf_type != null) {
            this.type = saf_type;
        }
        if (saf_label != null) {
            this.label = saf_label;
        }
        this.setSAFHandlers();
        this.validateConfig();
    }

    protected String getMessage(String key, Object ... args) {
        return CommandUtils.getMessage(key, args);
    }

    public void setSAFHandlers() {
        this.handlers.put("safkeyring", "com.ibm.crypto.provider.safkeyring.Handler");
        this.handlers.put("safkeyringhw", "com.ibm.crypto.hdwrCCA.provider.safkeyring.Handler");
        this.handlers.put("safkeyringhybrid", "com.ibm.crypto.ibmjcehybrid.provider.safkeyring.Handler");
    }

    private void validateConfig() throws Exception {
        block6: {
            this.keystore = this.loadKeyStore();
            X509Certificate certEntry = null;
            if (this.keystore != null) {
                if (!this.keystore.containsAlias(this.label)) {
                    String msg = this.getMessage("saf.label.does.not.exist", this.label, this.keyring);
                    throw new Exception(msg);
                }
                if (!this.keystore.isKeyEntry(this.label)) {
                    String msg = "The " + this.label + " certificate is not a key entry.  The certificate needs to be a key entry for use as an AES password encryption key.";
                    throw new Exception(msg);
                }
                certEntry = (X509Certificate)this.keystore.getCertificate(this.label);
                if (!this.checkIfCertDateIsGood(certEntry)) {
                    String msg = this.getMessage("saf.cert.expired", this.label);
                    throw new Exception(msg);
                }
                break block6;
            }
            String msg = this.getMessage("saf.keyring.does.not.exist", this.keyring);
            throw new Exception(msg);
        }
    }

    private boolean checkIfCertDateIsGood(X509Certificate cert) {
        if (cert != null) {
            long currentTime = System.currentTimeMillis();
            long notAfter = cert.getNotAfter().getTime();
            return notAfter >= currentTime;
        }
        return false;
    }

    private InputStream openKeyStoreURL() throws Exception {
        URLStreamHandler handler = null;
        String effectiveLocation = this.processKeyringURL(this.keyring);
        if (effectiveLocation != null) {
            try {
                String keyringPrefix = effectiveLocation.substring(0, effectiveLocation.indexOf(":"));
                String jceHandler = this.handlers.get(keyringPrefix.toLowerCase());
                handler = (URLStreamHandler)Class.forName(jceHandler).newInstance();
            }
            catch (Exception e) {
                String msg = "Failed to set SAF handler associated with the keyring: " + effectiveLocation + ".  Extended error: " + e.getMessage();
                throw new Exception(msg);
            }
        }
        URL url = new URL(null, effectiveLocation, handler);
        InputStream fis = url.openStream();
        return fis;
    }

    private KeyStore loadKeyStore() throws Exception {
        try {
            KeyStore ks = KeyStore.getInstance(this.type);
            InputStream is = this.openKeyStoreURL();
            ks.load(is, racfPass.toCharArray());
            return ks;
        }
        catch (Exception e) {
            String msg = "An exception occured when loading the " + this.keyring + " SAF key ring.  No key can be retrieved to use as the AES password encryption key.  Extended error is: " + e.getMessage();
            throw new Exception(msg);
        }
    }

    private String processKeyringURL(String safKeyringURL) {
        String processedUrl = null;
        if (safKeyringURL != null && this.safKeyringPattern.matcher(safKeyringURL).matches()) {
            processedUrl = safKeyringURL;
            if (!safKeyringURL.contains("///")) {
                int index = safKeyringURL.indexOf("//");
                StringBuffer sb = new StringBuffer(safKeyringURL);
                sb.insert(index, "/");
                processedUrl = sb.toString();
            }
        }
        return processedUrl;
    }

    public String getKey() throws Exception {
        Key key = null;
        Key privKey = null;
        try {
            if (this.keystore != null && this.label != null && (key = this.keystore.getKey(this.label, racfPass.toCharArray())) instanceof PrivateKey) {
                privKey = (PrivateKey)key;
            }
        }
        catch (Exception e) {
            String msg = "An exception occurred during the " + this.label + " private key access.  No key can be retrieved for use as the AES password encryption key.  Extended error: " + e.getMessage();
            throw new Exception(msg);
        }
        byte[] keyBytes = privKey.getEncoded();
        String keyString = new String(keyBytes);
        return keyString;
    }
}

