/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.ContextualAction;
import com.ibm.ws.concurrent.internal.LastExecutionImpl;
import com.ibm.ws.concurrent.internal.ManagedScheduledExecutorServiceImpl;
import com.ibm.ws.concurrent.internal.Utils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.threadcontext.ThreadContext;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.concurrent.AbortedException;
import javax.enterprise.concurrent.LastExecution;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.concurrent.ManagedTask;
import javax.enterprise.concurrent.ManagedTaskListener;
import javax.enterprise.concurrent.SkippedException;
import javax.enterprise.concurrent.Trigger;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ScheduledTask<T>
implements Callable<T> {
    private static final TraceComponent tc = Tr.register(ScheduledTask.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
    private final Long fixedDelay;
    private final Long fixedRate;
    final FutureImpl future = new FutureImpl();
    private final Long initialDelay;
    private final boolean isCallable;
    private volatile LastExecution lastExecution;
    private final ManagedTaskListener listener;
    private final ManagedScheduledExecutorServiceImpl managedExecSvc;
    private volatile long nextExecutionTime;
    private final AtomicReference<Result> resultRef = new AtomicReference<Result>(new Result());
    private final Object task;
    private final Date taskScheduledTime = new Date();
    private final long taskScheduledNanos = System.nanoTime();
    private final ThreadContextDescriptor threadContextDescriptor;
    private final Trigger trigger;
    private final TimeUnit unit;
    static final long serialVersionUID = -7808585572388892585L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    ScheduledTask(ManagedScheduledExecutorServiceImpl managedExecSvc, Object task, boolean isCallable, long initialDelay, Long fixedDelay, Long fixedRate, TimeUnit unit) {
        Status status;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        this.fixedDelay = fixedDelay;
        this.fixedRate = fixedRate;
        this.initialDelay = initialDelay;
        this.isCallable = isCallable;
        this.listener = task instanceof ManagedTask ? ((ManagedTask)task).getManagedTaskListener() : null;
        this.managedExecSvc = managedExecSvc;
        this.trigger = null;
        this.unit = unit;
        if (task instanceof ContextualAction) {
            ContextualAction a = (ContextualAction)task;
            this.task = a.getAction();
            this.threadContextDescriptor = a.getContextDescriptor();
        } else {
            this.task = task;
            Map<String, String> execProps = managedExecSvc.getExecutionProperties(task);
            try {
                this.threadContextDescriptor = managedExecSvc.captureThreadContext(execProps);
            }
            catch (NullPointerException nullPointerException) {
                void x;
                FFDCFilter.processException((Throwable)nullPointerException, (String)"com.ibm.ws.concurrent.internal.ScheduledTask", (String)"237", (Object)this, (Object[])new Object[]{managedExecSvc, task, isCallable, initialDelay, fixedDelay, fixedRate, unit});
                throw x;
            }
            catch (Throwable x) {
                FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.internal.ScheduledTask", (String)"239", (Object)this, (Object[])new Object[]{managedExecSvc, task, isCallable, initialDelay, fixedDelay, fixedRate, unit});
                throw new RejectedExecutionException(x);
            }
        }
        this.nextExecutionTime = this.taskScheduledNanos + unit.toNanos(initialDelay);
        Result result = this.resultRef.get();
        if (this.listener != null) {
            ThreadContext tranContextRestorer = managedExecSvc.suspendTransaction();
            try {
                result.executionThread = Thread.currentThread();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)"taskSubmitted", (Object[])new Object[]{managedExecSvc, this.task});
                }
                this.listener.taskSubmitted((Future)this.future, (ManagedExecutorService)managedExecSvc, this.task);
            }
            finally {
                result.executionThread = null;
                if (tranContextRestorer != null) {
                    tranContextRestorer.taskStopping();
                }
            }
        }
        if ((status = result.getStatus()).type == Status.Type.NONE && result.compareAndSet(status, new Status(Status.Type.SUBMITTED, null, null, false))) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("schedule " + initialDelay + ' ' + (Object)((Object)unit) + " from now"), (Object[])new Object[0]);
            }
            ScheduledExecutorService scheduledExecSvc = managedExecSvc.scheduledExecSvc;
            ScheduledFuture scheduledFuture = scheduledExecSvc.schedule(this, initialDelay, unit);
            this.future.scheduledFutureRef.set(scheduledFuture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    ScheduledTask(ManagedScheduledExecutorServiceImpl managedExecSvc, Object task, boolean isCallable, Trigger trigger) {
        Status status;
        Date nextExecutionDate;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        this.fixedDelay = null;
        this.fixedRate = null;
        this.initialDelay = null;
        this.isCallable = isCallable;
        this.listener = task instanceof ManagedTask ? ((ManagedTask)task).getManagedTaskListener() : null;
        this.managedExecSvc = managedExecSvc;
        this.trigger = trigger;
        this.unit = TimeUnit.MILLISECONDS;
        if (task instanceof ContextualAction) {
            ContextualAction a = (ContextualAction)task;
            this.task = a.getAction();
            this.threadContextDescriptor = a.getContextDescriptor();
        } else {
            this.task = task;
            Map<String, String> execProps = managedExecSvc.getExecutionProperties(task);
            try {
                this.threadContextDescriptor = managedExecSvc.captureThreadContext(execProps);
            }
            catch (Throwable throwable) {
                void x;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.concurrent.internal.ScheduledTask", (String)"303", (Object)this, (Object[])new Object[]{managedExecSvc, task, isCallable, trigger});
                throw new RejectedExecutionException((Throwable)x);
            }
        }
        try {
            this.lastExecution = null;
            nextExecutionDate = trigger.getNextRunTime(null, this.taskScheduledTime);
        }
        catch (Throwable x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.internal.ScheduledTask", (String)"311", (Object)this, (Object[])new Object[]{managedExecSvc, task, isCallable, trigger});
            throw new RejectedExecutionException(x);
        }
        if (nextExecutionDate == null) {
            throw new RejectedExecutionException("Trigger.getNextRunTime: null");
        }
        this.nextExecutionTime = nextExecutionDate.getTime();
        long delay = this.nextExecutionTime - this.taskScheduledTime.getTime();
        Result result = this.resultRef.get();
        if (this.listener != null) {
            ThreadContext tranContextRestorer = managedExecSvc.suspendTransaction();
            try {
                result.executionThread = Thread.currentThread();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)"taskSubmitted", (Object[])new Object[]{managedExecSvc, this.task});
                }
                this.listener.taskSubmitted((Future)this.future, (ManagedExecutorService)managedExecSvc, this.task);
            }
            finally {
                result.executionThread = null;
                if (tranContextRestorer != null) {
                    tranContextRestorer.taskStopping();
                }
            }
        }
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"getNextRunTime", (Object[])new Object[]{"taskScheduled " + Utils.toString(this.taskScheduledTime), "nextRunTime = " + Utils.toString(nextExecutionDate)});
        }
        if ((status = result.getStatus()).type == Status.Type.NONE && result.compareAndSet(status, new Status(Status.Type.SUBMITTED, null, null, false))) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("schedule " + delay + "ms from now"), (Object[])new Object[0]);
            }
            ScheduledExecutorService scheduledExecSvc = managedExecSvc.scheduledExecSvc;
            ScheduledFuture scheduledFuture = scheduledExecSvc.schedule(this, delay, TimeUnit.MILLISECONDS);
            this.future.scheduledFutureRef.set(scheduledFuture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @FFDCIgnore(value={Throwable.class})
    public T call() throws Exception {
        block84: {
            trace = TraceComponent.isAnyTracingEnabled();
            if (this.future.isCancelled()) {
                if (trace && ScheduledTask.tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)ScheduledTask.tc, (String)"canceled - not running the task", (Object[])new Object[0]);
                }
                return null;
            }
            resultForThisExecution = result = this.resultRef.get();
            skipped = null;
            done = false;
            taskResult = null;
            contextAppliedToThread = null;
            Result.access$802(resultForThisExecution, Thread.currentThread());
            try {
                contextAppliedToThread = this.threadContextDescriptor.taskStarting();
                if (this.trigger != null) {
                    try {
                        if (this.trigger.skipRun(this.lastExecution, new Date(this.nextExecutionTime))) {
                            skipped = new Status<T>(Status.Type.SKIPPED, null, null, false);
                        }
                    }
                    catch (Throwable x) {
                        Tr.error((TraceComponent)ScheduledTask.tc, (String)"CWWKC1103.skip.run.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x});
                        skipped = new Status<T>(Status.Type.SKIPPED, null, x, false);
                    }
                }
                nextExecutionDate = null;
                if (skipped == null) {
                    if (this.listener != null) {
                        try {
                            if (TraceComponent.isAnyTracingEnabled() && ScheduledTask.tc.isEventEnabled()) {
                                Tr.event((Object)this, (TraceComponent)ScheduledTask.tc, (String)"taskStarting", (Object[])new Object[]{this.managedExecSvc, this.task});
                            }
                            this.listener.taskStarting((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task);
                        }
                        catch (Throwable var10_11) {
                            done = Status.access$200(Result.access$900(result)) == Status.Type.CANCELED;
                            throw var10_11;
                        }
                        done = Status.access$200(Result.access$900(result)) == Status.Type.CANCELED;
                    }
                    if (Status.access$200(status = Result.access$900(result)) == Status.Type.SUBMITTED && Result.access$1000(result, status, new Status<T>(Status.Type.STARTED, null, null, false))) {
                        try {
                            if (this.trigger == null) {
                                if (this.isCallable) {
                                    taskResult = (T)((Callable)this.task).call();
                                } else {
                                    ((Runnable)this.task).run();
                                }
                            } else {
                                startTime = System.currentTimeMillis();
                                if (this.isCallable) {
                                    taskResult = (T)((Callable)this.task).call();
                                } else {
                                    ((Runnable)this.task).run();
                                }
                                endTime = System.currentTimeMillis();
                                execProps = this.threadContextDescriptor.getExecutionProperties();
                                if (this.managedExecSvc.eeVersion < 9) {
                                    identityName = (String)execProps.get("javax.enterprise.concurrent.IDENTITY_NAME");
                                    if (identityName == null) {
                                        identityName = (String)execProps.get("jakarta.enterprise.concurrent.IDENTITY_NAME");
                                    }
                                } else {
                                    identityName = (String)execProps.get("jakarta.enterprise.concurrent.IDENTITY_NAME");
                                    if (identityName == null) {
                                        identityName = (String)execProps.get("javax.enterprise.concurrent.IDENTITY_NAME");
                                    }
                                }
                                this.lastExecution = new LastExecutionImpl(identityName, this.nextExecutionTime, startTime, endTime, taskResult);
                            }
                        }
                        catch (Throwable x) {
                            Tr.error((TraceComponent)ScheduledTask.tc, (String)"CWWKC1101.task.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x});
                            status = Result.access$900(result);
                            if (Status.access$200(status) == Status.Type.CANCELED) {
                                Result.access$1000(result, status, new Status<T>(Status.Type.CANCELED, null, x, true));
                            } else if (Status.access$200(status) == Status.Type.STARTED) {
                                Result.access$1000(result, status, new Status<T>(Status.Type.DONE, null, x, true));
                            }
                            Result.access$1200(result).countDown();
                        }
                        status = Result.access$900(result);
                        if (Status.access$200(status) == Status.Type.STARTED) {
                            if (this.trigger == null) {
                                Result.access$1000(result, status, new Status<T>(Status.Type.DONE, taskResult, null, this.fixedDelay == null && this.fixedRate == null));
                            } else {
                                nextExecutionDate = this.trigger.getNextRunTime(this.lastExecution, this.taskScheduledTime);
                                if (TraceComponent.isAnyTracingEnabled() && ScheduledTask.tc.isDebugEnabled()) {
                                    Tr.debug((Object)this, (TraceComponent)ScheduledTask.tc, (String)"getNextRunTime", (Object[])new Object[]{this.trigger, this.lastExecution, "taskScheduled " + Utils.toString(this.taskScheduledTime), "nextRunTime = " + Utils.toString(nextExecutionDate)});
                                }
                                Result.access$1000(result, status, new Status<T>(Status.Type.DONE, taskResult, null, nextExecutionDate == null));
                            }
                            Result.access$1200(result).countDown();
                        }
                        done = true;
                        if (this.listener != null) {
                            try {
                                if (Status.access$200(status) == Status.Type.CANCELED) {
                                    try {
                                        cancelX = new CancellationException(Tr.formatMessage((TraceComponent)ScheduledTask.tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{this.getName(), this.managedExecSvc.name}));
                                        if (trace && ScheduledTask.tc.isEventEnabled()) {
                                            Tr.event((Object)this, (TraceComponent)ScheduledTask.tc, (String)"taskCanceled", (Object[])new Object[]{this.managedExecSvc, this.task, cancelX});
                                        }
                                        this.listener.taskAborted((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, (Throwable)cancelX);
                                    }
                                    catch (Throwable x) {
                                        Tr.error((TraceComponent)ScheduledTask.tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x});
                                    }
                                }
                                failure = Status.access$500(Result.access$900(result));
                                if (trace && ScheduledTask.tc.isEventEnabled()) {
                                    Tr.event((Object)this, (TraceComponent)ScheduledTask.tc, (String)"taskDone", (Object[])new Object[]{this.managedExecSvc, this.task, failure});
                                }
                                this.listener.taskDone((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, failure);
                            }
                            catch (Throwable x) {
                                Tr.error((TraceComponent)ScheduledTask.tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x});
                            }
                        }
                    }
                } else {
                    try {
                        status = Result.access$900(result);
                        if (Status.access$200(status) == Status.Type.SUBMITTED) {
                            Result.access$1000(result, status, skipped);
                        }
                        nextExecutionDate = this.trigger.getNextRunTime(this.lastExecution, this.taskScheduledTime);
                        if (TraceComponent.isAnyTracingEnabled() && ScheduledTask.tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)ScheduledTask.tc, (String)"getNextRunTime", (Object[])new Object[]{this.trigger, this.lastExecution, "taskScheduled " + Utils.toString(this.taskScheduledTime), "nextRunTime = " + Utils.toString(nextExecutionDate)});
                        }
                        if (nextExecutionDate == null) {
                            Result.access$1000(result, skipped, new Status<T>(Status.Type.SKIPPED, null, Status.access$500(skipped), true));
                        }
                        Result.access$1200(result).countDown();
                        ** if (this.listener == null) goto lbl-1000
                    }
                    catch (Throwable var16_28) {
                        Result.access$1200(result).countDown();
                        if (this.listener != null) {
                            if (TraceComponent.isAnyTracingEnabled() && ScheduledTask.tc.isEventEnabled()) {
                                Tr.event((Object)this, (TraceComponent)ScheduledTask.tc, (String)"taskAborted(skipped)", (Object[])new Object[]{this.managedExecSvc, this.task});
                            }
                            this.listener.taskAborted((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, (Throwable)new SkippedException(Status.access$500(skipped)));
                        }
                        throw var16_28;
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (TraceComponent.isAnyTracingEnabled() && ScheduledTask.tc.isEventEnabled()) {
                            Tr.event((Object)this, (TraceComponent)ScheduledTask.tc, (String)"taskAborted(skipped)", (Object[])new Object[]{this.managedExecSvc, this.task});
                        }
                        this.listener.taskAborted((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, (Throwable)new SkippedException(Status.access$500(skipped)));
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                    if (this.listener != null) {
                        if (TraceComponent.isAnyTracingEnabled() && ScheduledTask.tc.isEventEnabled()) {
                            Tr.event((Object)this, (TraceComponent)ScheduledTask.tc, (String)"taskDone(skipped)", (Object[])new Object[]{this.managedExecSvc, this.task});
                        }
                        this.listener.taskDone((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, null);
                    }
                }
                if (Status.access$300(status = Result.access$900(result)) || Status.access$200(status) != Status.Type.DONE && Status.access$200(status) != Status.Type.SKIPPED) break block84;
                if (trace && ScheduledTask.tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)ScheduledTask.tc, (String)"DONE-->NONE (reset for next result)", (Object[])new Object[0]);
                }
                result = new Result();
                this.resultRef.set(result);
                done = false;
                if (this.fixedDelay != null) {
                    delay = this.fixedDelay;
                    this.nextExecutionTime = System.nanoTime() + this.unit.toNanos(delay);
                } else if (this.fixedRate != null) {
                    nanoTime = System.nanoTime();
                    elapsed = this.unit.convert(nanoTime - this.taskScheduledNanos, TimeUnit.NANOSECONDS) - this.initialDelay;
                    delay = (elapsed / this.fixedRate + 1L) * this.fixedRate - elapsed;
                    this.nextExecutionTime = nanoTime + this.unit.toNanos(delay);
                } else {
                    this.nextExecutionTime = nextExecutionDate.getTime();
                    delay = this.nextExecutionTime - System.currentTimeMillis();
                }
                if (delay < 0L) {
                    delay = 0L;
                }
                if (this.listener != null) {
                    try {
                        Result.access$802(result, Thread.currentThread());
                        if (TraceComponent.isAnyTracingEnabled() && ScheduledTask.tc.isEventEnabled()) {
                            Tr.event((Object)this, (TraceComponent)ScheduledTask.tc, (String)"taskSubmitted", (Object[])new Object[]{this.managedExecSvc, this.task});
                        }
                        this.listener.taskSubmitted((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task);
                    }
                    finally {
                        Result.access$802(result, null);
                    }
                }
                if (Status.access$200(status = Result.access$900(result)) == Status.Type.NONE && Result.access$1000(result, status, new Status<T>(Status.Type.SUBMITTED, null, null, false))) {
                    if (trace && ScheduledTask.tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)ScheduledTask.tc, (String)("reschedule " + delay + ' ' + (Object)this.unit + " from now"), (Object[])new Object[0]);
                    }
                    scheduledFuture = this.managedExecSvc.scheduledExecSvc.schedule(this, delay, this.unit);
                    FutureImpl.access$1100(this.future).set(scheduledFuture);
                }
            }
            catch (Throwable x) {
                if (contextAppliedToThread == null && x instanceof IllegalStateException && FrameworkState.isStopping()) {
                    if (trace && ScheduledTask.tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)ScheduledTask.tc, (String)"Task not started due to server shutdown", (Object[])new Object[]{this.getName(), x});
                    }
                } else {
                    Tr.error((TraceComponent)ScheduledTask.tc, (String)"CWWKC1101.task.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x});
                }
                if (!Status.access$300(status = Result.access$900(result))) {
                    newStatus = Status.access$200(status) == Status.Type.STARTED ? new Status<T>(Status.Type.DONE, null, x, true) : new Status<T>(Status.Type.ABORTED, null, x, true);
                    Result.access$1000(result, status, newStatus);
                }
                Result.access$1200(result).countDown();
                if (this.listener != null && !done) {
                    try {
                        block86: {
                            try {
                                if (skipped != null || Status.access$200(status) == Status.Type.STARTED) break block86;
                                if (TraceComponent.isAnyTracingEnabled() && ScheduledTask.tc.isEventEnabled()) {
                                    Tr.event((Object)this, (TraceComponent)ScheduledTask.tc, (String)"taskAborted", (Object[])new Object[]{this.managedExecSvc});
                                }
                                this.listener.taskAborted((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, (Throwable)new AbortedException(x));
                            }
                            catch (Throwable var18_30) {
                                if (TraceComponent.isAnyTracingEnabled() && ScheduledTask.tc.isEventEnabled()) {
                                    Tr.event((Object)this, (TraceComponent)ScheduledTask.tc, (String)"taskDone", (Object[])new Object[]{this.managedExecSvc, this.task, x});
                                }
                                this.listener.taskDone((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, x);
                                throw var18_30;
                            }
                        }
                        if (TraceComponent.isAnyTracingEnabled() && ScheduledTask.tc.isEventEnabled()) {
                            Tr.event((Object)this, (TraceComponent)ScheduledTask.tc, (String)"taskDone", (Object[])new Object[]{this.managedExecSvc, this.task, x});
                        }
                        this.listener.taskDone((Future)this.future, (ManagedExecutorService)this.managedExecSvc, this.task, x);
                    }
                    catch (Throwable t) {
                        Tr.error((TraceComponent)ScheduledTask.tc, (String)"CWWKC1102.listener.failed", (Object[])new Object[]{this.getName(), this.managedExecSvc.name, x});
                    }
                }
                if (x instanceof Exception) {
                    throw (Exception)x;
                }
                throw (Error)x;
            }
            finally {
                Result.access$802(resultForThisExecution, null);
                if (contextAppliedToThread != null) {
                    this.threadContextDescriptor.taskStopping(contextAppliedToThread);
                }
            }
        }
        return taskResult;
    }

    @Trivial
    final String getName() {
        Map execProps = this.threadContextDescriptor.getExecutionProperties();
        String taskName = null;
        if (execProps != null) {
            if (this.managedExecSvc.eeVersion < 9) {
                taskName = (String)execProps.get("javax.enterprise.concurrent.IDENTITY_NAME");
                if (taskName == null) {
                    taskName = (String)execProps.get("jakarta.enterprise.concurrent.IDENTITY_NAME");
                }
            } else {
                taskName = (String)execProps.get("jakarta.enterprise.concurrent.IDENTITY_NAME");
                if (taskName == null) {
                    taskName = (String)execProps.get("javax.enterprise.concurrent.IDENTITY_NAME");
                }
            }
        }
        return taskName == null ? this.task.toString() : taskName;
    }

    @Trivial
    private class FutureImpl
    implements ScheduledFuture<T> {
        private final AtomicReference<ScheduledFuture<?>> scheduledFutureRef = new AtomicReference();
        private final ScheduledTask<T> task = ScheduledTask.this;

        private FutureImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry(this.task, (TraceComponent)tc, (String)"cancel", (Object[])new Object[]{mayInterruptIfRunning});
            }
            boolean canceled = false;
            Status canceledStatus = new Status(Status.Type.CANCELED, null, null, true);
            Result result = (Result)ScheduledTask.this.resultRef.get();
            Status status = result.getStatus();
            while (!canceled && !status.finalExecutionIsComplete) {
                if (result.compareAndSet(status, canceledStatus)) {
                    Future future = this.scheduledFutureRef.get();
                    if (future != null) {
                        future.cancel(mayInterruptIfRunning);
                    }
                    result.latch.countDown();
                    if ((status.type == Status.Type.NONE || status.type == Status.Type.SUBMITTED) && ScheduledTask.this.listener != null) {
                        Throwable failure = null;
                        ThreadContext tranContextRestorer = ScheduledTask.this.managedExecSvc.suspendTransaction();
                        try {
                            try {
                                CancellationException cancelX = new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{ScheduledTask.this.getName(), ((ScheduledTask)ScheduledTask.this).managedExecSvc.name}));
                                if (trace && tc.isEventEnabled()) {
                                    Tr.event((Object)this, (TraceComponent)tc, (String)"taskAborted", (Object[])new Object[]{ScheduledTask.this.managedExecSvc, this.task.task, cancelX});
                                }
                                ScheduledTask.this.listener.taskAborted((Future)this, (ManagedExecutorService)ScheduledTask.this.managedExecSvc, this.task.task, (Throwable)cancelX);
                            }
                            catch (Error x) {
                                try {
                                    failure = x;
                                    throw x;
                                    catch (RuntimeException x2) {
                                        failure = x2;
                                        throw x2;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (trace && tc.isEventEnabled()) {
                                        Tr.event((Object)this, (TraceComponent)tc, (String)"taskDone", (Object[])new Object[]{ScheduledTask.this.managedExecSvc, this.task.task, failure});
                                    }
                                    ScheduledTask.this.listener.taskDone((Future)this, (ManagedExecutorService)ScheduledTask.this.managedExecSvc, this.task.task, failure);
                                    throw throwable;
                                }
                            }
                            if (trace && tc.isEventEnabled()) {
                                Tr.event((Object)this, (TraceComponent)tc, (String)"taskDone", (Object[])new Object[]{ScheduledTask.this.managedExecSvc, this.task.task, failure});
                            }
                            ScheduledTask.this.listener.taskDone((Future)this, (ManagedExecutorService)ScheduledTask.this.managedExecSvc, this.task.task, failure);
                        }
                        finally {
                            if (tranContextRestorer != null) {
                                tranContextRestorer.taskStopping();
                            }
                        }
                    }
                    canceled = true;
                    continue;
                }
                result = (Result)ScheduledTask.this.resultRef.get();
                status = result.getStatus();
            }
            if (trace && tc.isEntryEnabled()) {
                Tr.exit(this.task, (TraceComponent)tc, (String)"cancel", (Object)canceled);
            }
            return canceled;
        }

        @Override
        public int compareTo(Delayed delayed) {
            int result;
            if (delayed instanceof FutureImpl) {
                long value1 = ScheduledTask.this.nextExecutionTime;
                long value2 = ((FutureImpl)delayed).task.nextExecutionTime;
                result = this == delayed || value1 == value2 ? 0 : (value1 - value2 < 0L ? -1 : 1);
            } else {
                long diff = this.getDelay(TimeUnit.MILLISECONDS) - delayed.getDelay(TimeUnit.MILLISECONDS);
                int n = diff < -100L ? -1 : (result = diff > 100L ? 1 : 0);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(this.task, (TraceComponent)tc, (String)"compareTo", (Object[])new Object[]{this, delayed, result});
            }
            return result;
        }

        @Override
        public T get() throws ExecutionException, InterruptedException {
            boolean trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry(this.task, (TraceComponent)tc, (String)"get", (Object[])new Object[0]);
            }
            Result result = (Result)ScheduledTask.this.resultRef.get();
            Status status = result.getStatus();
            Exception x = null;
            if (status.type == Status.Type.CANCELED) {
                x = new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{ScheduledTask.this.getName(), ((ScheduledTask)ScheduledTask.this).managedExecSvc.name}));
            } else if ((status.type == Status.Type.NONE || status.type == Status.Type.SUBMITTED) && result.executionThread != null && Thread.currentThread().equals(result.executionThread)) {
                x = new InterruptedException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1120.future.get.rejected", (Object[])new Object[0]));
            } else {
                result.latch.await();
                status = result.getStatus();
                switch (status.type) {
                    case DONE: {
                        if (status.failure == null) {
                            if (trace && tc.isEntryEnabled()) {
                                Tr.exit(this.task, (TraceComponent)tc, (String)"get", (Object)status.value);
                            }
                            return status.value;
                        }
                        x = new ExecutionException(status.failure);
                        break;
                    }
                    case ABORTED: {
                        x = new AbortedException(status.failure);
                        break;
                    }
                    case CANCELED: {
                        x = new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{ScheduledTask.this.getName(), ((ScheduledTask)ScheduledTask.this).managedExecSvc.name}));
                        break;
                    }
                    case SKIPPED: {
                        x = new SkippedException(status.failure);
                        break;
                    }
                    default: {
                        x = new IllegalStateException(status.type.name());
                    }
                }
            }
            if (trace && tc.isEntryEnabled()) {
                Tr.exit(this.task, (TraceComponent)tc, (String)"get", (Object)Utils.toString(x));
            }
            if (x instanceof ExecutionException) {
                throw (ExecutionException)x;
            }
            if (x instanceof InterruptedException) {
                throw x;
            }
            throw (RuntimeException)x;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
            boolean trace = TraceComponent.isAnyTracingEnabled();
            if (trace && tc.isEntryEnabled()) {
                Tr.entry(this.task, (TraceComponent)tc, (String)"get", (Object[])new Object[]{timeout, unit});
            }
            Result result = (Result)ScheduledTask.this.resultRef.get();
            Status status = result.getStatus();
            Exception x = null;
            if (status.type == Status.Type.CANCELED) {
                x = new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{ScheduledTask.this.getName(), ((ScheduledTask)ScheduledTask.this).managedExecSvc.name}));
            } else if ((status.type == Status.Type.NONE || status.type == Status.Type.SUBMITTED) && result.executionThread != null && Thread.currentThread().equals(result.executionThread)) {
                x = new InterruptedException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1120.future.get.rejected", (Object[])new Object[0]));
            } else if (!result.latch.await(timeout, unit)) {
                x = new TimeoutException();
            } else {
                status = result.getStatus();
                switch (status.type) {
                    case DONE: {
                        if (status.failure == null) {
                            if (trace && tc.isEntryEnabled()) {
                                Tr.exit(this.task, (TraceComponent)tc, (String)"get", (Object)status.value);
                            }
                            return status.value;
                        }
                        x = new ExecutionException(status.failure);
                        break;
                    }
                    case ABORTED: {
                        x = new AbortedException(status.failure);
                        break;
                    }
                    case CANCELED: {
                        x = new CancellationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1110.task.canceled", (Object[])new Object[]{ScheduledTask.this.getName(), ((ScheduledTask)ScheduledTask.this).managedExecSvc.name}));
                        break;
                    }
                    case SKIPPED: {
                        x = new SkippedException(status.failure);
                        break;
                    }
                    default: {
                        x = new IllegalStateException(status.type.name());
                    }
                }
            }
            if (trace && tc.isEntryEnabled()) {
                Tr.exit(this.task, (TraceComponent)tc, (String)"get", (Object)Utils.toString(x));
            }
            if (x instanceof ExecutionException) {
                throw (ExecutionException)x;
            }
            if (x instanceof InterruptedException) {
                throw (InterruptedException)x;
            }
            if (x instanceof TimeoutException) {
                throw x;
            }
            throw (RuntimeException)x;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long delay = ScheduledTask.this.trigger == null ? unit.convert(ScheduledTask.this.nextExecutionTime - System.nanoTime(), TimeUnit.NANOSECONDS) : unit.convert(ScheduledTask.this.nextExecutionTime - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(this.task, (TraceComponent)tc, (String)"getDelay", (Object[])new Object[]{unit, delay});
            }
            return delay;
        }

        public final int hashCode() {
            return this.task.hashCode();
        }

        @Override
        public boolean isCancelled() {
            Status status = ((Result)ScheduledTask.this.resultRef.get()).getStatus();
            if (status.type == Status.Type.CANCELED) {
                return true;
            }
            if (status.finalExecutionIsComplete) {
                return false;
            }
            Future future = this.scheduledFutureRef.get();
            if (future != null && future.isCancelled()) {
                future.cancel(true);
                return true;
            }
            return false;
        }

        @Override
        public boolean isDone() {
            Status status = ((Result)ScheduledTask.this.resultRef.get()).getStatus();
            return status.type == Status.Type.ABORTED || status.type == Status.Type.DONE || status.type == Status.Type.SKIPPED || this.isCancelled();
        }
    }

    @Trivial
    private static class Status<T> {
        private final Throwable failure;
        private final boolean finalExecutionIsComplete;
        private final Type type;
        private final T value;

        private Status(Type type, T value, Throwable failure, boolean finalExecutionIsComplete) {
            this.failure = failure;
            this.finalExecutionIsComplete = finalExecutionIsComplete;
            this.type = type;
            this.value = value;
        }

        @Trivial
        private static enum Type {
            ABORTED,
            CANCELED,
            DONE,
            NONE,
            SKIPPED,
            STARTED,
            SUBMITTED;

        }
    }

    @Trivial
    private class Result {
        private volatile Thread executionThread;
        private final CountDownLatch latch = new CountDownLatch(1);
        private final AtomicReference<Status<T>> statusRef = new AtomicReference(new Status(Status.Type.NONE, null, null, false));

        private Result() {
        }

        private final boolean compareAndSet(Status<T> expectedStatus, Status<T> newStatus) {
            boolean updated = this.statusRef.compareAndSet(expectedStatus, newStatus);
            if (updated && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                StringBuilder sb = new StringBuilder(60).append((Object)expectedStatus.type).append("-->").append((Object)newStatus.type).append(' ');
                if (newStatus.finalExecutionIsComplete) {
                    sb.append("[final]").append(' ');
                }
                if (newStatus.value != null) {
                    sb.append(newStatus.value).append(' ');
                }
                if (newStatus.failure != null) {
                    sb.append(newStatus.failure);
                }
                Tr.event((Object)ScheduledTask.this, (TraceComponent)tc, (String)sb.toString(), (Object[])new Object[0]);
            }
            return updated;
        }

        private final Status<T> getStatus() {
            return this.statusRef.get();
        }
    }
}

