/*
 * Decompiled with CFR 0.152.
 */
package graphql.cachecontrol;

import graphql.Assert;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.PublicApi;
import graphql.execution.ExecutionPath;
import graphql.schema.DataFetchingEnvironment;
import graphql.util.FpKit;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

@PublicApi
public class CacheControl {
    public static final String CACHE_CONTROL_EXTENSION_KEY = "cacheControl";
    private final List<Hint> hints = new CopyOnWriteArrayList<Hint>();

    private CacheControl() {
    }

    public CacheControl hint(ExecutionPath path, Integer maxAge, Scope scope) {
        Assert.assertNotNull(path);
        Assert.assertNotNull(scope);
        this.hints.add(new Hint(path.toList(), maxAge, scope));
        return this;
    }

    public CacheControl hint(ExecutionPath path, Scope scope) {
        return this.hint(path, null, scope);
    }

    public CacheControl hint(ExecutionPath path, Integer maxAge) {
        return this.hint(path, maxAge, Scope.PUBLIC);
    }

    public CacheControl hint(DataFetchingEnvironment dataFetchingEnvironment, Integer maxAge, Scope scope) {
        Assert.assertNotNull(dataFetchingEnvironment);
        Assert.assertNotNull(scope);
        this.hint(dataFetchingEnvironment.getExecutionStepInfo().getPath(), maxAge, scope);
        return this;
    }

    public CacheControl hint(DataFetchingEnvironment dataFetchingEnvironment, Integer maxAge) {
        this.hint(dataFetchingEnvironment, maxAge, Scope.PUBLIC);
        return this;
    }

    public CacheControl hint(DataFetchingEnvironment dataFetchingEnvironment, Scope scope) {
        return this.hint(dataFetchingEnvironment, null, scope);
    }

    public static CacheControl newCacheControl() {
        return new CacheControl();
    }

    public ExecutionResult addTo(ExecutionResult executionResult) {
        return ExecutionResultImpl.newExecutionResult().from(executionResult).addExtension(CACHE_CONTROL_EXTENSION_KEY, this.hintsToCacheControlProperties()).build();
    }

    private Map<String, Object> hintsToCacheControlProperties() {
        List<Map> recordedHints = FpKit.map(this.hints, Hint::toMap);
        LinkedHashMap<String, Object> cacheControl = new LinkedHashMap<String, Object>();
        cacheControl.put("version", 1);
        cacheControl.put("hints", recordedHints);
        return cacheControl;
    }

    private class Hint {
        private final List<Object> path;
        private final Integer maxAge;
        private final Scope scope;

        private Hint(List<Object> path, Integer maxAge, Scope scope) {
            this.path = Assert.assertNotNull(path);
            this.maxAge = maxAge;
            this.scope = scope;
        }

        Map<String, Object> toMap() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("path", this.path);
            if (this.maxAge != null) {
                map.put("maxAge", this.maxAge);
            }
            if (this.scope != null) {
                map.put("scope", this.scope.name());
            }
            return map;
        }
    }

    public static enum Scope {
        PUBLIC,
        PRIVATE;

    }
}

