/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.discovery;

import com.google.inject.Inject;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.Identifier;
import org.openid4java.discovery.UrlIdentifier;
import org.openid4java.discovery.XriIdentifier;
import org.openid4java.discovery.html.HtmlResolver;
import org.openid4java.discovery.xri.XriResolver;
import org.openid4java.discovery.yadis.YadisResolver;
import org.openid4java.util.HttpFetcherFactory;
import org.openid4java.util.OpenID4JavaUtils;

public class Discovery {
    private static Log _log = LogFactory.getLog(Discovery.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private static final Pattern URL_PATTERN = Pattern.compile("^https?://", 2);
    private static final Pattern XRI_PATTERN = Pattern.compile("^[!=@\\$\\+\\(]", 2);
    private HtmlResolver _htmlResolver;
    private YadisResolver _yadisResolver;
    private XriResolver _xriResolver;
    private static final String XRI_RESOLVER_CLASS_NAME_KEY = "discovery.xri.resolver";

    public static XriResolver getXriResolver() {
        String className = OpenID4JavaUtils.getProperty(XRI_RESOLVER_CLASS_NAME_KEY);
        if (DEBUG) {
            _log.debug((Object)("discovery.xri.resolver:" + className));
        }
        try {
            return (XriResolver)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing XRI resolver.", e);
        }
    }

    @Inject
    public Discovery(HtmlResolver htmlResolver, YadisResolver yadisResolver, XriResolver xriResolver) {
        this._htmlResolver = htmlResolver;
        this._yadisResolver = yadisResolver;
        this._xriResolver = xriResolver;
    }

    public Discovery() {
        this(new HtmlResolver(new HttpFetcherFactory()), new YadisResolver(new HttpFetcherFactory()), Discovery.getXriResolver());
    }

    public void setXriResolver(XriResolver xriResolver) {
        this._xriResolver = xriResolver;
    }

    public void setYadisResolver(YadisResolver yadisResolver) {
        this._yadisResolver = yadisResolver;
    }

    public void setHtmlResolver(HtmlResolver htmlResolver) {
        this._htmlResolver = htmlResolver;
    }

    public Identifier parseIdentifier(String identifier) throws DiscoveryException {
        return this.parseIdentifier(identifier, false);
    }

    public Identifier parseIdentifier(String identifier, boolean removeFragment) throws DiscoveryException {
        try {
            if (identifier.toLowerCase().startsWith("xri://")) {
                if (DEBUG) {
                    _log.debug((Object)("Dropping xri:// prefix from identifier: " + identifier));
                }
                identifier = identifier.substring(6);
            }
            if (URL_PATTERN.matcher(identifier).find()) {
                if (DEBUG) {
                    _log.debug((Object)("Creating URL identifier for: " + identifier));
                }
                return new UrlIdentifier(identifier, removeFragment);
            }
            if (XRI_PATTERN.matcher(identifier).find()) {
                if (DEBUG) {
                    _log.debug((Object)("Creating XRI identifier for: " + identifier));
                }
                return this._xriResolver.parseIdentifier(identifier);
            }
            if (DEBUG) {
                _log.debug((Object)("Creating URL identifier (http:// prepended) for: " + identifier));
            }
            return new UrlIdentifier("http://" + identifier, removeFragment);
        }
        catch (Exception e) {
            throw new DiscoveryException("Cannot parse identifier: " + identifier, (Throwable)e);
        }
    }

    public List discover(String identifier) throws DiscoveryException {
        return this.discover(this.parseIdentifier(identifier, true));
    }

    public List discover(Identifier identifier) throws DiscoveryException {
        List result;
        if (identifier instanceof XriIdentifier) {
            _log.info((Object)("Starting discovery on XRI identifier: " + identifier));
            result = this._xriResolver.discover((XriIdentifier)identifier);
        } else if (identifier instanceof UrlIdentifier) {
            _log.info((Object)("Starting discovery on URL identifier: " + identifier));
            UrlIdentifier urlId = (UrlIdentifier)identifier;
            result = this._yadisResolver.discover(urlId.getIdentifier());
            if (result == null || result.size() == 0) {
                _log.info((Object)"No OpenID service endpoints discovered through Yadis; attempting HTML discovery...");
                result = this._htmlResolver.discoverHtml(urlId);
            }
        } else {
            throw new DiscoveryException("Unknown identifier type: " + identifier.toString());
        }
        _log.info((Object)("Discovered " + result.size() + " OpenID endpoints."));
        return result;
    }

    public static List rpDiscovery(String realm, YadisResolver yadisResolver) throws DiscoveryException {
        return yadisResolver.discoverRP(realm);
    }

    public YadisResolver getYadisResolver() {
        return this._yadisResolver;
    }
}

