/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j;

import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.shredzone.acme4j.toolbox.JSON;

@ParametersAreNonnullByDefault
@Immutable
public class Metadata {
    private final JSON meta;

    public Metadata(JSON meta) {
        this.meta = meta;
    }

    @CheckForNull
    public URI getTermsOfService() {
        return this.meta.get("termsOfService").map(JSON.Value::asURI).orElse(null);
    }

    @CheckForNull
    public URL getWebsite() {
        return this.meta.get("website").map(JSON.Value::asURL).orElse(null);
    }

    public Collection<String> getCaaIdentities() {
        return this.meta.get("caaIdentities").asArray().stream().map(JSON.Value::asString).collect(Collectors.toList());
    }

    public boolean isExternalAccountRequired() {
        return this.meta.get("externalAccountRequired").map(JSON.Value::asBoolean).orElse(false);
    }

    public boolean isStarEnabled() {
        return this.meta.get("star-enabled").map(JSON.Value::asBoolean).orElse(false);
    }

    public Duration getStarMinCertValidity() {
        return this.meta.get("star-min-cert-validity").map(JSON.Value::asDuration).orElse(null);
    }

    public Duration getStarMaxRenewal() {
        return this.meta.get("star-max-renewal").map(JSON.Value::asDuration).orElse(null);
    }

    public boolean isStarCertificateGetAllowed() {
        return this.meta.get("star-allow-certificate-get").map(JSON.Value::asBoolean).orElse(false);
    }

    public JSON getJSON() {
        return this.meta;
    }
}

