/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.extension;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.bus.extension.Extension;
import org.apache.cxf.common.logging.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextExtensionFragmentParser {
    private static final Logger LOG = LogUtils.getL7dLogger(TextExtensionFragmentParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Extension> getExtensions(URL url) {
        InputStream is = null;
        try {
            is = url.openStream();
            List<Extension> list = this.getExtensions(is);
            return list;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
            ArrayList<Extension> arrayList = new ArrayList<Extension>();
            return arrayList;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public List<Extension> getExtensions(InputStream is) throws IOException {
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        String line = reader.readLine();
        while (line != null) {
            Extension extension = this.getExtensionFromTextLine(line);
            if (extension != null) {
                extensions.add(extension);
            }
            line = reader.readLine();
        }
        return extensions;
    }

    private Extension getExtensionFromTextLine(String line) {
        if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
            return null;
        }
        Extension ext = new Extension();
        String[] parts = line.split(":");
        ext.setClassname(parts[0]);
        if (ext.getClassname() == null) {
            return null;
        }
        if (parts.length >= 2) {
            String interfaceName = parts[1];
            if (interfaceName != null && "".equals(interfaceName)) {
                interfaceName = null;
            }
            ext.setInterfaceName(interfaceName);
        }
        if (parts.length >= 3) {
            ext.setDeferred(Boolean.parseBoolean(parts[2]));
        }
        if (parts.length >= 4) {
            ext.setOptional(Boolean.parseBoolean(parts[3]));
        }
        return ext;
    }
}

