/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.classsource.specification.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.annocache.classsource.specification.ClassSource_Specification_Element;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.annocache.classsource.ClassSource;
import com.ibm.wsspi.annocache.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.annocache.classsource.ClassSource_Exception;
import com.ibm.wsspi.annocache.classsource.ClassSource_Factory;
import com.ibm.wsspi.annocache.util.Util_Factory;
import com.ibm.wsspi.annocache.util.Util_InternMap;
import com.ibm.wsspi.annocache.util.Util_RelativePath;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ClassSourceImpl_Specification_Element
implements ClassSource_Specification_Element {
    public static final String CLASS_NAME;
    protected final String name;
    protected final ClassSource_Aggregate.ScanPolicy policy;
    protected final Util_RelativePath relativePath;
    protected final String entryPrefix;
    static final long serialVersionUID = -4577065185493752981L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ClassSourceImpl_Specification_Element(String name, ClassSource_Aggregate.ScanPolicy policy, Util_RelativePath relativePath) {
        this(name, policy, relativePath, ClassSource.NO_ENTRY_PREFIX);
    }

    public ClassSourceImpl_Specification_Element(String name, ClassSource_Aggregate.ScanPolicy policy, Util_RelativePath relativePath, String entryPrefix) {
        this.name = name;
        this.policy = policy;
        this.relativePath = relativePath;
        this.entryPrefix = entryPrefix;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ClassSource_Aggregate.ScanPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public Util_RelativePath getPath() {
        return this.relativePath;
    }

    @Override
    public String getEntryPrefix() {
        return this.entryPrefix;
    }

    @Override
    public void addTo(ClassSource_Aggregate rootClassSource) throws ClassSource_Exception {
        ClassSource_Factory classSourceFactory = rootClassSource.getFactory();
        Util_InternMap internMap = rootClassSource.getInternMap();
        String useName = this.getName();
        ClassSource_Aggregate.ScanPolicy usePolicy = this.getPolicy();
        Util_RelativePath usePath = this.getPath();
        if (usePath == null) {
            throw new IllegalArgumentException("Class source specification [ " + useName + " ] [ " + (Object)((Object)usePolicy) + " ] has neither a class loader nor a path");
        }
        String useEntryPrefix = this.getEntryPrefix();
        Util_Factory utilFactory = classSourceFactory.getUtilFactory();
        String dirPath = utilFactory.denormalize(usePath.n_getFullPath());
        final File dir = new File(dirPath);
        Boolean dirIsFile = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            static final long serialVersionUID = 5968620990632828924L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Boolean run() {
                return dir.exists() && dir.isFile();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification_Element$1", 1.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
            }
        });
        ClassSource classSource = dirIsFile != false ? classSourceFactory.createJarClassSource(internMap, useName, dirPath, useEntryPrefix) : classSourceFactory.createDirectoryClassSource(internMap, useName, dirPath, useEntryPrefix);
        rootClassSource.addClassSource(classSource, usePolicy);
    }

    @Override
    public void log(Logger useLogger) {
        String methodName = "log";
        if (!useLogger.isLoggable(Level.FINER)) {
            return;
        }
        String useName = this.getName();
        ClassSource_Aggregate.ScanPolicy usePolicy = this.getPolicy();
        Util_RelativePath usePath = this.getPath();
        String useEntryPrefix = this.getEntryPrefix();
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Class Source [ {0} ] [ {1} ]: [ {2} ] [ {3} ] Prefix [ {4} ]", new Object[]{useName, usePolicy, usePath.n_getBasePath(), usePath.n_getRelativePath(), useEntryPrefix});
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.classsource.specification.internal.ClassSourceImpl_Specification_Element", ClassSourceImpl_Specification_Element.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        CLASS_NAME = ClassSourceImpl_Specification_Element.class.getSimpleName();
    }
}

