/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.activator;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.ContainerAS;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.EJBThreadData;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.StatefulBeanReaper;
import com.ibm.ejs.container.activator.ActivationStrategy;
import com.ibm.ejs.container.activator.TransactionKey;
import com.ibm.ejs.container.passivator.StatefulPassivator;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.container.util.locking.LockTable;
import com.ibm.ejs.util.cache.Cache;
import com.ibm.ejs.util.cache.Element;
import com.ibm.websphere.csi.CacheElement;
import com.ibm.websphere.csi.EJBCache;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.PassivationPolicy;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.diagnostics.IntrospectionWriter;
import com.ibm.ws.ejbcontainer.diagnostics.TrDumpWriter;
import com.ibm.ws.ejbcontainer.failover.SfFailoverCache;
import com.ibm.ws.ejbcontainer.runtime.EJBRuntime;
import com.ibm.ws.util.cache.DiscardWithLockStrategy;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.concurrent.ScheduledExecutorService;
import javax.ejb.DuplicateKeyException;

public final class Activator
implements DiscardWithLockStrategy {
    public static final int UNCACHED_ACTIVATION_STRATEGY = 0;
    public static final int STATEFUL_ACTIVATE_ONCE_ACTIVATION_STRATEGY = 1;
    public static final int STATEFUL_ACTIVATE_TRAN_ACTIVATION_STRATEGY = 2;
    public static final int STATEFUL_ACTIVATE_SESSION_ACTIVATION_STRATEGY = 3;
    public static final int OPTA_ENTITY_ACTIVATION_STRATEGY = 4;
    public static final int OPTB_ENTITY_ACTIVATION_STRATEGY = 5;
    public static final int OPTC_ENTITY_ACTIVATION_STRATEGY = 6;
    public static final int ENTITY_SESSIONAL_TRAN_ACTIVATION_STRATEGY = 7;
    public static final int READONLY_ENTITY_ACTIVATION_STRATEGY = 8;
    private static final int NUM_STRATEGIES = 9;
    protected static final String[] svStrategyStrs = new String[]{"Uncached", "Stateful Once", "Stateful Transaction", "Stateful Session", "Entity Option A", "Entity Option B", "Entity Option C", "Entity Option C Sessional", "Entity Read Only"};
    EJBCache beanCache;
    LockTable activationLocks;
    protected EJSContainer container;
    private ActivationStrategy[] strategies;
    StatefulPassivator passivator;
    private static final TraceComponent tc = Tr.register(Activator.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    StatefulBeanReaper statefulBeanReaper;

    public Activator(EJSContainer container2, EJBCache cache, PassivationPolicy passivationPolicy, StatefulPassivator passivator, SfFailoverCache failoverCache) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[]{container2, cache, passivationPolicy});
        }
        ScheduledExecutorService deferrableExecutor = container2.getEJBRuntime().getDeferrableScheduledExecutorService();
        if (EJSPlatformHelper.isZOS()) {
            long sweepInterval = 0L;
            Long sweepIntervallong = Long.getLong("com.ibm.websphere.bean.delete.sleep.time");
            if (sweepIntervallong != null) {
                sweepInterval = sweepIntervallong * 1000L;
            }
            this.statefulBeanReaper = new StatefulBeanReaper(this, cache.getNumBuckets(), sweepInterval, failoverCache, deferrableExecutor);
        } else {
            this.statefulBeanReaper = new StatefulBeanReaper(this, cache.getNumBuckets(), failoverCache, deferrableExecutor);
        }
        this.initialize(container2, cache, passivationPolicy, passivator, failoverCache);
        if (!passivationPolicy.equals(PassivationPolicy.ON_DEMAND)) {
            this.statefulBeanReaper.start();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    private void initialize(EJSContainer container2, EJBCache cache, PassivationPolicy passivationPolicy, StatefulPassivator passivator, SfFailoverCache failoverCache) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object[])new Object[0]);
        }
        this.container = container2;
        this.beanCache = cache;
        this.passivator = passivator;
        this.activationLocks = new LockTable(this.beanCache.getNumBuckets());
        EJBRuntime runtime = container2.getEJBRuntime();
        this.strategies = new ActivationStrategy[9];
        for (int type = 0; type < this.strategies.length; ++type) {
            this.strategies[type] = runtime.createActivationStrategy(this, type, passivationPolicy);
        }
        this.beanCache.setDiscardStrategy(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public BeanO preInvokeActivateBean(EJBThreadData threadData, ContainerTx tx, BeanId beanId) throws RemoteException {
        return beanId.getActivationStrategy().atActivate(threadData, tx, beanId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanO activateBean(EJBThreadData threadData, ContainerTx tx, BeanId beanId) throws RemoteException {
        BeanO beanO = null;
        try {
            beanO = beanId.getActivationStrategy().atActivate(threadData, tx, beanId);
        }
        finally {
            if (beanO != null) {
                threadData.popCallbackBeanO();
            }
        }
        return beanO;
    }

    public void postInvoke(ContainerTx tx, BeanO bean) {
        bean.getActivationStrategy().atPostInvoke(tx, bean);
    }

    public BeanO addBean(ContainerTx tx, BeanO bean) throws DuplicateKeyException, RemoteException {
        return bean.getHome().getActivationStrategy().atCreate(tx, bean);
    }

    public boolean lockBean(ContainerTx tx, BeanId beanId) throws RemoteException {
        return beanId.getActivationStrategy().atLock(tx, beanId);
    }

    public void removeBean(ContainerTx tx, BeanO bean) {
        bean.getActivationStrategy().atRemove(tx, bean);
    }

    public BeanO getBean(ContainerTx tx, BeanId id) {
        return id.getActivationStrategy().atGet(tx, id);
    }

    public void commitBean(ContainerTx tx, BeanO bean) {
        bean.getActivationStrategy().atCommit(tx, bean);
    }

    public void unitOfWorkEnd(ContainerAS as, BeanO bean) {
        bean.getActivationStrategy().atUnitOfWorkEnd(as, bean);
    }

    public void rollbackBean(ContainerTx tx, BeanO bean) {
        bean.getActivationStrategy().atRollback(tx, bean);
    }

    public final void enlistBean(ContainerTx tx, BeanO bean) {
        bean.getActivationStrategy().atEnlist(tx, bean);
    }

    public void setCacheSweepInterval(long sweepInterval) {
        this.beanCache.setSweepInterval(sweepInterval);
    }

    public void setCachePreferredMaxSize(int size) {
        this.beanCache.setCachePreferredMaxSize(size);
    }

    public final ActivationStrategy getActivationStrategy(int id) {
        return this.strategies[id];
    }

    public final ActivationStrategy getActivationStrategy(EJSHome home, int id) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getActivationStrategy: " + this.beanCache.getName() + " used for " + home.getJ2EEName()), (Object[])new Object[0]);
        }
        return this.strategies[id];
    }

    public static final String getActivationStrategyString(int id) {
        if (id < 0 || id >= svStrategyStrs.length) {
            return "Unknown (" + id + ")";
        }
        return svStrategyStrs[id];
    }

    @Override
    public void discardObject(EJBCache cache, Object key, Object object) throws RemoteException {
        BeanO bean = (BeanO)object;
        bean.getActivationStrategy().atDiscard(bean);
    }

    @Override
    public LockTable getEvictionLockTable() {
        return this.activationLocks;
    }

    public void timeoutBean(BeanId beanId) throws RemoteException {
        beanId.getActivationStrategy().atTimeout(beanId);
    }

    public void terminate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"terminate", (Object[])new Object[0]);
        }
        this.statefulBeanReaper.cancel();
        this.statefulBeanReaper.finalSweep(this.passivator);
        this.beanCache.terminate();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"terminate");
        }
    }

    public void uninstallBean(J2EEName homeName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("uninstallBean " + homeName), (Object[])new Object[0]);
        }
        int numEnumerated = 0;
        int numRemoved = 0;
        int numTimedout = 0;
        Enumeration<?> enumerate = this.beanCache.enumerateElements();
        while (enumerate.hasMoreElements()) {
            BeanO cacheMember = (BeanO)((CacheElement)enumerate.nextElement()).getObject();
            BeanId cacheMemberBeanId = cacheMember.getId();
            J2EEName cacheHomeName = cacheMemberBeanId.getJ2EEName();
            ++numEnumerated;
            if (!cacheHomeName.equals(homeName)) continue;
            EJSHome home = cacheMember.getHome();
            BeanMetaData bmd = cacheMemberBeanId.getBeanMetaData();
            if (EJSPlatformHelper.isZOS() && bmd.isPassivationCapable()) {
                try {
                    home.getActivationStrategy().atPassivate(cacheMemberBeanId);
                }
                catch (Exception ex) {
                    Tr.warning((TraceComponent)tc, (String)"UNABLE_TO_PASSIVATE_EJB_CNTR0005W", (Object[])new Object[]{cacheMemberBeanId, this, ex});
                }
            } else {
                home.getActivationStrategy().atUninstall(cacheMemberBeanId, cacheMember);
            }
            ++numRemoved;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this.beanCache.getName() + ": Uninstalled " + numRemoved + " bean instances (total = " + numEnumerated + ")"), (Object[])new Object[0]);
        }
        Iterator<BeanId> statefulBeans = this.statefulBeanReaper.getPassivatedStatefulBeanIds(homeName);
        while (statefulBeans.hasNext()) {
            BeanId beanId = statefulBeans.next();
            if (EJSPlatformHelper.isZOS()) {
                this.statefulBeanReaper.remove(beanId);
            } else {
                beanId.getActivationStrategy().atUninstall(beanId, null);
            }
            ++numTimedout;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Passivated Beans: Uninstalled " + numTimedout + " bean instances"), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"uninstallBean");
        }
    }

    public int size() {
        int size = this.beanCache.getSize();
        return size;
    }

    public void dump() {
        if (!tc.isDumpEnabled()) {
            return;
        }
        this.introspect(new TrDumpWriter(tc));
    }

    public void introspect(IntrospectionWriter writer) {
        writer.begin("Activator Dump (" + this.beanCache.getName() + "): " + this.beanCache.getSize() + " beans in cache");
        Enumeration<Element> vEnum = ((Cache)this.beanCache).enumerateElements();
        while (vEnum.hasMoreElements()) {
            Element element = vEnum.nextElement();
            Object key = element.getKey();
            if (key instanceof TransactionKey) {
                Object bean = element.getObject();
                String state = element.stateToString();
                ContainerTx tx = ((TransactionKey)key).tx;
                writer.println(bean + state + " : " + tx);
                continue;
            }
            writer.println(element.toString());
        }
        writer.end();
    }
}

