/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.configuration;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jsp.Constants;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspConfigPropertyGroup;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.configuration.StaticIncludeJspConfiguration;
import com.ibm.ws.webcontainer.util.URIMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class JspConfigurationManager {
    protected boolean isServlet24OrHigher;
    protected boolean isServlet25OrHigher;
    protected URIMatcher uriMatcher;
    protected List jspExtensionList;
    boolean JCDIEnabled;
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.configuration.JspConfigurationManager";
    static final long serialVersionUID = 2285763750258808802L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspConfigurationManager(List jspPropertyGroups, boolean isServlet24, boolean isServlet24_or_higher, List addtlJspFileExtensions, boolean JCDIEnabled) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{jspPropertyGroups, isServlet24, isServlet24_or_higher, addtlJspFileExtensions, JCDIEnabled});
        }
        this.isServlet24OrHigher = false;
        this.isServlet25OrHigher = false;
        this.uriMatcher = null;
        this.jspExtensionList = new ArrayList();
        this.isServlet24OrHigher = isServlet24_or_higher;
        this.isServlet25OrHigher = this.isServlet24OrHigher && !isServlet24;
        this.uriMatcher = new URIMatcher();
        ArrayList<String> urlPatterns = new ArrayList<String>();
        for (JspConfigPropertyGroup jspPropertyGroup : jspPropertyGroups) {
            for (String urlPattern : jspPropertyGroup.getUrlPatterns()) {
                if (!urlPatterns.contains(urlPattern)) {
                    urlPatterns.add(urlPattern);
                    try {
                        this.uriMatcher.put(urlPattern, (Object)jspPropertyGroup);
                    }
                    catch (Exception e) {
                        logger.logp(Level.WARNING, CLASS_NAME, "JspConfigurationManager", "Failed to add url pattern [" + urlPattern + "] to match list.", e);
                    }
                } else {
                    throw new JspCoreException("jsp.error.dup.url.pattern", new Object[]{urlPattern});
                }
                if (this.jspExtensionList.contains(urlPattern)) continue;
                boolean newExtFound = true;
                for (int i = 0; i < Constants.STANDARD_JSP_EXTENSIONS.length; ++i) {
                    if (!urlPattern.equals(Constants.STANDARD_JSP_EXTENSIONS[i])) continue;
                    newExtFound = false;
                    break;
                }
                if (!newExtFound) continue;
                this.jspExtensionList.add(urlPattern);
            }
        }
        for (String urlPattern : addtlJspFileExtensions) {
            if (!urlPattern.startsWith("*.") || this.jspExtensionList.contains(urlPattern)) continue;
            boolean newExtFound = true;
            for (int i = 0; i < Constants.STANDARD_JSP_EXTENSIONS.length; ++i) {
                if (!urlPattern.equals(Constants.STANDARD_JSP_EXTENSIONS[i])) continue;
                newExtFound = false;
                break;
            }
            if (!newExtFound) continue;
            this.jspExtensionList.add(urlPattern);
        }
        this.JCDIEnabled = JCDIEnabled;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized JspConfiguration getConfigurationForUrl(String url) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getConfigurationForUrl", new Object[]{url});
        }
        List matches = this.uriMatcher.matchAll(url);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "getConfigurationForUrl", "begin creation of new JspConfiguration for url = [{0}] uris matched = [{1}]", new Object[]{url, matches.size()});
        }
        JspConfiguration configuration = new JspConfiguration(this);
        if (matches.size() > 0) {
            if (this.isServlet24OrHigher) {
                configuration.setElIgnored(false);
            }
            if (!this.isServlet25OrHigher) {
                configuration.setDeferredSyntaxAllowedAsLiteral(true);
            }
            configuration.setServletVersion(this.getServletVersion());
            for (JspConfigPropertyGroup propertyGroup : matches) {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "getConfigurationForUrl", "handling config url pattern(s) " + propertyGroup.getUrlPatterns());
                }
                if (propertyGroup.getIncludeCodas() != null) {
                    configuration.addIncludeCodas(propertyGroup.getIncludeCodas());
                }
                if (propertyGroup.getElIgnored() != null) {
                    configuration.setElIgnored(Boolean.valueOf(propertyGroup.getElIgnored()));
                }
                if (propertyGroup.getIsXml() != null) {
                    configuration.setIsXml(Boolean.valueOf(propertyGroup.getIsXml()));
                }
                if (propertyGroup.getPageEncoding() != null) {
                    configuration.setPageEncoding(propertyGroup.getPageEncoding());
                }
                if (propertyGroup.getIncludePreludes() != null) {
                    configuration.addIncludePreludes(propertyGroup.getIncludePreludes());
                }
                if (propertyGroup.getScriptingInvalid() != null) {
                    configuration.setScriptingInvalid(Boolean.valueOf(propertyGroup.getScriptingInvalid()));
                }
                if (propertyGroup.getTrimDirectiveWhitespaces() != null) {
                    configuration.setTrimDirectiveWhitespaces(Boolean.valueOf(propertyGroup.getTrimDirectiveWhitespaces()));
                    configuration.setTrimDirectiveWhitespaces(Boolean.valueOf(propertyGroup.getTrimDirectiveWhitespaces()).toString());
                }
                if (propertyGroup.getDeferredSyntaxAllowedAsLiteral() != null) {
                    configuration.setDeferredSyntaxAllowedAsLiteral(Boolean.valueOf(propertyGroup.getDeferredSyntaxAllowedAsLiteral()));
                    configuration.setDeferredSyntaxAllowedAsLiteral(Boolean.valueOf(propertyGroup.getDeferredSyntaxAllowedAsLiteral()).toString());
                }
                if (propertyGroup.getDefaultContentType() != null) {
                    configuration.setDefaultContentType(propertyGroup.getDefaultContentType());
                }
                if (propertyGroup.getBuffer() != null) {
                    configuration.setBuffer(propertyGroup.getBuffer());
                }
                if (propertyGroup.getErrorOnUndeclaredNamespace() == null) continue;
                configuration.setErrorOnUndeclaredNamespace(Boolean.valueOf(propertyGroup.getErrorOnUndeclaredNamespace()));
            }
        } else {
            if (this.isServlet24OrHigher) {
                configuration.setElIgnored(false);
            }
            if (!this.isServlet25OrHigher) {
                configuration.setDeferredSyntaxAllowedAsLiteral(true);
            }
            configuration.setServletVersion(this.getServletVersion());
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "getConfigurationForUrl", "complete creation of new JspConfiguration for url = [{0}] {1}", new Object[]{url, configuration.toString()});
        }
        JspConfiguration jspConfiguration = configuration;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspConfiguration = jspConfiguration;
            logger.exiting(CLASS_NAME, "getConfigurationForUrl", jspConfiguration);
        }
        return jspConfiguration;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized JspConfiguration getConfigurationForStaticInclude(String url, JspConfiguration parentConfig) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getConfigurationForStaticInclude", new Object[]{url, parentConfig});
        }
        List matches = this.uriMatcher.matchAll(url);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "getConfigurationForStaticInclude", "begin creation of new StaticIncludeJspConfiguration for url = [{0}] uris matched = [{1}] (config inherited from parent)", new Object[]{url, matches.size()});
        }
        StaticIncludeJspConfiguration configuration = new StaticIncludeJspConfiguration(parentConfig);
        if (matches.size() > 0) {
            for (JspConfigPropertyGroup propertyGroup : matches) {
                if (propertyGroup.getPageEncoding() == null) continue;
                configuration.setPageEncoding(propertyGroup.getPageEncoding());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "getConfigurationForStaticInclude", "complete creation of new StaticIncludeJspConfiguration for url = [{0}] {1}", new Object[]{url, configuration.toString()});
        }
        StaticIncludeJspConfiguration staticIncludeJspConfiguration = configuration;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            staticIncludeJspConfiguration = staticIncludeJspConfiguration;
            logger.exiting(CLASS_NAME, "getConfigurationForStaticInclude", staticIncludeJspConfiguration);
        }
        return staticIncludeJspConfiguration;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List getJspExtensionList() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getJspExtensionList", new Object[0]);
        }
        List list = this.jspExtensionList;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting(CLASS_NAME, "getJspExtensionList", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspConfiguration createJspConfiguration() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "createJspConfiguration", new Object[0]);
        }
        JspConfiguration newConfiguration = new JspConfiguration(this);
        newConfiguration.setServletVersion(this.getServletVersion());
        JspConfiguration jspConfiguration = newConfiguration;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspConfiguration = jspConfiguration;
            logger.exiting(CLASS_NAME, "createJspConfiguration", jspConfiguration);
        }
        return jspConfiguration;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isJCDIEnabled() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isJCDIEnabled", new Object[0]);
        }
        boolean bl = this.JCDIEnabled;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isJCDIEnabled", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setJCDIEnabled(boolean b) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setJCDIEnabled", new Object[]{b});
        }
        this.JCDIEnabled = b;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setJCDIEnabled");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getServletVersion() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getServletVersion", new Object[0]);
        }
        String s = !this.isServlet24OrHigher ? "2.3" : (!this.isServlet25OrHigher ? "2.4" : "2.5");
        String string = s;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getServletVersion", string);
        }
        return string;
    }
}

