/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.generator;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.utils.JspTranslatorUtil;
import com.ibm.ws.jsp.translator.visitor.generator.JavaCodeWriter;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateResult;
import com.ibm.ws.jsp.webcontainerext.JSPExtensionFactory;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import java.io.CharArrayWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import org.w3c.dom.Element;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class GeneratorUtils {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.visitor.generator.GeneratorUtils";
    public static String classfileVersion = JSPExtensionFactory.getGeneratorUtilsExtFactory().getGeneratorUtilsExt().getClassFileVersion();
    public static String fullClassfileInformation = "unknown";
    public static int TAG_FILE_TYPE = 1;
    public static int JSP_FILE_TYPE = 2;
    static final long serialVersionUID = -5225323075537813194L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public GeneratorUtils() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String quote(String s) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "quote", new Object[]{s});
        }
        String string = GeneratorUtils.quote(s, false);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "quote", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String quote(String s, boolean flag) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "quote", new Object[]{s, flag});
        }
        if (s == null) {
            String string = "null";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "quote", string);
            }
            return string;
        }
        if (flag) {
            s = s.replaceAll("&quot;", "\"");
        }
        String string = '\"' + GeneratorUtils.escape(s) + '\"';
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "quote", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String escape(String s) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "escape", new Object[]{s});
        }
        if (s == null) {
            String string = "";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "escape", string);
            }
            return string;
        }
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                b.append('\\').append('\"');
                continue;
            }
            if (c == '\\') {
                b.append('\\').append('\\');
                continue;
            }
            if (c == '\n') {
                b.append('\\').append('n');
                continue;
            }
            if (c == '\r') {
                b.append('\\').append('r');
                continue;
            }
            b.append(c);
        }
        String string = b.toString();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "escape", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String handleEscapes(String exp) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "handleEscapes", new Object[]{exp});
        }
        boolean evalExpressionFollowingTwoBackslashes = WCCustomProperties.EVAL_EXPRESSION_FOLLOWING_TWO_BACKSLASHES;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "handleEscapes", "expression = [" + exp + "]");
            logger.logp(Level.FINEST, CLASS_NAME, "handleEscapes", "evalExpressionFollowingTwoBackslashes = [" + evalExpressionFollowingTwoBackslashes + "]");
        }
        if (!evalExpressionFollowingTwoBackslashes) {
            String string = exp;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "handleEscapes", string);
            }
            return string;
        }
        if (exp.indexOf("${") == -1) {
            String string = exp;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "handleEscapes", string);
            }
            return string;
        }
        boolean inEL = false;
        int len = exp.length();
        StringBuilder sb = new StringBuilder();
        for (int x = 0; x < len; ++x) {
            char c = exp.charAt(x);
            if (c == '$') {
                if (x + 1 < len && exp.charAt(x + 1) == '{') {
                    inEL = true;
                    sb.append("${");
                    ++x;
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c == '}') {
                inEL = false;
                sb.append(c);
                continue;
            }
            if (c == '\\' && !inEL) {
                if (x + 4 < len) {
                    if (exp.substring(x, x + 4).equals("\\\\\\\\")) {
                        sb.append("${'\\\\\\\\'}");
                        x += 3;
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "handleEscapes", "after processing expression = [" + sb.toString() + "]");
        }
        String string = sb.toString();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "handleEscapes", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String toGetterMethod(String attrName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "toGetterMethod", new Object[]{attrName});
        }
        char[] attrChars = attrName.toCharArray();
        attrChars[0] = Character.toUpperCase(attrChars[0]);
        String string = "get" + new String(attrChars) + "()";
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "toGetterMethod", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String toSetterMethodName(String attrName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "toSetterMethodName", new Object[]{attrName});
        }
        char[] attrChars = attrName.toCharArray();
        attrChars[0] = Character.toUpperCase(attrChars[0]);
        String string = "set" + new String(attrChars);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "toSetterMethodName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void generateLocalVariables(JavaCodeWriter out, Element jspElement, String pageContextVar) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "generateLocalVariables", new Object[]{out, jspElement, pageContextVar});
        }
        if (GeneratorUtils.hasUseBean(jspElement)) {
            out.println("HttpSession session = " + pageContextVar + ".getSession();");
            out.println("ServletContext application = " + pageContextVar + ".getServletContext();");
        }
        if (GeneratorUtils.hasUseBean(jspElement) || GeneratorUtils.hasIncludeAction(jspElement) || GeneratorUtils.hasSetProperty(jspElement) || GeneratorUtils.hasForwardAction(jspElement)) {
            out.println("HttpServletRequest request = (HttpServletRequest)" + pageContextVar + ".getRequest();");
        }
        if (GeneratorUtils.hasIncludeAction(jspElement)) {
            out.println("HttpServletResponse response = (HttpServletResponse)" + pageContextVar + ".getResponse();");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "generateLocalVariables");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean hasUseBean(Element jspElement) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "hasUseBean", new Object[]{jspElement});
        }
        boolean b = false;
        if (jspElement.getElementsByTagNameNS("http://java.sun.com/JSP/Page", "useBean").getLength() > 0) {
            b = true;
        }
        boolean bl = b;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "hasUseBean", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean hasIncludeAction(Element jspElement) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "hasIncludeAction", new Object[]{jspElement});
        }
        boolean b = false;
        if (jspElement.getElementsByTagNameNS("http://java.sun.com/JSP/Page", "include").getLength() > 0) {
            b = true;
        }
        boolean bl = b;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "hasIncludeAction", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean hasForwardAction(Element jspElement) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "hasForwardAction", new Object[]{jspElement});
        }
        boolean b = false;
        if (jspElement.getElementsByTagNameNS("http://java.sun.com/JSP/Page", "forward").getLength() > 0) {
            b = true;
        }
        boolean bl = b;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "hasForwardAction", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean hasSetProperty(Element jspElement) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "hasSetProperty", new Object[]{jspElement});
        }
        boolean b = false;
        if (jspElement.getElementsByTagNameNS("http://java.sun.com/JSP/Page", "setProperty").getLength() > 0) {
            b = true;
        }
        boolean bl = b;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "hasSetProperty", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isDeferredInput(TagAttributeInfo tai) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isDeferredInput", new Object[]{tai});
        }
        boolean bl = tai != null ? tai.isDeferredValue() : false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isDeferredInput", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isDeferredMethodInput(TagAttributeInfo tai) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isDeferredMethodInput", new Object[]{tai});
        }
        boolean bl = tai != null ? tai.isDeferredMethod() : false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isDeferredMethodInput", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getClassType(Class expectedType) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getClassType", new Object[]{expectedType});
        }
        String classType = expectedType.getName();
        if (expectedType.isPrimitive()) {
            if (expectedType.equals(Boolean.TYPE)) {
                classType = Boolean.class.getName();
            } else if (expectedType.equals(Byte.TYPE)) {
                classType = Byte.class.getName();
            } else if (expectedType.equals(Character.TYPE)) {
                classType = Character.class.getName();
            } else if (expectedType.equals(Short.TYPE)) {
                classType = Short.class.getName();
            } else if (expectedType.equals(Integer.TYPE)) {
                classType = Integer.class.getName();
            } else if (expectedType.equals(Long.TYPE)) {
                classType = Long.class.getName();
            } else if (expectedType.equals(Float.TYPE)) {
                classType = Float.class.getName();
            } else if (expectedType.equals(Double.TYPE)) {
                classType = Double.class.getName();
            }
        }
        String string = classType = GeneratorUtils.toJavaSourceType(classType);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getClassType", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getPrimitiveConverterMethod(Class expectedType) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getPrimitiveConverterMethod", new Object[]{expectedType});
        }
        String primitiveConverterMethod = null;
        if (expectedType.isPrimitive()) {
            if (expectedType.equals(Boolean.TYPE)) {
                primitiveConverterMethod = "booleanValue";
            } else if (expectedType.equals(Byte.TYPE)) {
                primitiveConverterMethod = "byteValue";
            } else if (expectedType.equals(Character.TYPE)) {
                primitiveConverterMethod = "charValue";
            } else if (expectedType.equals(Short.TYPE)) {
                primitiveConverterMethod = "shortValue";
            } else if (expectedType.equals(Integer.TYPE)) {
                primitiveConverterMethod = "intValue";
            } else if (expectedType.equals(Long.TYPE)) {
                primitiveConverterMethod = "longValue";
            } else if (expectedType.equals(Float.TYPE)) {
                primitiveConverterMethod = "floatValue";
            } else if (expectedType.equals(Double.TYPE)) {
                primitiveConverterMethod = "doubleValue";
            }
        }
        String string = primitiveConverterMethod;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getPrimitiveConverterMethod", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String interpreterCall(boolean isTagFile, String expression, Class expectedType, String fnmapvar, boolean XmlEscape, String pageContextVar) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "interpreterCall", new Object[]{isTagFile, expression, expectedType, fnmapvar, XmlEscape, pageContextVar});
        }
        String string = JSPExtensionFactory.getGeneratorUtilsExtFactory().getGeneratorUtilsExt().interpreterCall(isTagFile, expression, expectedType, fnmapvar, XmlEscape, pageContextVar);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "interpreterCall", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String createValueExpression(StringBuffer sb, String mark, String elContext, String attrValue, boolean isELinput, Class c, TagAttributeInfo tai, String jspCtxt) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "createValueExpression", new Object[]{sb, mark, elContext, attrValue, isELinput, c, tai, jspCtxt});
        }
        sb.append("new org.apache.jasper.el.JspValueExpression(");
        sb.append(GeneratorUtils.quote(mark));
        sb.append(',');
        sb.append("_el_expressionfactory");
        sb.append(".createValueExpression(");
        sb.append(elContext);
        sb.append(',');
        sb.append(GeneratorUtils.quote(attrValue));
        sb.append(',');
        sb.append(GeneratorUtils.toJavaSourceTypeFromTld(GeneratorUtils.getExpectedTypeName(tai)));
        sb.append("))");
        boolean evaluate = false;
        if (tai.canBeRequestTime()) {
            evaluate = true;
        }
        if (GeneratorUtils.isDeferredInput(tai)) {
            evaluate = false;
        }
        if (GeneratorUtils.isDeferredInput(tai) && tai.canBeRequestTime()) {
            boolean bl = evaluate = !attrValue.contains("#{");
        }
        if (evaluate) {
            sb.append(".getValue(");
            sb.append(jspCtxt);
            sb.append(".getELContext()");
            sb.append(")");
        }
        attrValue = sb.toString();
        String string = sb.toString();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "createValueExpression", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String createMethodExpression(StringBuffer sb, String mark, String elContext, String attrValue, boolean isELinput, Class c, TagAttributeInfo tai, String jspCtxt) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "createMethodExpression", new Object[]{sb, mark, elContext, attrValue, isELinput, c, tai, jspCtxt});
        }
        sb.append("new org.apache.jasper.el.JspMethodExpression(");
        sb.append(GeneratorUtils.quote(mark));
        sb.append(',');
        sb.append("_el_expressionfactory");
        sb.append(".createMethodExpression(");
        sb.append(elContext);
        sb.append(',');
        sb.append(GeneratorUtils.quote(attrValue));
        sb.append(',');
        sb.append(GeneratorUtils.toJavaSourceTypeFromTld(GeneratorUtils.getExpectedTypeName(tai)));
        sb.append(',');
        sb.append("new Class[] {");
        String[] p = GeneratorUtils.getParameterTypeNames(tai);
        for (int i = 0; i < p.length; ++i) {
            sb.append(GeneratorUtils.toJavaSourceTypeFromTld(p[i]));
            sb.append(',');
        }
        if (p.length > 0) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}))");
        attrValue = sb.toString();
        String string = sb.toString();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "createMethodExpression", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String toJavaSourceTypeFromTld(String type) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "toJavaSourceTypeFromTld", new Object[]{type});
        }
        if (type == null || "void".equals(type)) {
            String string = "Void.TYPE";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "toJavaSourceTypeFromTld", string);
            }
            return string;
        }
        String string = type + ".class";
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "toJavaSourceTypeFromTld", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String[] getParameterTypeNames(TagAttributeInfo tai) {
        String m;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getParameterTypeNames", new Object[]{tai});
        }
        if (tai != null && GeneratorUtils.isDeferredMethodInput(tai) && (m = tai.getMethodSignature()) != null) {
            m = m.trim();
            m = m.substring(m.indexOf(40) + 1);
            if ((m = m.substring(0, m.length() - 1)).trim().length() > 0) {
                String[] p = m.split(",");
                for (int i = 0; i < p.length; ++i) {
                    p[i] = p[i].trim();
                }
                String[] stringArray = p;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    stringArray = stringArray;
                    logger.exiting(CLASS_NAME, "getParameterTypeNames", stringArray);
                }
                return stringArray;
            }
        }
        String[] stringArray = new String[]{};
        if (logger != null && logger.isLoggable(Level.FINER)) {
            stringArray = stringArray;
            logger.exiting(CLASS_NAME, "getParameterTypeNames", stringArray);
        }
        return stringArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getExpectedTypeName(TagAttributeInfo tai) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getExpectedTypeName", new Object[]{tai});
        }
        if (tai != null) {
            int rti;
            String m;
            if (GeneratorUtils.isDeferredInput(tai)) {
                String string = tai.getExpectedTypeName();
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string = string;
                    logger.exiting(CLASS_NAME, "getExpectedTypeName", string);
                }
                return string;
            }
            if (GeneratorUtils.isDeferredMethodInput(tai) && (m = tai.getMethodSignature()) != null && (rti = m.trim().indexOf(32)) > 0) {
                String string = m.substring(0, rti).trim();
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    string = string;
                    logger.exiting(CLASS_NAME, "getExpectedTypeName", string);
                }
                return string;
            }
        }
        String string = "java.lang.Object";
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getExpectedTypeName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String nextTemporaryVariableName(Map persistentData) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "nextTemporaryVariableName", new Object[]{persistentData});
        }
        String nextTempVar = "_jspx_temp";
        Integer tempVarIndex = (Integer)persistentData.get("tempVarIndex");
        if (tempVarIndex == null) {
            tempVarIndex = new Integer(0);
        }
        int val = tempVarIndex;
        tempVarIndex = new Integer(++val);
        nextTempVar = nextTempVar + tempVarIndex;
        persistentData.put("tempVarIndex", tempVarIndex);
        String string = nextTempVar;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "nextTemporaryVariableName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String attributeValue(String valueIn, boolean encode, Class expectedType, JspConfiguration jspConfig, boolean isTagFile, String pageContextVar) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "attributeValue", new Object[]{valueIn, encode, expectedType, jspConfig, isTagFile, pageContextVar});
        }
        String value = valueIn;
        value = value.replaceAll("&gt;", ">");
        value = value.replaceAll("&lt;", "<");
        value = value.replaceAll("&amp;", "&");
        value = value.replaceAll("<\\%", "<%");
        value = value.replaceAll("%\\>", "%>");
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "attributeValue", "valueIn = [" + valueIn + "]");
            logger.logp(Level.FINEST, CLASS_NAME, "attributeValue", "encode = [" + encode + "]");
            logger.logp(Level.FINEST, CLASS_NAME, "attributeValue", "expectedType = [" + expectedType + "]");
            logger.logp(Level.FINEST, CLASS_NAME, "attributeValue", "isTagFile = [" + isTagFile + "]");
        }
        if (JspTranslatorUtil.isExpression(value)) {
            value = value.substring(2, value.length() - 1);
            if (encode) {
                value = "org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode(String.valueOf(" + value + "), request.getCharacterEncoding())";
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "attributeValue", "isExpression. value = [" + value + "]");
            }
        } else if (JspTranslatorUtil.isELInterpreterInput(value, jspConfig)) {
            value = encode ? "org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode(" + GeneratorUtils.interpreterCall(isTagFile, value, expectedType, "_jspx_fnmap", false, pageContextVar) + ", request.getCharacterEncoding())" : GeneratorUtils.interpreterCall(isTagFile, value, expectedType, "_jspx_fnmap", false, pageContextVar);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "attributeValue", "isELInterpreterInput. value = [" + value + "]");
            }
        } else {
            value = encode ? "org.apache.jasper.runtime.JspRuntimeLibrary.URLEncode(" + GeneratorUtils.quote(value) + ", request.getCharacterEncoding())" : GeneratorUtils.quote(value);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "attributeValue", "default. value = [" + value + "]");
            }
        }
        String string = value;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "attributeValue", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String replace(String name, char replace, String with) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "replace", new Object[]{name, Character.valueOf(replace), with});
        }
        StringBuffer buf = new StringBuffer();
        int begin = 0;
        int last = name.length();
        while (true) {
            int end;
            if ((end = name.indexOf(replace, begin)) < 0) {
                end = last;
            }
            buf.append(name.substring(begin, end));
            if (end == last) break;
            buf.append(with);
            begin = end + 1;
        }
        String string = buf.toString();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "replace", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static char[] removeQuotes(char[] chars) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "removeQuotes", new Object[]{chars});
        }
        CharArrayWriter caw = new CharArrayWriter();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '%' && chars[i + 1] == '\\' && chars[i + 2] == '>') {
                caw.write(37);
                caw.write(62);
                i += 3;
                continue;
            }
            caw.write(chars[i]);
        }
        char[] cArray = caw.toCharArray();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            cArray = cArray;
            logger.exiting(CLASS_NAME, "removeQuotes", cArray);
        }
        return cArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static char[] escapeQuotes(char[] chars) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "escapeQuotes", new Object[]{chars});
        }
        char[] c = GeneratorUtils.escapeScriptingStart(chars);
        char[] cArray = c = GeneratorUtils.escapeScriptingEnd(c);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            cArray = cArray;
            logger.exiting(CLASS_NAME, "escapeQuotes", cArray);
        }
        return cArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static char[] escapeScriptingStart(char[] chars) {
        int n;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "escapeScriptingStart", new Object[]{chars});
        }
        String s = new String(chars);
        while ((n = s.indexOf("<\\%")) >= 0) {
            StringBuffer sb = new StringBuffer(s.substring(0, n));
            sb.append("<%");
            sb.append(s.substring(n + 3));
            s = sb.toString();
        }
        char[] cArray = chars = s.toCharArray();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            cArray = cArray;
            logger.exiting(CLASS_NAME, "escapeScriptingStart", cArray);
        }
        return cArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static char[] escapeScriptingEnd(char[] chars) {
        int n;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "escapeScriptingEnd", new Object[]{chars});
        }
        String s = new String(chars);
        while ((n = s.indexOf("%\\>")) >= 0) {
            StringBuffer sb = new StringBuffer(s.substring(0, n));
            sb.append("%>");
            sb.append(s.substring(n + 3));
            s = sb.toString();
        }
        char[] cArray = chars = s.toCharArray();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            cArray = cArray;
            logger.exiting(CLASS_NAME, "escapeScriptingEnd", cArray);
        }
        return cArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void generateELFunctionCode(JavaCodeWriter writer, ValidateResult validatorResult) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "generateELFunctionCode", new Object[]{writer, validatorResult});
        }
        JSPExtensionFactory.getGeneratorUtilsExtFactory().getGeneratorUtilsExt().generateELFunctionCode(writer, validatorResult);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "generateELFunctionCode");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void generateDependencyList(JavaCodeWriter writer, ValidateResult validatorResult, JspCoreContext context, boolean isTrackDependencies) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "generateDependencyList", new Object[]{writer, validatorResult, context, isTrackDependencies});
        }
        writer.println("private static String[] _jspx_dependants;");
        if (validatorResult.getDependencyList().size() > 0 || isTrackDependencies) {
            writer.println("static {");
            writer.print("_jspx_dependants = new String[");
            if (validatorResult.getDependencyList().size() > 0) {
                writer.print("" + validatorResult.getDependencyList().size());
            } else {
                writer.print("0");
            }
            writer.print("];");
            writer.println();
            int count = 0;
            String dependencyName = null;
            Iterator itr = validatorResult.getDependencyList().iterator();
            while (itr.hasNext()) {
                writer.print("_jspx_dependants[" + count++ + "] = \"");
                dependencyName = (String)itr.next();
                long dependencyTimeStamp = context.getRealTimeStamp(dependencyName);
                writer.print(dependencyName + "^" + dependencyTimeStamp + "^" + new Date(dependencyTimeStamp).toString());
                writer.print("\";");
                writer.println();
            }
            writer.println("}");
            writer.println();
        }
        writer.println("public String[] getDependants() {");
        writer.println("return _jspx_dependants;");
        writer.println("}");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "generateDependencyList");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void generateVersionInformation(JavaCodeWriter writer, boolean isDebugClassFile) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "generateVersionInformation", new Object[]{writer, isDebugClassFile});
        }
        writer.println("private static String _jspx_classVersion;");
        writer.println("private static boolean _jspx_isDebugClassFile;");
        writer.println("static {");
        writer.print("_jspx_classVersion = new String(");
        writer.print("\"" + classfileVersion);
        writer.print("\");");
        writer.println();
        writer.print("_jspx_isDebugClassFile = ");
        writer.print("" + isDebugClassFile);
        writer.print(";");
        writer.println();
        writer.println("}");
        writer.println();
        writer.println("public String getVersionInformation() {");
        writer.println("return _jspx_classVersion;");
        writer.println("}");
        writer.println("public boolean isDebugClassFile() {");
        writer.println("return _jspx_isDebugClassFile;");
        writer.println("}");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "generateVersionInformation");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String coerceToPrimitiveBoolean(String s, boolean isNamedAttribute) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "coerceToPrimitiveBoolean", new Object[]{s, isNamedAttribute});
        }
        if (isNamedAttribute) {
            String string = "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToBoolean(" + s + ")";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToPrimitiveBoolean", string);
            }
            return string;
        }
        if (s == null || s.length() == 0) {
            String string = "false";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToPrimitiveBoolean", string);
            }
            return string;
        }
        String string = Boolean.valueOf(s).toString();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "coerceToPrimitiveBoolean", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String coerceToBoolean(String s, boolean isNamedAttribute) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "coerceToBoolean", new Object[]{s, isNamedAttribute});
        }
        if (isNamedAttribute) {
            String string = "(Boolean) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + ", Boolean.class)";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToBoolean", string);
            }
            return string;
        }
        if (s == null || s.length() == 0) {
            String string = "new Boolean(false)";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToBoolean", string);
            }
            return string;
        }
        String string = "new Boolean(" + Boolean.valueOf(s).toString() + ")";
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "coerceToBoolean", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String coerceToPrimitiveByte(String s, boolean isNamedAttribute) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "coerceToPrimitiveByte", new Object[]{s, isNamedAttribute});
        }
        if (isNamedAttribute) {
            String string = "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToByte(" + s + ")";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToPrimitiveByte", string);
            }
            return string;
        }
        if (s == null || s.length() == 0) {
            String string = "(byte) 0";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToPrimitiveByte", string);
            }
            return string;
        }
        String string = "((byte)" + Byte.valueOf(s).toString() + ")";
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "coerceToPrimitiveByte", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String coerceToByte(String s, boolean isNamedAttribute) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "coerceToByte", new Object[]{s, isNamedAttribute});
        }
        if (isNamedAttribute) {
            String string = "(Byte) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + ", Byte.class)";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToByte", string);
            }
            return string;
        }
        if (s == null || s.length() == 0) {
            String string = "new Byte((byte) 0)";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToByte", string);
            }
            return string;
        }
        String string = "new Byte((byte)" + Byte.valueOf(s).toString() + ")";
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "coerceToByte", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String coerceToChar(String s, boolean isNamedAttribute) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "coerceToChar", new Object[]{s, isNamedAttribute});
        }
        if (isNamedAttribute) {
            String string = "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToChar(" + s + ")";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToChar", string);
            }
            return string;
        }
        if (s == null || s.length() == 0) {
            String string = "(char) 0";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToChar", string);
            }
            return string;
        }
        char ch = s.charAt(0);
        String string = "((char) " + ch + ")";
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "coerceToChar", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String coerceToCharacter(String s, boolean isNamedAttribute) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "coerceToCharacter", new Object[]{s, isNamedAttribute});
        }
        if (isNamedAttribute) {
            String string = "(Character) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + ", Character.class)";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToCharacter", string);
            }
            return string;
        }
        if (s == null || s.length() == 0) {
            String string = "new Character((char) 0)";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToCharacter", string);
            }
            return string;
        }
        char ch = s.charAt(0);
        String string = "new Character((char) " + ch + ")";
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "coerceToCharacter", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String coerceToPrimitiveDouble(String s, boolean isNamedAttribute) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "coerceToPrimitiveDouble", new Object[]{s, isNamedAttribute});
        }
        if (isNamedAttribute) {
            String string = "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToDouble(" + s + ")";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToPrimitiveDouble", string);
            }
            return string;
        }
        if (s == null || s.length() == 0) {
            String string = "(double) 0";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToPrimitiveDouble", string);
            }
            return string;
        }
        String string = Double.valueOf(s).toString();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "coerceToPrimitiveDouble", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String coerceToDouble(String s, boolean isNamedAttribute) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "coerceToDouble", new Object[]{s, isNamedAttribute});
        }
        if (isNamedAttribute) {
            String string = "(Double) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + ", Double.class)";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToDouble", string);
            }
            return string;
        }
        if (s == null || s.length() == 0) {
            String string = "new Double(0)";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToDouble", string);
            }
            return string;
        }
        String string = "new Double(" + Double.valueOf(s).toString() + ")";
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "coerceToDouble", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String coerceToPrimitiveFloat(String s, boolean isNamedAttribute) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "coerceToPrimitiveFloat", new Object[]{s, isNamedAttribute});
        }
        if (isNamedAttribute) {
            String string = "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToFloat(" + s + ")";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToPrimitiveFloat", string);
            }
            return string;
        }
        if (s == null || s.length() == 0) {
            String string = "(float) 0";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToPrimitiveFloat", string);
            }
            return string;
        }
        String string = Float.valueOf(s).toString() + "f";
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "coerceToPrimitiveFloat", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String coerceToFloat(String s, boolean isNamedAttribute) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "coerceToFloat", new Object[]{s, isNamedAttribute});
        }
        if (isNamedAttribute) {
            String string = "(Float) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + ", Float.class)";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToFloat", string);
            }
            return string;
        }
        if (s == null || s.length() == 0) {
            String string = "new Float(0)";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToFloat", string);
            }
            return string;
        }
        String string = "new Float(" + Float.valueOf(s).toString() + "f)";
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "coerceToFloat", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String coerceToInt(String s, boolean isNamedAttribute) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "coerceToInt", new Object[]{s, isNamedAttribute});
        }
        if (isNamedAttribute) {
            String string = "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToInt(" + s + ")";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToInt", string);
            }
            return string;
        }
        if (s == null || s.length() == 0) {
            String string = "0";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToInt", string);
            }
            return string;
        }
        String string = Integer.valueOf(s).toString();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "coerceToInt", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String coerceToInteger(String s, boolean isNamedAttribute) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "coerceToInteger", new Object[]{s, isNamedAttribute});
        }
        if (isNamedAttribute) {
            String string = "(Integer) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + ", Integer.class)";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToInteger", string);
            }
            return string;
        }
        if (s == null || s.length() == 0) {
            String string = "new Integer(0)";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToInteger", string);
            }
            return string;
        }
        String string = "new Integer(" + Integer.valueOf(s).toString() + ")";
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "coerceToInteger", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String coerceToPrimitiveShort(String s, boolean isNamedAttribute) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "coerceToPrimitiveShort", new Object[]{s, isNamedAttribute});
        }
        if (isNamedAttribute) {
            String string = "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToShort(" + s + ")";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToPrimitiveShort", string);
            }
            return string;
        }
        if (s == null || s.length() == 0) {
            String string = "(short) 0";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToPrimitiveShort", string);
            }
            return string;
        }
        String string = "((short) " + Short.valueOf(s).toString() + ")";
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "coerceToPrimitiveShort", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String coerceToShort(String s, boolean isNamedAttribute) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "coerceToShort", new Object[]{s, isNamedAttribute});
        }
        if (isNamedAttribute) {
            String string = "(Short) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + ", Short.class)";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToShort", string);
            }
            return string;
        }
        if (s == null || s.length() == 0) {
            String string = "new Short((short) 0)";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToShort", string);
            }
            return string;
        }
        String string = "new Short(\"" + Short.valueOf(s).toString() + "\")";
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "coerceToShort", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String coerceToPrimitiveLong(String s, boolean isNamedAttribute) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "coerceToPrimitiveLong", new Object[]{s, isNamedAttribute});
        }
        if (isNamedAttribute) {
            String string = "org.apache.jasper.runtime.JspRuntimeLibrary.coerceToLong(" + s + ")";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToPrimitiveLong", string);
            }
            return string;
        }
        if (s == null || s.length() == 0) {
            String string = "(long) 0";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToPrimitiveLong", string);
            }
            return string;
        }
        String string = Long.valueOf(s).toString() + "l";
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "coerceToPrimitiveLong", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String coerceToLong(String s, boolean isNamedAttribute) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "coerceToLong", new Object[]{s, isNamedAttribute});
        }
        if (isNamedAttribute) {
            String string = "(Long) org.apache.jasper.runtime.JspRuntimeLibrary.coerce(" + s + ", Long.class)";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToLong", string);
            }
            return string;
        }
        if (s == null || s.length() == 0) {
            String string = "new Long(0)";
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "coerceToLong", string);
            }
            return string;
        }
        String string = "new Long(" + Long.valueOf(s).toString() + "l)";
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "coerceToLong", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String toJavaSourceType(String type) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "toJavaSourceType", new Object[]{type});
        }
        if (type.charAt(0) != '[') {
            String string = type;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                string = string;
                logger.exiting(CLASS_NAME, "toJavaSourceType", string);
            }
            return string;
        }
        int dims = 1;
        String t = null;
        for (int i = 1; i < type.length(); ++i) {
            if (type.charAt(i) == '[') {
                ++dims;
                continue;
            }
            switch (type.charAt(i)) {
                case 'Z': {
                    t = "boolean";
                    break;
                }
                case 'B': {
                    t = "byte";
                    break;
                }
                case 'C': {
                    t = "char";
                    break;
                }
                case 'D': {
                    t = "double";
                    break;
                }
                case 'F': {
                    t = "float";
                    break;
                }
                case 'I': {
                    t = "int";
                    break;
                }
                case 'J': {
                    t = "long";
                    break;
                }
                case 'S': {
                    t = "short";
                    break;
                }
                case 'L': {
                    t = type.substring(i + 1, type.indexOf(59));
                    break;
                }
            }
            break;
        }
        StringBuffer resultType = new StringBuffer(t);
        while (dims > 0) {
            resultType.append("[]");
            --dims;
        }
        String string = resultType.toString();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "toJavaSourceType", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void generateInitSectionCode(JavaCodeWriter writer, int type) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "generateInitSectionCode", new Object[]{writer, type});
        }
        GeneratorUtils.generateInitSectionCode(writer, type, null);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "generateInitSectionCode");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void generateInitSectionCode(JavaCodeWriter writer, int type, JspOptions jspOptions) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "generateInitSectionCode", new Object[]{writer, type, jspOptions});
        }
        writer.println("private javax.el.ExpressionFactory _el_expressionfactory;");
        if (type == TAG_FILE_TYPE) {
            if (jspOptions == null || !jspOptions.isDisableResourceInjection()) {
                GeneratorUtils.generateInjectionSection(writer);
            }
            writer.println("private void _jspInit(ServletConfig config) {");
        } else {
            writer.println("public void _jspInit() {");
        }
        writer.print("_el_expressionfactory");
        writer.print(" = _jspxFactory.getJspApplicationContext(");
        if (type == TAG_FILE_TYPE) {
            writer.print("config");
        } else {
            writer.print("getServletConfig()");
        }
        writer.print(".getServletContext()).getExpressionFactory();");
        writer.println();
        writer.println();
        if (jspOptions == null || !jspOptions.isDisableResourceInjection()) {
            writer.print("com.ibm.wsspi.webcontainer.annotation.AnnotationHelperManager _jspx_aHelper = ");
            writer.print("com.ibm.wsspi.webcontainer.annotation.AnnotationHelperManager.getInstance (");
            if (type == TAG_FILE_TYPE) {
                writer.print("config");
            } else {
                writer.print("getServletConfig()");
            }
            writer.println(".getServletContext());");
            writer.println("_jspx_iaHelper = _jspx_aHelper.getAnnotationHelper();");
        }
        if (type == JSP_FILE_TYPE) {
            writer.println("_jspx_isJspInited = true;");
        }
        writer.println("}");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "generateInitSectionCode");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void generateFactoryInitialization(JavaCodeWriter writer, boolean jcdiWrapIt) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "generateFactoryInitialization", new Object[]{writer, jcdiWrapIt});
        }
        writer.print("private static final JspFactory _jspxFactory = ");
        if (jcdiWrapIt) {
            writer.print("new org.apache.jasper.runtime.JcdiWrappedJspFactoryImpl(");
        }
        writer.print("JspFactory.getDefaultFactory()");
        if (jcdiWrapIt) {
            writer.print(")");
        }
        writer.println(";");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "generateFactoryInitialization");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void generateInjectionSection(JavaCodeWriter writer) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "generateInjectionSection", new Object[]{writer});
        }
        writer.println("private com.ibm.wsspi.webcontainer.annotation.AnnotationHelper _jspx_iaHelper;");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "generateInjectionSection");
        }
    }
}

