/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.joblog.internal.impl;

import com.ibm.jbatch.container.instance.WorkUnitDescriptor;
import com.ibm.jbatch.container.ws.events.BatchEventsPublisher;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jbatch.joblog.internal.impl.BatchLogPartNotCreatedException;
import com.ibm.ws.jbatch.joblog.internal.impl.JobLogFormatter;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JobLogFileHandler
extends StreamHandler {
    private static final String CLASSNAME;
    private final Logger logger = Logger.getLogger(CLASSNAME, "com.ibm.ws.jbatch.joblog.internal.resources.JBatchJobLogMessages");
    private int filePart;
    private int recordsWritten;
    private final int maxRecordsPerFile;
    private final int maxTimePerFile;
    private final String fileNamePattern;
    private File logFile;
    private Path previousLogPath;
    private boolean allowRotate = true;
    private final boolean purgeOnPublish;
    private final WorkUnitDescriptor execContext;
    private final String correlationId;
    private boolean timerCancelled = false;
    protected Timer _timer;
    static final long serialVersionUID = 6787939327465750089L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public JobLogFileHandler(String logFileNamePattern, int maxFileLines, Boolean purgeOnPublishHandler, WorkUnitDescriptor ctx, int maxTime) throws BatchLogPartNotCreatedException {
        this.setLevel(Level.FINEST);
        this.setFormatter(new JobLogFormatter());
        this.fileNamePattern = logFileNamePattern;
        this.maxRecordsPerFile = maxFileLines;
        this.maxTimePerFile = maxTime;
        this.purgeOnPublish = purgeOnPublishHandler;
        this.execContext = ctx;
        this.filePart = 0;
        this.correlationId = this.execContext == null ? null : this.execContext.getCorrelationId();
        this.rotate();
    }

    /*
     * WARNING - void declaration
     */
    private synchronized void rotate() throws BatchLogPartNotCreatedException {
        ++this.filePart;
        this.recordsWritten = 0;
        if (this.filePart > 1) {
            this.previousLogPath = Paths.get(this.logFile.getPath(), new String[0]);
        }
        Object token = null;
        this.logFile = new File(String.format(this.fileNamePattern, this.filePart));
        try {
            token = ThreadIdentityManager.runAsServer();
            File logDir = new File(this.logFile.getParent());
            boolean dirExists = logDir.exists();
            if (!dirExists && !(dirExists = logDir.mkdirs())) {
                dirExists = logDir.mkdirs();
            }
            if (!dirExists) {
                throw new BatchLogPartNotCreatedException("Batch Log Directory Not Created:" + logDir.toString());
            }
            this.setOutputStream(new FileOutputStream(this.logFile));
            if (this._timer != null) {
                this._timer.cancel();
                this._timer = null;
            }
            if (this.maxTimePerFile > 0) {
                this._timer = new Timer("JobLogTimer");
                this._timer.schedule(new TimerTask(){
                    static final long serialVersionUID = 9153183418711004679L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     */
                    @Override
                    public void run() {
                        JobLogFileHandler jobLogFileHandler = JobLogFileHandler.this;
                        synchronized (jobLogFileHandler) {
                            if (JobLogFileHandler.this.timerCancelled) {
                                return;
                            }
                            if (JobLogFileHandler.this.recordsWritten > 0 && JobLogFileHandler.this.allowRotate) {
                                JobLogFileHandler.this._timer.cancel();
                                JobLogFileHandler.this._timer = null;
                                try {
                                    JobLogFileHandler.this.rotate();
                                }
                                catch (BatchLogPartNotCreatedException batchLogPartNotCreatedException) {
                                    void e;
                                    FFDCFilter.processException((Throwable)batchLogPartNotCreatedException, (String)"com.ibm.ws.jbatch.joblog.internal.impl.JobLogFileHandler$1", (String)"148", (Object)this, (Object[])new Object[0]);
                                    JobLogFileHandler.this.allowRotate = false;
                                    JobLogFileHandler.this.logger.log(Level.WARNING, "job.logging.create.next", new Object[]{e.getCause() != null ? e.getCause() : e});
                                }
                            }
                        }
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.joblog.internal.impl.JobLogFileHandler$1", 1.class, null, null);
                    }
                }, this.maxTimePerFile * 1000, (long)(this.maxTimePerFile * 1000));
            }
            if (this.filePart > 1) {
                this.handleNewJobLogPart();
            }
        }
        catch (SecurityException logDir) {
            void e;
            FFDCFilter.processException((Throwable)logDir, (String)"com.ibm.ws.jbatch.joblog.internal.impl.JobLogFileHandler", (String)"165", (Object)this, (Object[])new Object[0]);
            throw new BatchLogPartNotCreatedException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jbatch.joblog.internal.impl.JobLogFileHandler", (String)"167", (Object)this, (Object[])new Object[0]);
            throw new BatchLogPartNotCreatedException(e);
        }
        finally {
            if (token != null) {
                ThreadIdentityManager.reset((Object)token);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Trivial
    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        super.publish(record);
        this.flush();
        ++this.recordsWritten;
        if (this.recordsWritten >= this.maxRecordsPerFile && this.allowRotate) {
            try {
                this.rotate();
            }
            catch (BatchLogPartNotCreatedException batchLogPartNotCreatedException) {
                void e;
                FFDCFilter.processException((Throwable)batchLogPartNotCreatedException, (String)"com.ibm.ws.jbatch.joblog.internal.impl.JobLogFileHandler", (String)"192", (Object)this, (Object[])new Object[]{record});
                this.allowRotate = false;
                this.logger.log(Level.WARNING, "job.logging.create.next", new Object[]{e.getCause() != null ? e.getCause() : e});
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleNewJobLogPart() {
        if (this.getBatchEventsPublisher() != null) {
            String logContent = null;
            try {
                logContent = new String(Files.readAllBytes(this.previousLogPath), StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.jbatch.joblog.internal.impl.JobLogFileHandler", (String)"215", (Object)this, (Object[])new Object[0]);
                this.logger.log(Level.WARNING, "job.logging.read.log", new Object[]{e.getCause() != null ? e.getCause() : e});
            }
            catch (OutOfMemoryError e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jbatch.joblog.internal.impl.JobLogFileHandler", (String)"217", (Object)this, (Object[])new Object[0]);
                this.logger.log(Level.WARNING, "job.logging.read.log", new Object[]{e.getCause() != null ? e.getCause() : e});
            }
            catch (SecurityException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jbatch.joblog.internal.impl.JobLogFileHandler", (String)"219", (Object)this, (Object[])new Object[0]);
                this.logger.log(Level.WARNING, "job.logging.read.log", new Object[]{e.getCause() != null ? e.getCause() : e});
            }
            if (logContent != null) {
                this.sendJobLogEvent(this.filePart - 1, logContent, false);
            }
        }
    }

    private BatchEventsPublisher getBatchEventsPublisher() {
        BundleContext bundleContext = FrameworkUtil.getBundle(BatchEventsPublisher.class).getBundleContext();
        ServiceReference eventsPublisherSR = bundleContext.getServiceReference(BatchEventsPublisher.class);
        return eventsPublisherSR != null ? (BatchEventsPublisher)bundleContext.getService(eventsPublisherSR) : null;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void handleFinalJobLogPart() {
        if (this._timer != null) {
            this._timer.cancel();
            this._timer = null;
            this.timerCancelled = true;
        }
        if (this.getBatchEventsPublisher() != null) {
            Object token = null;
            try {
                token = ThreadIdentityManager.runAsServer();
                String logContent = new String(Files.readAllBytes(Paths.get(this.logFile.getPath(), new String[0])), StandardCharsets.UTF_8);
                this.sendJobLogEvent(this.filePart, logContent, true);
            }
            catch (IOException logContent) {
                void e;
                FFDCFilter.processException((Throwable)logContent, (String)"com.ibm.ws.jbatch.joblog.internal.impl.JobLogFileHandler", (String)"288", (Object)this, (Object[])new Object[0]);
                this.logger.log(Level.WARNING, "job.logging.read.log", new Object[]{e.getCause() != null ? e.getCause() : e});
            }
            catch (OutOfMemoryError e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jbatch.joblog.internal.impl.JobLogFileHandler", (String)"290", (Object)this, (Object[])new Object[0]);
                this.logger.log(Level.WARNING, "job.logging.read.log", new Object[]{e.getCause() != null ? e.getCause() : e});
            }
            catch (SecurityException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jbatch.joblog.internal.impl.JobLogFileHandler", (String)"292", (Object)this, (Object[])new Object[0]);
                this.logger.log(Level.WARNING, "job.logging.read.log", new Object[]{e.getCause() != null ? e.getCause() : e});
            }
            finally {
                if (token != null) {
                    ThreadIdentityManager.reset((Object)token);
                }
            }
        }
        this.close();
    }

    @Trivial
    protected void sendJobLogEvent(int partNum, String logContent, boolean finalLog) {
        BatchEventsPublisher batchEventsPublisher = this.getBatchEventsPublisher();
        if (batchEventsPublisher == null) {
            return;
        }
        String partitionStep = null;
        String splitName = null;
        String flowName = null;
        Integer partitionNum = null;
        switch (this.execContext.getWorkUnitType()) {
            case PARTITIONED_STEP: {
                partitionStep = this.execContext.getPartitionedStepName();
                partitionNum = this.execContext.getPartitionNumber();
                break;
            }
            case SPLIT_FLOW: {
                splitName = this.execContext.getSplitName();
                flowName = this.execContext.getFlowName();
                break;
            }
        }
        batchEventsPublisher.publishJobLogEvent(this.execContext.getTopLevelInstanceId(), this.execContext.getTopLevelExecutionId(), this.execContext.getTopLevelJobName(), partitionStep, partitionNum, splitName, flowName, partNum, finalLog, logContent, this.correlationId);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.joblog.internal.impl.JobLogFileHandler", JobLogFileHandler.class, null, null);
        CLASSNAME = JobLogFileHandler.class.getName();
    }
}

